/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.javac;

import com.google.gwt.dev.javac.JdtUtil;
import com.google.gwt.dev.jjs.ast.HasJsInfo;
import com.google.gwt.dev.jjs.ast.JConstructor;
import com.google.gwt.dev.jjs.ast.JDeclaredType;
import com.google.gwt.dev.jjs.ast.JField;
import com.google.gwt.dev.jjs.ast.JMember;
import com.google.gwt.dev.jjs.ast.JMethod;
import com.google.gwt.dev.jjs.ast.JParameter;
import com.google.gwt.dev.jjs.ast.JPrimitiveType;
import com.google.gwt.thirdparty.guava.common.base.Joiner;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import java.util.ArrayList;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;

public final class JsInteropUtil {
    public static final String UNUSABLE_BY_JS = "unusable-by-js";
    public static final String INVALID_JSNAME = "<invalid>";

    public static boolean isGlobal(String jsNamespace) {
        return "<global>".equals(jsNamespace);
    }

    public static boolean isWindow(String jsNamespace) {
        return "<window>".equals(jsNamespace);
    }

    public static String normalizeQualifier(String qualifier) {
        assert (!qualifier.isEmpty());
        ArrayList<String> components = Lists.newArrayList(qualifier.split("\\."));
        if (JsInteropUtil.isWindow((String)components.get(0))) {
            components.remove(0);
        } else if (JsInteropUtil.isGlobal((String)components.get(0))) {
            components.set(0, "$wnd");
        } else {
            components.add(0, "$wnd");
        }
        return Joiner.on('.').join(components);
    }

    public static void maybeSetJsInteropProperties(JDeclaredType type, Annotation[] annotations) {
        AnnotationBinding jsType = JsInteropUtil.getInteropAnnotation(annotations, "JsType");
        String namespace = JdtUtil.getAnnotationParameterString(jsType, "namespace");
        String name = JdtUtil.getAnnotationParameterString(jsType, "name");
        boolean isJsNative = JdtUtil.getAnnotationParameterBoolean(jsType, "isNative", false);
        AnnotationBinding jsPackage = JsInteropUtil.getInteropAnnotation(annotations, "JsPackage");
        String packageNamespace = JdtUtil.getAnnotationParameterString(jsPackage, "namespace");
        if (packageNamespace != null) {
            namespace = packageNamespace;
        }
        boolean isJsType = jsType != null;
        boolean isJsFunction = JsInteropUtil.getInteropAnnotation(annotations, "JsFunction") != null;
        type.setJsTypeInfo(isJsType, isJsNative, isJsFunction, namespace, name, isJsType);
    }

    public static void maybeSetJsInteropProperties(JMethod method, boolean generateExport, Annotation ... annotations) {
        AnnotationBinding annotation = JsInteropUtil.getInteropAnnotation(annotations, "JsMethod");
        if (annotation == null) {
            annotation = JsInteropUtil.getInteropAnnotation(annotations, "JsConstructor");
        }
        if (annotation == null) {
            annotation = JsInteropUtil.getInteropAnnotation(annotations, "JsProperty");
        }
        boolean isPropertyAccessor = JsInteropUtil.getInteropAnnotation(annotations, "JsProperty") != null;
        JsInteropUtil.setJsInteropProperties(method, annotations, annotation, isPropertyAccessor, generateExport);
    }

    public static void maybeSetJsInteropProperties(JParameter parameter, Annotation ... annotations) {
        if (JsInteropUtil.getInteropAnnotation(annotations, "JsOptional") != null) {
            parameter.setOptional();
        }
    }

    public static void maybeSetJsInteropProperties(JField field, boolean generateExport, Annotation ... annotations) {
        AnnotationBinding annotation = JsInteropUtil.getInteropAnnotation(annotations, "JsProperty");
        JsInteropUtil.setJsInteropProperties(field, annotations, annotation, false, generateExport);
    }

    private static void setJsInteropProperties(JMember member, Annotation[] annotations, AnnotationBinding memberAnnotation, boolean isAccessor, boolean generateExport) {
        if (JsInteropUtil.getInteropAnnotation(annotations, "JsOverlay") != null) {
            member.setJsOverlay();
        }
        if (JsInteropUtil.getInteropAnnotation(annotations, "JsIgnore") != null) {
            return;
        }
        boolean isPublicMemberForJsType = member.getEnclosingType().isJsType() && member.isPublic();
        boolean memberForNativeType = member.getEnclosingType().isJsNative();
        if (memberAnnotation == null && (!isPublicMemberForJsType && !memberForNativeType || member.isJsOverlay())) {
            return;
        }
        String namespace = JdtUtil.getAnnotationParameterString(memberAnnotation, "namespace");
        String name = JdtUtil.getAnnotationParameterString(memberAnnotation, "name");
        HasJsInfo.JsMemberType memberType = JsInteropUtil.getJsMemberType(member, isAccessor);
        member.setJsMemberInfo(memberType, namespace, name, generateExport);
    }

    private static HasJsInfo.JsMemberType getJsMemberType(JMember member, boolean isPropertyAccessor) {
        if (member instanceof JField) {
            return HasJsInfo.JsMemberType.PROPERTY;
        }
        if (member instanceof JConstructor) {
            return HasJsInfo.JsMemberType.CONSTRUCTOR;
        }
        if (isPropertyAccessor) {
            return JsInteropUtil.getJsPropertyAccessorType((JMethod)member);
        }
        return HasJsInfo.JsMemberType.METHOD;
    }

    private static HasJsInfo.JsMemberType getJsPropertyAccessorType(JMethod method) {
        if (method.getParams().size() == 1 && method.getType() == JPrimitiveType.VOID) {
            return HasJsInfo.JsMemberType.SETTER;
        }
        if (method.getParams().isEmpty() && (method.getType() != JPrimitiveType.VOID || JsInteropUtil.isDebugger(method))) {
            return HasJsInfo.JsMemberType.GETTER;
        }
        return HasJsInfo.JsMemberType.UNDEFINED_ACCESSOR;
    }

    private static boolean isDebugger(JMethod method) {
        return method.isStatic() && method.getName().equals("debugger") && (method.isJsNative() || method.isAbstract());
    }

    private static AnnotationBinding getInteropAnnotation(Annotation[] annotations, String name) {
        return JdtUtil.getAnnotationByName(annotations, "jsinterop.annotations." + name);
    }
}

