/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.javac;

import com.google.gwt.dev.jjs.ast.JDeclaredType;
import com.google.gwt.dev.util.Name;
import com.google.gwt.thirdparty.guava.common.base.Function;
import com.google.gwt.thirdparty.guava.common.base.Joiner;
import com.google.gwt.thirdparty.guava.common.base.Predicate;
import com.google.gwt.thirdparty.guava.common.base.Strings;
import com.google.gwt.thirdparty.guava.common.collect.FluentIterable;
import com.google.gwt.thirdparty.guava.common.collect.ImmutableSet;
import com.google.gwt.thirdparty.guava.common.collect.Iterables;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.impl.BooleanConstant;
import org.eclipse.jdt.internal.compiler.impl.StringConstant;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.ElementValuePair;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.NestedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticArgumentBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public final class JdtUtil {
    private static final String JSO_CLASS = "com/google/gwt/core/client/JavaScriptObject";
    private static final String VALUE_SUFFIX = "Value";
    private static final String VALUE_OF_METHOD_NAME = "valueOf";
    private static final char[] VALUE_SUFFIX_ = "Value".toCharArray();
    private static final char[] VALUE_OF_ = "valueOf".toCharArray();

    public static String asDottedString(char[][] name) {
        return JdtUtil.join(name, ".");
    }

    public static String join(char[][] name, String separator) {
        StringBuilder result = new StringBuilder();
        if (name.length > 0) {
            result.append(name[0]);
        }
        for (int i = 1; i < name.length; ++i) {
            result.append(separator);
            result.append(name[i]);
        }
        return result.toString();
    }

    public static String getQualifiedSourceName(ReferenceBinding binding) {
        if (binding instanceof LocalTypeBinding) {
            return Name.InternalName.toBinaryName(String.valueOf(binding.constantPoolName()));
        }
        return JdtUtil.asDottedString(binding.compoundName);
    }

    public static String getDefiningCompilationUnitType(ReferenceBinding binding) {
        return JdtUtil.asDottedString(binding.outermostEnclosingType().compoundName);
    }

    public static String getSourceName(TypeBinding classBinding) {
        return JdtUtil.getSourceName(CharOperation.charToString(classBinding.qualifiedPackageName()), CharOperation.charToString(classBinding.qualifiedSourceName()));
    }

    public static String getSourceName(String qualifiedPackageName, String qualifiedSourceName) {
        return Joiner.on(".").skipNulls().join(new String[]{Strings.emptyToNull(qualifiedPackageName), qualifiedSourceName});
    }

    public static String getBinaryName(TypeBinding classBinding) {
        return JdtUtil.getBinaryName(CharOperation.charToString(classBinding.qualifiedPackageName()), CharOperation.charToString(classBinding.qualifiedSourceName()));
    }

    public static String getBinaryName(String qualifiedPackageName, String qualifiedSourceName) {
        return Joiner.on(".").skipNulls().join(new String[]{Strings.emptyToNull(qualifiedPackageName), qualifiedSourceName.replace('.', '$')});
    }

    public static boolean isInnerClass(ReferenceBinding binding) {
        return binding.isNestedType() && !binding.isStatic();
    }

    public static String formatMethodSignature(MethodBinding methodBinding) {
        ReferenceBinding declaringClassBinding = methodBinding.declaringClass;
        StringBuilder methodNameWithSignature = new StringBuilder();
        String methodName = String.valueOf(methodBinding.selector);
        ArrayList<TypeBinding> parameterTypeBindings = Lists.newArrayList();
        if (methodName.equals("<init>")) {
            methodName = "new";
            if (JdtUtil.isInnerClass(declaringClassBinding)) {
                NestedTypeBinding nestedBinding = (NestedTypeBinding)declaringClassBinding;
                if (nestedBinding.enclosingInstances != null) {
                    for (SyntheticArgumentBinding argumentBinding : nestedBinding.enclosingInstances) {
                        parameterTypeBindings.add(argumentBinding.type);
                    }
                }
            }
        }
        parameterTypeBindings.addAll(Arrays.asList(methodBinding.parameters));
        methodNameWithSignature.append(methodName);
        methodNameWithSignature.append("(");
        for (TypeBinding parameterTypeBinding : parameterTypeBindings) {
            methodNameWithSignature.append(parameterTypeBinding.signature());
        }
        methodNameWithSignature.append(")");
        return methodNameWithSignature.toString();
    }

    public static String formatBinding(MethodBinding methodBinding) {
        String accessModifier = null;
        if (methodBinding.isProtected()) {
            accessModifier = "protected";
        } else if (methodBinding.isPrivate()) {
            accessModifier = "private";
        } else if (methodBinding.isPublic()) {
            accessModifier = "public";
        }
        return Joiner.on(" ").skipNulls().join(accessModifier, methodBinding.isStatic() ? "static" : null, JdtUtil.getSourceName(methodBinding.declaringClass) + "." + JdtUtil.formatMethodSignature(methodBinding));
    }

    private JdtUtil() {
    }

    public static String getAnnotationParameterString(AnnotationBinding annotationBinding, String parameterName) {
        if (annotationBinding != null) {
            for (ElementValuePair parameterNameValuePair : annotationBinding.getElementValuePairs()) {
                if (!(parameterNameValuePair.getValue() instanceof StringConstant) || !parameterName.equals(String.valueOf(parameterNameValuePair.getName()))) continue;
                return ((StringConstant)parameterNameValuePair.getValue()).stringValue();
            }
        }
        return null;
    }

    public static boolean getAnnotationParameterBoolean(AnnotationBinding annotationBinding, String parameterName, boolean defaultValue) {
        Boolean booleanParameterValue = JdtUtil.getAnnotationParameterBoolean(annotationBinding, parameterName);
        return booleanParameterValue == null ? defaultValue : booleanParameterValue;
    }

    public static Boolean getAnnotationParameterBoolean(AnnotationBinding annotationBinding, String parameterName) {
        if (annotationBinding != null) {
            for (ElementValuePair parameterNameValuePair : annotationBinding.getElementValuePairs()) {
                if (!(parameterNameValuePair.getValue() instanceof BooleanConstant) || !parameterName.equals(String.valueOf(parameterNameValuePair.getName()))) continue;
                return ((BooleanConstant)parameterNameValuePair.getValue()).booleanValue();
            }
        }
        return null;
    }

    public static AnnotationBinding getAnnotationByName(Annotation[] annotations, String name) {
        if (annotations == null) {
            return null;
        }
        for (Annotation annotation : annotations) {
            AnnotationBinding annotationBinding = annotation.getCompilerAnnotation();
            if (!JdtUtil.matchAnnotationName(annotationBinding, name)) continue;
            return annotationBinding;
        }
        return null;
    }

    public static AnnotationBinding getAnnotationByName(AnnotationBinding[] annotationsBindings, String name) {
        if (annotationsBindings == null) {
            return null;
        }
        for (AnnotationBinding annotationBinding : annotationsBindings) {
            if (!JdtUtil.matchAnnotationName(annotationBinding, name)) continue;
            return annotationBinding;
        }
        return null;
    }

    private static boolean matchAnnotationName(AnnotationBinding annotationBinding, String name) {
        if (annotationBinding == null) {
            return false;
        }
        return name.equals(CharOperation.toString(annotationBinding.getAnnotationType().compoundName));
    }

    public static TypeBinding getAnnotationParameterTypeBinding(AnnotationBinding annotationBinding, String parameterName) {
        if (annotationBinding != null) {
            for (ElementValuePair parameterNameValuePair : annotationBinding.getElementValuePairs()) {
                if (!(parameterNameValuePair.getValue() instanceof Class) || !parameterName.equals(String.valueOf(parameterNameValuePair.getName()))) continue;
                return (TypeBinding)parameterNameValuePair.getValue();
            }
        }
        return null;
    }

    public static TypeBinding[] getAnnotationParameterTypeBindingArray(AnnotationBinding annotationBinding, String parameterName) {
        if (annotationBinding == null) {
            return null;
        }
        for (ElementValuePair parameterNameValuePair : annotationBinding.getElementValuePairs()) {
            Object value = parameterNameValuePair.getValue();
            if (!parameterName.equals(String.valueOf(parameterNameValuePair.getName()))) continue;
            if (value instanceof Object[]) {
                Object[] values = (Object[])value;
                TypeBinding[] bindings = new TypeBinding[values.length];
                System.arraycopy(values, 0, bindings, 0, values.length);
                return bindings;
            }
            assert (value instanceof TypeBinding);
            return new TypeBinding[]{(TypeBinding)value};
        }
        return null;
    }

    public static StringConstant[] getAnnotationParameterStringConstantArray(AnnotationBinding annotationBinding, String parameterName) {
        if (annotationBinding == null) {
            return null;
        }
        for (ElementValuePair parameterNameValuePair : annotationBinding.getElementValuePairs()) {
            if (!parameterName.equals(String.valueOf(parameterNameValuePair.getName()))) continue;
            Object value = parameterNameValuePair.getValue();
            if (value instanceof Object[]) {
                Object[] values = (Object[])value;
                StringConstant[] stringConstants = new StringConstant[values.length];
                System.arraycopy(values, 0, stringConstants, 0, values.length);
                return stringConstants;
            }
            assert (value instanceof StringConstant);
            return new StringConstant[]{(StringConstant)value};
        }
        return null;
    }

    public static Set<String> getSuppressedWarnings(Annotation[] annotations) {
        if (annotations == null) {
            return ImmutableSet.of();
        }
        AnnotationBinding suppressWarnings = JdtUtil.getAnnotationByName(annotations, SuppressWarnings.class.getName());
        if (suppressWarnings != null) {
            StringConstant[] values = JdtUtil.getAnnotationParameterStringConstantArray(suppressWarnings, "value");
            return FluentIterable.from(Arrays.asList(values)).transform(new Function<StringConstant, String>(){

                @Override
                public String apply(StringConstant value) {
                    return value.stringValue();
                }
            }).toSet();
        }
        return ImmutableSet.of();
    }

    public static String signature(FieldBinding binding) {
        StringBuilder sb = new StringBuilder();
        sb.append(binding.declaringClass.constantPoolName());
        sb.append('.');
        sb.append(binding.name);
        sb.append(':');
        sb.append(binding.type.signature());
        return sb.toString();
    }

    public static String signature(MethodBinding binding) {
        StringBuilder sb = new StringBuilder();
        sb.append(binding.declaringClass.constantPoolName());
        sb.append('.');
        sb.append(binding.selector);
        sb.append('(');
        for (TypeBinding paramType : binding.parameters) {
            sb.append(paramType.signature());
        }
        sb.append(')');
        sb.append(binding.returnType.signature());
        return sb.toString();
    }

    public static String signature(TypeBinding binding) {
        assert (!binding.isIntersectionType18() && !binding.isIntersectionType()) : binding.debugName();
        if (binding.isBaseType()) {
            return String.valueOf(binding.sourceName());
        }
        return String.valueOf(binding.constantPoolName());
    }

    public static void setClassDispositionFromBinding(SourceTypeBinding binding, JDeclaredType type) {
        if (binding.isNestedType()) {
            if (JdtUtil.isLocalClass(binding)) {
                type.setClassDisposition(JDeclaredType.NestedClassDisposition.LOCAL);
            } else if (binding.isAnonymousType()) {
                type.setClassDisposition(JDeclaredType.NestedClassDisposition.ANONYMOUS);
            } else if (JdtUtil.isInnerClass(binding)) {
                type.setClassDisposition(JDeclaredType.NestedClassDisposition.INNER);
            } else if (JdtUtil.isStaticClass(binding)) {
                type.setClassDisposition(JDeclaredType.NestedClassDisposition.STATIC);
            }
        } else {
            type.setClassDisposition(JDeclaredType.NestedClassDisposition.TOP_LEVEL);
        }
    }

    public static boolean isLocalClass(SourceTypeBinding binding) {
        return binding.isLocalType() && !binding.isAnonymousType();
    }

    public static boolean isStaticClass(SourceTypeBinding binding) {
        return binding.isNestedType() && binding.isStatic();
    }

    public static boolean isJso(TypeBinding typeBinding) {
        if (!(typeBinding instanceof ReferenceBinding)) {
            return false;
        }
        for (ReferenceBinding binding = (ReferenceBinding)typeBinding; binding != null; binding = binding.superclass()) {
            if (!JSO_CLASS.equals(String.valueOf(binding.constantPoolName()))) continue;
            return true;
        }
        return false;
    }

    public static boolean isJsoSubclass(TypeBinding typeBinding) {
        if (!(typeBinding instanceof ReferenceBinding)) {
            return false;
        }
        ReferenceBinding binding = (ReferenceBinding)typeBinding;
        return JdtUtil.isJso(binding.superclass());
    }

    public static Iterable<ReferenceBinding> getSuperInterfacesRequiringInitialization(ReferenceBinding type) {
        Iterable<ReferenceBinding> interfaces = Collections.emptyList();
        for (ReferenceBinding interfaceType : type.superInterfaces()) {
            interfaces = Iterables.concat(interfaces, JdtUtil.getSuperInterfacesRequiringInitialization(interfaceType));
            if (!JdtUtil.hasDefaultMethods(interfaceType)) continue;
            interfaces = Iterables.concat(interfaces, Collections.singleton(interfaceType));
        }
        return interfaces;
    }

    private static boolean hasDefaultMethods(ReferenceBinding interfaceType) {
        return Iterables.any(Arrays.asList(interfaceType.methods()), new Predicate<MethodBinding>(){

            @Override
            public boolean apply(MethodBinding methodBinding) {
                return methodBinding.isDefaultMethod();
            }
        });
    }

    public static boolean requiresBoxing(int implicitConversion) {
        return implicitConversion != -1 && (implicitConversion & 0x200) != 0;
    }

    public static boolean requiresUnboxing(int implicitConversion) {
        return implicitConversion != -1 && (implicitConversion & 0x400) != 0;
    }

    public static BaseTypeBinding getBoxingPrimitiveType(ClassScope scope, int implicitConversion) {
        int typeId = (implicitConversion & 0xFF) >> 4;
        return JdtUtil.getBaseTypeBinding(scope, typeId);
    }

    public static BaseTypeBinding getUnboxingPrimitiveType(ClassScope scope, int implicitConversion) {
        if (JdtUtil.needsCastBeforeUnbox(scope, implicitConversion)) {
            int typeId = (implicitConversion & 0xFF) >> 4;
            return JdtUtil.getBaseTypeBinding(scope, typeId);
        }
        int compileTypeId = implicitConversion & 0xF;
        return JdtUtil.getBaseTypeBinding(scope, compileTypeId);
    }

    public static BaseTypeBinding getBaseTypeBinding(ClassScope scope, int typeId) {
        return (BaseTypeBinding)TypeBinding.wellKnownType(scope, typeId);
    }

    public static ReferenceBinding getBoxedTypeBinding(ClassScope scope, BaseTypeBinding primitiveType) {
        return (ReferenceBinding)scope.boxing(primitiveType);
    }

    public static boolean needsCastBeforeUnbox(ClassScope scope, int implicitConversion) {
        int compileTypeId = implicitConversion & 0xF;
        return !(TypeBinding.wellKnownType(scope, compileTypeId) instanceof BaseTypeBinding);
    }

    public static MethodBinding getBoxingMethodBinding(ClassScope scope, BaseTypeBinding primitiveType) {
        ReferenceBinding boxType = (ReferenceBinding)scope.boxing(primitiveType);
        MethodBinding valueOfMethod = boxType.getExactMethod(VALUE_OF_, new TypeBinding[]{primitiveType}, scope.compilationUnitScope());
        assert (valueOfMethod != null);
        return valueOfMethod;
    }

    public static MethodBinding getUnboxingMethodBinding(ClassScope scope, BaseTypeBinding primitiveType) {
        ReferenceBinding boxType = (ReferenceBinding)scope.boxing(primitiveType);
        char[] selector = CharOperation.concat(primitiveType.simpleName, VALUE_SUFFIX_);
        MethodBinding valueMethod = boxType.getExactMethod(selector, new TypeBinding[0], scope.compilationUnitScope());
        assert (valueMethod != null);
        return valueMethod;
    }
}

