/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.javac;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.dev.CompilerContext;
import com.google.gwt.dev.javac.CompilationUnit;
import com.google.gwt.dev.javac.CompilationUnitBuilder;
import com.google.gwt.dev.javac.CompiledClass;
import com.google.gwt.dev.javac.Dependencies;
import com.google.gwt.dev.javac.GwtIncompatiblePreprocessor;
import com.google.gwt.dev.javac.JdtUtil;
import com.google.gwt.dev.javac.MethodArgNamesLookup;
import com.google.gwt.dev.javac.Shared;
import com.google.gwt.dev.javac.UnusedImportsRemover;
import com.google.gwt.dev.jdt.TypeRefVisitor;
import com.google.gwt.dev.util.arg.SourceLevel;
import com.google.gwt.dev.util.collect.Lists;
import com.google.gwt.dev.util.log.speedtracer.CompilerEventType;
import com.google.gwt.dev.util.log.speedtracer.SpeedTracerLogger;
import com.google.gwt.thirdparty.guava.common.collect.ArrayListMultimap;
import com.google.gwt.thirdparty.guava.common.collect.ImmutableMap;
import com.google.gwt.thirdparty.guava.common.collect.ListMultimap;
import com.google.gwt.thirdparty.guava.common.collect.Maps;
import com.google.gwt.thirdparty.guava.common.collect.Sets;
import com.google.gwt.thirdparty.guava.common.io.BaseEncoding;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.Block;
import org.eclipse.jdt.internal.compiler.ast.Clinit;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.ast.Initializer;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.MissingTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.NestedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.UnresolvedReferenceBinding;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;

public class JdtCompiler {
    private static final double ABORT_COUNT_MAX = 100.0;
    private final Map<String, CompiledClass> internalTypes = new HashMap<String, CompiledClass>();
    private final Set<String> unresolvableReferences = Sets.newHashSet();
    private transient CompilerImpl compilerImpl;
    private final Set<String> packages = new HashSet<String>();
    private final UnitProcessor processor;
    private final SourceLevel sourceLevel;
    private CompilerContext compilerContext;
    private static boolean removeUnusedImports = true;
    private static final Map<SourceLevel, Long> jdtLevelByGwtLevel = ImmutableMap.of(SourceLevel.JAVA8, 0x340000L, SourceLevel.JAVA9, 0x350000L, SourceLevel.JAVA10, 0x360000L, SourceLevel.JAVA11, 0x370000L, SourceLevel.JAVA17, 0x3D0000L);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<CompilationUnit> compile(TreeLogger logger, CompilerContext compilerContext, Collection<CompilationUnitBuilder> builders) throws UnableToCompleteException {
        SpeedTracerLogger.Event jdtCompilerEvent = SpeedTracerLogger.start(CompilerEventType.JDT_COMPILER, new String[0]);
        try {
            DefaultUnitProcessor processor = new DefaultUnitProcessor();
            JdtCompiler compiler = new JdtCompiler(compilerContext, processor);
            compiler.doCompile(logger, builders);
            List<CompilationUnit> list = processor.getResults();
            return list;
        }
        finally {
            jdtCompilerEvent.end(new String[0]);
        }
    }

    public static CompilerOptions getStandardCompilerOptions() {
        long jdtSourceLevel;
        CompilerOptions options = new CompilerOptions(){
            {
                this.warningThreshold.clearAll();
            }
        };
        options.originalSourceLevel = jdtSourceLevel = jdtLevelByGwtLevel.get((Object)SourceLevel.DEFAULT_SOURCE_LEVEL).longValue();
        options.complianceLevel = jdtSourceLevel;
        options.sourceLevel = jdtSourceLevel;
        options.targetJDK = jdtSourceLevel;
        options.storeAnnotations = true;
        options.produceDebugAttributes = 7;
        options.preserveAllLocalVariables = true;
        options.produceReferenceInfo = true;
        options.reportUnusedDeclaredThrownExceptionIncludeDocCommentReference = false;
        options.reportUnusedDeclaredThrownExceptionExemptExceptionAndThrowable = false;
        options.inlineJsrBytecode = true;
        return options;
    }

    public CompilerOptions getCompilerOptions() {
        long jdtSourceLevel;
        CompilerOptions options = JdtCompiler.getStandardCompilerOptions();
        options.originalSourceLevel = jdtSourceLevel = jdtLevelByGwtLevel.get((Object)this.sourceLevel).longValue();
        options.complianceLevel = jdtSourceLevel;
        options.sourceLevel = jdtSourceLevel;
        options.targetJDK = jdtSourceLevel;
        return options;
    }

    private static ReferenceBinding resolveType(LookupEnvironment lookupEnvironment, String sourceOrBinaryName) {
        ReferenceBinding type = null;
        int p = sourceOrBinaryName.indexOf(36);
        if (p > 0) {
            String cupName = sourceOrBinaryName.substring(0, p);
            char[][] chars = CharOperation.splitOn('.', cupName.toCharArray());
            ReferenceBinding outerType = lookupEnvironment.getType(chars);
            if (outerType != null) {
                JdtCompiler.resolveRecursive(outerType);
                chars = CharOperation.splitOn('.', sourceOrBinaryName.toCharArray());
                type = lookupEnvironment.getCachedType(chars);
                if (type == null) {
                    return null;
                }
            }
        } else {
            char[][] chars = CharOperation.splitOn('.', sourceOrBinaryName.toCharArray());
            type = lookupEnvironment.getType(chars);
        }
        if (type != null) {
            if (type instanceof UnresolvedReferenceBinding) {
                type = (ReferenceBinding)BinaryTypeBinding.resolveType(type, lookupEnvironment, true);
            }
            return type;
        }
        p = sourceOrBinaryName.lastIndexOf(46);
        if (p >= 0) {
            sourceOrBinaryName = sourceOrBinaryName.substring(0, p) + "$" + sourceOrBinaryName.substring(p + 1);
            return JdtCompiler.resolveType(lookupEnvironment, sourceOrBinaryName);
        }
        return null;
    }

    private static boolean isLocalType(ClassFile classFile) {
        SourceTypeBinding b = classFile.referenceBinding;
        while (!b.isStatic()) {
            if (b instanceof LocalTypeBinding) {
                return true;
            }
            b = ((NestedTypeBinding)b).enclosingType;
        }
        return false;
    }

    private static void resolveRecursive(ReferenceBinding outerType) {
        for (ReferenceBinding memberType : outerType.memberTypes()) {
            JdtCompiler.resolveRecursive(memberType);
        }
    }

    public JdtCompiler(CompilerContext compilerContext, UnitProcessor processor) {
        this.compilerContext = compilerContext;
        this.processor = processor;
        this.sourceLevel = compilerContext.getOptions().getSourceLevel();
    }

    public void addCompiledUnit(CompilationUnit unit) {
        this.addPackages(Shared.getPackageName(unit.getTypeName()).replace('.', '/'));
        this.addBinaryTypes(unit.getCompiledClasses());
    }

    public ArrayList<String> collectApiRefs(final CompilationUnitDeclaration cud) {
        final HashSet apiRefs = new HashSet();
        class DependencyVisitor
        extends TypeRefVisitor {
            public DependencyVisitor() {
                super(compilationUnitDeclaration);
            }

            @Override
            public boolean visit(Argument arg, BlockScope scope) {
                if (arg.type != null) {
                    arg.type.traverse((ASTVisitor)this, scope);
                }
                return false;
            }

            @Override
            public boolean visit(Argument arg, ClassScope scope) {
                if (arg.type != null) {
                    arg.type.traverse((ASTVisitor)this, scope);
                }
                return false;
            }

            @Override
            public boolean visit(Block block, BlockScope scope) {
                assert (false) : "Error in DepedencyVisitor; should never visit a block";
                return false;
            }

            @Override
            public boolean visit(Clinit clinit, ClassScope scope) {
                return false;
            }

            @Override
            public boolean visit(ConstructorDeclaration ctor, ClassScope scope) {
                if (ctor.typeParameters != null) {
                    int typeParametersLength = ctor.typeParameters.length;
                    for (int i = 0; i < typeParametersLength; ++i) {
                        ctor.typeParameters[i].traverse((ASTVisitor)this, ctor.scope);
                    }
                }
                this.traverse(ctor);
                return false;
            }

            @Override
            public boolean visit(FieldDeclaration fieldDeclaration, MethodScope scope) {
                if (fieldDeclaration.type != null) {
                    fieldDeclaration.type.traverse((ASTVisitor)this, scope);
                }
                return false;
            }

            @Override
            public boolean visit(Initializer initializer, MethodScope scope) {
                return false;
            }

            @Override
            public boolean visit(MethodDeclaration meth, ClassScope scope) {
                if (meth.typeParameters != null) {
                    int typeParametersLength = meth.typeParameters.length;
                    for (int i = 0; i < typeParametersLength; ++i) {
                        meth.typeParameters[i].traverse((ASTVisitor)this, meth.scope);
                    }
                }
                if (meth.returnType != null) {
                    meth.returnType.traverse((ASTVisitor)this, meth.scope);
                }
                this.traverse(meth);
                return false;
            }

            @Override
            public boolean visit(TypeDeclaration typeDeclaration, ClassScope scope) {
                this.traverse(typeDeclaration);
                return false;
            }

            @Override
            public boolean visit(TypeDeclaration typeDeclaration, CompilationUnitScope scope) {
                this.traverse(typeDeclaration);
                return false;
            }

            @Override
            protected void onMissingTypeRef(MissingTypeBinding referencedType, CompilationUnitDeclaration unitOfReferrer, Expression expression) {
                this.addReference(referencedType);
            }

            @Override
            protected void onBinaryTypeRef(BinaryTypeBinding referencedType, CompilationUnitDeclaration unitOfReferrer, Expression expression) {
                if (!String.valueOf(referencedType.getFileName()).endsWith(".java")) {
                    return;
                }
                this.addReference(referencedType);
            }

            @Override
            protected void onTypeRef(SourceTypeBinding referencedType, CompilationUnitDeclaration unitOfReferrer) {
                this.addReference(referencedType);
            }

            private void addReference(ReferenceBinding referencedType) {
                apiRefs.add(JdtUtil.getSourceName(referencedType));
            }

            private void traverse(AbstractMethodDeclaration meth) {
                int i;
                if (meth.arguments != null) {
                    int argumentLength = meth.arguments.length;
                    for (i = 0; i < argumentLength; ++i) {
                        meth.arguments[i].traverse((ASTVisitor)this, meth.scope);
                    }
                }
                if (meth.thrownExceptions != null) {
                    int thrownExceptionsLength = meth.thrownExceptions.length;
                    for (i = 0; i < thrownExceptionsLength; ++i) {
                        meth.thrownExceptions[i].traverse((ASTVisitor)this, meth.scope);
                    }
                }
            }

            private void traverse(TypeDeclaration type) {
                int i;
                int length;
                if (type.superclass != null) {
                    type.superclass.traverse((ASTVisitor)this, type.scope);
                }
                if (type.superInterfaces != null) {
                    length = type.superInterfaces.length;
                    for (i = 0; i < length; ++i) {
                        type.superInterfaces[i].traverse((ASTVisitor)this, type.scope);
                    }
                }
                if (type.typeParameters != null) {
                    length = type.typeParameters.length;
                    for (i = 0; i < length; ++i) {
                        type.typeParameters[i].traverse((ASTVisitor)this, type.scope);
                    }
                }
                if (type.memberTypes != null) {
                    length = type.memberTypes.length;
                    for (i = 0; i < length; ++i) {
                        type.memberTypes[i].traverse((ASTVisitor)this, type.scope);
                    }
                }
                if (type.fields != null) {
                    for (FieldDeclaration field : type.fields) {
                        if (field.isStatic()) {
                            field.traverse((ASTVisitor)this, type.staticInitializerScope);
                            continue;
                        }
                        field.traverse((ASTVisitor)this, type.initializerScope);
                    }
                }
                if (type.methods != null) {
                    length = type.methods.length;
                    for (i = 0; i < length; ++i) {
                        type.methods[i].traverse((ASTVisitor)this, type.scope);
                    }
                }
            }
        }
        DependencyVisitor visitor = new DependencyVisitor();
        cud.traverse((ASTVisitor)visitor, cud.scope);
        ArrayList<String> result = new ArrayList<String>(apiRefs);
        Collections.sort(result);
        return result;
    }

    public void doCompile(TreeLogger logger, Collection<CompilationUnitBuilder> builders) throws UnableToCompleteException {
        if (builders.isEmpty()) {
            return;
        }
        ArrayList<Adapter> icus = new ArrayList<Adapter>();
        for (CompilationUnitBuilder builder : builders) {
            this.addPackages(Shared.getPackageName(builder.getTypeName()).replace('.', '/'));
            icus.add(new Adapter(builder));
        }
        this.compilerImpl = new CompilerImpl(logger, this.getCompilerOptions(), new INameEnvironmentImpl(this.packages, this.internalTypes), this.processor, this.internalTypes);
        try {
            this.compilerImpl.compile(icus.toArray(new ICompilationUnit[icus.size()]));
        }
        catch (AbortCompilation e) {
            String compilerAborted = String.format("JDT compiler aborted after %d errors", this.compilerImpl.getAbortCount());
            if (e.problem == null) {
                logger.log(TreeLogger.Type.ERROR, compilerAborted + ".");
            } else if (e.problem.getOriginatingFileName() == null) {
                logger.log(TreeLogger.Type.ERROR, compilerAborted + ": " + e.problem.getMessage());
            } else {
                String filename = new String(e.problem.getOriginatingFileName());
                TreeLogger branch = logger.branch(TreeLogger.Type.ERROR, "At " + filename + ": " + e.problem.getSourceLineNumber());
                branch.log(TreeLogger.Type.ERROR, compilerAborted + ": " + e.problem.getMessage());
            }
            throw new UnableToCompleteException();
        }
        finally {
            this.compilerImpl = null;
        }
    }

    public ReferenceBinding resolveType(String sourceOrBinaryName) {
        if (this.unresolvableReferences.contains(sourceOrBinaryName)) {
            return null;
        }
        ReferenceBinding typeBinding = JdtCompiler.resolveType(this.compilerImpl.lookupEnvironment, sourceOrBinaryName);
        if (typeBinding == null) {
            this.unresolvableReferences.add(sourceOrBinaryName);
        }
        return typeBinding;
    }

    public static void setRemoveUnusedImports(boolean remove) {
        removeUnusedImports = remove;
    }

    private void addBinaryTypes(Collection<CompiledClass> compiledClasses) {
        JdtCompiler.addBinaryTypes(compiledClasses, this.internalTypes);
    }

    private static void addBinaryTypes(Collection<CompiledClass> compiledClasses, Map<String, CompiledClass> internalTypes) {
        for (CompiledClass cc : compiledClasses) {
            internalTypes.put(cc.getInternalName(), cc);
        }
    }

    private void addPackages(String slashedPackageName) {
        JdtCompiler.addPackages(this.packages, slashedPackageName);
    }

    private static void addPackages(Set<String> packages, String slashedPackageName) {
        while (packages.add(slashedPackageName)) {
            int pos = slashedPackageName.lastIndexOf(47);
            if (pos > 0) {
                slashedPackageName = slashedPackageName.substring(0, pos);
                continue;
            }
            packages.add("");
            break;
        }
    }

    private static boolean caseSensitivePathExists(String resourcePath) {
        URL resourceURL = JdtCompiler.getClassLoader().getResource(resourcePath + '/');
        if (resourceURL == null) {
            return false;
        }
        try {
            File resourceFile = new File(resourceURL.toURI());
            return Arrays.asList(resourceFile.getParentFile().list()).contains(resourceFile.getName());
        }
        catch (URISyntaxException uRISyntaxException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return true;
    }

    private static ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    private static class INameEnvironmentImpl
    implements INameEnvironment {
        private final Map<String, NameEnvironmentAnswer> cachedClassPathAnswerByInternalName = Maps.newHashMap();
        private final Set<String> packages;
        private final Set<String> notPackages = new HashSet<String>();
        private final Map<String, CompiledClass> internalTypes;

        public INameEnvironmentImpl(Set<String> packages, Map<String, CompiledClass> internalTypes) {
            this.packages = packages;
            this.internalTypes = internalTypes;
        }

        @Override
        public void cleanup() {
        }

        @Override
        public NameEnvironmentAnswer findType(char[] type, char[][] pkg) {
            return this.findType(CharOperation.arrayConcat(pkg, type));
        }

        @Override
        public NameEnvironmentAnswer findType(char[][] compoundTypeName) {
            char[] internalNameChars = CharOperation.concatWith(compoundTypeName, '/');
            String internalName = String.valueOf(internalNameChars);
            if (this.packages.contains(internalName)) {
                return null;
            }
            NameEnvironmentAnswer cachedAnswer = this.findTypeInCache(internalName);
            if (cachedAnswer != null) {
                return cachedAnswer;
            }
            NameEnvironmentAnswer classPathAnswer = this.findTypeInClassPath(internalName);
            if (classPathAnswer != null) {
                return classPathAnswer;
            }
            return null;
        }

        private byte[] getLambdaMetafactoryBytes() {
            return BaseEncoding.base64().decode("yv66vgAAADMAFwoAAwARBwASBwATAQAGPGluaXQ+AQADKClWAQAEQ29kZQEAD0xpbmVOdW1iZXJUYWJsZQEAC21ldGFmYWN0b3J5BwAVAQAGTG9va3VwAQAMSW5uZXJDbGFzc2VzAQDMKExqYXZhL2xhbmcvaW52b2tlL01ldGhvZEhhbmRsZXMkTG9va3VwO0xqYXZhL2xhbmcvU3RyaW5nO0xqYXZhL2xhbmcvaW52b2tlL01ldGhvZFR5cGU7TGphdmEvbGFuZy9pbnZva2UvTWV0aG9kVHlwZTtMamF2YS9sYW5nL2ludm9rZS9NZXRob2RIYW5kbGU7TGphdmEvbGFuZy9pbnZva2UvTWV0aG9kVHlwZTspTGphdmEvbGFuZy9pbnZva2UvQ2FsbFNpdGU7AQAOYWx0TWV0YWZhY3RvcnkBAIYoTGphdmEvbGFuZy9pbnZva2UvTWV0aG9kSGFuZGxlcyRMb29rdXA7TGphdmEvbGFuZy9TdHJpbmc7TGphdmEvbGFuZy9pbnZva2UvTWV0aG9kVHlwZTtbTGphdmEvbGFuZy9PYmplY3Q7KUxqYXZhL2xhbmcvaW52b2tlL0NhbGxTaXRlOwEAClNvdXJjZUZpbGUBABZMYW1iZGFNZXRhZmFjdG9yeS5qYXZhDAAEAAUBACJqYXZhL2xhbmcvaW52b2tlL0xhbWJkYU1ldGFmYWN0b3J5AQAQamF2YS9sYW5nL09iamVjdAcAFgEAJWphdmEvbGFuZy9pbnZva2UvTWV0aG9kSGFuZGxlcyRMb29rdXABAB5qYXZhL2xhbmcvaW52b2tlL01ldGhvZEhhbmRsZXMAIQACAAMAAAAAAAMAAQAEAAUAAQAGAAAAHQABAAEAAAAFKrcAAbEAAAABAAcAAAAGAAEAAAAGAAkACAAMAAEABgAAABoAAQAGAAAAAgGwAAAAAQAHAAAABgABAAAAEACJAA0ADgABAAYAAAAaAAEABAAAAAIBsAAAAAEABwAAAAYAAQAAABUAAgAPAAAAAgAQAAsAAAAKAAEACQAUAAoAGQ==");
        }

        private byte[] getSerializedLambdaBytes() {
            return BaseEncoding.base64().decode("yv66vgAAADMAIQoABAAcCgAEAB0HAB4HAB8BAAY8aW5pdD4BAKYoTGphdmEvbGFuZy9DbGFzcztMamF2YS9sYW5nL1N0cmluZztMamF2YS9sYW5nL1N0cmluZztMamF2YS9sYW5nL1N0cmluZztJTGphdmEvbGFuZy9TdHJpbmc7TGphdmEvbGFuZy9TdHJpbmc7TGphdmEvbGFuZy9TdHJpbmc7TGphdmEvbGFuZy9TdHJpbmc7W0xqYXZhL2xhbmcvT2JqZWN0OylWAQAEQ29kZQEAD0xpbmVOdW1iZXJUYWJsZQEACVNpZ25hdHVyZQEAqShMamF2YS9sYW5nL0NsYXNzPCo+O0xqYXZhL2xhbmcvU3RyaW5nO0xqYXZhL2xhbmcvU3RyaW5nO0xqYXZhL2xhbmcvU3RyaW5nO0lMamF2YS9sYW5nL1N0cmluZztMamF2YS9sYW5nL1N0cmluZztMamF2YS9sYW5nL1N0cmluZztMamF2YS9sYW5nL1N0cmluZztbTGphdmEvbGFuZy9PYmplY3Q7KVYBABFnZXRDYXB0dXJpbmdDbGFzcwEAFCgpTGphdmEvbGFuZy9TdHJpbmc7AQAbZ2V0RnVuY3Rpb25hbEludGVyZmFjZUNsYXNzAQAgZ2V0RnVuY3Rpb25hbEludGVyZmFjZU1ldGhvZE5hbWUBACVnZXRGdW5jdGlvbmFsSW50ZXJmYWNlTWV0aG9kU2lnbmF0dXJlAQAMZ2V0SW1wbENsYXNzAQARZ2V0SW1wbE1ldGhvZE5hbWUBABZnZXRJbXBsTWV0aG9kU2lnbmF0dXJlAQARZ2V0SW1wbE1ldGhvZEtpbmQBAAMoKUkBABlnZXRJbnN0YW50aWF0ZWRNZXRob2RUeXBlAQATZ2V0Q2FwdHVyZWRBcmdDb3VudAEADmdldENhcHR1cmVkQXJnAQAVKEkpTGphdmEvbGFuZy9PYmplY3Q7AQAIdG9TdHJpbmcBAApTb3VyY2VGaWxlAQAVU2VyaWFsaXplZExhbWJkYS5qYXZhDAAFACAMABkADAEAIWphdmEvbGFuZy9pbnZva2UvU2VyaWFsaXplZExhbWJkYQEAEGphdmEvbGFuZy9PYmplY3QBAAMoKVYAIQADAAQAAAAAAA0AAQAFAAYAAgAHAAAAIQABAAsAAAAFKrcAAbEAAAABAAgAAAAKAAIAAAANAAQADgAJAAAAAgAKAAEACwAMAAEABwAAABoAAQABAAAAAgGwAAAAAQAIAAAABgABAAAAEAABAA0ADAABAAcAAAAaAAEAAQAAAAIBsAAAAAEACAAAAAYAAQAAABEAAQAOAAwAAQAHAAAAGgABAAEAAAACAbAAAAABAAgAAAAGAAEAAAASAAEADwAMAAEABwAAABoAAQABAAAAAgGwAAAAAQAIAAAABgABAAAAEwABABAADAABAAcAAAAaAAEAAQAAAAIBsAAAAAEACAAAAAYAAQAAABQAAQARAAwAAQAHAAAAGgABAAEAAAACAbAAAAABAAgAAAAGAAEAAAAVAAEAEgAMAAEABwAAABoAAQABAAAAAgGwAAAAAQAIAAAABgABAAAAFgABABMAFAABAAcAAAAaAAEAAQAAAAIDrAAAAAEACAAAAAYAAQAAABcAEQAVAAwAAQAHAAAAGgABAAEAAAACAbAAAAABAAgAAAAGAAEAAAAYAAEAFgAUAAEABwAAABoAAQABAAAAAgOsAAAAAQAIAAAABgABAAAAGQABABcAGAABAAcAAAAaAAEAAgAAAAIBsAAAAAEACAAAAAYAAQAAABoAAQAZAAwAAQAHAAAAHQABAAEAAAAFKrcAArAAAAABAAgAAAAGAAEAAAAbAAEAGgAAAAIAGw==");
        }

        private NameEnvironmentAnswer findTypeInCache(String internalName) {
            if (!this.internalTypes.containsKey(internalName)) {
                return null;
            }
            try {
                return this.internalTypes.get(internalName).getNameEnvironmentAnswer();
            }
            catch (ClassFormatException ex) {
                return null;
            }
        }

        private NameEnvironmentAnswer findTypeInClassPath(String internalName) {
            if (this.cachedClassPathAnswerByInternalName.containsKey(internalName)) {
                return this.cachedClassPathAnswerByInternalName.get(internalName);
            }
            NameEnvironmentAnswer answer = this.doFindTypeInClassPath(internalName);
            this.cachedClassPathAnswerByInternalName.put(internalName, answer);
            return answer;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private NameEnvironmentAnswer doFindTypeInClassPath(String internalName) {
            ClassFileReader cfr;
            URL resource = JdtCompiler.getClassLoader().getResource(internalName + ".class");
            if (resource != null) {
                try (InputStream openStream2222 = resource.openStream();){
                    ClassFileReader classFileReader = ClassFileReader.read(openStream2222, resource.toExternalForm(), true);
                    if (internalName.equals(CharOperation.charToString(classFileReader.getName()))) {
                        NameEnvironmentAnswer nameEnvironmentAnswer = new NameEnvironmentAnswer(classFileReader, null);
                        return nameEnvironmentAnswer;
                    }
                }
                catch (IOException | ClassFormatException openStream2222) {
                    // empty catch block
                }
            }
            if (internalName.equals("java/lang/invoke/LambdaMetafactory")) {
                try {
                    cfr = new ClassFileReader(this.getLambdaMetafactoryBytes(), "synthetic:java/lang/invoke/LambdaMetafactory".toCharArray(), true);
                    return new NameEnvironmentAnswer(cfr, null);
                }
                catch (ClassFormatException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            if (!internalName.equals("java/lang/invoke/SerializedLambda")) return null;
            try {
                cfr = new ClassFileReader(this.getSerializedLambdaBytes(), "synthetic:java/lang/invoke/SerializedLambda".toCharArray(), true);
                return new NameEnvironmentAnswer(cfr, null);
            }
            catch (ClassFormatException e) {
                e.printStackTrace();
            }
            return null;
        }

        @Override
        public boolean isPackage(char[][] parentPkg, char[] pkg) {
            char[] pathChars = CharOperation.concatWith(parentPkg, pkg, '/');
            String packageName = String.valueOf(pathChars);
            return this.isPackage(packageName);
        }

        private boolean isPackage(String slashedPackageName) {
            if (this.packages.contains(slashedPackageName)) {
                return true;
            }
            if (this.notPackages.contains(slashedPackageName)) {
                return false;
            }
            if (JdtCompiler.caseSensitivePathExists(slashedPackageName)) {
                JdtCompiler.addPackages(this.packages, slashedPackageName);
                return true;
            }
            this.notPackages.add(slashedPackageName);
            return false;
        }
    }

    private static class ICompilerRequestorImpl
    implements ICompilerRequestor {
        private ICompilerRequestorImpl() {
        }

        @Override
        public void acceptResult(CompilationResult result) {
        }
    }

    private static class CompilerImpl
    extends Compiler {
        private final TreeLogger logger;
        private int abortCount = 0;
        private final UnitProcessor processor;
        private final Map<String, CompiledClass> internalTypes;

        public CompilerImpl(TreeLogger logger, CompilerOptions compilerOptions, INameEnvironment nameEnvironment, UnitProcessor processor, Map<String, CompiledClass> internalTypes) {
            super(nameEnvironment, DefaultErrorHandlingPolicies.proceedWithAllProblems(), compilerOptions, (ICompilerRequestor)new ICompilerRequestorImpl(), (IProblemFactory)new DefaultProblemFactory(Locale.getDefault()));
            this.logger = logger;
            this.processor = processor;
            this.internalTypes = internalTypes;
        }

        @Override
        protected void handleInternalException(AbortCompilation abortException, CompilationUnitDeclaration unit) {
            throw abortException;
        }

        @Override
        public void initializeParser() {
            this.parser = new ParserImpl(this.problemReporter, this.options.parseLiteralExpressionsAsConstants);
        }

        @Override
        public void process(CompilationUnitDeclaration cud, int i) {
            try {
                super.process(cud, i);
            }
            catch (AbortCompilation e) {
                ++this.abortCount;
                String filename = new String(cud.getFileName());
                this.logger.log(TreeLogger.WARN, "JDT aborted: " + filename + ": " + e.problem.getMessage());
                if ((double)this.abortCount >= 100.0) {
                    this.logger.log(TreeLogger.ERROR, "JDT threw too many exceptions.");
                    throw e;
                }
                return;
            }
            catch (RuntimeException e) {
                ++this.abortCount;
                String filename = new String(cud.getFileName());
                this.logger.log(TreeLogger.WARN, "JDT threw an exception: " + filename + ": " + e);
                if ((double)this.abortCount >= 100.0) {
                    this.logger.log(TreeLogger.ERROR, "JDT threw too many exceptions.");
                    throw new AbortCompilation(cud.compilationResult, (Throwable)e);
                }
                return;
            }
            ClassFile[] classFiles = cud.compilationResult().getClassFiles();
            LinkedHashMap<ClassFile, CompiledClass> results = new LinkedHashMap<ClassFile, CompiledClass>();
            for (ClassFile classFile : classFiles) {
                this.createCompiledClass(classFile, results);
            }
            ArrayList<CompiledClass> compiledClasses = new ArrayList<CompiledClass>(results.values());
            JdtCompiler.addBinaryTypes(compiledClasses, this.internalTypes);
            ICompilationUnit icu = cud.compilationResult().compilationUnit;
            Adapter adapter = (Adapter)icu;
            CompilationUnitBuilder builder = adapter.getBuilder();
            assert (this.parser instanceof ParserImpl);
            Collection cudOriginalImports = ((ParserImpl)this.parser).originalImportsByCud.removeAll(cud);
            this.processor.process(builder, cud, (List<ImportReference>)cudOriginalImports, compiledClasses);
        }

        private void createCompiledClass(ClassFile classFile, Map<ClassFile, CompiledClass> results) {
            if (results.containsKey(classFile)) {
                return;
            }
            CompiledClass enclosingClass = null;
            if (classFile.enclosingClassFile != null) {
                ClassFile enclosingClassFile = classFile.enclosingClassFile;
                this.createCompiledClass(enclosingClassFile, results);
                enclosingClass = results.get(enclosingClassFile);
                assert (enclosingClass != null);
            }
            String internalName = CharOperation.charToString(classFile.fileName());
            String sourceName = JdtUtil.getSourceName(classFile.referenceBinding);
            CompiledClass result = new CompiledClass(classFile.getBytes(), enclosingClass, JdtCompiler.isLocalType(classFile), internalName, sourceName);
            results.put(classFile, result);
        }

        int getAbortCount() {
            return this.abortCount;
        }
    }

    private static class ParserImpl
    extends Parser {
        public final ListMultimap<CompilationUnitDeclaration, ImportReference> originalImportsByCud = ArrayListMultimap.create();

        public ParserImpl(ProblemReporter problemReporter, boolean optimizeStringLiterals) {
            super(problemReporter, optimizeStringLiterals);
        }

        @Override
        public CompilationUnitDeclaration parse(ICompilationUnit sourceUnit, CompilationResult compilationResult) {
            boolean saveDiet = this.diet;
            this.diet = false;
            CompilationUnitDeclaration decl = super.parse(sourceUnit, compilationResult);
            this.diet = saveDiet;
            GwtIncompatiblePreprocessor.preproccess(decl);
            if (decl.imports != null) {
                this.originalImportsByCud.putAll(decl, Arrays.asList(decl.imports));
            }
            if (decl.hasErrors()) {
                return decl;
            }
            if (removeUnusedImports) {
                UnusedImportsRemover.exec(decl);
            }
            return decl;
        }
    }

    private static class Adapter
    implements ICompilationUnit {
        private final CompilationUnitBuilder builder;

        public Adapter(CompilationUnitBuilder builder) {
            this.builder = builder;
        }

        public CompilationUnitBuilder getBuilder() {
            return this.builder;
        }

        @Override
        public char[] getContents() {
            return this.builder.getSource().toCharArray();
        }

        @Override
        public char[] getFileName() {
            return this.builder.getLocation().toCharArray();
        }

        @Override
        public char[] getMainTypeName() {
            return Shared.getShortName(this.builder.getTypeName()).toCharArray();
        }

        @Override
        public char[][] getPackageName() {
            String packageName = Shared.getPackageName(this.builder.getTypeName());
            return CharOperation.splitOn('.', packageName.toCharArray());
        }

        @Override
        public boolean ignoreOptionalProblems() {
            return false;
        }

        public String toString() {
            return this.builder.toString();
        }
    }

    public static interface UnitProcessor {
        public void process(CompilationUnitBuilder var1, CompilationUnitDeclaration var2, List<ImportReference> var3, List<CompiledClass> var4);
    }

    public static final class DefaultUnitProcessor
    implements UnitProcessor {
        private final List<CompilationUnit> results = new ArrayList<CompilationUnit>();

        public List<CompilationUnit> getResults() {
            return Lists.normalizeUnmodifiable(this.results);
        }

        @Override
        public void process(CompilationUnitBuilder builder, CompilationUnitDeclaration cud, List<ImportReference> cudOriginaImports, List<CompiledClass> compiledClasses) {
            builder.setClasses(compiledClasses).setTypes(Collections.emptyList()).setDependencies(new Dependencies()).setJsniMethods(Collections.emptyList()).setMethodArgs(new MethodArgNamesLookup()).setProblems(cud.compilationResult().getProblems());
            this.results.add(builder.build());
        }
    }
}

