/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.javac;

import com.google.gwt.core.ext.typeinfo.JType;
import com.google.gwt.dev.javac.typemodel.JAbstractMethod;
import com.google.gwt.dev.javac.typemodel.JClassType;
import com.google.gwt.dev.javac.typemodel.JParameter;
import com.google.gwt.dev.jjs.InternalCompilerException;
import com.google.gwt.dev.resource.Resource;
import com.google.gwt.dev.util.Name;
import com.google.gwt.dev.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.WeakHashMap;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.core.util.CodeSnippetParsingUtil;

public class JavaSourceParser {
    private WeakHashMap<JClassType, Resource> classSources = new WeakHashMap();
    private WeakHashMap<JClassType, SoftReference<CompilationUnitDeclaration>> cudCache = new WeakHashMap();

    public static JClassType getTopmostType(JClassType type) {
        while (type.getEnclosingType() != null) {
            type = type.getEnclosingType();
        }
        return type;
    }

    static List<char[]> getClassChain(String binaryName) {
        int idx;
        ArrayList<char[]> result = new ArrayList<char[]>();
        String className = Name.BinaryName.getClassName(binaryName);
        while ((idx = className.indexOf(36)) >= 0) {
            result.add(className.substring(0, idx).toCharArray());
            className = className.substring(idx + 1);
        }
        result.add(className.toCharArray());
        return result;
    }

    private static AbstractMethodDeclaration findMethod(TypeDeclaration type, JAbstractMethod jMethod) {
        List<AbstractMethodDeclaration> candidates = JavaSourceParser.findNamedMethods(type, jMethod.getName());
        if (candidates.size() == 0) {
            return null;
        }
        if (candidates.size() == 1) {
            return candidates.get(0);
        }
        block0: for (AbstractMethodDeclaration candidate : candidates) {
            JParameter[] params;
            int n = candidate.arguments == null ? 0 : candidate.arguments.length;
            if (n != (params = jMethod.getParameters()).length) continue;
            for (int i = 0; i < n; ++i) {
                if (!JavaSourceParser.typeMatches(candidate.arguments[i].type, params[i].getType())) continue block0;
            }
            return candidate;
        }
        return null;
    }

    private static List<AbstractMethodDeclaration> findNamedMethods(TypeDeclaration type, String name) {
        ArrayList<AbstractMethodDeclaration> matching = new ArrayList<AbstractMethodDeclaration>();
        if (type.methods == null) {
            return matching;
        }
        boolean isCtor = "<init>".equals(name);
        char[] nameArray = name.toCharArray();
        for (AbstractMethodDeclaration method : type.methods) {
            if ((!isCtor || !method.isConstructor()) && (isCtor || method.isConstructor() || method.isClinit() || !Arrays.equals(method.selector, nameArray))) continue;
            matching.add(method);
        }
        return matching;
    }

    private static TypeDeclaration findType(CompilationUnitDeclaration unit, String binaryName) {
        List<char[]> classChain = JavaSourceParser.getClassChain(binaryName);
        TypeDeclaration curType = JavaSourceParser.findType(unit.types, classChain.get(0));
        for (int i = 1; i < classChain.size(); ++i) {
            if (curType == null) {
                return null;
            }
            curType = JavaSourceParser.findType(curType.memberTypes, classChain.get(i));
        }
        return curType;
    }

    private static TypeDeclaration findType(TypeDeclaration[] types, char[] name) {
        if (types == null) {
            return null;
        }
        for (TypeDeclaration type : types) {
            if (!Arrays.equals(name, type.name)) continue;
            return type;
        }
        return null;
    }

    private static CompilationUnitDeclaration parseJava(String javaSource) {
        CodeSnippetParsingUtil parsingUtil = new CodeSnippetParsingUtil(true);
        CompilerOptions options = new CompilerOptions();
        options.complianceLevel = 0x340000L;
        options.originalSourceLevel = 0x340000L;
        options.sourceLevel = 0x340000L;
        CompilationUnitDeclaration unit = parsingUtil.parseCompilationUnit(javaSource.toString().toCharArray(), options.getMap(), true);
        if (unit.compilationResult().hasProblems()) {
            return null;
        }
        return unit;
    }

    private static boolean typeMatches(TypeReference jdtType, JType toType) {
        List<char[]> toNameComponents = JavaSourceParser.getClassChain(toType.getQualifiedBinaryName());
        int toLen = toNameComponents.size();
        char[][] jdtNameComponents = jdtType.getTypeName();
        int jdtLen = jdtNameComponents.length;
        int maxToCompare = Math.min(toLen, jdtLen);
        for (int i = 1; i <= maxToCompare; ++i) {
            if (Arrays.equals(jdtNameComponents[jdtLen - i], toNameComponents.get(toLen - i))) continue;
            return false;
        }
        return true;
    }

    public synchronized void addSourceForType(JClassType topType, Resource source) {
        this.classSources.put(topType, source);
    }

    public synchronized String[] getArguments(JAbstractMethod method) {
        JClassType type = method.getEnclosingType();
        JClassType topType = JavaSourceParser.getTopmostType(type);
        CompilationUnitDeclaration cud = this.getCudForTopLevelType(topType);
        if (cud == null) {
            return null;
        }
        TypeDeclaration jdtType = JavaSourceParser.findType(cud, type.getQualifiedBinaryName());
        if (jdtType == null) {
            return null;
        }
        AbstractMethodDeclaration jdtMethod = JavaSourceParser.findMethod(jdtType, method);
        if (jdtMethod == null) {
            return null;
        }
        int n = jdtMethod.arguments.length;
        String[] argNames = new String[n];
        for (int i = 0; i < n; ++i) {
            argNames[i] = String.valueOf(jdtMethod.arguments[i].name);
        }
        return argNames;
    }

    private synchronized CompilationUnitDeclaration getCudForTopLevelType(JClassType topType) {
        SoftReference<CompilationUnitDeclaration> cudRef;
        CompilationUnitDeclaration cud = null;
        if (this.cudCache.containsKey(topType) && (cudRef = this.cudCache.get(topType)) != null) {
            cud = cudRef.get();
        }
        if (cud == null) {
            Resource classSource = this.classSources.get(topType);
            String source = null;
            if (classSource != null) {
                try {
                    InputStream stream = classSource.openContents();
                    source = Util.readStreamAsString(stream);
                }
                catch (IOException ex) {
                    throw new InternalCompilerException("Problem reading resource: " + classSource.getLocation(), ex);
                }
            }
            if (source == null) {
                this.cudCache.put(topType, null);
            } else {
                cud = JavaSourceParser.parseJava(source);
                this.cudCache.put(topType, new SoftReference<CompilationUnitDeclaration>(cud));
            }
        }
        return cud;
    }
}

