/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.javac;

import com.google.gwt.dev.javac.GWTProblem;
import com.google.gwt.dev.javac.JdtUtil;
import com.google.gwt.dev.jdt.SafeASTVisitor;
import com.google.gwt.dev.util.InstalledHelpInfo;
import com.google.gwt.dev.util.collect.Stack;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileConstants;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class JSORestrictionsChecker {
    public static final String ERR_CONSTRUCTOR_WITH_PARAMETERS = "Constructors must not have parameters in subclasses of JavaScriptObject";
    public static final String ERR_INSTANCE_FIELD = "Instance fields cannot be used in subclasses of JavaScriptObject";
    public static final String ERR_INSTANCE_METHOD_NONFINAL = "Instance methods must be 'final' in non-final subclasses of JavaScriptObject";
    public static final String ERR_IS_NONSTATIC_NESTED = "Nested classes must be 'static' if they extend JavaScriptObject";
    public static final String ERR_NEW_JSO = "'new' cannot be used to create instances of JavaScriptObject subclasses; instances must originate in JavaScript";
    public static final String ERR_NONEMPTY_CONSTRUCTOR = "Constructors must be totally empty in subclasses of JavaScriptObject";
    public static final String ERR_NONPROTECTED_CONSTRUCTOR = "Constructors must be 'protected' in subclasses of JavaScriptObject";
    public static final String ERR_OVERRIDDEN_METHOD = "Methods cannot be overridden in JavaScriptObject subclasses";
    public static final String ERR_JS_FUNCTION_ONLY_ALLOWED_ON_FUNCTIONAL_INTERFACE = "@JsFunction is only allowed on functional interface";
    private final CompilationUnitDeclaration cud;
    private final CheckerState state;

    public static void check(CheckerState state, CompilationUnitDeclaration cud) {
        JSORestrictionsChecker checker = new JSORestrictionsChecker(state, cud);
        checker.check();
    }

    static String errAlreadyImplemented(String intfName, String impl1, String impl2) {
        return "Only one JavaScriptObject type may implement the methods of an interface that declared methods. The interface (" + intfName + ") is implemented by both (" + impl1 + ") and (" + impl2 + ")";
    }

    private static void errorOn(ASTNode node, CompilationUnitDeclaration cud, String error) {
        GWTProblem.recordError(node, cud, error, new InstalledHelpInfo("jsoRestrictions.html"));
    }

    private JSORestrictionsChecker(CheckerState state, CompilationUnitDeclaration cud) {
        this.cud = cud;
        this.state = state;
    }

    private void check() {
        this.cud.traverse((ASTVisitor)new JSORestrictionsVisitor(), this.cud.scope);
    }

    private void errorOn(ASTNode node, String error) {
        JSORestrictionsChecker.errorOn(node, this.cud, error);
    }

    private class JSORestrictionsVisitor
    extends SafeASTVisitor
    implements ClassFileConstants {
        private final Stack<ClassState> classStateStack = new Stack();
        private final Stack<SourceTypeBinding> typeBindingStack = new Stack();

        private JSORestrictionsVisitor() {
        }

        @Override
        public void endVisit(AllocationExpression exp, BlockScope scope) {
            if (exp.type == null) {
                return;
            }
            TypeBinding resolvedType = exp.resolvedType;
            if (resolvedType == null) {
                if (scope == null) {
                    return;
                }
                resolvedType = exp.type.resolveType(scope);
            }
            if (JdtUtil.isJsoSubclass(resolvedType)) {
                JSORestrictionsChecker.this.errorOn(exp, JSORestrictionsChecker.ERR_NEW_JSO);
            }
        }

        @Override
        public void endVisit(ConstructorDeclaration meth, ClassScope scope) {
            if (!this.isJso()) {
                return;
            }
            if (meth.arguments != null && meth.arguments.length > 0) {
                JSORestrictionsChecker.this.errorOn(meth, JSORestrictionsChecker.ERR_CONSTRUCTOR_WITH_PARAMETERS);
            }
            if ((meth.modifiers & 4) == 0) {
                JSORestrictionsChecker.this.errorOn(meth, JSORestrictionsChecker.ERR_NONPROTECTED_CONSTRUCTOR);
            }
            if (meth.statements != null && meth.statements.length > 0) {
                JSORestrictionsChecker.this.errorOn(meth, JSORestrictionsChecker.ERR_NONEMPTY_CONSTRUCTOR);
            }
        }

        @Override
        public void endVisit(FieldDeclaration field, MethodScope scope) {
            if (!this.isJso()) {
                return;
            }
            if (!field.isStatic()) {
                JSORestrictionsChecker.this.errorOn(field, JSORestrictionsChecker.ERR_INSTANCE_FIELD);
            }
        }

        @Override
        public void endVisit(MethodDeclaration meth, ClassScope scope) {
            if (!this.isJso()) {
                return;
            }
            if (!((meth.modifiers & 0x1A) != 0 || meth.scope != null && meth.scope.enclosingSourceType().isFinal())) {
                JSORestrictionsChecker.this.errorOn(meth, JSORestrictionsChecker.ERR_INSTANCE_METHOD_NONFINAL);
            }
            if (!meth.isStatic() && meth.binding != null && meth.binding.isOverriding()) {
                JSORestrictionsChecker.this.errorOn(meth, JSORestrictionsChecker.ERR_OVERRIDDEN_METHOD);
            }
        }

        @Override
        public void endVisit(TypeDeclaration type, ClassScope scope) {
            this.popState();
        }

        @Override
        public void endVisit(TypeDeclaration type, CompilationUnitScope scope) {
            this.popState();
        }

        @Override
        public void endVisitValid(TypeDeclaration type, BlockScope scope) {
            this.popState();
        }

        @Override
        public boolean visit(TypeDeclaration type, ClassScope scope) {
            this.pushState(type);
            return true;
        }

        @Override
        public boolean visit(TypeDeclaration type, CompilationUnitScope scope) {
            this.pushState(type);
            return true;
        }

        @Override
        public boolean visitValid(TypeDeclaration type, BlockScope scope) {
            this.pushState(type);
            return true;
        }

        private void checkJsFunction(TypeDeclaration type) {
            if (JdtUtil.getAnnotationByName(type.annotations, "jsinterop.annotations.JsFunction") == null) {
                return;
            }
            if (!type.binding.isFunctionalInterface(type.scope)) {
                JSORestrictionsChecker.this.errorOn(type, JSORestrictionsChecker.ERR_JS_FUNCTION_ONLY_ALLOWED_ON_FUNCTIONAL_INTERFACE);
                return;
            }
        }

        private ClassState checkType(TypeDeclaration type) {
            ReferenceBinding[] interfaces;
            this.checkJsFunction(type);
            SourceTypeBinding binding = type.binding;
            if (!JdtUtil.isJsoSubclass(binding)) {
                return ClassState.NORMAL;
            }
            if (type.enclosingType != null && !binding.isStatic()) {
                JSORestrictionsChecker.this.errorOn(type, JSORestrictionsChecker.ERR_IS_NONSTATIC_NESTED);
            }
            if ((interfaces = binding.superInterfaces()) != null) {
                for (ReferenceBinding interf : interfaces) {
                    ReferenceBinding superclass;
                    if (interf.methods() == null || interf.methods().length <= 0 || (superclass = binding.superclass()) != null && superclass.implementsInterface(interf, true)) continue;
                    JSORestrictionsChecker.this.state.addJsoInterface(type, JSORestrictionsChecker.this.cud, interf);
                }
            }
            return ClassState.JSO;
        }

        private boolean isJso() {
            return this.classStateStack.peek() == ClassState.JSO;
        }

        private void popState() {
            this.classStateStack.pop();
            this.typeBindingStack.pop();
        }

        private void pushState(TypeDeclaration type) {
            this.classStateStack.push(this.checkType(type));
            this.typeBindingStack.push(type.binding);
        }
    }

    public static class CheckerState {
        private final Map<String, String> interfacesToJsoImpls = new HashMap<String, String>();

        public void addJsoInterface(TypeDeclaration jsoType, CompilationUnitDeclaration cud, ReferenceBinding interf) {
            String intfName = CharOperation.toString(interf.compoundName);
            String alreadyImplementor = this.interfacesToJsoImpls.get(intfName);
            String myName = CharOperation.toString(jsoType.binding.compoundName);
            if (alreadyImplementor != null) {
                String msg = JSORestrictionsChecker.errAlreadyImplemented(intfName, alreadyImplementor, myName);
                JSORestrictionsChecker.errorOn(jsoType, cud, msg);
                return;
            }
            this.interfacesToJsoImpls.put(intfName, myName);
        }
    }

    private static enum ClassState {
        NORMAL,
        JSO;

    }
}

