/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.javac;

import java.util.ArrayList;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.QualifiedAllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;

public class GwtIncompatiblePreprocessor {
    private static boolean hasGwtIncompatibleAnnotation(Annotation[] annotations) {
        if (annotations == null) {
            return false;
        }
        for (Annotation ann : annotations) {
            String typeName = new String(ann.type.getLastToken());
            if (!typeName.equals("GwtIncompatible")) continue;
            return true;
        }
        return false;
    }

    private static void processMembers(TypeDeclaration tyDecl) {
        GwtIncompatiblePreprocessor.processTypes(tyDecl.memberTypes);
        GwtIncompatiblePreprocessor.processMethods(tyDecl);
        GwtIncompatiblePreprocessor.processFields(tyDecl);
    }

    private static void processTypes(TypeDeclaration[] types) {
        if (types == null) {
            return;
        }
        for (TypeDeclaration tyDecl : types) {
            if (!GwtIncompatiblePreprocessor.hasGwtIncompatibleAnnotation(tyDecl.annotations)) {
                GwtIncompatiblePreprocessor.processMembers(tyDecl);
                continue;
            }
            GwtIncompatiblePreprocessor.stripAllMembers(tyDecl);
        }
    }

    private static void processMethods(TypeDeclaration tyDecl) {
        if (tyDecl.methods == null) {
            return;
        }
        ArrayList<AbstractMethodDeclaration> newMethods = new ArrayList<AbstractMethodDeclaration>();
        for (AbstractMethodDeclaration methodDecl : tyDecl.methods) {
            if (GwtIncompatiblePreprocessor.hasGwtIncompatibleAnnotation(methodDecl.annotations)) continue;
            newMethods.add(methodDecl);
        }
        if (newMethods.size() != tyDecl.methods.length) {
            tyDecl.methods = newMethods.isEmpty() ? null : newMethods.toArray(new AbstractMethodDeclaration[newMethods.size()]);
        }
    }

    private static void processFields(TypeDeclaration tyDecl) {
        if (tyDecl.fields == null) {
            return;
        }
        ArrayList<FieldDeclaration> newFields = new ArrayList<FieldDeclaration>();
        for (FieldDeclaration fieldDecl : tyDecl.fields) {
            if (GwtIncompatiblePreprocessor.hasGwtIncompatibleAnnotation(fieldDecl.annotations)) continue;
            newFields.add(fieldDecl);
        }
        if (newFields.size() != tyDecl.fields.length) {
            tyDecl.fields = newFields.isEmpty() ? null : newFields.toArray(new FieldDeclaration[newFields.size()]);
        }
    }

    private static void processAllAnonymousInnerClasses(CompilationUnitDeclaration cud) {
        ASTVisitor visitor = new ASTVisitor(){

            @Override
            public void endVisit(QualifiedAllocationExpression qualifiedAllocationExpression, BlockScope scope) {
                if (qualifiedAllocationExpression.anonymousType != null) {
                    GwtIncompatiblePreprocessor.processMembers(qualifiedAllocationExpression.anonymousType);
                }
            }
        };
        cud.traverse(visitor, cud.scope);
    }

    private static void stripAllMembers(TypeDeclaration tyDecl) {
        if (TypeDeclaration.kind(tyDecl.modifiers) == 4) {
            return;
        }
        tyDecl.superclass = null;
        tyDecl.superInterfaces = null;
        tyDecl.annotations = null;
        tyDecl.methods = null;
        tyDecl.memberTypes = null;
        tyDecl.fields = null;
        if (TypeDeclaration.kind(tyDecl.modifiers) == 1) {
            ConstructorDeclaration constructor = tyDecl.createDefaultConstructor(true, true);
            constructor.modifiers = 2;
            constructor.bits &= 0xFFFFFF7F;
            tyDecl.modifiers |= 0x10;
            tyDecl.modifiers &= 0xFFFFFBFF;
        }
    }

    public static void preproccess(CompilationUnitDeclaration cud) {
        GwtIncompatiblePreprocessor.processTypes(cud.types);
        GwtIncompatiblePreprocessor.processAllAnonymousInnerClasses(cud);
    }
}

