/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.javac;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.dev.javac.SerializableCategorizedProblem;
import com.google.gwt.dev.jjs.SourceInfo;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblem;
import org.eclipse.jdt.internal.compiler.util.Util;

public class GWTProblem
extends SerializableCategorizedProblem {
    private TreeLogger.HelpInfo helpInfo;

    public static void recordError(ASTNode node, CompilationUnitDeclaration cud, String message, TreeLogger.HelpInfo helpInfo) {
        GWTProblem.recordProblem(node, cud.compilationResult(), message, helpInfo, 1);
    }

    public static void recordProblem(ASTNode node, CompilationResult compResult, String message, TreeLogger.HelpInfo helpInfo, int problemSeverity) {
        int[] lineEnds = compResult.getLineSeparatorPositions();
        int startLine = Util.getLineNumber(node.sourceStart(), lineEnds, 0, lineEnds.length - 1);
        int startColumn = Util.searchColumnNumber(lineEnds, startLine, node.sourceStart());
        GWTProblem.recordProblem(node.sourceStart(), node.sourceEnd(), startLine, startColumn, compResult, message, helpInfo, problemSeverity);
    }

    public static void recordProblem(SourceInfo info, int startColumn, CompilationResult compResult, String message, TreeLogger.HelpInfo helpInfo, int problemSeverity) {
        GWTProblem.recordProblem(info.getStartPos(), info.getEndPos(), info.getStartLine(), startColumn, compResult, message, helpInfo, problemSeverity);
    }

    private static void recordProblem(int startPos, int endPos, int startLine, int startColumn, CompilationResult compResult, String message, TreeLogger.HelpInfo helpInfo, int problemSeverity) {
        GWTProblem problem = new GWTProblem(compResult.fileName, startPos, endPos, startLine, startColumn, message, helpInfo, problemSeverity);
        compResult.record(problem, null);
    }

    private GWTProblem(char[] originatingFileName, int startPosition, int endPosition, int line, int column, String message, TreeLogger.HelpInfo helpInfo, int problemSeverity) {
        super(new DefaultProblem(originatingFileName, message, 900, null, problemSeverity, startPosition, endPosition, line, column));
        this.helpInfo = helpInfo;
    }

    public TreeLogger.HelpInfo getHelpInfo() {
        return this.helpInfo;
    }
}

