/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.javac;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.dev.javac.CompiledClass;
import com.google.gwt.dev.util.StringInterner;
import com.google.gwt.dev.util.collect.HashMap;
import com.google.gwt.dev.util.collect.Lists;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

class Dependencies
implements Serializable {
    Map<String, Ref> qualified = new HashMap<String, Ref>(true);
    Map<String, Ref> simple = new HashMap<String, Ref>(true);
    private final List<String> apiRefs;
    private final String myPackage;

    Dependencies() {
        this.myPackage = "";
        this.apiRefs = Lists.create();
    }

    Dependencies(String myPackage, List<String> unresolvedQualified, List<String> unresolvedSimple, List<String> apiRefs) {
        this.myPackage = StringInterner.get().intern(myPackage.length() == 0 ? "" : myPackage + '.');
        for (String qualifiedRef : unresolvedQualified) {
            this.qualified.put(qualifiedRef, null);
        }
        for (String simpleRef : unresolvedSimple) {
            this.simple.put(simpleRef, null);
        }
        this.apiRefs = apiRefs;
    }

    List<String> getApiRefs() {
        return this.apiRefs;
    }

    void resolve(Map<String, CompiledClass> allValidClasses) {
        CompiledClass cc;
        for (Map.Entry<String, Ref> entry : this.qualified.entrySet()) {
            cc = allValidClasses.get(entry.getKey());
            if (cc == null) continue;
            entry.setValue(new Ref(cc));
        }
        for (Map.Entry<String, Ref> entry : this.simple.entrySet()) {
            cc = this.findBySimpleName(entry.getKey(), allValidClasses);
            if (cc == null) continue;
            entry.setValue(new Ref(cc));
        }
    }

    boolean validate(TreeLogger logger, Map<String, CompiledClass> allValidClasses) {
        CompiledClass theirs;
        for (Map.Entry<String, Ref> entry : this.qualified.entrySet()) {
            if (this.validateClass(logger, entry, theirs = allValidClasses.get(entry.getKey()))) continue;
            return false;
        }
        for (Map.Entry<String, Ref> entry : this.simple.entrySet()) {
            if (this.validateClass(logger, entry, theirs = this.findBySimpleName(entry.getKey(), allValidClasses))) continue;
            return false;
        }
        return true;
    }

    private CompiledClass findBySimpleName(String ref, Map<String, CompiledClass> allValidClasses) {
        CompiledClass cc = allValidClasses.get(this.myPackage + ref);
        if (cc != null) {
            return cc;
        }
        return allValidClasses.get("java.lang." + ref);
    }

    private boolean validateClass(TreeLogger logger, Map.Entry<String, Ref> entry, CompiledClass theirs) {
        boolean result;
        Ref mine = entry.getValue();
        if (mine == null != (theirs == null)) {
            if (logger.isLoggable(TreeLogger.DEBUG)) {
                logger.log(TreeLogger.DEBUG, "Invalid ref: " + entry.getKey() + " mine: " + (mine == null ? "null" : "not null") + " theirs: " + (theirs == null ? "null" : "not null"));
            }
            result = false;
        } else if (mine == null && theirs == null) {
            result = true;
        } else if (mine.getSignatureHash().equals(theirs.getSignatureHash())) {
            result = true;
        } else {
            if (logger.isLoggable(TreeLogger.DEBUG)) {
                logger.log(TreeLogger.DEBUG, entry.getKey() + " isn't structurally same.");
            }
            result = false;
        }
        return result;
    }

    static class Ref
    implements Serializable {
        private final String internalName;
        private final String hash;

        private Ref(CompiledClass cc) {
            this(cc.getInternalName(), cc.getSignatureHash());
        }

        private Ref(String internalName, String hash) {
            this.internalName = internalName;
            this.hash = hash;
        }

        public String getInternalName() {
            return this.internalName;
        }

        public String getSignatureHash() {
            return this.hash;
        }
    }
}

