/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.javac;

import com.google.gwt.dev.javac.BytecodeSignatureMaker;
import com.google.gwt.dev.javac.CompilationUnit;
import com.google.gwt.dev.javac.Shared;
import com.google.gwt.dev.jjs.InternalCompilerException;
import com.google.gwt.dev.util.DiskCache;
import com.google.gwt.dev.util.DiskCacheToken;
import com.google.gwt.dev.util.StringInterner;
import com.google.gwt.thirdparty.guava.common.annotations.VisibleForTesting;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;

public class CompiledClass
implements Serializable {
    private static final DiskCache diskCache = DiskCache.INSTANCE;
    private final DiskCacheToken classBytesToken;
    private CompiledClass enclosingClass;
    private final String internalName;
    private final boolean isLocal;
    private transient SoftReference<NameEnvironmentAnswer> nameEnvironmentAnswerReference;
    private String signatureHash;
    private final String sourceName;
    private CompilationUnit unit;

    static Collection<CompiledClass> copyForUnit(Collection<CompiledClass> in, CompilationUnit newUnit) {
        if (in == null) {
            return null;
        }
        ArrayList<CompiledClass> copy = new ArrayList<CompiledClass>();
        HashMap<CompiledClass, CompiledClass> enclosingClassMap = new HashMap<CompiledClass, CompiledClass>();
        for (CompiledClass cc : in) {
            CompiledClass copyCc = new CompiledClass(cc, newUnit);
            copy.add(copyCc);
            enclosingClassMap.put(cc, copyCc);
        }
        for (CompiledClass copyCc : copy) {
            if (copyCc.enclosingClass == null) continue;
            CompiledClass newRef = (CompiledClass)enclosingClassMap.get(copyCc.enclosingClass);
            if (null == newRef) {
                throw new InternalCompilerException("Enclosing type not found for " + copyCc.sourceName);
            }
            copyCc.enclosingClass = newRef;
        }
        return Collections.unmodifiableCollection(copy);
    }

    @VisibleForTesting
    protected CompiledClass(CompiledClass enclosingClass, String internalName, String sourceName) {
        this.enclosingClass = enclosingClass;
        this.internalName = StringInterner.get().intern(internalName);
        this.sourceName = StringInterner.get().intern(sourceName);
        this.isLocal = false;
        this.classBytesToken = null;
    }

    CompiledClass(byte[] classBytes, CompiledClass enclosingClass, boolean isLocal, String internalName, String sourceName) {
        this.enclosingClass = enclosingClass;
        this.internalName = StringInterner.get().intern(internalName);
        this.sourceName = StringInterner.get().intern(sourceName);
        this.classBytesToken = new DiskCacheToken(diskCache.writeByteArray(classBytes));
        this.isLocal = isLocal;
    }

    private CompiledClass(CompiledClass orig, CompilationUnit newUnit) {
        this.enclosingClass = orig.enclosingClass;
        this.internalName = orig.internalName;
        this.sourceName = orig.sourceName;
        this.classBytesToken = orig.classBytesToken;
        this.isLocal = orig.isLocal;
        this.unit = newUnit;
        this.signatureHash = orig.signatureHash;
    }

    public byte[] getBytes() {
        return this.classBytesToken.readByteArray();
    }

    public CompiledClass getEnclosingClass() {
        return this.enclosingClass;
    }

    public String getInternalName() {
        return this.internalName;
    }

    public String getPackageName() {
        return Shared.getPackageNameFromBinary(this.internalName);
    }

    public String getSignatureHash() {
        if (this.signatureHash == null) {
            this.signatureHash = BytecodeSignatureMaker.getCompileDependencySignature(this.getBytes());
        }
        return this.signatureHash;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public CompilationUnit getUnit() {
        return this.unit;
    }

    public boolean isLocal() {
        return this.isLocal;
    }

    public String toString() {
        return this.internalName;
    }

    NameEnvironmentAnswer getNameEnvironmentAnswer() throws ClassFormatException {
        NameEnvironmentAnswer nameEnvironmentAnswer;
        NameEnvironmentAnswer nameEnvironmentAnswer2 = nameEnvironmentAnswer = this.nameEnvironmentAnswerReference == null ? null : this.nameEnvironmentAnswerReference.get();
        if (nameEnvironmentAnswer == null) {
            ClassFileReader cfr = new ClassFileReader(this.getBytes(), this.unit.getResourceLocation().toCharArray(), true);
            nameEnvironmentAnswer = new NameEnvironmentAnswer(cfr, null);
            this.nameEnvironmentAnswerReference = new SoftReference<NameEnvironmentAnswer>(nameEnvironmentAnswer);
        }
        return nameEnvironmentAnswer;
    }

    void initUnit(CompilationUnit unit) {
        this.unit = unit;
    }
}

