/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.javac;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.typeinfo.JPrimitiveType;
import com.google.gwt.core.ext.typeinfo.JType;
import com.google.gwt.dev.javac.AnnotationProxyFactory;
import com.google.gwt.dev.javac.CompilationUnit;
import com.google.gwt.dev.javac.CompiledClass;
import com.google.gwt.dev.javac.MethodArgNamesLookup;
import com.google.gwt.dev.javac.Resolver;
import com.google.gwt.dev.javac.Shared;
import com.google.gwt.dev.javac.TypeParameterLookup;
import com.google.gwt.dev.javac.asm.CollectAnnotationData;
import com.google.gwt.dev.javac.asm.CollectClassData;
import com.google.gwt.dev.javac.asm.CollectFieldData;
import com.google.gwt.dev.javac.asm.CollectMethodData;
import com.google.gwt.dev.javac.asm.CollectTypeParams;
import com.google.gwt.dev.javac.asm.ResolveClassSignature;
import com.google.gwt.dev.javac.asm.ResolveMethodSignature;
import com.google.gwt.dev.javac.asm.ResolveTypeSignature;
import com.google.gwt.dev.javac.typemodel.JAbstractMethod;
import com.google.gwt.dev.javac.typemodel.JArrayType;
import com.google.gwt.dev.javac.typemodel.JClassType;
import com.google.gwt.dev.javac.typemodel.JField;
import com.google.gwt.dev.javac.typemodel.JGenericType;
import com.google.gwt.dev.javac.typemodel.JMethod;
import com.google.gwt.dev.javac.typemodel.JPackage;
import com.google.gwt.dev.javac.typemodel.JParameterizedType;
import com.google.gwt.dev.javac.typemodel.JRawType;
import com.google.gwt.dev.javac.typemodel.JRealClassType;
import com.google.gwt.dev.javac.typemodel.JTypeParameter;
import com.google.gwt.dev.javac.typemodel.JWildcardType;
import com.google.gwt.dev.javac.typemodel.TypeOracle;
import com.google.gwt.dev.javac.typemodel.TypeOracleUpdater;
import com.google.gwt.dev.util.Name;
import com.google.gwt.dev.util.log.speedtracer.CompilerEventType;
import com.google.gwt.dev.util.log.speedtracer.SpeedTracerLogger;
import com.google.gwt.thirdparty.guava.common.annotations.VisibleForTesting;
import com.google.gwt.thirdparty.guava.common.base.Function;
import com.google.gwt.thirdparty.guava.common.collect.Collections2;
import com.google.gwt.thirdparty.guava.common.collect.ImmutableMap;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import com.google.gwt.thirdparty.guava.common.collect.Maps;
import com.google.gwt.thirdparty.guava.common.collect.Queues;
import com.google.gwt.thirdparty.guava.common.collect.Sets;
import com.google.gwt.thirdparty.guava.common.util.concurrent.ThreadFactoryBuilder;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.Type;
import org.objectweb.asm.signature.SignatureReader;

public class CompilationUnitTypeOracleUpdater
extends TypeOracleUpdater {
    private static final int[] ASM_TO_SHARED_MODIFIERS = new int[]{1, 32, 2, 8, 4, 16, 8, 64, 16, 2, 1024, 1, 64, 256, 128, 128};
    private static final JTypeParameter[] NO_TYPE_PARAMETERS = new JTypeParameter[0];
    private static final boolean TRACE_CLASSES = false;
    private static boolean warnedMissingValidationJar = false;
    private final Set<String> resolvedTypeSourceNames = Sets.newHashSet();
    private final Map<String, JRealClassType> typesByInternalName = Maps.newHashMap();
    private static ExecutorService executor = new ThreadPoolExecutor(0, Runtime.getRuntime().availableProcessors(), 60L, TimeUnit.SECONDS, Queues.newLinkedBlockingQueue(), new ThreadFactoryBuilder().setDaemon(true).build());
    private static final Map<String, Class<?>> BUILT_IN_PRIMITIVE_MAP;

    private static JTypeParameter[] collectTypeParams(String signature) {
        if (signature != null) {
            ArrayList<JTypeParameter> params = Lists.newArrayList();
            SignatureReader reader = new SignatureReader(signature);
            reader.accept(new CollectTypeParams(params));
            return params.toArray(new JTypeParameter[params.size()]);
        }
        return NO_TYPE_PARAMETERS;
    }

    private static JTypeParameter[] getTypeParametersForClass(CollectClassData classData) {
        JTypeParameter[] typeParams = null;
        if (classData.getSignature() != null) {
            typeParams = CompilationUnitTypeOracleUpdater.collectTypeParams(classData.getSignature());
        }
        return typeParams;
    }

    private static Class<?> getWrapperClass(Class<?> primitiveClass) {
        assert (primitiveClass.isPrimitive());
        if (primitiveClass.equals(Integer.TYPE)) {
            return Integer.class;
        }
        if (primitiveClass.equals(Boolean.TYPE)) {
            return Boolean.class;
        }
        if (primitiveClass.equals(Byte.TYPE)) {
            return Byte.class;
        }
        if (primitiveClass.equals(Character.TYPE)) {
            return Character.class;
        }
        if (primitiveClass.equals(Short.TYPE)) {
            return Short.class;
        }
        if (primitiveClass.equals(Long.TYPE)) {
            return Long.class;
        }
        if (primitiveClass.equals(Float.TYPE)) {
            return Float.class;
        }
        if (primitiveClass.equals(Double.TYPE)) {
            return Double.class;
        }
        throw new IllegalArgumentException(primitiveClass.toString() + " not a primitive class");
    }

    private static boolean isPackageInfoTypeName(String simpleSourceName) {
        return "package-info".equals(simpleSourceName);
    }

    private static boolean nonStaticInsideGeneric(CollectClassData classData, CollectClassData enclosingClassData) {
        if (enclosingClassData == null || (classData.getAccess() & 8) != 0) {
            return false;
        }
        return CompilationUnitTypeOracleUpdater.getTypeParametersForClass(enclosingClassData) != null;
    }

    private static JType possiblySubstituteRawType(JType type) {
        JGenericType genericType;
        if (type != null && (genericType = (JGenericType)type.isGenericType()) != null) {
            type = genericType.getRawType();
        }
        return type;
    }

    public CompilationUnitTypeOracleUpdater(TypeOracle typeOracle) {
        super(typeOracle);
    }

    void addNewTypesDontIndex(TreeLogger logger, Collection<TypeData> typeDataList, MethodArgNamesLookup argsLookup) {
        SpeedTracerLogger.Event typeOracleUpdaterEvent = SpeedTracerLogger.start(CompilerEventType.TYPE_ORACLE_UPDATER, new String[0]);
        SpeedTracerLogger.Event visitClassFileEvent = SpeedTracerLogger.start(CompilerEventType.TYPE_ORACLE_UPDATER, "phase", "Visit Class Files");
        TypeOracleBuildContext context = this.getContext(argsLookup);
        for (TypeData typeData : typeDataList) {
            CollectClassData classData = typeData.getCollectClassData();
            if (classData.hasNoExternalName() || this.typesByInternalName.containsKey(classData.getInternalName())) continue;
            context.classDataByInternalName.put(typeData.internalName, classData);
        }
        visitClassFileEvent.end(new String[0]);
        SpeedTracerLogger.Event identityEvent = SpeedTracerLogger.start(CompilerEventType.TYPE_ORACLE_UPDATER, "phase", "Establish Identity");
        LinkedHashSet<JRealClassType> unresolvedTypes = Sets.newLinkedHashSet();
        for (TypeData typeData : typeDataList) {
            JRealClassType type;
            CollectClassData classData = (CollectClassData)context.classDataByInternalName.get(typeData.internalName);
            if (classData == null || this.typesByInternalName.containsKey(classData.getInternalName()) || (type = this.createType(typeData, unresolvedTypes, context)) == null) continue;
            assert (Name.isInternalName(typeData.internalName));
            this.typesByInternalName.put(typeData.internalName, type);
            context.classDataByType.put(type, classData);
        }
        identityEvent.end(new String[0]);
        SpeedTracerLogger.Event resolveEnclosingEvent = SpeedTracerLogger.start(CompilerEventType.TYPE_ORACLE_UPDATER, "phase", "Resolve Enclosing Classes");
        TreeLogger branch = logger.branch(TreeLogger.SPAM, "Resolving enclosing classes");
        Iterator unresolvedTypesIterator = unresolvedTypes.iterator();
        while (unresolvedTypesIterator.hasNext()) {
            JRealClassType unresolvedType = (JRealClassType)unresolvedTypesIterator.next();
            if (this.resolveEnclosingClass(branch, unresolvedType, context)) continue;
            unresolvedTypesIterator.remove();
        }
        resolveEnclosingEvent.end(new String[0]);
        SpeedTracerLogger.Event resolveUnresolvedEvent = SpeedTracerLogger.start(CompilerEventType.TYPE_ORACLE_UPDATER, "phase", "Resolve Unresolved Types");
        for (JRealClassType unresolvedType : unresolvedTypes) {
            branch = logger.branch(TreeLogger.SPAM, "Resolving " + unresolvedType.getQualifiedSourceName());
            if (this.resolveClass(branch, unresolvedType, context)) continue;
        }
        resolveUnresolvedEvent.end(new String[0]);
        context = null;
        typeOracleUpdaterEvent.end(new String[0]);
    }

    private static void prefechTypeData(Collection<TypeData> typeDataList) {
        try {
            executor.invokeAll(Collections2.transform(typeDataList, new Function<TypeData, Callable<Void>>(){

                @Override
                public Callable<Void> apply(final TypeData typeData) {
                    return new Callable<Void>(){

                        @Override
                        public Void call() {
                            typeData.getCollectClassData();
                            return null;
                        }
                    };
                }
            }));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void addNewUnits(TreeLogger logger, Collection<CompilationUnit> compilationUnits) {
        this.addNewTypesDontIndex(logger, compilationUnits);
        this.indexTypes();
    }

    @VisibleForTesting
    void indexTypes() {
        SpeedTracerLogger.Event finishEvent = SpeedTracerLogger.start(CompilerEventType.TYPE_ORACLE_UPDATER, "phase", "Finish");
        super.finish();
        finishEvent.end(new String[0]);
    }

    protected void addNewTypesDontIndex(TreeLogger logger, Collection<CompilationUnit> compilationUnits) {
        ArrayList<TypeData> typeDataList = Lists.newArrayList();
        MethodArgNamesLookup argsLookup = new MethodArgNamesLookup();
        for (CompilationUnit compilationUnit : compilationUnits) {
            argsLookup.mergeFrom(compilationUnit.getMethodArgs());
        }
        for (CompilationUnit compilationUnit : compilationUnits) {
            for (CompiledClass compiledClass : compilationUnit.getCompiledClasses()) {
                TypeData typeData = new TypeData(compiledClass.getPackageName(), compiledClass.getSourceName(), compiledClass.getInternalName(), compiledClass.getBytes(), compiledClass.getUnit().getLastModified());
                typeDataList.add(typeData);
            }
        }
        CompilationUnitTypeOracleUpdater.prefechTypeData(typeDataList);
        this.addNewTypesDontIndex(logger, typeDataList, argsLookup);
    }

    @VisibleForTesting
    public Resolver getMockResolver() {
        return new CompilationUnitTypeOracleResolver(new TypeOracleBuildContext(new MethodArgNamesLookup()));
    }

    public TypeOracle getTypeOracle() {
        return this.typeOracle;
    }

    @VisibleForTesting
    public Map<String, JRealClassType> getTypesByInternalName() {
        return this.typesByInternalName;
    }

    protected JRealClassType findByInternalName(String internalName) {
        assert (Name.isInternalName(internalName));
        return this.typesByInternalName.get(internalName);
    }

    private Annotation createAnnotation(TreeLogger logger, Class<? extends Annotation> annotationClass, CollectAnnotationData.AnnotationData annotationData) {
        HashMap<String, Object> values = Maps.newHashMap(annotationData.getValues());
        logger = logger.branch(TreeLogger.TRACE, "Resolving annotation for " + annotationClass.getName());
        for (Map.Entry entry : values.entrySet()) {
            Method method = null;
            Exception caught = null;
            try {
                method = annotationClass.getMethod((String)entry.getKey(), new Class[0]);
                entry.setValue(this.resolveAnnotationValue(logger, method.getReturnType(), entry.getValue()));
            }
            catch (SecurityException e) {
                caught = e;
            }
            catch (NoSuchMethodException e) {
                caught = e;
            }
            if (caught == null) continue;
            logger.log(TreeLogger.WARN, "Exception resolving " + annotationClass.getCanonicalName() + "." + (String)entry.getKey() + " : " + caught.getMessage());
            return null;
        }
        return AnnotationProxyFactory.create(annotationClass, values);
    }

    private JRealClassType createType(TypeData typeData, CollectClassData collectClassData, CollectClassData enclosingClassData) {
        JTypeParameter[] typeParams;
        boolean isInterface;
        int access = collectClassData.getAccess();
        String simpleName = Shared.getShortName(typeData.sourceName);
        JRealClassType type = null;
        String packageName = typeData.packageName;
        JPackage pkg = this.typeOracle.getOrCreatePackage(packageName);
        boolean bl = isInterface = (access & 0x200) != 0;
        assert (!collectClassData.hasNoExternalName());
        String enclosingSimpleName = null;
        if (enclosingClassData != null) {
            enclosingSimpleName = enclosingClassData.getNestedSourceName();
        }
        type = (access & 0x2000) != 0 ? this.newAnnotationType(pkg, enclosingSimpleName, simpleName) : ((access & 0x4000) != 0 ? this.newEnumType(pkg, enclosingSimpleName, simpleName) : ((typeParams = CompilationUnitTypeOracleUpdater.getTypeParametersForClass(collectClassData)) != null && typeParams.length > 0 || CompilationUnitTypeOracleUpdater.nonStaticInsideGeneric(collectClassData, enclosingClassData) ? new JGenericType(this.typeOracle, pkg, enclosingSimpleName, simpleName, isInterface, typeParams) : this.newRealClassType(pkg, enclosingSimpleName, simpleName, isInterface)));
        type.addModifierBits(this.mapBits(ASM_TO_SHARED_MODIFIERS, access));
        if (isInterface) {
            type.addModifierBits(65);
        }
        type.addLastModifiedTime(typeData.lastModifiedTime);
        return type;
    }

    private JRealClassType createType(TypeData typeData, Set<JRealClassType> unresolvedTypes, TypeOracleBuildContext context) {
        CollectClassData classData = (CollectClassData)context.classDataByInternalName.get(typeData.internalName);
        String enclosingClassInternalName = classData.getEnclosingInternalName();
        CollectClassData enclosingClassData = null;
        if (enclosingClassInternalName != null && (enclosingClassData = (CollectClassData)context.classDataByInternalName.get(enclosingClassInternalName)) == null) {
            return null;
        }
        JRealClassType realClassType = this.createType(typeData, classData, enclosingClassData);
        unresolvedTypes.add(realClassType);
        return realClassType;
    }

    private Class<? extends Annotation> getAnnotationClass(TreeLogger logger, CollectAnnotationData.AnnotationData annotationData) {
        Type type = Type.getType(annotationData.getDesc());
        String binaryName = type.getClassName();
        try {
            Class<?> clazz = Class.forName(binaryName, false, Thread.currentThread().getContextClassLoader());
            if (!Annotation.class.isAssignableFrom(clazz)) {
                logger.log(TreeLogger.ERROR, "Type " + binaryName + " is not an annotation");
                return null;
            }
            return clazz.asSubclass(Annotation.class);
        }
        catch (ClassNotFoundException e) {
            TreeLogger.Type level = TreeLogger.WARN;
            if (this.shouldSuppressUnresolvableAnnotation(logger, binaryName)) {
                level = TreeLogger.DEBUG;
            }
            logger.log(level, "Ignoring unresolvable annotation type " + binaryName);
            return null;
        }
    }

    private Class<?> getClassLiteralForPrimitive(Type type) {
        switch (type.getSort()) {
            case 1: {
                return Boolean.TYPE;
            }
            case 3: {
                return Byte.TYPE;
            }
            case 2: {
                return Character.TYPE;
            }
            case 4: {
                return Short.TYPE;
            }
            case 5: {
                return Integer.TYPE;
            }
            case 7: {
                return Long.TYPE;
            }
            case 6: {
                return Float.TYPE;
            }
            case 8: {
                return Double.TYPE;
            }
            case 0: {
                return Void.TYPE;
            }
        }
        assert (false) : "Unexpected primitive type " + type;
        return null;
    }

    protected TypeOracleBuildContext getContext(MethodArgNamesLookup argsLookup) {
        return new TypeOracleBuildContext(argsLookup);
    }

    private int mapBits(int[] mapping, int input) {
        int output = 0;
        for (int i = 0; i < mapping.length; i += 2) {
            if ((input & mapping[i]) == 0) continue;
            output |= mapping[i + 1];
        }
        return output;
    }

    private boolean resolveAnnotation(TreeLogger logger, CollectAnnotationData annotationVisitor, Map<Class<? extends Annotation>, Annotation> declaredAnnotations) {
        CollectAnnotationData.AnnotationData annotationData = annotationVisitor.getAnnotation();
        Class<? extends Annotation> annotationClass = this.getAnnotationClass(logger, annotationData);
        if (annotationClass == null) {
            return false;
        }
        Annotation annotation = this.createAnnotation(logger, annotationClass, annotationData);
        if (annotation == null) {
            return false;
        }
        declaredAnnotations.put(annotationClass, annotation);
        return true;
    }

    private boolean resolveAnnotations(TreeLogger logger, List<CollectAnnotationData> annotationVisitors, Map<Class<? extends Annotation>, Annotation> declaredAnnotations) {
        boolean succeeded = true;
        if (annotationVisitors != null) {
            for (CollectAnnotationData annotationVisitor : annotationVisitors) {
                succeeded &= this.resolveAnnotation(logger, annotationVisitor, declaredAnnotations);
            }
        }
        return succeeded;
    }

    private Object resolveAnnotationValue(TreeLogger logger, Class<?> expectedType, Object value) {
        if (expectedType.isArray()) {
            Class<?> componentType = expectedType.getComponentType();
            if (!value.getClass().isArray()) {
                logger.log(TreeLogger.WARN, "Annotation error: expected array of " + componentType.getCanonicalName() + ", got " + value.getClass().getCanonicalName());
                return null;
            }
            if (componentType.isPrimitive()) {
                return value;
            }
            int n = Array.getLength(value);
            Object newArray = Array.newInstance(componentType, n);
            for (int i = 0; i < n; ++i) {
                Object valueElement = Array.get(value, i);
                Object resolvedValue = this.resolveAnnotationValue(logger, componentType, valueElement);
                if (resolvedValue == null || !componentType.isAssignableFrom(resolvedValue.getClass())) {
                    logger.log(TreeLogger.ERROR, "Annotation error: expected " + componentType + ", got " + resolvedValue);
                    continue;
                }
                Array.set(newArray, i, resolvedValue);
            }
            return newArray;
        }
        if (expectedType.isEnum()) {
            if (!(value instanceof CollectClassData.AnnotationEnum)) {
                logger.log(TreeLogger.ERROR, "Annotation error: expected an enum value, but got " + value);
                return null;
            }
            CollectClassData.AnnotationEnum annotEnum = (CollectClassData.AnnotationEnum)value;
            Class<Enum> enumType = expectedType.asSubclass(Enum.class);
            try {
                return Enum.valueOf(enumType, annotEnum.getValue());
            }
            catch (IllegalArgumentException e) {
                logger.log(TreeLogger.WARN, "Unable to resolve annotation value '" + annotEnum.getValue() + "' within enum type '" + enumType.getName() + "'");
                return null;
            }
        }
        if (Annotation.class.isAssignableFrom(expectedType)) {
            if (!(value instanceof CollectAnnotationData.AnnotationData)) {
                logger.log(TreeLogger.WARN, "Annotation error: expected annotation type " + expectedType.getCanonicalName() + ", got " + value.getClass().getCanonicalName());
                return null;
            }
            CollectAnnotationData.AnnotationData annotData = (CollectAnnotationData.AnnotationData)value;
            Class<? extends Annotation> annotationClass = this.getAnnotationClass(logger, annotData);
            if (!expectedType.isAssignableFrom(annotationClass)) {
                logger.log(TreeLogger.WARN, "Annotation error: expected " + expectedType.getCanonicalName() + ", got " + annotationClass.getCanonicalName());
                return null;
            }
            return this.createAnnotation(logger, annotationClass, annotData);
        }
        if (expectedType.isPrimitive()) {
            Class<?> wrapper = CompilationUnitTypeOracleUpdater.getWrapperClass(expectedType);
            return wrapper.cast(value);
        }
        if (expectedType.isAssignableFrom(value.getClass())) {
            return value;
        }
        if (Class.class.equals(expectedType)) {
            if (!(value instanceof Type)) {
                logger.log(TreeLogger.WARN, "Annotation error: expected a class literal, but received " + value);
                return null;
            }
            Type valueType = (Type)value;
            try {
                return CompilationUnitTypeOracleUpdater.forName(valueType.getClassName());
            }
            catch (ClassNotFoundException e) {
                logger.log(TreeLogger.WARN, "Annotation error: cannot resolve " + valueType.getClassName());
                return null;
            }
        }
        return value;
    }

    public static Class forName(String name) throws ClassNotFoundException {
        Class<?> c = BUILT_IN_PRIMITIVE_MAP.get(name);
        if (c == null) {
            c = Class.forName(name, false, Thread.currentThread().getContextClassLoader());
        }
        return c;
    }

    private JType resolveArray(Type type) {
        assert (type.getSort() == 9);
        JType resolvedType = this.resolveType(type.getElementType());
        int dimensions = type.getDimensions();
        for (int i = 0; i < dimensions; ++i) {
            resolvedType = this.typeOracle.getArrayType(resolvedType);
        }
        return resolvedType;
    }

    private boolean resolveClass(TreeLogger logger, JRealClassType unresolvedType, TypeOracleBuildContext context) {
        boolean isInterface;
        assert (unresolvedType != null);
        if (this.resolvedTypeSourceNames.contains(unresolvedType.getQualifiedSourceName())) {
            return true;
        }
        this.resolvedTypeSourceNames.add(unresolvedType.getQualifiedSourceName());
        if (unresolvedType.getEnclosingType() != null && !this.resolveClass(logger, unresolvedType.getEnclosingType(), context)) {
            return false;
        }
        TypeParameterLookup typeParamLookup = new TypeParameterLookup();
        typeParamLookup.pushEnclosingScopes(unresolvedType);
        CollectClassData classData = (CollectClassData)context.classDataByType.get(unresolvedType);
        assert (classData != null);
        int access = classData.getAccess();
        assert (!classData.getClassType().hasNoExternalName());
        logger = logger.branch(TreeLogger.SPAM, "Found type '" + unresolvedType.getQualifiedSourceName() + "'", null);
        if (CompilationUnitTypeOracleUpdater.isPackageInfoTypeName(unresolvedType.getSimpleSourceName())) {
            return this.resolvePackage(logger, unresolvedType, classData.getAnnotations());
        }
        HashMap<Class<? extends Annotation>, Annotation> declaredAnnotations = Maps.newHashMap();
        this.resolveAnnotations(logger, classData.getAnnotations(), declaredAnnotations);
        this.addAnnotations(unresolvedType, declaredAnnotations);
        String signature = classData.getSignature();
        boolean bl = isInterface = (access & 0x200) != 0;
        if (signature != null) {
            SignatureReader reader = new SignatureReader(signature);
            ResolveClassSignature classResolver = new ResolveClassSignature(context.resolver, logger, unresolvedType, typeParamLookup);
            reader.accept(classResolver);
            classResolver.finish();
            if (unresolvedType.getSuperclass() != null && !this.resolveClass(logger, unresolvedType.getSuperclass(), context)) {
                logger.log(TreeLogger.WARN, "Unable to resolve supertype " + unresolvedType.getSuperclass().getName());
                return false;
            }
        } else {
            if (!isInterface) {
                String[] superInternalName = classData.getSuperInternalName();
                assert (Name.isInternalName((String)superInternalName));
                if (superInternalName != null) {
                    JRealClassType superType = this.findByInternalName((String)superInternalName);
                    if (superType == null || !this.resolveClass(logger, (JType)superType, context)) {
                        logger.log(TreeLogger.WARN, "Unable to resolve supertype " + (String)superInternalName);
                        return false;
                    }
                    this.setSuperClass(unresolvedType, (JClassType)CompilationUnitTypeOracleUpdater.possiblySubstituteRawType(superType));
                }
            }
            for (String interfaceInternalName : classData.getInterfaceInternalNames()) {
                JRealClassType interfaceType = this.findByInternalName(interfaceInternalName);
                if (interfaceType == null || !this.resolveClass(logger, (JType)interfaceType, context)) {
                    logger.log(TreeLogger.WARN, "Unable to resolve interface " + interfaceInternalName);
                    return false;
                }
                this.addImplementedInterface(unresolvedType, (JClassType)CompilationUnitTypeOracleUpdater.possiblySubstituteRawType(interfaceType));
            }
        }
        if (!isInterface && unresolvedType.getSuperclass() == null) assert ("java/lang/Object".equals(classData.getInternalName()));
        for (CollectMethodData method : classData.getMethods()) {
            TreeLogger branch = logger.branch(TreeLogger.SPAM, "Resolving method " + method.getName());
            if (isInterface && this.isJava8InterfaceMethod(method)) {
                logger.log(TreeLogger.Type.SPAM, "Ignoring Java 8 interface method " + method.getName());
                continue;
            }
            if (this.resolveMethod(branch, unresolvedType, method, typeParamLookup, context)) continue;
            return false;
        }
        int[] nextEnumOrdinal = new int[]{0};
        for (CollectFieldData field : classData.getFields()) {
            TreeLogger branch = logger.branch(TreeLogger.SPAM, "Resolving field " + field.getName());
            if (this.resolveField(branch, unresolvedType, field, typeParamLookup, nextEnumOrdinal, context)) continue;
            return false;
        }
        return true;
    }

    private boolean isJava8InterfaceMethod(CollectMethodData method) {
        return (method.getAccess() & 0x400) == 0;
    }

    private boolean resolveClass(TreeLogger logger, JType unresolvedType, TypeOracleBuildContext context) {
        if (!(unresolvedType instanceof JClassType)) {
            return true;
        }
        if (unresolvedType instanceof JRealClassType) {
            return this.resolveClass(logger, (JRealClassType)unresolvedType, context);
        }
        if (unresolvedType instanceof JArrayType) {
            return this.resolveClass(logger, ((JArrayType)unresolvedType).getComponentType(), context);
        }
        if (unresolvedType instanceof JParameterizedType) {
            return this.resolveClass(logger, ((JParameterizedType)unresolvedType).getBaseType(), context);
        }
        if (unresolvedType instanceof JRawType) {
            return this.resolveClass(logger, ((JRawType)unresolvedType).getBaseType(), context);
        }
        if (unresolvedType instanceof JTypeParameter) {
            JTypeParameter typeParam = (JTypeParameter)unresolvedType;
            if (!this.resolveClass(logger, typeParam.getDeclaringClass(), context)) {
                return false;
            }
            for (JClassType bound : typeParam.getBounds()) {
                if (this.resolveClass(logger, bound, context)) continue;
                return false;
            }
            return true;
        }
        if (unresolvedType instanceof JWildcardType) {
            JWildcardType wildcard = (JWildcardType)unresolvedType;
            for (JClassType bound : wildcard.getUpperBounds()) {
                if (this.resolveClass(logger, bound, context)) continue;
                return false;
            }
            for (JClassType bound : wildcard.getLowerBounds()) {
                if (this.resolveClass(logger, bound, context)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean resolveEnclosingClass(TreeLogger logger, JRealClassType unresolvedType, TypeOracleBuildContext context) {
        assert (unresolvedType != null);
        if (unresolvedType.getEnclosingType() != null) {
            return true;
        }
        CollectClassData classData = (CollectClassData)context.classDataByType.get(unresolvedType);
        assert (classData != null);
        String enclosingClassInternalName = classData.getEnclosingInternalName();
        JRealClassType enclosingType = null;
        if (enclosingClassInternalName != null && (enclosingType = this.findByInternalName(enclosingClassInternalName)) != null) {
            if (!this.resolveEnclosingClass(logger, enclosingType, context)) {
                return false;
            }
            if (enclosingType.isGenericType() != null && (classData.getAccess() & 0x208) != 0) {
                JGenericType genericType = enclosingType.isGenericType();
                this.setEnclosingType(unresolvedType, genericType.getRawType());
            } else {
                this.setEnclosingType(unresolvedType, enclosingType);
            }
        }
        return true;
    }

    private boolean resolveField(TreeLogger logger, JRealClassType unresolvedType, CollectFieldData field, TypeParameterLookup typeParamLookup, int[] nextEnumOrdinal, TypeOracleBuildContext context) {
        JType fieldJType;
        JField jfield;
        HashMap<Class<? extends Annotation>, Annotation> declaredAnnotations = Maps.newHashMap();
        this.resolveAnnotations(logger, field.getAnnotations(), declaredAnnotations);
        String name = field.getName();
        if ((field.getAccess() & 0x4000) != 0) {
            assert (unresolvedType.isEnum() != null);
            int n = nextEnumOrdinal[0];
            nextEnumOrdinal[0] = n + 1;
            jfield = this.newEnumConstant(unresolvedType, name, declaredAnnotations, n);
        } else {
            JField newField;
            jfield = newField = this.newField(unresolvedType, name, declaredAnnotations);
        }
        this.addModifierBits(jfield, this.mapBits(ASM_TO_SHARED_MODIFIERS, field.getAccess()));
        String signature = field.getSignature();
        if (signature != null) {
            SignatureReader reader = new SignatureReader(signature);
            JType[] fieldTypeRef = new JType[1];
            reader.acceptType(new ResolveTypeSignature(context.resolver, logger, fieldTypeRef, typeParamLookup, null));
            fieldJType = fieldTypeRef[0];
            if (fieldJType == null) {
                logger.log(TreeLogger.ERROR, "Unable to resolve type in field signature " + signature);
                return false;
            }
        } else {
            Type fieldType = Type.getType(field.getDesc());
            fieldJType = this.resolveType(fieldType);
            if (fieldJType == null) {
                logger.log(TreeLogger.ERROR, "Unable to resolve type " + fieldType.getInternalName() + " of field " + field.getName());
                return false;
            }
        }
        this.setFieldType(jfield, fieldJType);
        return true;
    }

    private boolean resolveMethod(TreeLogger logger, JRealClassType unresolvedType, CollectMethodData methodData, TypeParameterLookup typeParamLookup, TypeOracleBuildContext context) {
        String signature;
        JAbstractMethod method;
        HashMap<Class<? extends Annotation>, Annotation> declaredAnnotations = Maps.newHashMap();
        this.resolveAnnotations(logger, methodData.getAnnotations(), declaredAnnotations);
        String name = methodData.getName();
        if ("<clinit>".equals(name) || (methodData.getAccess() & 0x1000) != 0) {
            return true;
        }
        if (unresolvedType.isEnum() != null && "<init>".equals(name)) {
            return true;
        }
        JTypeParameter[] typeParams = CompilationUnitTypeOracleUpdater.collectTypeParams(methodData.getSignature());
        typeParamLookup.pushScope(typeParams);
        boolean hasReturnType = true;
        if ("<init>".equals(name)) {
            name = unresolvedType.getSimpleSourceName();
            method = this.newConstructor(unresolvedType, name, declaredAnnotations, typeParams);
            hasReturnType = false;
        } else {
            method = unresolvedType.isAnnotation() != null ? this.newAnnotationMethod(unresolvedType, name, declaredAnnotations, typeParams, null) : this.newMethod(unresolvedType, name, declaredAnnotations, typeParams);
        }
        this.addModifierBits(method, this.mapBits(ASM_TO_SHARED_MODIFIERS, methodData.getAccess()));
        if (unresolvedType.isInterface() != null) {
            this.addModifierBits(method, 33);
        }
        if ((methodData.getAccess() & 0x80) != 0) {
            this.setVarArgs(method);
        }
        if ((signature = methodData.getSignature()) != null) {
            SignatureReader reader = new SignatureReader(signature);
            ResolveMethodSignature methodResolver = new ResolveMethodSignature(context.resolver, logger, method, typeParamLookup, hasReturnType, methodData, methodData.getArgTypes(), methodData.getArgNames(), methodData.hasActualArgNames(), context.allMethodArgs);
            reader.accept(methodResolver);
            if (!methodResolver.finish()) {
                logger.log(TreeLogger.ERROR, "Failed to resolve.");
                return false;
            }
        } else {
            if (hasReturnType) {
                Type returnType = Type.getReturnType(methodData.getDesc());
                JType returnJType = this.resolveType(returnType);
                if (returnJType == null) {
                    logger.log(TreeLogger.ERROR, "Unable to resolve return type " + returnType.getInternalName());
                    return false;
                }
                this.setReturnType(method, returnJType);
            }
            if (!this.resolveParameters(logger, method, methodData, context)) {
                return false;
            }
        }
        if (!this.resolveThrows(logger, method, methodData)) {
            return false;
        }
        typeParamLookup.popScope();
        return true;
    }

    private JRealClassType resolveObject(Type type) {
        assert (type.getSort() == 10);
        String internalName = type.getInternalName();
        assert (Name.isInternalName(internalName));
        JRealClassType classType = this.findByInternalName(internalName);
        return classType;
    }

    private boolean resolvePackage(TreeLogger logger, JRealClassType unresolvedType, List<CollectAnnotationData> annotationVisitors) {
        HashMap<Class<? extends Annotation>, Annotation> declaredAnnotations = Maps.newHashMap();
        this.resolveAnnotations(logger, annotationVisitors, declaredAnnotations);
        this.addAnnotations(unresolvedType.getPackage(), declaredAnnotations);
        return true;
    }

    private boolean resolveParameters(TreeLogger logger, JAbstractMethod method, CollectMethodData methodData, TypeOracleBuildContext context) {
        String[] lookupNames;
        Type[] argTypes = methodData.getArgTypes();
        boolean argNamesAreReal = methodData.hasActualArgNames();
        String[] argNames = methodData.getArgNames();
        if (!argNamesAreReal && (lookupNames = context.allMethodArgs.lookup(method, methodData)) != null) {
            argNames = lookupNames;
            argNamesAreReal = true;
        }
        List<CollectAnnotationData>[] paramAnnot = methodData.getArgAnnotations();
        for (int i = 0; i < argTypes.length; ++i) {
            Type argType = argTypes[i];
            JType argJType = this.resolveType(argType);
            if (argJType == null) {
                logger.log(TreeLogger.ERROR, "Unable to resolve type " + argType.getInternalName() + " of argument " + methodData.getArgNames()[i]);
                return false;
            }
            HashMap<Class<? extends Annotation>, Annotation> declaredAnnotations = Maps.newHashMap();
            this.resolveAnnotations(logger, paramAnnot[i], declaredAnnotations);
            this.newParameter(method, argJType, argNames[i], declaredAnnotations, argNamesAreReal);
        }
        return true;
    }

    private boolean resolveThrows(TreeLogger logger, JAbstractMethod method, CollectMethodData methodData) {
        if (method.getThrows().length == 0) {
            for (String exceptionName : methodData.getExceptions()) {
                Type exceptionType = Type.getObjectType(exceptionName);
                JType exceptionJType = this.resolveType(exceptionType);
                if (exceptionJType == null) {
                    logger.log(TreeLogger.ERROR, "Unable to resolve type " + exceptionType.getInternalName() + " of thrown exception");
                    return false;
                }
                this.addThrows(method, (JClassType)exceptionJType);
            }
        }
        return true;
    }

    private JType resolveType(Type type) {
        switch (type.getSort()) {
            case 1: {
                return JPrimitiveType.BOOLEAN;
            }
            case 3: {
                return JPrimitiveType.BYTE;
            }
            case 2: {
                return JPrimitiveType.CHAR;
            }
            case 4: {
                return JPrimitiveType.SHORT;
            }
            case 5: {
                return JPrimitiveType.INT;
            }
            case 7: {
                return JPrimitiveType.LONG;
            }
            case 6: {
                return JPrimitiveType.FLOAT;
            }
            case 8: {
                return JPrimitiveType.DOUBLE;
            }
            case 0: {
                return JPrimitiveType.VOID;
            }
            case 9: {
                return this.resolveArray(type);
            }
            case 10: {
                JRealClassType resolvedType = this.resolveObject(type);
                return CompilationUnitTypeOracleUpdater.possiblySubstituteRawType(resolvedType);
            }
        }
        assert (false) : "Unexpected type " + type;
        return null;
    }

    private boolean shouldSuppressUnresolvableAnnotation(TreeLogger logger, String sourceName) {
        if (sourceName.startsWith("javax.validation.") || sourceName.startsWith("com.google.gwt.validation.")) {
            if (!warnedMissingValidationJar) {
                warnedMissingValidationJar = true;
                logger.log(TreeLogger.WARN, "Detected warnings related to '" + sourceName + "'.   Is validation-<version>.jar on the classpath?");
                logger.log(TreeLogger.INFO, "Specify -logLevel DEBUG to see all errors.");
                return false;
            }
            return true;
        }
        return false;
    }

    static {
        ImmutableMap.Builder<String, Class<Void>> builder = ImmutableMap.builder().put("Z", Boolean.TYPE).put("B", Byte.TYPE).put("C", Character.TYPE).put("S", Short.TYPE).put("I", Integer.TYPE).put("F", Float.TYPE).put("D", Double.TYPE).put("J", Long.TYPE).put("V", Void.TYPE);
        for (Class c : new Class[]{Void.TYPE, Boolean.TYPE, Byte.TYPE, Character.TYPE, Short.TYPE, Integer.TYPE, Float.TYPE, Double.TYPE, Long.TYPE}) {
            builder.put(c.getName(), c);
        }
        BUILT_IN_PRIMITIVE_MAP = builder.build();
    }

    protected class TypeOracleBuildContext {
        protected final MethodArgNamesLookup allMethodArgs;
        private final Map<String, CollectClassData> classDataByInternalName = Maps.newHashMap();
        private final Map<JRealClassType, CollectClassData> classDataByType = Maps.newHashMap();
        private final Resolver resolver = new CompilationUnitTypeOracleResolver(this);

        protected TypeOracleBuildContext(MethodArgNamesLookup allMethodArgs) {
            this.allMethodArgs = allMethodArgs;
        }
    }

    private class CompilationUnitTypeOracleResolver
    implements Resolver {
        private final TypeOracleBuildContext context;

        public CompilationUnitTypeOracleResolver(TypeOracleBuildContext context) {
            this.context = context;
        }

        @Override
        public void addImplementedInterface(JRealClassType type, JClassType intf) {
            CompilationUnitTypeOracleUpdater.this.addImplementedInterface(type, intf);
        }

        @Override
        public void addThrows(JAbstractMethod method, JClassType exception) {
            CompilationUnitTypeOracleUpdater.this.addThrows(method, exception);
        }

        @Override
        public JRealClassType findByInternalName(String internalName) {
            return CompilationUnitTypeOracleUpdater.this.findByInternalName(internalName);
        }

        @Override
        public TypeOracle getTypeOracle() {
            return CompilationUnitTypeOracleUpdater.this.typeOracle;
        }

        @Override
        public JMethod newMethod(JClassType type, String name, Map<Class<? extends Annotation>, Annotation> declaredAnnotations, JTypeParameter[] typeParams) {
            return CompilationUnitTypeOracleUpdater.this.newMethod(type, name, declaredAnnotations, typeParams);
        }

        @Override
        public void newParameter(JAbstractMethod method, JType argType, String argName, Map<Class<? extends Annotation>, Annotation> declaredAnnotations, boolean argNamesAreReal) {
            CompilationUnitTypeOracleUpdater.this.newParameter(method, argType, argName, declaredAnnotations, argNamesAreReal);
        }

        @Override
        public JRealClassType newRealClassType(JPackage pkg, String enclosingTypeName, boolean isLocalType, String simpleSourceName, boolean isInterface) {
            return CompilationUnitTypeOracleUpdater.this.newRealClassType(pkg, enclosingTypeName, simpleSourceName, isInterface);
        }

        @Override
        public boolean resolveAnnotations(TreeLogger logger, List<CollectAnnotationData> annotations, Map<Class<? extends Annotation>, Annotation> declaredAnnotations) {
            return CompilationUnitTypeOracleUpdater.this.resolveAnnotations(logger, annotations, declaredAnnotations);
        }

        @Override
        public boolean resolveClass(TreeLogger logger, JRealClassType type) {
            return CompilationUnitTypeOracleUpdater.this.resolveClass(logger, type, this.context);
        }

        @Override
        public void setReturnType(JAbstractMethod method, JType returnType) {
            CompilationUnitTypeOracleUpdater.this.setReturnType(method, returnType);
        }

        @Override
        public void setSuperClass(JRealClassType type, JClassType superType) {
            CompilationUnitTypeOracleUpdater.this.setSuperClass(type, superType);
        }
    }

    static class TypeData {
        private final byte[] byteCode;
        private CollectClassData classData;
        private final String internalName;
        private final long lastModifiedTime;
        private final String packageName;
        private final String sourceName;

        protected TypeData(String packageName, String sourceName, String internalName, byte[] byteCode, long lastModifiedTime) {
            this.packageName = packageName;
            this.sourceName = sourceName;
            this.internalName = internalName;
            this.byteCode = byteCode;
            this.lastModifiedTime = lastModifiedTime;
        }

        synchronized CollectClassData getCollectClassData() {
            if (this.classData == null) {
                ClassReader reader = new ClassReader(this.byteCode);
                CollectClassData classVisitor = this.classData = new CollectClassData();
                reader.accept(classVisitor, 0);
            }
            return this.classData;
        }
    }
}

