/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.javac;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.dev.javac.CompilationErrorsIndex;
import com.google.gwt.dev.javac.CompilationUnit;
import com.google.gwt.dev.javac.CompiledClass;
import com.google.gwt.thirdparty.guava.common.collect.HashMultimap;
import com.google.gwt.thirdparty.guava.common.collect.ImmutableList;
import com.google.gwt.thirdparty.guava.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CompilationUnitInvalidator {
    public static void retainValidUnits(TreeLogger logger, Collection<CompilationUnit> units, Map<String, CompiledClass> validClasses, CompilationErrorsIndex compilationErrorsIndex) {
        HashMultimap<String, CompilationUnit> missing;
        logger = logger.branch(TreeLogger.TRACE, "Removing invalidated units");
        HashMultimap<String, CompilationUnit> depsNeeded = HashMultimap.create();
        HashSet<String> depsProvided = new HashSet<String>();
        ImmutableSet<CompilationUnit> initialUnits = units instanceof Set ? (ImmutableSet<CompilationUnit>)units : ImmutableSet.copyOf(units);
        HashSet<CompilationUnit> allBrokenUnits = new HashSet<CompilationUnit>();
        for (CompilationUnit unit : units) {
            if (unit.isError()) {
                allBrokenUnits.add(unit);
                continue;
            }
            for (CompiledClass cc : unit.getCompiledClasses()) {
                depsProvided.add(cc.getSourceName());
            }
            for (String ref : unit.getDependencies().getApiRefs()) {
                CompiledClass compiledClass = validClasses.get(ref);
                if (compiledClass != null && !compiledClass.getUnit().isError() && !initialUnits.contains(compiledClass.getUnit())) continue;
                depsNeeded.put(ref, unit);
            }
        }
        do {
            missing = HashMultimap.create();
            missing.putAll(depsNeeded);
            missing.keySet().removeAll(depsProvided);
            for (Map.Entry brokenEntry : missing.entries()) {
                CompilationUnit brokenUnit = (CompilationUnit)brokenEntry.getValue();
                if (!allBrokenUnits.add(brokenUnit)) continue;
                for (CompiledClass cc : brokenUnit.getCompiledClasses()) {
                    depsProvided.remove(cc.getSourceName());
                }
                TreeLogger branch = logger.branch(TreeLogger.DEBUG, "Compilation unit '" + brokenUnit + "' is removed due to invalid reference(s):");
                branch.log(TreeLogger.DEBUG, (String)brokenEntry.getKey());
                compilationErrorsIndex.add(brokenUnit.getTypeName(), brokenUnit.getResourceLocation(), brokenUnit.getDependencies().getApiRefs(), ImmutableList.of((String)brokenEntry.getKey() + " cannot be resolved to a type"));
            }
            depsNeeded.keySet().removeAll(missing.keySet());
        } while (!missing.isEmpty());
        units.removeAll(allBrokenUnits);
    }
}

