/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.javac;

import com.google.gwt.dev.javac.CompilationUnit;
import com.google.gwt.dev.javac.CompiledClass;
import com.google.gwt.dev.javac.Dependencies;
import com.google.gwt.dev.javac.JsniMethod;
import com.google.gwt.dev.javac.MethodArgNamesLookup;
import com.google.gwt.dev.jjs.ast.JDeclaredType;
import com.google.gwt.dev.jjs.ast.JProgram;
import com.google.gwt.dev.util.collect.Lists;
import com.google.gwt.thirdparty.guava.common.base.Predicate;
import com.google.gwt.thirdparty.guava.common.collect.Iterables;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.List;
import org.eclipse.jdt.core.compiler.CategorizedProblem;

abstract class CompilationUnitImpl
extends CompilationUnit {
    protected transient long astToken;
    private final Dependencies dependencies;
    private final List<CompiledClass> exposedCompiledClasses;
    private final boolean hasErrors;
    private final boolean hasJsInteropRootType;
    private final List<JsniMethod> jsniMethods;
    private final MethodArgNamesLookup methodArgs;
    private final CategorizedProblem[] problems;

    public CompilationUnitImpl(List<CompiledClass> compiledClasses, List<JDeclaredType> types, Dependencies dependencies, Collection<? extends JsniMethod> jsniMethods, MethodArgNamesLookup methodArgs, CategorizedProblem[] problems) {
        this.exposedCompiledClasses = Lists.normalizeUnmodifiable(compiledClasses);
        this.dependencies = dependencies;
        this.jsniMethods = Lists.create(jsniMethods.toArray(new JsniMethod[jsniMethods.size()]));
        this.methodArgs = methodArgs;
        this.problems = problems;
        boolean hasAnyErrors = false;
        if (problems != null) {
            for (CategorizedProblem problem : problems) {
                if (!problem.isError()) continue;
                hasAnyErrors = true;
            }
        }
        this.hasErrors = hasAnyErrors;
        this.hasJsInteropRootType = Iterables.any(types, new Predicate<JDeclaredType>(){

            @Override
            public boolean apply(JDeclaredType type) {
                return type.hasJsInteropEntryPoints();
            }
        });
        for (CompiledClass cc : compiledClasses) {
            cc.initUnit(this);
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(baos);
            JProgram.serializeTypes(types, out);
            out.close();
            this.astToken = diskCache.writeByteArray(baos.toByteArray());
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected IOException on in-memory stream", e);
        }
    }

    @Override
    public Collection<CompiledClass> getCompiledClasses() {
        return this.exposedCompiledClasses;
    }

    @Override
    public List<JsniMethod> getJsniMethods() {
        return this.jsniMethods;
    }

    @Override
    public MethodArgNamesLookup getMethodArgs() {
        return this.methodArgs;
    }

    @Override
    public byte[] getTypesSerialized() {
        return diskCache.readByteArray(this.astToken);
    }

    @Override
    public boolean isError() {
        return this.hasErrors;
    }

    @Override
    boolean hasJsInteropRootType() {
        return this.hasJsInteropRootType;
    }

    @Override
    Dependencies getDependencies() {
        return this.dependencies;
    }

    @Override
    CategorizedProblem[] getProblems() {
        return this.problems;
    }
}

