/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.javac;

import com.google.gwt.dev.javac.CachedCompilationUnit;
import com.google.gwt.dev.javac.CompilationUnit;
import com.google.gwt.dev.javac.CompilationUnitImpl;
import com.google.gwt.dev.javac.CompiledClass;
import com.google.gwt.dev.javac.ContentId;
import com.google.gwt.dev.javac.Dependencies;
import com.google.gwt.dev.javac.GeneratedUnit;
import com.google.gwt.dev.javac.JsniMethod;
import com.google.gwt.dev.javac.MethodArgNamesLookup;
import com.google.gwt.dev.javac.Shared;
import com.google.gwt.dev.javac.SourceFileCompilationUnit;
import com.google.gwt.dev.jjs.ast.JDeclaredType;
import com.google.gwt.dev.resource.Resource;
import com.google.gwt.dev.util.Util;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import org.eclipse.jdt.core.compiler.CategorizedProblem;

public abstract class CompilationUnitBuilder {
    private List<CompiledClass> compiledClasses;
    private Dependencies dependencies;
    private Collection<? extends JsniMethod> jsniMethods;
    private MethodArgNamesLookup methodArgs;
    private CategorizedProblem[] problems;
    private transient String source;
    private List<JDeclaredType> types;

    public static CompilationUnitBuilder create(GeneratedUnit generatedUnit) {
        return new GeneratedCompilationUnitBuilder(generatedUnit);
    }

    public static CompilationUnitBuilder create(Resource resource) {
        return new ResourceCompilationUnitBuilder(resource);
    }

    public static String getSourceMapPathFor(Resource resource) {
        return resource.getPathPrefix() + resource.getPath();
    }

    static String getLocationFor(GeneratedUnit generatedUnit) {
        String location = generatedUnit.optionalFileLocation();
        if (location != null) {
            return location;
        }
        return "generated://" + generatedUnit.getStrongHash() + "/" + Shared.toPath(generatedUnit.getTypeName());
    }

    protected CompilationUnitBuilder() {
    }

    public CompilationUnit build() {
        this.source = null;
        assert (this.compiledClasses != null);
        assert (this.types != null);
        assert (this.dependencies != null);
        assert (this.jsniMethods != null);
        assert (this.methodArgs != null);
        return this.makeUnit(this.compiledClasses, this.types, this.dependencies, this.jsniMethods, this.methodArgs, this.problems);
    }

    public abstract ContentId getContentId();

    public abstract String getLocation();

    public String getSource() {
        if (this.source == null) {
            this.source = this.doGetSource();
        }
        return this.source;
    }

    public abstract String getSourceMapPath();

    public abstract String getTypeName();

    public CompilationUnitBuilder setClasses(List<CompiledClass> compiledClasses) {
        this.compiledClasses = compiledClasses;
        return this;
    }

    public CompilationUnitBuilder setDependencies(Dependencies dependencies) {
        this.dependencies = dependencies;
        return this;
    }

    public CompilationUnitBuilder setJsniMethods(Collection<? extends JsniMethod> jsniMethods) {
        this.jsniMethods = jsniMethods;
        return this;
    }

    public CompilationUnitBuilder setMethodArgs(MethodArgNamesLookup methodArgs) {
        this.methodArgs = methodArgs;
        return this;
    }

    public CompilationUnitBuilder setProblems(CategorizedProblem[] problems) {
        this.problems = problems;
        return this;
    }

    public CompilationUnitBuilder setTypes(List<JDeclaredType> types) {
        this.types = types;
        return this;
    }

    public final String toString() {
        return this.getLocation();
    }

    protected abstract String doGetSource();

    protected abstract CompilationUnit makeUnit(List<CompiledClass> var1, List<JDeclaredType> var2, Dependencies var3, Collection<? extends JsniMethod> var4, MethodArgNamesLookup var5, CategorizedProblem[] var6);

    static final class GeneratedCompilationUnit
    extends CompilationUnitImpl {
        private final GeneratedUnit generatedUnit;

        public GeneratedCompilationUnit(GeneratedUnit generatedUnit, List<CompiledClass> compiledClasses, List<JDeclaredType> types, Dependencies dependencies, Collection<? extends JsniMethod> jsniMethods, MethodArgNamesLookup methodArgs, CategorizedProblem[] problems) {
            super(compiledClasses, types, dependencies, jsniMethods, methodArgs, problems);
            this.generatedUnit = generatedUnit;
        }

        @Override
        public CachedCompilationUnit asCachedCompilationUnit() {
            return new CachedCompilationUnit(this, this.astToken);
        }

        @Override
        public long getLastModified() {
            return this.generatedUnit.creationTime();
        }

        @Override
        public String getResourceLocation() {
            return CompilationUnitBuilder.getLocationFor(this.generatedUnit);
        }

        @Override
        public String getResourcePath() {
            return Shared.toPath(this.generatedUnit.getTypeName());
        }

        @Override
        public String getTypeName() {
            return this.generatedUnit.getTypeName();
        }

        @Override
        @Deprecated
        public boolean isGenerated() {
            return true;
        }

        @Override
        @Deprecated
        public boolean isSuperSource() {
            return false;
        }

        @Override
        ContentId getContentId() {
            return new ContentId(this.getTypeName(), this.generatedUnit.getStrongHash());
        }

        String getSource() {
            return this.generatedUnit.getSource();
        }
    }

    static class ResourceCompilationUnitBuilder
    extends CompilationUnitBuilder {
        private ContentId contentId;
        private long lastModifed = -1L;
        private final Resource resource;
        private final String typeName;

        private ResourceCompilationUnitBuilder(Resource resource) {
            this.typeName = Shared.toTypeName(resource.getPath());
            this.resource = resource;
        }

        @Override
        public ContentId getContentId() {
            if (this.contentId == null) {
                this.getSource();
            }
            return this.contentId;
        }

        public long getLastModified() {
            if (this.lastModifed < 0L) {
                return this.resource.getLastModified();
            }
            return this.lastModifed;
        }

        @Override
        public String getLocation() {
            return this.resource.getLocation();
        }

        public Resource getResource() {
            return this.resource;
        }

        @Override
        public String getSourceMapPath() {
            return ResourceCompilationUnitBuilder.getSourceMapPathFor(this.resource);
        }

        @Override
        public String getTypeName() {
            return this.typeName;
        }

        @Override
        protected String doGetSource() {
            this.lastModifed = this.resource.getLastModified();
            ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
            try {
                InputStream in = this.resource.openContents();
                if (in == null) {
                    throw new RuntimeException("Unexpected error reading resource '" + this.resource + "'");
                }
                Util.copy(in, out);
            }
            catch (IOException e) {
                throw new RuntimeException("Unexpected error reading resource '" + this.resource + "'", e);
            }
            byte[] content = out.toByteArray();
            this.contentId = new ContentId(this.getTypeName(), Util.computeStrongName(content));
            return Util.toString(content);
        }

        @Override
        protected CompilationUnit makeUnit(List<CompiledClass> compiledClasses, List<JDeclaredType> types, Dependencies dependencies, Collection<? extends JsniMethod> jsniMethods, MethodArgNamesLookup methodArgs, CategorizedProblem[] problems) {
            return new SourceFileCompilationUnit(this.getResource(), this.getContentId(), compiledClasses, types, dependencies, jsniMethods, methodArgs, problems, this.getLastModified());
        }
    }

    static class GeneratedCompilationUnitBuilder
    extends CompilationUnitBuilder {
        private final GeneratedUnit generatedUnit;

        public GeneratedCompilationUnitBuilder(GeneratedUnit generatedUnit) {
            this.generatedUnit = generatedUnit;
        }

        @Override
        public ContentId getContentId() {
            return new ContentId(this.getTypeName(), this.generatedUnit.getStrongHash());
        }

        @Override
        public String getLocation() {
            return GeneratedCompilationUnitBuilder.getLocationFor(this.generatedUnit);
        }

        @Override
        public String getSourceMapPath() {
            return this.generatedUnit.getSourceMapPath();
        }

        @Override
        public String getTypeName() {
            return this.generatedUnit.getTypeName();
        }

        @Override
        protected String doGetSource() {
            return this.generatedUnit.getSource();
        }

        @Override
        protected CompilationUnit makeUnit(List<CompiledClass> compiledClasses, List<JDeclaredType> types, Dependencies dependencies, Collection<? extends JsniMethod> jsniMethods, MethodArgNamesLookup methodArgs, CategorizedProblem[] problems) {
            return new GeneratedCompilationUnit(this.generatedUnit, compiledClasses, types, dependencies, jsniMethods, methodArgs, problems);
        }
    }
}

