/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.javac;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.dev.javac.CachedCompilationUnit;
import com.google.gwt.dev.javac.CompiledClass;
import com.google.gwt.dev.javac.ContentId;
import com.google.gwt.dev.javac.Dependencies;
import com.google.gwt.dev.javac.GeneratedClassnameComparator;
import com.google.gwt.dev.javac.JsniMethod;
import com.google.gwt.dev.javac.MethodArgNamesLookup;
import com.google.gwt.dev.javac.asmbridge.EmptyVisitor;
import com.google.gwt.dev.jjs.ast.JDeclaredType;
import com.google.gwt.dev.jjs.ast.JProgram;
import com.google.gwt.dev.util.DiskCache;
import com.google.gwt.dev.util.StringInterningObjectInputStream;
import com.google.gwt.dev.util.Util;
import com.google.gwt.dev.util.collect.HashMap;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.MethodVisitor;

public abstract class CompilationUnit
implements Serializable {
    public static final Comparator<CompilationUnit> COMPARATOR = new Comparator<CompilationUnit>(){

        @Override
        public int compare(CompilationUnit o1, CompilationUnit o2) {
            return o1.getResourcePath().compareTo(o2.getResourcePath());
        }
    };
    protected static final DiskCache diskCache = DiskCache.INSTANCE;
    private static final Pattern GENERATED_CLASSNAME_PATTERN = Pattern.compile(".+\\$\\d.*");
    private transient Map<String, String> anonymousClassMap = null;

    @Deprecated
    public static boolean isClassnameGenerated(String className) {
        return GENERATED_CLASSNAME_PATTERN.matcher(className).matches();
    }

    public abstract CachedCompilationUnit asCachedCompilationUnit();

    @Deprecated
    public final boolean constructAnonymousClassMappings(TreeLogger logger) {
        this.anonymousClassMap = new HashMap<String, String>();
        for (String topLevelClass : this.getTopLevelClasses()) {
            List<String> javacClasses = new GeneratedClassnameFinder(logger, topLevelClass).getClassNames();
            List<String> jdtClasses = this.getJdtClassNames(topLevelClass);
            if (javacClasses.size() != jdtClasses.size()) {
                this.anonymousClassMap = Collections.emptyMap();
                return false;
            }
            int size = javacClasses.size();
            for (int i = 0; i < size; ++i) {
                if (javacClasses.get(i).equals(jdtClasses.get(i))) continue;
                this.anonymousClassMap.put(javacClasses.get(i), jdtClasses.get(i));
            }
        }
        return true;
    }

    @Deprecated
    public final boolean createdClassMapping() {
        return this.anonymousClassMap != null;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Deprecated
    public final Map<String, String> getAnonymousClassMap() {
        if (this.anonymousClassMap == null) {
            return Collections.emptyMap();
        }
        return this.anonymousClassMap;
    }

    public abstract Collection<CompiledClass> getCompiledClasses();

    public abstract List<JsniMethod> getJsniMethods();

    public abstract long getLastModified();

    public abstract MethodArgNamesLookup getMethodArgs();

    public abstract String getResourceLocation();

    public abstract String getResourcePath();

    public abstract String getTypeName();

    public List<JDeclaredType> getTypes() {
        try {
            byte[] bytes = this.getTypesSerialized();
            StringInterningObjectInputStream ois = new StringInterningObjectInputStream(new ByteArrayInputStream(bytes));
            return JProgram.deserializeTypes(ois);
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected IOException on in-memory stream", e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unexpected error deserializing AST for '" + this.getTypeName() + "'", e);
        }
    }

    public abstract byte[] getTypesSerialized();

    @Deprecated
    public final boolean hasAnonymousClasses() {
        for (CompiledClass cc : this.getCompiledClasses()) {
            if (!this.isAnonymousClass(cc)) continue;
            return true;
        }
        return false;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public abstract boolean isError();

    @Deprecated
    public abstract boolean isGenerated();

    @Deprecated
    public abstract boolean isSuperSource();

    public final String toString() {
        return this.getResourceLocation();
    }

    protected final Object writeReplace() {
        return this.asCachedCompilationUnit();
    }

    abstract ContentId getContentId();

    abstract Dependencies getDependencies();

    abstract CategorizedProblem[] getProblems();

    abstract boolean hasJsInteropRootType();

    private List<String> getJdtClassNames(String topLevelClass) {
        ArrayList<String> classNames = new ArrayList<String>();
        for (CompiledClass cc : this.getCompiledClasses()) {
            if (!this.isAnonymousClass(cc) || !cc.getInternalName().startsWith(topLevelClass + "$")) continue;
            classNames.add(cc.getInternalName());
        }
        Collections.sort(classNames, new GeneratedClassnameComparator());
        return classNames;
    }

    private List<String> getTopLevelClasses() {
        ArrayList<String> topLevelClasses = new ArrayList<String>();
        for (CompiledClass cc : this.getCompiledClasses()) {
            if (cc.getEnclosingClass() != null) continue;
            topLevelClasses.add(cc.getInternalName());
        }
        return topLevelClasses;
    }

    private boolean isAnonymousClass(CompiledClass cc) {
        return cc.isLocal() && CompilationUnit.isClassnameGenerated(cc.getInternalName());
    }

    static class GeneratedClassnameFinder {
        private final List<String> classesToScan;
        private final TreeLogger logger;
        private final String mainClass;
        private String mainUrlBase = null;

        GeneratedClassnameFinder(TreeLogger logger, String mainClass) {
            assert (mainClass != null);
            this.mainClass = mainClass;
            this.classesToScan = new ArrayList<String>();
            this.classesToScan.add(mainClass);
            this.logger = logger;
        }

        List<String> getClassNames() {
            ArrayList<String> allGeneratedClasses = new ArrayList<String>();
            for (int i = 0; i < this.classesToScan.size(); ++i) {
                String lookupName = this.classesToScan.get(i);
                byte[] classBytes = this.getClassBytes(lookupName);
                if (classBytes == null) continue;
                AnonymousClassVisitor cv = new AnonymousClassVisitor();
                new ClassReader(classBytes).accept(cv, 0);
                if (!cv.isWellFormed()) continue;
                if (CompilationUnit.isClassnameGenerated(lookupName) && !allGeneratedClasses.contains(lookupName)) {
                    allGeneratedClasses.add(lookupName);
                }
                List<String> innerClasses = cv.getInnerClassNames();
                for (String innerClass : innerClasses) {
                    if (!innerClass.startsWith(this.mainClass + "$") || this.classesToScan.contains(innerClass)) continue;
                    this.classesToScan.add(innerClass);
                }
            }
            Collections.sort(allGeneratedClasses, new GeneratedClassnameComparator());
            return allGeneratedClasses;
        }

        private byte[] getClassBytes(String slashedName) {
            URL url = Thread.currentThread().getContextClassLoader().getResource(slashedName + ".class");
            if (url == null) {
                if (this.logger.isLoggable(TreeLogger.DEBUG)) {
                    this.logger.log(TreeLogger.DEBUG, "Unable to find " + slashedName + " on the classPath");
                }
                return null;
            }
            String urlStr = url.toExternalForm();
            if (slashedName.equals(this.mainClass)) {
                this.mainUrlBase = urlStr.substring(0, urlStr.lastIndexOf(47));
            } else {
                assert (this.mainUrlBase != null);
                if (!this.mainUrlBase.equals(urlStr.substring(0, urlStr.lastIndexOf(47)))) {
                    if (this.logger.isLoggable(TreeLogger.DEBUG)) {
                        this.logger.log(TreeLogger.DEBUG, "Found " + slashedName + " at " + urlStr + " The base location is different from  that of " + this.mainUrlBase + " Not loading");
                    }
                    return null;
                }
            }
            try {
                URLConnection conn = url.openConnection();
                return Util.readURLConnectionAsBytes(conn);
            }
            catch (IOException ignored) {
                if (this.logger.isLoggable(TreeLogger.DEBUG)) {
                    this.logger.log(TreeLogger.DEBUG, "Unable to load " + urlStr + ", in trying to load " + slashedName);
                }
                return null;
            }
        }

        private static class AnonymousClassVisitor
        extends EmptyVisitor {
            List<String> classNames = new ArrayList<String>();
            int expectCode;
            int sawCode;

            public AnonymousClassVisitor() {
                this.mv = new MethodVisitor(589824, this.mv){

                    @Override
                    public void visitCode() {
                        ++sawCode;
                    }
                };
            }

            public List<String> getInnerClassNames() {
                return this.classNames;
            }

            public boolean isWellFormed() {
                return this.expectCode == this.sawCode;
            }

            @Override
            public void visitInnerClass(String name, String outerName, String innerName, int access) {
                if ((access & 0x1000) == 0) {
                    this.classNames.add(name);
                }
            }

            @Override
            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                if ((access & 0x500) == 0) {
                    ++this.expectCode;
                }
                return super.visitMethod(access, name, desc, signature, exceptions);
            }
        }
    }
}

