/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.javac;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.dev.CompilerContext;
import com.google.gwt.dev.javac.BinaryTypeReferenceRestrictionsChecker;
import com.google.gwt.dev.javac.CachedCompilationUnit;
import com.google.gwt.dev.javac.CompilationProblemReporter;
import com.google.gwt.dev.javac.CompilationState;
import com.google.gwt.dev.javac.CompilationUnit;
import com.google.gwt.dev.javac.CompilationUnitBuilder;
import com.google.gwt.dev.javac.CompilationUnitTypeOracleUpdater;
import com.google.gwt.dev.javac.CompiledClass;
import com.google.gwt.dev.javac.ContentId;
import com.google.gwt.dev.javac.Dependencies;
import com.google.gwt.dev.javac.GeneratedUnit;
import com.google.gwt.dev.javac.JSORestrictionsChecker;
import com.google.gwt.dev.javac.JdtCompiler;
import com.google.gwt.dev.javac.JsniMethod;
import com.google.gwt.dev.javac.JsniMethodCollector;
import com.google.gwt.dev.javac.JsniReferenceResolver;
import com.google.gwt.dev.javac.MethodArgNamesLookup;
import com.google.gwt.dev.javac.MethodParamCollector;
import com.google.gwt.dev.javac.ProgressLogger;
import com.google.gwt.dev.javac.Shared;
import com.google.gwt.dev.javac.UnitCache;
import com.google.gwt.dev.javac.typemodel.TypeOracle;
import com.google.gwt.dev.jjs.CorrelationFactory;
import com.google.gwt.dev.jjs.ast.JDeclaredType;
import com.google.gwt.dev.jjs.impl.GwtAstBuilder;
import com.google.gwt.dev.js.ast.JsRootScope;
import com.google.gwt.dev.resource.Resource;
import com.google.gwt.dev.util.StringInterner;
import com.google.gwt.dev.util.Util;
import com.google.gwt.dev.util.log.speedtracer.CompilerEventType;
import com.google.gwt.dev.util.log.speedtracer.DevModeEventType;
import com.google.gwt.dev.util.log.speedtracer.SpeedTracerLogger;
import com.google.gwt.thirdparty.guava.common.collect.ImmutableList;
import com.google.gwt.thirdparty.guava.common.collect.ImmutableMap;
import com.google.gwt.thirdparty.guava.common.collect.Interner;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import com.google.gwt.thirdparty.guava.common.collect.Maps;
import com.google.gwt.thirdparty.guava.common.collect.Sets;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;

public class CompilationStateBuilder {
    private static final CompilationStateBuilder instance = new CompilationStateBuilder();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CompilationState buildFrom(TreeLogger logger, CompilerContext compilerContext, Set<Resource> resources) throws UnableToCompleteException {
        SpeedTracerLogger.Event event = SpeedTracerLogger.start(DevModeEventType.CSB_BUILD_FROM_ORACLE, new String[0]);
        try {
            CompilationState compilationState = instance.doBuildFrom(logger, compilerContext, resources);
            return compilationState;
        }
        finally {
            event.end(new String[0]);
        }
    }

    public synchronized CompilationState doBuildFrom(TreeLogger logger, CompilerContext compilerContext, Set<Resource> resources) throws UnableToCompleteException {
        UnitCache unitCache = compilerContext.getUnitCache();
        assert (unitCache != null) : "CompilerContext should always contain a unit cache.";
        ArrayList<CompilationUnitBuilder> builders = Lists.newArrayList();
        IdentityHashMap<CompilationUnitBuilder, CompilationUnit> cachedUnits = Maps.newIdentityHashMap();
        CompileMoreLater compileMoreLater = new CompileMoreLater(compilerContext);
        for (Resource resource : resources) {
            CompilationUnitBuilder builder = CompilationUnitBuilder.create(resource);
            CompilationUnit cachedUnit = unitCache.find(resource.getPathPrefix() + resource.getPath());
            if (cachedUnit != null && cachedUnit.getLastModified() == resource.getLastModified()) assert (this.verifyContentId(logger, resource, cachedUnit));
            if (cachedUnit != null && cachedUnit.getLastModified() != resource.getLastModified()) {
                unitCache.remove(cachedUnit);
                if (cachedUnit instanceof CachedCompilationUnit && cachedUnit.getContentId().equals(builder.getContentId())) {
                    CachedCompilationUnit updatedUnit = new CachedCompilationUnit((CachedCompilationUnit)cachedUnit, resource.getLastModified(), resource.getLocation());
                    unitCache.add(updatedUnit);
                } else {
                    cachedUnit = null;
                }
            }
            if (cachedUnit != null) {
                cachedUnits.put(builder, cachedUnit);
                compileMoreLater.addValidUnit(cachedUnit);
                continue;
            }
            builders.add(builder);
            compilerContext.getMinimalRebuildCache().addSourceCompilationUnitName(builder.getTypeName());
        }
        int cachedSourceCount = cachedUnits.size();
        int sourceCount = resources.size();
        if (logger.isLoggable(TreeLogger.TRACE)) {
            logger.log(TreeLogger.TRACE, "Found " + cachedSourceCount + " cached/archived units.  Used " + cachedSourceCount + " / " + sourceCount + " units from cache.");
        }
        Collection<CompilationUnit> resultUnits = compileMoreLater.compile(logger, compilerContext, builders, cachedUnits, CompilerEventType.JDT_COMPILER_CSB_FROM_ORACLE);
        TypeOracle typeOracle = new TypeOracle();
        CompilationUnitTypeOracleUpdater typeOracleUpdater = new CompilationUnitTypeOracleUpdater(typeOracle);
        CompilationState compilationState = new CompilationState(logger, compilerContext, typeOracle, typeOracleUpdater, resultUnits, compileMoreLater);
        compilationState.incrementStaticSourceCount(sourceCount);
        compilationState.incrementCachedStaticSourceCount(cachedSourceCount);
        return compilationState;
    }

    private boolean verifyContentId(TreeLogger logger, Resource resource, CompilationUnit cachedUnit) {
        if (!cachedUnit.getContentId().equals(this.getResourceContentId(resource))) {
            logger.log(TreeLogger.WARN, "Modification date hasn't changed but contentId has changed for " + resource.getLocation());
        }
        return true;
    }

    private ContentId getResourceContentId(Resource resource) {
        ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
        try {
            InputStream in = resource.openContents();
            if (in == null) {
                throw new RuntimeException("Unexpected error reading resource '" + resource + "'");
            }
            Util.copy(in, out);
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected error reading resource '" + resource + "'", e);
        }
        byte[] content = out.toByteArray();
        return new ContentId(Shared.getTypeName(resource), Util.computeStrongName(content));
    }

    synchronized Collection<CompilationUnit> doBuildGeneratedTypes(TreeLogger logger, CompilerContext compilerContext, Collection<GeneratedUnit> generatedUnits, CompilationState compilationState, CompileMoreLater compileMoreLater) throws UnableToCompleteException {
        UnitCache unitCache = compilerContext.getUnitCache();
        ArrayList<CompilationUnitBuilder> builders = Lists.newArrayList();
        IdentityHashMap<CompilationUnitBuilder, CompilationUnit> cachedUnits = Maps.newIdentityHashMap();
        for (GeneratedUnit generatedUnit : generatedUnits) {
            CompilationUnitBuilder builder = CompilationUnitBuilder.create(generatedUnit);
            CompilationUnit cachedUnit = unitCache.find(builder.getContentId());
            if (cachedUnit != null && !cachedUnit.isError()) {
                cachedUnits.put(builder, cachedUnit);
                compileMoreLater.addValidUnit(cachedUnit);
                continue;
            }
            builders.add(builder);
            compilerContext.getMinimalRebuildCache().addSourceCompilationUnitName(builder.getTypeName());
        }
        if (compilerContext.getOptions().isIncrementalCompileEnabled()) {
            compilerContext.getMinimalRebuildCache().recordGeneratedUnits(generatedUnits);
        }
        compilationState.incrementGeneratedSourceCount(builders.size() + cachedUnits.size());
        compilationState.incrementCachedGeneratedSourceCount(cachedUnits.size());
        return compileMoreLater.compile(logger, compilerContext, builders, cachedUnits, CompilerEventType.JDT_COMPILER_CSB_GENERATED);
    }

    public class CompileMoreLater {
        private final Map<String, CompiledClass> allValidClasses = Maps.newHashMap();
        private transient LinkedBlockingQueue<CompilationUnitBuilder> buildQueue;
        private final JdtCompiler compiler;
        private final JSORestrictionsChecker.CheckerState jsoState = new JSORestrictionsChecker.CheckerState();
        private final boolean suppressErrors;
        private CompilerContext compilerContext;

        public CompileMoreLater(CompilerContext compilerContext) {
            this.compilerContext = compilerContext;
            this.compiler = new JdtCompiler(compilerContext, new UnitProcessorImpl());
            this.suppressErrors = !compilerContext.getOptions().isStrict();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Collection<CompilationUnit> addGeneratedTypes(TreeLogger logger, Collection<GeneratedUnit> generatedUnits, CompilationState compilationState) throws UnableToCompleteException {
            SpeedTracerLogger.Event event = SpeedTracerLogger.start(DevModeEventType.CSB_ADD_GENERATED_TYPES, new String[0]);
            try {
                Collection<CompilationUnit> collection = CompilationStateBuilder.this.doBuildGeneratedTypes(logger, this.compilerContext, generatedUnits, compilationState, this);
                return collection;
            }
            finally {
                event.end(new String[0]);
            }
        }

        public Map<String, CompiledClass> getValidClasses() {
            return Collections.unmodifiableMap(this.allValidClasses);
        }

        void addValidUnit(CompilationUnit unit) {
            this.compiler.addCompiledUnit(unit);
            for (CompiledClass cc : unit.getCompiledClasses()) {
                this.allValidClasses.put(cc.getSourceName(), cc);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Collection<CompilationUnit> compile(TreeLogger logger, CompilerContext compilerContext, Collection<CompilationUnitBuilder> builders, Map<CompilationUnitBuilder, CompilationUnit> cachedUnits, SpeedTracerLogger.EventType eventType) throws UnableToCompleteException {
            UnitCache unitCache = compilerContext.getUnitCache();
            for (CompilationUnit unit : cachedUnits.values()) {
                for (CompiledClass cc : unit.getCompiledClasses()) {
                    String sourceName = cc.getSourceName();
                    this.allValidClasses.put(sourceName, cc);
                }
            }
            ArrayList<CompilationUnit> resultUnits = Lists.newArrayList();
            do {
                TreeLogger branch = logger.branch(TreeLogger.TRACE, "Compiling...");
                this.buildQueue = new LinkedBlockingQueue();
                final ArrayList<CompilationUnit> newlyBuiltUnits = Lists.newArrayList();
                final CompilationUnitBuilder sentinel = CompilationUnitBuilder.create((GeneratedUnit)null);
                final Throwable[] workerException = new Throwable[1];
                final ProgressLogger progressLogger = new ProgressLogger(branch, TreeLogger.TRACE, builders.size(), 10);
                Thread buildThread = new Thread(){

                    @Override
                    public void run() {
                        int processedCompilationUnitBuilders = 0;
                        try {
                            while (true) {
                                CompilationUnitBuilder builder = (CompilationUnitBuilder)CompileMoreLater.this.buildQueue.take();
                                if (!progressLogger.isTimerStarted()) {
                                    progressLogger.startTimer();
                                }
                                if (builder == sentinel) {
                                    return;
                                }
                                CompilationUnit unit = builder.build();
                                newlyBuiltUnits.add(unit);
                                progressLogger.updateProgress(++processedCompilationUnitBuilders);
                            }
                        }
                        catch (Throwable e) {
                            workerException[0] = e;
                            return;
                        }
                    }
                };
                buildThread.setName("CompilationUnitBuilder");
                buildThread.start();
                SpeedTracerLogger.Event jdtCompilerEvent = SpeedTracerLogger.start(eventType, new String[0]);
                long compilationStartNanos = System.nanoTime();
                try {
                    this.compiler.doCompile(branch, builders);
                }
                finally {
                    jdtCompilerEvent.end(new String[0]);
                }
                this.buildQueue.add(sentinel);
                try {
                    buildThread.join();
                    long compilationNanos = System.nanoTime() - compilationStartNanos;
                    double compilationSeconds = (double)compilationNanos / (double)TimeUnit.SECONDS.toNanos(1L);
                    branch.log(TreeLogger.TRACE, String.format("Compilation completed in %.02f seconds", compilationSeconds));
                    if (workerException[0] != null) {
                        throw workerException[0];
                    }
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw new RuntimeException("Exception processing units", e);
                }
                finally {
                    this.buildQueue = null;
                }
                resultUnits.addAll(newlyBuiltUnits);
                builders.clear();
                for (CompilationUnit unit : newlyBuiltUnits) {
                    unit.getDependencies().resolve(this.allValidClasses);
                }
                this.removeInvalidCachedUnitsAndRescheduleCorrespondingBuilders(logger, builders, cachedUnits);
            } while (builders.size() > 0);
            for (CompilationUnit unit : resultUnits) {
                unitCache.add(unit);
            }
            resultUnits.addAll(cachedUnits.values());
            unitCache.cleanup(logger);
            TreeLogger.Type logLevelForWarnings = this.suppressErrors ? TreeLogger.DEBUG : TreeLogger.WARN;
            int warningCount = CompilationProblemReporter.logWarnings(logger, logLevelForWarnings, resultUnits);
            if (warningCount > 0 && !logger.isLoggable(logLevelForWarnings)) {
                logger.log(TreeLogger.INFO, "Ignored " + warningCount + " unit" + (warningCount > 1 ? "s" : "") + " with compilation errors in first pass.\nCompile with -strict or with -logLevel set to DEBUG or WARN to see all errors.");
            }
            CompilationProblemReporter.indexErrors(compilerContext.getCompilationErrorsIndex(), resultUnits);
            TreeLogger.Type logLevelForErrors = this.suppressErrors ? TreeLogger.TRACE : TreeLogger.ERROR;
            int errorCount = CompilationProblemReporter.logErrorTrace(logger, logLevelForErrors, compilerContext, resultUnits, false);
            if (errorCount > 0 && !logger.isLoggable(logLevelForErrors) && logger.isLoggable(TreeLogger.INFO)) {
                logger.log(TreeLogger.INFO, "Ignored " + errorCount + " unit" + (errorCount > 1 ? "s" : "") + " with compilation errors in first pass.\nCompile with -strict or with -logLevel set to TRACE or DEBUG to see all errors.");
            }
            Collections.sort(resultUnits, CompilationUnit.COMPARATOR);
            return resultUnits;
        }

        private void removeInvalidCachedUnitsAndRescheduleCorrespondingBuilders(TreeLogger logger, Collection<CompilationUnitBuilder> builders, Map<CompilationUnitBuilder, CompilationUnit> cachedUnits) {
            ArrayList<CompilationUnit> invalidatedUnits = Lists.newArrayList();
            Iterator<Map.Entry<CompilationUnitBuilder, CompilationUnit>> it = cachedUnits.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<CompilationUnitBuilder, CompilationUnit> entry = it.next();
                CompilationUnit unit = entry.getValue();
                boolean isValid = unit.getDependencies().validate(logger, this.allValidClasses);
                if (isValid && unit.isError()) {
                    for (CompiledClass cc : unit.getCompiledClasses()) {
                        try {
                            cc.getNameEnvironmentAnswer();
                        }
                        catch (ClassFormatException ex) {
                            isValid = false;
                            break;
                        }
                    }
                }
                if (isValid) continue;
                if (logger.isLoggable(TreeLogger.TRACE)) {
                    logger.log(TreeLogger.TRACE, "Invalid Unit: " + unit.getTypeName());
                }
                invalidatedUnits.add(unit);
                builders.add(entry.getKey());
                it.remove();
            }
            if (invalidatedUnits.size() > 0 && logger.isLoggable(TreeLogger.TRACE)) {
                logger.log(TreeLogger.TRACE, "Invalid units found: " + invalidatedUnits.size());
            }
            for (CompilationUnit unit : invalidatedUnits) {
                for (CompiledClass cc : unit.getCompiledClasses()) {
                    this.allValidClasses.remove(cc.getSourceName());
                }
            }
        }

        private final class UnitProcessorImpl
        implements JdtCompiler.UnitProcessor {
            private UnitProcessorImpl() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void process(CompilationUnitBuilder builder, CompilationUnitDeclaration cud, List<ImportReference> cudOriginaImports, List<CompiledClass> compiledClasses) {
                SpeedTracerLogger.Event event = SpeedTracerLogger.start(DevModeEventType.CSB_PROCESS, new String[0]);
                try {
                    ImmutableList<JDeclaredType> types = ImmutableList.of();
                    final HashSet jsniDeps = Sets.newHashSet();
                    HashMap<String, Binding> jsniRefs = Maps.newHashMap();
                    ImmutableMap<MethodDeclaration, JsniMethod> jsniMethods = ImmutableMap.of();
                    AbstractCollection apiRefs = ImmutableList.of();
                    MethodArgNamesLookup methodArgs = new MethodArgNamesLookup();
                    if (!cud.compilationResult().hasErrors()) {
                        jsniMethods = JsniMethodCollector.collectJsniMethods(cud, builder.getSourceMapPath(), builder.getSource(), JsRootScope.INSTANCE, CorrelationFactory.DummyCorrelationFactory.INSTANCE);
                        JSORestrictionsChecker.check(CompileMoreLater.this.jsoState, cud);
                        JsniReferenceResolver.resolve(cud, cudOriginaImports, jsniMethods, jsniRefs, new JsniReferenceResolver.TypeResolver(){

                            @Override
                            public ReferenceBinding resolveType(String sourceOrBinaryName) {
                                ReferenceBinding resolveType = CompileMoreLater.this.compiler.resolveType(sourceOrBinaryName);
                                if (resolveType != null) {
                                    jsniDeps.add(String.valueOf(resolveType.qualifiedSourceName()));
                                }
                                return resolveType;
                            }
                        });
                        BinaryTypeReferenceRestrictionsChecker.check(cud);
                        if (!cud.compilationResult().hasErrors()) {
                            types = GwtAstBuilder.process(cud, builder.getSourceMapPath(), jsniMethods, jsniRefs, CompileMoreLater.this.compilerContext);
                        }
                        methodArgs = MethodParamCollector.collect(cud, builder.getSourceMapPath());
                    }
                    apiRefs = CompileMoreLater.this.compiler.collectApiRefs(cud);
                    Interner<String> interner = StringInterner.get();
                    String packageName = interner.intern(Shared.getPackageName(builder.getTypeName()));
                    ArrayList<String> unresolvedSimple = Lists.newArrayList();
                    for (char[] simpleRef : cud.compilationResult().simpleNameReferences) {
                        unresolvedSimple.add(interner.intern(String.valueOf(simpleRef)));
                    }
                    ArrayList<String> unresolvedQualified = Lists.newArrayList();
                    for (char[][] qualifiedRef : cud.compilationResult().qualifiedReferences) {
                        unresolvedQualified.add(interner.intern(CharOperation.toString(qualifiedRef)));
                    }
                    Object object = jsniDeps.iterator();
                    while (object.hasNext()) {
                        String jsniDep = (String)object.next();
                        unresolvedQualified.add(interner.intern(jsniDep));
                    }
                    for (int i = 0; i < apiRefs.size(); ++i) {
                        apiRefs.set(i, interner.intern((String)apiRefs.get(i)));
                    }
                    Dependencies dependencies = new Dependencies(packageName, unresolvedQualified, unresolvedSimple, (List<String>)((Object)apiRefs));
                    for (CompiledClass cc : compiledClasses) {
                        CompileMoreLater.this.allValidClasses.put(cc.getSourceName(), cc);
                    }
                    builder.setTypes(types).setDependencies(dependencies).setJsniMethods(jsniMethods.values()).setMethodArgs(methodArgs).setClasses(compiledClasses).setProblems(cud.compilationResult().getProblems());
                    CompileMoreLater.this.buildQueue.add(builder);
                }
                finally {
                    event.end(new String[0]);
                }
            }
        }
    }
}

