/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.javac;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.dev.CompilerContext;
import com.google.gwt.dev.javac.CompilationStateBuilder;
import com.google.gwt.dev.javac.CompilationUnit;
import com.google.gwt.dev.javac.CompilationUnitInvalidator;
import com.google.gwt.dev.javac.CompilationUnitTypeOracleUpdater;
import com.google.gwt.dev.javac.CompiledClass;
import com.google.gwt.dev.javac.GeneratedUnit;
import com.google.gwt.dev.javac.typemodel.TypeOracle;
import com.google.gwt.dev.util.log.speedtracer.DevModeEventType;
import com.google.gwt.dev.util.log.speedtracer.SpeedTracerLogger;
import com.google.gwt.thirdparty.guava.common.annotations.VisibleForTesting;
import com.google.gwt.thirdparty.guava.common.base.Function;
import com.google.gwt.thirdparty.guava.common.base.Predicates;
import com.google.gwt.thirdparty.guava.common.collect.FluentIterable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class CompilationState {
    protected final Map<String, CompiledClass> classFileMap = new HashMap<String, CompiledClass>();
    protected final Map<String, CompiledClass> classFileMapBySource = new HashMap<String, CompiledClass>();
    protected final Map<String, CompilationUnit> unitMap = new HashMap<String, CompilationUnit>();
    private int cachedGeneratedSourceCount = 0;
    private int cachedStaticSourceCount = 0;
    private final CompilationStateBuilder.CompileMoreLater compileMoreLater;
    private CompilerContext compilerContext;
    private final Map<String, CompiledClass> exposedClassFileMap = Collections.unmodifiableMap(this.classFileMap);
    private final Map<String, CompiledClass> exposedClassFileMapBySource = Collections.unmodifiableMap(this.classFileMapBySource);
    private final Map<String, CompilationUnit> exposedUnitMap = Collections.unmodifiableMap(this.unitMap);
    private final Collection<CompilationUnit> exposedUnits = Collections.unmodifiableCollection(this.unitMap.values());
    private int generatedSourceCount = 0;
    private int staticSourceCount = 0;
    private final TypeOracle typeOracle;
    private final CompilationUnitTypeOracleUpdater typeOracleUpdater;

    CompilationState(TreeLogger logger, CompilerContext compilerContext, TypeOracle typeOracle, CompilationUnitTypeOracleUpdater typeOracleUpdater, Collection<CompilationUnit> units, CompilationStateBuilder.CompileMoreLater compileMoreLater) {
        this.compileMoreLater = compileMoreLater;
        this.compilerContext = compilerContext;
        this.typeOracle = typeOracle;
        this.typeOracleUpdater = typeOracleUpdater;
        this.assimilateUnits(logger, units);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGeneratedCompilationUnits(TreeLogger logger, Collection<GeneratedUnit> generatedUnits) throws UnableToCompleteException {
        SpeedTracerLogger.Event generatedUnitsAddEvent = SpeedTracerLogger.start(DevModeEventType.COMP_STATE_ADD_GENERATED_UNITS, new String[0]);
        try {
            logger = logger.branch(TreeLogger.DEBUG, "Adding '" + generatedUnits.size() + "' new generated units");
            generatedUnitsAddEvent.addData("# new generated units", "" + generatedUnits.size());
            Collection<CompilationUnit> newUnits = this.compileMoreLater.addGeneratedTypes(logger, generatedUnits, this);
            this.assimilateUnits(logger, newUnits);
        }
        finally {
            generatedUnitsAddEvent.end(new String[0]);
        }
    }

    public int getCachedGeneratedSourceCount() {
        return this.cachedGeneratedSourceCount;
    }

    public int getCachedStaticSourceCount() {
        return this.cachedStaticSourceCount;
    }

    public Map<String, CompiledClass> getClassFileMap() {
        return this.exposedClassFileMap;
    }

    public Map<String, CompiledClass> getClassFileMapBySource() {
        return this.exposedClassFileMapBySource;
    }

    public Map<String, CompilationUnit> getCompilationUnitMap() {
        return this.exposedUnitMap;
    }

    public Collection<CompilationUnit> getCompilationUnits() {
        return this.exposedUnits;
    }

    public Iterable<String> getQualifiedJsInteropRootTypesNames() {
        Function<CompilationUnit, String> toRootTypeName = new Function<CompilationUnit, String>(){

            @Override
            public String apply(CompilationUnit compilationUnit) {
                return compilationUnit.hasJsInteropRootType() ? compilationUnit.getTypeName() : null;
            }
        };
        return FluentIterable.from(this.unitMap.values()).transform(toRootTypeName).filter(Predicates.notNull());
    }

    public CompilerContext getCompilerContext() {
        return this.compilerContext;
    }

    public int getGeneratedSourceCount() {
        return this.generatedSourceCount;
    }

    public int getStaticSourceCount() {
        return this.staticSourceCount;
    }

    public TypeOracle getTypeOracle() {
        return this.typeOracle;
    }

    @VisibleForTesting
    public Map<String, CompiledClass> getValidClasses() {
        return this.compileMoreLater.getValidClasses();
    }

    public boolean hasErrors() {
        for (CompilationUnit unit : this.unitMap.values()) {
            if (!unit.isError()) continue;
            return true;
        }
        return false;
    }

    public void incrementCachedGeneratedSourceCount(int extraCachedGeneratedSourceCount) {
        this.cachedGeneratedSourceCount += extraCachedGeneratedSourceCount;
    }

    public void incrementCachedStaticSourceCount(int extraCachedStaticSourceCount) {
        this.cachedStaticSourceCount += extraCachedStaticSourceCount;
    }

    public void incrementGeneratedSourceCount(int extraGeneratedSourceCount) {
        this.generatedSourceCount += extraGeneratedSourceCount;
    }

    public void incrementStaticSourceCount(int extraStaticSourceCount) {
        this.staticSourceCount += extraStaticSourceCount;
    }

    CompilationUnitTypeOracleUpdater getTypeOracleUpdater() {
        return this.typeOracleUpdater;
    }

    private void assimilateUnits(TreeLogger logger, Collection<CompilationUnit> units) {
        for (CompilationUnit unit : units) {
            this.unitMap.put(unit.getTypeName(), unit);
            for (CompiledClass compiledClass : unit.getCompiledClasses()) {
                this.classFileMap.put(compiledClass.getInternalName(), compiledClass);
                this.classFileMapBySource.put(compiledClass.getSourceName(), compiledClass);
            }
        }
        CompilationUnitInvalidator.retainValidUnits(logger, units, this.compileMoreLater.getValidClasses(), this.compilerContext.getCompilationErrorsIndex());
        this.typeOracleUpdater.addNewUnits(logger, units);
    }
}

