/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.javac;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.dev.CompilerContext;
import com.google.gwt.dev.javac.CompilationErrorsIndex;
import com.google.gwt.dev.javac.CompilationUnit;
import com.google.gwt.dev.javac.CompilationUnitBuilder;
import com.google.gwt.dev.javac.Dependencies;
import com.google.gwt.dev.javac.GWTProblem;
import com.google.gwt.dev.jjs.InternalCompilerException;
import com.google.gwt.dev.jjs.SourceInfo;
import com.google.gwt.dev.util.Messages;
import com.google.gwt.dev.util.Util;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import org.eclipse.jdt.core.compiler.CategorizedProblem;

public class CompilationProblemReporter {
    public static void indexErrors(CompilationErrorsIndex compilationErrorsIndex, List<CompilationUnit> units) {
        for (CompilationUnit unit : units) {
            if (!unit.isError()) continue;
            Dependencies dependencies = unit.getDependencies();
            compilationErrorsIndex.add(unit.getTypeName(), unit.getResourceLocation(), dependencies.getApiRefs(), CompilationProblemReporter.formatErrors(unit));
        }
    }

    public static UnableToCompleteException logAndTranslateException(TreeLogger logger, Throwable e) {
        if (e instanceof UnableToCompleteException) {
            return (UnableToCompleteException)e;
        }
        if (e instanceof InternalCompilerException) {
            TreeLogger topBranch = logger.branch(TreeLogger.ERROR, "An internal compiler exception occurred", e);
            List<InternalCompilerException.NodeInfo> nodeTrace = ((InternalCompilerException)e).getNodeTrace();
            for (InternalCompilerException.NodeInfo nodeInfo : nodeTrace) {
                String msg;
                SourceInfo info = nodeInfo.getSourceInfo();
                if (info != null) {
                    String fileName = info.getFileName();
                    fileName = fileName.substring(fileName.lastIndexOf(47) + 1);
                    fileName = fileName.substring(fileName.lastIndexOf(92) + 1);
                    msg = "at " + fileName + "(" + info.getStartLine() + "): ";
                } else {
                    msg = "<no source info>: ";
                }
                String description = nodeInfo.getDescription();
                msg = description != null ? msg + description : msg + "<no description available>";
                TreeLogger nodeBranch = topBranch.branch(TreeLogger.ERROR, msg, null);
                String className = nodeInfo.getClassName();
                if (className == null) continue;
                nodeBranch.log(TreeLogger.INFO, className, null);
            }
            return new UnableToCompleteException();
        }
        if (e instanceof VirtualMachineError) {
            throw (VirtualMachineError)e;
        }
        logger.log(TreeLogger.ERROR, "Unexpected internal compiler error", e);
        return new UnableToCompleteException();
    }

    public static int logErrorTrace(TreeLogger logger, TreeLogger.Type logLevel, CompilerContext compilerContext, List<CompilationUnit> units, boolean hint) {
        int errorCount = 0;
        for (CompilationUnit unit : units) {
            if (!unit.isError()) continue;
            CompilationProblemReporter.logErrorTrace(logger, logLevel, compilerContext, unit.getTypeName(), hint);
            ++errorCount;
            if (!logger.isLoggable(TreeLogger.INFO) || !(unit instanceof CompilationUnitBuilder.GeneratedCompilationUnit)) continue;
            CompilationProblemReporter.maybeDumpSource(logger, ((CompilationUnitBuilder.GeneratedCompilationUnit)unit).getSource(), unit.getTypeName());
        }
        return errorCount++;
    }

    public static void logErrorTrace(TreeLogger logger, TreeLogger.Type logLevel, CompilerContext compilerContext, String typeSourceName, boolean hint) {
        TreeLogger branch = logger.branch(TreeLogger.TRACE, "Tracing compile failure path for type '" + typeSourceName + "'");
        if (CompilationProblemReporter.logErrorChain(branch, logLevel, typeSourceName, compilerContext.getCompilationErrorsIndex())) {
            return;
        }
        if (hint) {
            CompilationProblemReporter.logHints(logger, typeSourceName);
        }
    }

    public static int logWarnings(TreeLogger logger, TreeLogger.Type logLevelForWarnings, List<CompilationUnit> units) {
        int warningCount = 0;
        for (CompilationUnit unit : units) {
            if (!CompilationProblemReporter.logWarnings(logger, logLevelForWarnings, unit)) continue;
            ++warningCount;
        }
        return warningCount++;
    }

    public static boolean reportErrors(TreeLogger logger, CompilationUnit unit, boolean suppressErrors) {
        TreeLogger.Type warnLogLevel;
        TreeLogger.Type errorLogLevel;
        CategorizedProblem[] problems = unit.getProblems();
        if (problems == null || problems.length == 0) {
            return false;
        }
        String fileName = unit.getResourceLocation();
        boolean isError = unit.isError();
        if (suppressErrors) {
            errorLogLevel = TreeLogger.TRACE;
            warnLogLevel = TreeLogger.DEBUG;
        } else {
            errorLogLevel = TreeLogger.ERROR;
            warnLogLevel = TreeLogger.WARN;
        }
        TreeLogger branch = null;
        for (CategorizedProblem problem : problems) {
            TreeLogger.Type logLevel;
            if (problem.isError()) {
                logLevel = errorLogLevel;
            } else {
                if (!problem.isWarning() || !(problem instanceof GWTProblem)) continue;
                logLevel = warnLogLevel;
            }
            TreeLogger.HelpInfo helpInfo = null;
            if (problem instanceof GWTProblem) {
                GWTProblem gwtProblem = (GWTProblem)problem;
                helpInfo = gwtProblem.getHelpInfo();
            }
            if (branch == null) {
                TreeLogger.Type branchType = isError ? errorLogLevel : warnLogLevel;
                String branchString = isError ? "Errors" : "Warnings";
                branch = logger.branch(branchType, branchString + " in '" + fileName + "'", null);
            }
            branch.log(logLevel, CompilationProblemReporter.toMessageWithLineNumber(problem), null, helpInfo);
        }
        if (branch != null && branch.isLoggable(TreeLogger.INFO) && unit instanceof CompilationUnitBuilder.GeneratedCompilationUnit) {
            CompilationUnitBuilder.GeneratedCompilationUnit generatedUnit = (CompilationUnitBuilder.GeneratedCompilationUnit)unit;
            CompilationProblemReporter.maybeDumpSource(branch, generatedUnit.getSource(), unit.getTypeName());
        }
        return branch != null;
    }

    private static void addUnitToVisit(CompilationErrorsIndex compilationErrorsIndex, String typeSourceName, Queue<String> toVisit, Set<String> visited) {
        if (compilationErrorsIndex.hasCompileErrors(typeSourceName) && !visited.contains(typeSourceName)) {
            toVisit.add(typeSourceName);
            visited.add(typeSourceName);
        }
    }

    private static List<String> formatErrors(CompilationUnit unit) {
        CategorizedProblem[] problems = unit.getProblems();
        assert (problems != null && problems.length > 0);
        ArrayList<String> errorMessages = Lists.newArrayList();
        for (CategorizedProblem problem : problems) {
            if (!problem.isError()) continue;
            errorMessages.add(CompilationProblemReporter.toMessageWithLineNumber(problem));
        }
        return errorMessages;
    }

    private static boolean hasWarnings(CompilationUnit unit) {
        CategorizedProblem[] problems = unit.getProblems();
        if (problems == null || problems.length == 0) {
            return false;
        }
        for (CategorizedProblem problem : problems) {
            if (!problem.isWarning() || !(problem instanceof GWTProblem)) continue;
            return true;
        }
        return false;
    }

    private static boolean logErrorChain(TreeLogger logger, TreeLogger.Type logLevel, String typeSourceName, CompilationErrorsIndex compilationErrorsIndex) {
        HashSet<String> visited = new HashSet<String>();
        LinkedList<String> toVisit = new LinkedList<String>();
        CompilationProblemReporter.addUnitToVisit(compilationErrorsIndex, typeSourceName, toVisit, visited);
        while (!toVisit.isEmpty()) {
            String dependentTypeSourceName = (String)toVisit.remove();
            Set<String> compileErrors = compilationErrorsIndex.getCompileErrors(dependentTypeSourceName);
            TreeLogger branch = logger.branch(logLevel, "Errors in '" + compilationErrorsIndex.getFileName(dependentTypeSourceName) + "'");
            for (String compileError : compileErrors) {
                branch.log(logLevel, compileError);
            }
            Set<String> typeReferences = compilationErrorsIndex.getTypeReferences(dependentTypeSourceName);
            if (typeReferences == null) continue;
            for (String typeReference : typeReferences) {
                CompilationProblemReporter.addUnitToVisit(compilationErrorsIndex, typeReference, toVisit, visited);
            }
        }
        logger.log(TreeLogger.DEBUG, "Checked " + visited.size() + " dependencies for errors.");
        return visited.size() > 1;
    }

    private static void logHints(TreeLogger logger, String typeSourceName) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        URL sourceURL = Util.findSourceInClassPath(cl, typeSourceName);
        if (sourceURL != null) {
            if (typeSourceName.indexOf(".client.") != -1) {
                Messages.HINT_CHECK_MODULE_INHERITANCE.log(logger, null);
            } else {
                Messages.HINT_CHECK_MODULE_NONCLIENT_SOURCE_DECL.log(logger, null);
            }
        } else if (!typeSourceName.equals("java.lang.Object")) {
            Messages.HINT_CHECK_TYPENAME.log(logger, typeSourceName, null);
            Messages.HINT_CHECK_CLASSPATH_SOURCE_ENTRIES.log(logger, null);
        }
        if (typeSourceName.indexOf("java.lang.") == 0 || typeSourceName.indexOf("com.google.gwt.core.") == 0) {
            Messages.HINT_CHECK_INHERIT_CORE.log(logger, null);
        } else if (typeSourceName.indexOf("com.google.gwt.user.") == 0) {
            Messages.HINT_CHECK_INHERIT_USER.log(logger, null);
        }
    }

    private static boolean logWarnings(TreeLogger logger, TreeLogger.Type logLevel, CompilationUnit unit) {
        if (!CompilationProblemReporter.hasWarnings(unit)) {
            return false;
        }
        TreeLogger branch = logger.branch(logLevel, "Warnings in '" + unit.getResourceLocation() + "'", null);
        for (CategorizedProblem problem : unit.getProblems()) {
            if (!problem.isWarning() || !(problem instanceof GWTProblem)) continue;
            branch.log(logLevel, CompilationProblemReporter.toMessageWithLineNumber(problem), null, ((GWTProblem)problem).getHelpInfo());
        }
        if (branch.isLoggable(TreeLogger.INFO) && unit instanceof CompilationUnitBuilder.GeneratedCompilationUnit) {
            CompilationProblemReporter.maybeDumpSource(branch, ((CompilationUnitBuilder.GeneratedCompilationUnit)unit).getSource(), unit.getTypeName());
        }
        return true;
    }

    private static void maybeDumpSource(TreeLogger logger, String source, String typeName) {
        IOException caught = null;
        try {
            while (typeName.length() < 3) {
                typeName = "_" + typeName;
            }
            File tmpSrc = File.createTempFile(typeName, ".java");
            Util.writeStringAsFile(tmpSrc, source);
            String dumpPath = tmpSrc.getAbsolutePath();
            if (logger.isLoggable(TreeLogger.INFO)) {
                logger.log(TreeLogger.INFO, "See snapshot: " + dumpPath, null);
            }
            return;
        }
        catch (IOException e) {
            caught = e;
            logger.log(TreeLogger.INFO, "Unable to dump source to disk", caught);
            return;
        }
    }

    private static String toMessageWithLineNumber(CategorizedProblem problem) {
        int lineNumber = problem.getSourceLineNumber();
        return (lineNumber > 0 ? "Line " + lineNumber + ": " : "") + problem.getMessage();
    }
}

