/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.javac;

import com.google.gwt.dev.javac.CompilationErrorsIndex;
import com.google.gwt.thirdparty.guava.common.base.Objects;
import com.google.gwt.thirdparty.guava.common.collect.HashMultimap;
import com.google.gwt.thirdparty.guava.common.collect.Maps;
import com.google.gwt.thirdparty.guava.common.collect.SetMultimap;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CompilationErrorsIndexImpl
implements CompilationErrorsIndex,
Serializable {
    private SetMultimap<String, String> compilationErrorsByTypeSourceName = HashMultimap.create();
    private Map<String, String> fileNamesByTypeSourceName = Maps.newHashMap();
    private SetMultimap<String, String> referencesByTypeSourceName = HashMultimap.create();

    private static SetMultimap<String, String> readStringListMap(ObjectInputStream objectInputStream) throws IOException {
        HashMultimap<String, String> stringListMap = HashMultimap.create();
        int keyCount = objectInputStream.readInt();
        for (int i = 0; i < keyCount; ++i) {
            String key = objectInputStream.readUTF();
            int listLength = objectInputStream.readInt();
            for (int j = 0; j < listLength; ++j) {
                stringListMap.put((Object)key, (Object)objectInputStream.readUTF());
            }
        }
        return stringListMap;
    }

    private static Map<String, String> readStringMap(ObjectInputStream objectInputStream) throws IOException {
        HashMap<String, String> stringMap = Maps.newHashMap();
        int fileNameMappingCount = objectInputStream.readInt();
        for (int i = 0; i < fileNameMappingCount; ++i) {
            String typeSourceName = objectInputStream.readUTF();
            String fileName = objectInputStream.readUTF();
            stringMap.put(typeSourceName, fileName);
        }
        return stringMap;
    }

    private static void writeStringListMap(ObjectOutputStream objectOutputStream, Map<String, Collection<String>> stringMap) throws IOException {
        objectOutputStream.writeInt(stringMap.size());
        for (Map.Entry<String, Collection<String>> entry : stringMap.entrySet()) {
            objectOutputStream.writeUTF(entry.getKey());
            Collection<String> strings = entry.getValue();
            objectOutputStream.writeInt(strings.size());
            for (String string : strings) {
                objectOutputStream.writeUTF(string);
            }
        }
    }

    private static void writeStringMap(ObjectOutputStream objectOutputStream, Map<String, String> stringMap) throws IOException {
        objectOutputStream.writeInt(stringMap.size());
        for (Map.Entry<String, String> entry : stringMap.entrySet()) {
            objectOutputStream.writeUTF(entry.getKey());
            objectOutputStream.writeUTF(entry.getValue());
        }
    }

    @Override
    public void add(String typeSourceName, String fileName, List<String> typeReferences, List<String> compilationErrors) {
        this.fileNamesByTypeSourceName.put(typeSourceName, fileName);
        this.compilationErrorsByTypeSourceName.putAll(typeSourceName, compilationErrors);
        this.referencesByTypeSourceName.putAll(typeSourceName, typeReferences);
    }

    public boolean equals(Object object) {
        if (object instanceof CompilationErrorsIndexImpl) {
            CompilationErrorsIndexImpl that = (CompilationErrorsIndexImpl)object;
            return Objects.equal(this.fileNamesByTypeSourceName, that.fileNamesByTypeSourceName) && Objects.equal(this.compilationErrorsByTypeSourceName, that.compilationErrorsByTypeSourceName) && Objects.equal(this.referencesByTypeSourceName, that.referencesByTypeSourceName);
        }
        return false;
    }

    @Override
    public Set<String> getCompileErrors(String typeSourceName) {
        return this.compilationErrorsByTypeSourceName.get((Object)typeSourceName);
    }

    @Override
    public String getFileName(String typeSourceName) {
        return this.fileNamesByTypeSourceName.get(typeSourceName);
    }

    @Override
    public Set<String> getTypeReferences(String typeSourceName) {
        return this.referencesByTypeSourceName.get((Object)typeSourceName);
    }

    @Override
    public boolean hasCompileErrors(String typeSourceName) {
        return this.compilationErrorsByTypeSourceName.containsKey(typeSourceName);
    }

    public int hashCode() {
        return Objects.hashCode(this.fileNamesByTypeSourceName, this.compilationErrorsByTypeSourceName, this.referencesByTypeSourceName);
    }

    @Override
    public boolean hasTypeReferences(String typeSourceName) {
        return this.referencesByTypeSourceName.containsKey(typeSourceName);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        this.fileNamesByTypeSourceName = CompilationErrorsIndexImpl.readStringMap(objectInputStream);
        this.compilationErrorsByTypeSourceName = CompilationErrorsIndexImpl.readStringListMap(objectInputStream);
        this.referencesByTypeSourceName = CompilationErrorsIndexImpl.readStringListMap(objectInputStream);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        CompilationErrorsIndexImpl.writeStringMap(objectOutputStream, this.fileNamesByTypeSourceName);
        CompilationErrorsIndexImpl.writeStringListMap(objectOutputStream, this.compilationErrorsByTypeSourceName.asMap());
        CompilationErrorsIndexImpl.writeStringListMap(objectOutputStream, this.referencesByTypeSourceName.asMap());
    }
}

