/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.javac;

import com.google.gwt.dev.javac.CompilationUnit;
import com.google.gwt.dev.javac.CompiledClass;
import com.google.gwt.dev.javac.ContentId;
import com.google.gwt.dev.javac.Dependencies;
import com.google.gwt.dev.javac.JsniMethod;
import com.google.gwt.dev.javac.MethodArgNamesLookup;
import com.google.gwt.dev.javac.SerializableCategorizedProblem;
import com.google.gwt.dev.jjs.impl.GwtAstBuilder;
import com.google.gwt.dev.util.DiskCacheToken;
import com.google.gwt.dev.util.Util;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jdt.core.compiler.CategorizedProblem;

public class CachedCompilationUnit
extends CompilationUnit {
    private static final boolean normalizeTimestamps = Boolean.parseBoolean(System.getProperty("gwt.normalizeTimestamps", "false"));
    private final DiskCacheToken astToken;
    private final long astVersion;
    private transient Collection<CompiledClass> compiledClasses;
    private final ContentId contentId;
    private final Dependencies dependencies;
    private final boolean isError;
    private final boolean isGenerated;
    private final boolean isSuperSource;
    private final boolean hasJsInteropRootType;
    private transient List<JsniMethod> jsniMethods;
    private final long lastModified;
    private final MethodArgNamesLookup methodArgNamesLookup;
    private final CategorizedProblem[] problems;
    private final String resourceLocation;
    private final String resourcePath;
    private final String typeName;

    public CachedCompilationUnit(CachedCompilationUnit unit, long lastModified, String resourceLocation) {
        assert (unit != null);
        this.compiledClasses = CompiledClass.copyForUnit(unit.getCompiledClasses(), this);
        this.hasJsInteropRootType = unit.hasJsInteropRootType;
        this.contentId = unit.getContentId();
        this.dependencies = unit.getDependencies();
        this.resourcePath = unit.getResourcePath();
        this.resourceLocation = Util.stripJarPathPrefix(resourceLocation);
        this.jsniMethods = unit.getJsniMethods();
        this.methodArgNamesLookup = unit.getMethodArgs();
        this.typeName = unit.getTypeName();
        this.isError = unit.isError();
        this.isGenerated = unit.isGenerated();
        this.isSuperSource = unit.isSuperSource();
        this.problems = unit.problems;
        this.astToken = unit.astToken;
        this.astVersion = unit.astVersion;
        this.lastModified = normalizeTimestamps ? 0L : lastModified;
    }

    CachedCompilationUnit(CompilationUnit unit, long astToken) {
        assert (unit != null);
        this.compiledClasses = CompiledClass.copyForUnit(unit.getCompiledClasses(), this);
        this.hasJsInteropRootType = unit.hasJsInteropRootType();
        this.contentId = unit.getContentId();
        this.dependencies = unit.getDependencies();
        this.resourcePath = unit.getResourcePath();
        this.resourceLocation = Util.stripJarPathPrefix(unit.getResourceLocation());
        this.jsniMethods = unit.getJsniMethods();
        this.lastModified = normalizeTimestamps ? 0L : unit.getLastModified();
        this.methodArgNamesLookup = unit.getMethodArgs();
        this.typeName = unit.getTypeName();
        this.isError = unit.isError();
        this.isGenerated = unit.isGenerated();
        this.isSuperSource = unit.isSuperSource();
        CategorizedProblem[] problemsIn = unit.getProblems();
        if (problemsIn == null) {
            this.problems = null;
        } else {
            this.problems = new CategorizedProblem[problemsIn.length];
            for (int i = 0; i < problemsIn.length; ++i) {
                this.problems[i] = new SerializableCategorizedProblem(problemsIn[i]);
            }
        }
        this.astToken = new DiskCacheToken(astToken);
        this.astVersion = GwtAstBuilder.getSerializationVersion();
    }

    @Override
    public CachedCompilationUnit asCachedCompilationUnit() {
        return this;
    }

    @Override
    public Collection<CompiledClass> getCompiledClasses() {
        return this.compiledClasses;
    }

    @Override
    public List<JsniMethod> getJsniMethods() {
        return this.jsniMethods;
    }

    @Override
    public long getLastModified() {
        return this.lastModified;
    }

    @Override
    public MethodArgNamesLookup getMethodArgs() {
        return this.methodArgNamesLookup;
    }

    @Override
    public String getResourceLocation() {
        return this.resourceLocation;
    }

    @Override
    public String getResourcePath() {
        return this.resourcePath;
    }

    @Override
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    public byte[] getTypesSerialized() {
        return this.astToken.readByteArray();
    }

    @Override
    public boolean isError() {
        return this.isError;
    }

    @Override
    @Deprecated
    public boolean isGenerated() {
        return this.isGenerated;
    }

    @Override
    @Deprecated
    public boolean isSuperSource() {
        return this.isSuperSource;
    }

    @Override
    boolean hasJsInteropRootType() {
        return this.hasJsInteropRootType;
    }

    @Override
    ContentId getContentId() {
        return this.contentId;
    }

    @Override
    Dependencies getDependencies() {
        return this.dependencies;
    }

    @Override
    CategorizedProblem[] getProblems() {
        return this.problems;
    }

    long getTypesSerializedVersion() {
        return this.astVersion;
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.compiledClasses = (Collection)ois.readObject();
        this.jsniMethods = (List)ois.readObject();
    }

    private <T> Collection<T> sort(Collection<T> collection, Comparator<T> comparator) {
        if (collection == null) {
            return null;
        }
        ArrayList<T> copy = new ArrayList<T>(collection);
        Collections.sort(copy, comparator);
        return copy;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        oos.writeObject(this.sort(this.compiledClasses, new Comparator<CompiledClass>(){

            @Override
            public int compare(CompiledClass o1, CompiledClass o2) {
                return o1.getSourceName().compareTo(o2.getSourceName());
            }
        }));
        oos.writeObject(this.sort(this.jsniMethods, new Comparator<JsniMethod>(){

            @Override
            public int compare(JsniMethod o1, JsniMethod o2) {
                return o1.name().compareTo(o2.name());
            }
        }));
    }
}

