/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.javac;

import com.google.gwt.dev.util.Util;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;

public class BytecodeSignatureMaker {
    public static String getCompileDependencySignature(byte[] byteCode) {
        CompileDependencyVisitor v = BytecodeSignatureMaker.visitCompileDependenciesInBytecode(byteCode);
        return v.getSignature();
    }

    static String getCompileDependencyRawSignature(byte[] byteCode) {
        CompileDependencyVisitor v = BytecodeSignatureMaker.visitCompileDependenciesInBytecode(byteCode);
        return v.getRawString();
    }

    private static CompileDependencyVisitor visitCompileDependenciesInBytecode(byte[] byteCode) {
        ClassReader reader = new ClassReader(byteCode);
        CompileDependencyVisitor v = new CompileDependencyVisitor();
        reader.accept(v, 7);
        return v;
    }

    private BytecodeSignatureMaker() {
    }

    private static class CompileDependencyVisitor
    extends ClassVisitor {
        private static final int ACCESS_FILTER_MASK = -133601;
        private String header;
        private Map<String, String> fields = new HashMap<String, String>();
        private Map<String, String> methods = new HashMap<String, String>();

        public CompileDependencyVisitor() {
            super(589824);
        }

        public String getSignature() {
            return Util.computeStrongName(Util.getBytes(this.getRawString()));
        }

        @Override
        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            StringBuilder headerBuilder = new StringBuilder();
            headerBuilder.append(access & 0xFFFDF61F);
            headerBuilder.append(":");
            headerBuilder.append(name);
            if (signature != null) {
                headerBuilder.append(":");
                headerBuilder.append(signature);
            }
            if (superName != null) {
                headerBuilder.append(":");
                headerBuilder.append(superName);
            }
            if (interfaces != null) {
                Arrays.sort(interfaces);
                for (String iface : interfaces) {
                    headerBuilder.append(":");
                    headerBuilder.append(iface);
                }
            }
            this.header = headerBuilder.toString();
        }

        @Override
        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return null;
        }

        @Override
        public void visitAttribute(Attribute attr) {
        }

        @Override
        public void visitEnd() {
        }

        @Override
        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            StringBuilder fieldBuilder = new StringBuilder();
            if ((access & 0x1000) == 0) {
                fieldBuilder.append(access & 0xFFFDF61F);
                fieldBuilder.append(":");
                fieldBuilder.append(name);
                fieldBuilder.append(":");
                fieldBuilder.append(desc);
                if (signature != null) {
                    fieldBuilder.append(":");
                    fieldBuilder.append(signature);
                }
                if (value != null) {
                    fieldBuilder.append(":");
                    fieldBuilder.append(value.toString());
                }
                this.fields.put(name, fieldBuilder.toString());
            }
            return null;
        }

        @Override
        public void visitInnerClass(String name, String outerName, String innerName, int access) {
        }

        @Override
        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if ((access & 0x1000) == 0) {
                StringBuilder methodBuilder = new StringBuilder();
                methodBuilder.append(access & 0xFFFDF61F);
                methodBuilder.append(":");
                methodBuilder.append(name);
                methodBuilder.append(":");
                methodBuilder.append(desc);
                if (signature != null) {
                    methodBuilder.append(":");
                    methodBuilder.append(signature);
                }
                if (exceptions != null) {
                    Object[] sortedExceptions = exceptions;
                    Arrays.sort(sortedExceptions);
                    for (Object exception : sortedExceptions) {
                        methodBuilder.append(":");
                        methodBuilder.append((String)exception);
                    }
                }
                this.methods.put(name, methodBuilder.toString());
            }
            return null;
        }

        @Override
        public void visitOuterClass(String owner, String name, String desc) {
        }

        @Override
        public void visitSource(String source, String debug) {
        }

        private String getRawString() {
            StringBuilder signatureBuilder = new StringBuilder();
            signatureBuilder.append(this.header);
            signatureBuilder.append("|");
            Object[] sortedFields = this.fields.values().toArray(new String[0]);
            Arrays.sort(sortedFields);
            for (Object field : sortedFields) {
                signatureBuilder.append((String)field);
                signatureBuilder.append("|");
            }
            Object[] sortedMethods = this.methods.values().toArray(new String[0]);
            Arrays.sort(sortedMethods);
            for (Object method : sortedMethods) {
                signatureBuilder.append((String)method);
                signatureBuilder.append("|");
            }
            return signatureBuilder.toString();
        }
    }
}

