/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.javac;

import com.google.gwt.dev.javac.GWTProblem;
import com.google.gwt.dev.jdt.TypeRefVisitor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.MarkerAnnotation;
import org.eclipse.jdt.internal.compiler.ast.NormalAnnotation;
import org.eclipse.jdt.internal.compiler.ast.SingleMemberAnnotation;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;

public class BinaryTypeReferenceRestrictionsChecker {
    public static void check(CompilationUnitDeclaration cud) {
        List<BinaryTypeReferenceSite> binaryTypeReferenceSites = BinaryTypeReferenceRestrictionsChecker.findAllBinaryTypeReferenceSites(cud);
        HashSet<BinaryTypeBinding> alreadySeenTypeBindings = new HashSet<BinaryTypeBinding>();
        for (BinaryTypeReferenceSite binaryTypeReferenceSite : binaryTypeReferenceSites) {
            BinaryTypeBinding binaryTypeBinding = binaryTypeReferenceSite.getBinaryTypeBinding();
            if (alreadySeenTypeBindings.contains(binaryTypeBinding)) continue;
            alreadySeenTypeBindings.add(binaryTypeBinding);
            String fileName = String.valueOf(binaryTypeBinding.getFileName());
            if (fileName.endsWith(".java")) continue;
            String qualifiedTypeName = binaryTypeBinding.debugName();
            String error = BinaryTypeReferenceRestrictionsChecker.formatBinaryTypeRefErrorMessage(qualifiedTypeName);
            GWTProblem.recordError(binaryTypeReferenceSite.getExpression(), cud, error, null);
        }
    }

    static List<BinaryTypeReferenceSite> findAllBinaryTypeReferenceSites(CompilationUnitDeclaration cud) {
        ArrayList<BinaryTypeReferenceSite> binaryTypeReferenceSites = new ArrayList<BinaryTypeReferenceSite>();
        BinaryTypeReferenceVisitor binaryTypeReferenceVisitor = new BinaryTypeReferenceVisitor(cud, binaryTypeReferenceSites);
        cud.traverse((ASTVisitor)binaryTypeReferenceVisitor, cud.scope);
        return binaryTypeReferenceSites;
    }

    static String formatBinaryTypeRefErrorMessage(String qualifiedTypeName) {
        return "No source code is available for type " + qualifiedTypeName + "; did you forget to inherit a required module?";
    }

    private BinaryTypeReferenceRestrictionsChecker() {
    }

    static class BinaryTypeReferenceVisitor
    extends TypeRefVisitor {
        private final List<BinaryTypeReferenceSite> binaryTypeReferenceSites;

        public BinaryTypeReferenceVisitor(CompilationUnitDeclaration cud, List<BinaryTypeReferenceSite> binaryTypeReferenceSites) {
            super(cud);
            this.binaryTypeReferenceSites = binaryTypeReferenceSites;
        }

        @Override
        public boolean visit(MarkerAnnotation annotation, BlockScope scope) {
            return false;
        }

        @Override
        public boolean visit(MarkerAnnotation annotation, ClassScope scope) {
            return false;
        }

        @Override
        public boolean visit(NormalAnnotation annotation, BlockScope scope) {
            return false;
        }

        @Override
        public boolean visit(NormalAnnotation annotation, ClassScope scope) {
            return false;
        }

        @Override
        public boolean visit(SingleMemberAnnotation annotation, BlockScope scope) {
            return false;
        }

        @Override
        public boolean visit(SingleMemberAnnotation annotation, ClassScope scope) {
            return false;
        }

        @Override
        protected void onBinaryTypeRef(BinaryTypeBinding binding, CompilationUnitDeclaration unitOfReferrer, Expression expression) {
            if (expression.constant != null && expression.constant != Constant.NotAConstant) {
                return;
            }
            this.binaryTypeReferenceSites.add(new BinaryTypeReferenceSite(expression, binding));
        }

        @Override
        protected void onTypeRef(SourceTypeBinding referencedType, CompilationUnitDeclaration unitOfReferrer) {
        }
    }

    static class BinaryTypeReferenceSite {
        private final BinaryTypeBinding binaryTypeBinding;
        private final Expression expression;

        BinaryTypeReferenceSite(Expression expression, BinaryTypeBinding binaryTypeBinding) {
            this.expression = expression;
            this.binaryTypeBinding = binaryTypeBinding;
        }

        public BinaryTypeBinding getBinaryTypeBinding() {
            return this.binaryTypeBinding;
        }

        public Expression getExpression() {
            return this.expression;
        }
    }
}

