/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.javac;

import com.google.gwt.dev.util.collect.Maps;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Map;

class AnnotationProxyFactory {
    AnnotationProxyFactory() {
    }

    public static Annotation create(Class<? extends Annotation> annotationClass, Map<String, Object> identifierToValue) {
        AnnotationProxyInvocationHandler annotationInvocationHandler = new AnnotationProxyInvocationHandler(identifierToValue, annotationClass);
        Annotation proxy = (Annotation)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{Annotation.class, annotationClass}, (InvocationHandler)annotationInvocationHandler);
        annotationInvocationHandler.setProxy(proxy);
        return proxy;
    }

    private static class AnnotationProxyInvocationHandler
    implements InvocationHandler {
        private Class<? extends Annotation> annotationClass;
        private final Map<String, Object> identifierToValue;
        private Annotation proxy;

        private static boolean isValidReturnType(Class<?> expectedReturnType, Class<? extends Object> actualReturnType) {
            if (expectedReturnType.isAssignableFrom(actualReturnType)) {
                return true;
            }
            if (expectedReturnType.isPrimitive()) {
                if (expectedReturnType == Boolean.TYPE) {
                    return actualReturnType == Boolean.class;
                }
                if (expectedReturnType == Byte.TYPE) {
                    return actualReturnType == Byte.class;
                }
                if (expectedReturnType == Character.TYPE) {
                    return actualReturnType == Character.class;
                }
                if (expectedReturnType == Double.TYPE) {
                    return actualReturnType == Double.class;
                }
                if (expectedReturnType == Float.TYPE) {
                    return actualReturnType == Float.class;
                }
                if (expectedReturnType == Integer.TYPE) {
                    return actualReturnType == Integer.class;
                }
                if (expectedReturnType == Long.TYPE) {
                    return actualReturnType == Long.class;
                }
                if (expectedReturnType == Short.TYPE) {
                    return actualReturnType == Short.class;
                }
            }
            return false;
        }

        public AnnotationProxyInvocationHandler(Map<String, Object> identifierToValue, Class<? extends Annotation> annotationClass) {
            this.identifierToValue = Maps.normalizeUnmodifiable(identifierToValue);
            this.annotationClass = annotationClass;
        }

        public boolean equals(Object other) {
            if (this.proxy == other) {
                return true;
            }
            if (!(other instanceof Annotation)) {
                return false;
            }
            Annotation otherAnnotation = (Annotation)other;
            if (this.annotationClass != otherAnnotation.annotationType()) {
                return false;
            }
            try {
                for (Method method : this.annotationClass.getDeclaredMethods()) {
                    Object myVal = method.invoke((Object)this.proxy, new Object[0]);
                    Object otherVal = method.invoke(other, new Object[0]);
                    if (!(myVal instanceof Object[] ? !Arrays.equals((Object[])myVal, (Object[])otherVal) : (myVal instanceof boolean[] ? !Arrays.equals((boolean[])myVal, (boolean[])otherVal) : (myVal instanceof byte[] ? !Arrays.equals((byte[])myVal, (byte[])otherVal) : (myVal instanceof char[] ? !Arrays.equals((char[])myVal, (char[])otherVal) : (myVal instanceof short[] ? !Arrays.equals((short[])myVal, (short[])otherVal) : (myVal instanceof int[] ? !Arrays.equals((int[])myVal, (int[])otherVal) : (myVal instanceof long[] ? !Arrays.equals((long[])myVal, (long[])otherVal) : (myVal instanceof float[] ? !Arrays.equals((float[])myVal, (float[])otherVal) : (myVal instanceof double[] ? !Arrays.equals((double[])myVal, (double[])otherVal) : !myVal.equals(otherVal))))))))))) continue;
                    return false;
                }
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e.getTargetException());
            }
            return true;
        }

        public int hashCode() {
            int sum = 0;
            try {
                for (Method method : this.annotationClass.getDeclaredMethods()) {
                    Object myVal = method.invoke((Object)this.proxy, new Object[0]);
                    int memberHash = myVal instanceof Object[] ? Arrays.hashCode((Object[])myVal) : (myVal instanceof boolean[] ? Arrays.hashCode((boolean[])myVal) : (myVal instanceof byte[] ? Arrays.hashCode((byte[])myVal) : (myVal instanceof char[] ? Arrays.hashCode((char[])myVal) : (myVal instanceof short[] ? Arrays.hashCode((short[])myVal) : (myVal instanceof int[] ? Arrays.hashCode((int[])myVal) : (myVal instanceof long[] ? Arrays.hashCode((long[])myVal) : (myVal instanceof float[] ? Arrays.hashCode((float[])myVal) : (myVal instanceof double[] ? Arrays.hashCode((double[])myVal) : myVal.hashCode()))))))));
                    sum += (memberHash ^= 127 * method.getName().hashCode());
                }
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e.getTargetException());
            }
            return sum;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object value = null;
            if (args == null || args.length == 0) {
                String name = method.getName();
                if (this.identifierToValue.containsKey(name)) {
                    value = this.identifierToValue.get(name);
                    assert (value != null);
                } else {
                    value = "annotationType".equals(method.getName()) ? this.annotationClass : method.getDefaultValue();
                }
                if (value != null) {
                    assert (AnnotationProxyInvocationHandler.isValidReturnType(method.getReturnType(), value.getClass()));
                    return value;
                }
            }
            return method.invoke((Object)this, args);
        }

        public void setProxy(Annotation proxy) {
            this.proxy = proxy;
        }

        public String toString() {
            StringBuilder msg = new StringBuilder();
            String qualifiedSourceName = this.annotationClass.getName().replace('$', '.');
            msg.append('@').append(qualifiedSourceName).append('(');
            boolean first = true;
            try {
                for (Method method : this.annotationClass.getDeclaredMethods()) {
                    if (first) {
                        first = false;
                    } else {
                        msg.append(", ");
                    }
                    msg.append(method.getName()).append('=');
                    Object myVal = method.invoke((Object)this.proxy, new Object[0]);
                    if (myVal instanceof Object[]) {
                        msg.append(Arrays.deepToString((Object[])myVal));
                        continue;
                    }
                    if (myVal instanceof boolean[]) {
                        msg.append(Arrays.toString((boolean[])myVal));
                        continue;
                    }
                    if (myVal instanceof byte[]) {
                        msg.append(Arrays.toString((byte[])myVal));
                        continue;
                    }
                    if (myVal instanceof char[]) {
                        msg.append(Arrays.toString((char[])myVal));
                        continue;
                    }
                    if (myVal instanceof short[]) {
                        msg.append(Arrays.toString((short[])myVal));
                        continue;
                    }
                    if (myVal instanceof int[]) {
                        msg.append(Arrays.toString((int[])myVal));
                        continue;
                    }
                    if (myVal instanceof long[]) {
                        msg.append(Arrays.toString((long[])myVal));
                        continue;
                    }
                    if (myVal instanceof float[]) {
                        msg.append(Arrays.toString((float[])myVal));
                        continue;
                    }
                    if (myVal instanceof double[]) {
                        msg.append(Arrays.toString((double[])myVal));
                        continue;
                    }
                    msg.append(myVal);
                }
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e.getTargetException());
            }
            msg.append(')');
            return msg.toString();
        }
    }
}

