/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.cfg;

import com.google.gwt.dev.cfg.ResourceLoader;
import com.google.gwt.thirdparty.guava.common.base.Splitter;
import com.google.gwt.thirdparty.guava.common.base.StandardSystemProperty;
import com.google.gwt.thirdparty.guava.common.collect.Sets;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;

public class ResourceLoaders {
    public static ResourceLoader fromContextClassLoader() {
        return new ContextClassLoaderAdapter();
    }

    public static ResourceLoader forPathAndFallback(List<File> path, ResourceLoader fallback) {
        return new PrefixLoader(path, fallback);
    }

    private ResourceLoaders() {
    }

    private static class PrefixLoader
    implements ResourceLoader {
        private final List<File> path;
        private final List<URL> pathAsUrls = new ArrayList<URL>();
        private final ResourceLoader fallback;

        public PrefixLoader(List<File> path, ResourceLoader fallback) {
            assert (path != null);
            this.path = path;
            this.fallback = fallback;
            for (File file : path) {
                try {
                    this.pathAsUrls.add(file.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException("can't create URL for file: " + file);
                }
            }
        }

        public boolean equals(Object other) {
            if (!(other instanceof PrefixLoader)) {
                return false;
            }
            PrefixLoader otherLoader = (PrefixLoader)other;
            return this.path.equals(otherLoader.path) && this.fallback.equals(otherLoader.fallback);
        }

        @Override
        public List<URL> getClassPath() {
            ArrayList<URL> result = new ArrayList<URL>();
            result.addAll(this.pathAsUrls);
            result.addAll(this.fallback.getClassPath());
            return result;
        }

        @Override
        public URL getResource(String resourceName) {
            for (File prefix : this.path) {
                File candidate = new File(prefix, resourceName);
                if (!candidate.exists()) continue;
                try {
                    return candidate.toURI().toURL();
                }
                catch (MalformedURLException e) {
                    return null;
                }
            }
            return this.fallback.getResource(resourceName);
        }

        public int hashCode() {
            return this.path.hashCode() ^ this.fallback.hashCode();
        }
    }

    private static class ContextClassLoaderAdapter
    implements ResourceLoader {
        private final ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();

        public boolean equals(Object other) {
            if (!(other instanceof ContextClassLoaderAdapter)) {
                return false;
            }
            ContextClassLoaderAdapter otherAdapter = (ContextClassLoaderAdapter)other;
            return this.contextClassLoader.equals(otherAdapter.contextClassLoader);
        }

        @Override
        public List<URL> getClassPath() {
            ArrayList<URL> result = new ArrayList<URL>();
            LinkedHashSet<String> uniqueClassPathEntries = Sets.newLinkedHashSet(Splitter.on(File.pathSeparatorChar).split(StandardSystemProperty.JAVA_CLASS_PATH.value()));
            for (String entry : uniqueClassPathEntries) {
                try {
                    result.add(Paths.get(entry, new String[0]).toUri().toURL());
                }
                catch (MalformedURLException malformedURLException) {}
            }
            return result;
        }

        @Override
        public URL getResource(String resourceName) {
            return this.contextClassLoader.getResource(resourceName);
        }

        public int hashCode() {
            return this.contextClassLoader.hashCode();
        }
    }
}

