/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.cfg;

import com.google.gwt.core.ext.PropertyOracle;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.dev.cfg.BindingProperties;
import com.google.gwt.dev.cfg.BindingProperty;
import com.google.gwt.dev.cfg.Condition;
import com.google.gwt.dev.cfg.ConfigurationProperties;
import com.google.gwt.dev.cfg.ConfigurationProperty;
import com.google.gwt.dev.cfg.DeferredBindingQuery;
import com.google.gwt.dev.cfg.Properties;
import com.google.gwt.dev.util.CollapsedPropertyKey;
import com.google.gwt.thirdparty.guava.common.base.Objects;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import com.google.gwt.thirdparty.guava.common.collect.Maps;
import com.google.gwt.thirdparty.guava.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;

public class PropertyCombinations
implements Iterable<String[]> {
    private final Properties properties;
    private final List<String[]> values;

    private static List<String[]> allPermutationsOf(Properties properties, Set<String> activeLinkerNames) {
        BindingProperty[] bindingProperties = PropertyCombinations.getOrderedPropertiesOf(properties);
        ArrayList<String[]> permutations = new ArrayList<String[]>();
        if (bindingProperties.length > 0) {
            PropertyCombinations.permute(bindingProperties, activeLinkerNames, null, 0, permutations);
        } else {
            permutations.add(new String[0]);
        }
        return permutations;
    }

    private static BindingProperty[] getOrderedPropertiesOf(Properties properties) {
        LinkedHashSet<BindingProperty> bindingProperties = Sets.newLinkedHashSet(properties.getBindingProperties());
        LinkedHashMap<String, BindingProperty> evaluationOrder = Maps.newLinkedHashMap();
        while (!bindingProperties.isEmpty()) {
            boolean changed = false;
            Iterator it = bindingProperties.iterator();
            while (it.hasNext()) {
                BindingProperty prop = (BindingProperty)it.next();
                Set<String> deps = prop.getRequiredProperties();
                if (!evaluationOrder.keySet().containsAll(deps)) continue;
                it.remove();
                evaluationOrder.put(prop.getName(), prop);
                changed = true;
            }
            if (changed) continue;
            throw new IllegalStateException("Cycle detected within remaining property dependencies " + ((Object)bindingProperties).toString());
        }
        return evaluationOrder.values().toArray(new BindingProperty[evaluationOrder.size()]);
    }

    private static void permute(BindingProperty[] properties, Set<String> activeLinkerNames, String[] soFar, int whichProp, List<String[]> permutations) {
        int lastProp = properties.length - 1;
        BindingProperty prop = properties[whichProp];
        Condition winner = null;
        if (prop.getConditionalValues().size() == 1) {
            winner = prop.getRootCondition();
        } else {
            BindingProperty[] answerable = new BindingProperty[soFar.length];
            System.arraycopy(properties, 0, answerable, 0, soFar.length);
            PropertyOracle propertyOracle = new BindingProperties(answerable, soFar, ConfigurationProperties.EMPTY).toPropertyOracle();
            for (Condition cond : prop.getConditionalValues().keySet()) {
                try {
                    if (!cond.isTrue(TreeLogger.NULL, new DeferredBindingQuery(propertyOracle, activeLinkerNames))) continue;
                    winner = cond;
                }
                catch (UnableToCompleteException e) {
                    throw new IllegalStateException("Should never get here for simple properties", e);
                }
            }
        }
        assert (winner != null);
        String[] options = prop.getGeneratedValues(winner);
        for (int i = 0; i < options.length; ++i) {
            String knownValue = options[i];
            String[] nextStep = new String[whichProp + 1];
            if (whichProp > 0) {
                System.arraycopy(soFar, 0, nextStep, 0, soFar.length);
            }
            nextStep[whichProp] = knownValue;
            if (whichProp < lastProp) {
                PropertyCombinations.permute(properties, activeLinkerNames, nextStep, whichProp + 1, permutations);
                continue;
            }
            permutations.add(nextStep);
        }
    }

    public PropertyCombinations(Properties properties, Set<String> activeLinkerNames) {
        this.properties = properties;
        this.values = PropertyCombinations.allPermutationsOf(properties, activeLinkerNames);
    }

    public PropertyCombinations(PropertyCombinations allPermutations, List<String[]> values) {
        this.properties = allPermutations.properties;
        this.values = values;
    }

    public List<PropertyCombinations> collapseProperties() {
        TreeMap map = Maps.newTreeMap();
        BindingProperty[] propertyKeys = this.getOrderedProperties();
        for (String[] propertyValues : this) {
            assert (propertyValues.length == propertyKeys.length);
            BindingProperties bindingProperties = new BindingProperties(propertyKeys, propertyValues, ConfigurationProperties.EMPTY);
            CollapsedPropertyKey key = new CollapsedPropertyKey(bindingProperties);
            ArrayList<String[]> list = (ArrayList<String[]>)map.get(key);
            if (list == null) {
                list = Lists.newArrayList();
                map.put(key, list);
            }
            list.add(propertyValues);
        }
        ArrayList<PropertyCombinations> toReturn = new ArrayList<PropertyCombinations>(map.size());
        for (List list : map.values()) {
            toReturn.add(new PropertyCombinations(this, list));
        }
        return toReturn;
    }

    public BindingProperty[] getOrderedProperties() {
        return PropertyCombinations.getOrderedPropertiesOf(this.properties);
    }

    public String[] getOrderedPropertyValues(int permutation) {
        return this.values.get(permutation);
    }

    public PermutationDescription getPermutationDescription(int permutationId) {
        PermutationDescription permutationDescription = new PermutationDescription();
        for (BindingProperty bindingProperty : this.properties.getBindingProperties()) {
            permutationDescription.bindingPropertyNames.add(bindingProperty.getName());
        }
        for (ConfigurationProperty configurationProperty : this.properties.getConfigurationProperties()) {
            permutationDescription.configurationPropertyNames.add(configurationProperty.getName());
        }
        permutationDescription.propertyValues.addAll(Arrays.asList(this.values.get(permutationId)));
        return permutationDescription;
    }

    @Override
    public Iterator<String[]> iterator() {
        return this.values.iterator();
    }

    public int size() {
        return this.values.size();
    }

    public static class PermutationDescription {
        private List<String> bindingPropertyNames = Lists.newArrayList();
        private List<String> configurationPropertyNames = Lists.newArrayList();
        private List<String> propertyValues = Lists.newArrayList();

        public int hashCode() {
            return Objects.hashCode(this.bindingPropertyNames, this.configurationPropertyNames, this.propertyValues);
        }

        public boolean equals(Object obj) {
            if (obj instanceof PermutationDescription) {
                PermutationDescription that = (PermutationDescription)obj;
                return Objects.equal(this.bindingPropertyNames, that.bindingPropertyNames) && Objects.equal(this.configurationPropertyNames, that.configurationPropertyNames) && Objects.equal(this.propertyValues, that.propertyValues);
            }
            return false;
        }

        public String toString() {
            return String.format("PermutationDescription [bindingPropertyNames=%s, configurationPropertyNames=%s, propertyValues=%s]", this.bindingPropertyNames, this.configurationPropertyNames, this.propertyValues);
        }
    }
}

