/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.cfg;

import com.google.gwt.dev.cfg.BindingProperty;
import com.google.gwt.dev.cfg.ConfigurationProperty;
import com.google.gwt.dev.cfg.Property;
import com.google.gwt.thirdparty.guava.common.collect.ListMultimap;
import com.google.gwt.thirdparty.guava.common.collect.Maps;
import com.google.gwt.thirdparty.guava.common.collect.Sets;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;

public class Properties {
    private final SortedSet<BindingProperty> bindingProperties = Sets.newTreeSet();
    private final SortedSet<ConfigurationProperty> configurationProperties = Sets.newTreeSet();
    private final SortedMap<String, Property> map = Maps.newTreeMap();

    public void addBindingProperty(BindingProperty bindingProperty) {
        this.bindingProperties.add(bindingProperty);
    }

    public BindingProperty createBinding(String name) {
        BindingProperty prop = this.create(name, BindingProperty.class);
        this.bindingProperties.add(prop);
        return prop;
    }

    public ConfigurationProperty createConfiguration(String name, boolean allowMultipleValues) {
        ConfigurationProperty prop = this.create(name, allowMultipleValues, ConfigurationProperty.class);
        this.configurationProperties.add(prop);
        return prop;
    }

    public Property find(String name) {
        return (Property)this.map.get(name);
    }

    public BindingProperty findBindingProp(String propName) {
        Property p = (Property)this.map.get(propName);
        if (p instanceof BindingProperty) {
            return (BindingProperty)p;
        }
        return null;
    }

    public ConfigurationProperty findConfigProp(String propName) {
        Property p = (Property)this.map.get(propName);
        if (p instanceof ConfigurationProperty) {
            return (ConfigurationProperty)p;
        }
        return null;
    }

    public SortedSet<BindingProperty> getBindingProperties() {
        return this.bindingProperties;
    }

    public SortedSet<ConfigurationProperty> getConfigurationProperties() {
        return this.configurationProperties;
    }

    public void setProperties(ListMultimap<String, String> properties) {
        for (Map.Entry<String, Collection<String>> property : properties.asMap().entrySet()) {
            String propertyName = property.getKey();
            Collection<String> propertyValues = property.getValue();
            BindingProperty bindingProp = this.findBindingProp(propertyName);
            ConfigurationProperty configProp = this.findConfigProp(propertyName);
            if (bindingProp != null) {
                bindingProp.setValues(bindingProp.getRootCondition(), propertyValues.toArray(new String[propertyValues.size()]));
                continue;
            }
            if (configProp != null) {
                if (configProp.allowsMultipleValues()) {
                    configProp.clear();
                    for (String propertyValue : propertyValues) {
                        configProp.addValue(propertyValue);
                    }
                    continue;
                }
                String firstValue = propertyValues.iterator().next();
                if (propertyValues.size() > 1) {
                    throw new IllegalArgumentException("Attemp to set multiple values to a single-valued configuration property '" + propertyName + "'.");
                }
                configProp.setValue(firstValue);
                continue;
            }
            throw new IllegalArgumentException("Unknown property: " + propertyName);
        }
    }

    private <T extends Property> T create(String name, boolean flag, boolean useFlagArgument, Class<T> clazz) {
        ReflectiveOperationException ex;
        if (clazz == null) {
            throw new NullPointerException("clazz");
        }
        if (name == null) {
            throw new NullPointerException("name");
        }
        Property property = this.find(name);
        if (property != null) {
            try {
                return (T)((Property)clazz.cast(property));
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("Cannot create property " + name + " because one of another type (" + property.getClass().getSimpleName() + ") already exists.");
            }
        }
        try {
            Property newInstance = useFlagArgument ? (Property)clazz.getConstructor(String.class, Boolean.TYPE).newInstance(name, flag) : (Property)clazz.getConstructor(String.class).newInstance(name);
            this.map.put(name, newInstance);
            return (T)newInstance;
        }
        catch (NoSuchMethodException e) {
            ex = e;
        }
        catch (InstantiationException e) {
            ex = e;
        }
        catch (IllegalAccessException e) {
            ex = e;
        }
        catch (InvocationTargetException e) {
            ex = e;
        }
        throw new RuntimeException("Unable to create Property instance", ex);
    }

    private <T extends Property> T create(String name, boolean flag, Class<T> clazz) {
        return this.create(name, flag, true, clazz);
    }

    private <T extends Property> T create(String name, Class<T> clazz) {
        return this.create(name, false, false, clazz);
    }
}

