/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.cfg;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.dev.cfg.BindingProperties;
import com.google.gwt.dev.cfg.BindingProperty;
import com.google.gwt.dev.cfg.ConfigurationProperties;
import com.google.gwt.thirdparty.guava.common.base.Objects;
import com.google.gwt.thirdparty.guava.common.collect.ImmutableList;
import com.google.gwt.thirdparty.guava.common.collect.ImmutableMap;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import com.google.gwt.thirdparty.guava.common.collect.Sets;
import java.util.ArrayList;
import java.util.TreeSet;

public class PermutationProperties {
    private final ImmutableList<BindingProperties> softProperties;

    public PermutationProperties(Iterable<BindingProperties> softProperties) {
        this.softProperties = ImmutableList.copyOf(softProperties);
        assert (this.softProperties.size() >= 1);
        assert (this.sameBindingProperties(this.softProperties)) : "The binding properties should be the same for each soft permutation.";
    }

    public ConfigurationProperties getConfigurationProperties() {
        return ((BindingProperties)this.softProperties.get(0)).getConfigurationProperties();
    }

    public ImmutableList<BindingProperty> getBindingProperties() {
        return ImmutableList.copyOf(((BindingProperties)this.softProperties.get(0)).getOrderedProps());
    }

    public ImmutableList<BindingProperties> getSoftProperties() {
        return this.softProperties;
    }

    public String mustGetString(String key) {
        if (!this.isEqualInEachPermutation(key)) {
            throw new IllegalStateException("The '" + key + "' binding property must be the same in each soft permutation");
        }
        String value = ((BindingProperties)this.softProperties.get(0)).getString(key, null);
        if (value == null) {
            throw new IllegalStateException("The '" + key + "' binding property is not defined");
        }
        return value;
    }

    public boolean isEqualInEachPermutation(String key) {
        String expected = ((BindingProperties)this.softProperties.get(0)).getString(key, null);
        for (BindingProperties prop : this.softProperties.subList(1, this.softProperties.size())) {
            String actual = prop.getString(key, null);
            if (Objects.equal(expected, actual)) continue;
            return false;
        }
        return true;
    }

    public boolean isTrueInAnyPermutation(String name) {
        for (BindingProperties bindingProperties : this.softProperties) {
            if (!bindingProperties.getBoolean(name, false)) continue;
            return true;
        }
        return false;
    }

    public ImmutableList<ImmutableMap<String, String>> findEmbeddedProperties(TreeLogger logger) {
        TreeSet<String> propsWanted = Sets.newTreeSet(this.getConfigurationProperties().getStrings("js.embedded.properties"));
        TreeSet<String> propsToSave = Sets.newTreeSet();
        for (BindingProperty prop : this.getBindingProperties()) {
            String name = prop.getName();
            if (!propsWanted.remove(name)) continue;
            propsToSave.add(name);
        }
        if (!propsWanted.isEmpty()) {
            TreeLogger branch = logger.branch(TreeLogger.Type.WARN, propsWanted.size() + "properties listed in js.embedded.properties are undefined");
            for (String prop : propsWanted) {
                branch.log(TreeLogger.Type.WARN, "undefined property: '" + prop + "'");
            }
        }
        ArrayList result = Lists.newArrayList();
        for (BindingProperties properties : this.getSoftProperties()) {
            ImmutableMap.Builder<String, String> values = ImmutableMap.builder();
            for (String key : propsToSave) {
                values.put(key, properties.getString(key, null));
            }
            result.add(values.build());
        }
        return ImmutableList.copyOf(result);
    }

    public String prettyPrint() {
        StringBuilder out = new StringBuilder();
        for (BindingProperties properties : this.getSoftProperties()) {
            if (out.length() > 0) {
                out.append("; ");
            }
            out.append(properties.prettyPrint());
        }
        return out.toString();
    }

    private boolean sameBindingProperties(ImmutableList<BindingProperties> properties) {
        BindingProperties expected = (BindingProperties)properties.get(0);
        for (BindingProperties actual : properties.subList(1, properties.size())) {
            if (expected.hasSameBindingProperties(actual)) continue;
            return false;
        }
        return true;
    }
}

