/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.cfg;

import com.google.gwt.core.ext.Generator;
import com.google.gwt.core.ext.Linker;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.linker.LinkerOrder;
import com.google.gwt.core.ext.linker.PropertyProviderGenerator;
import com.google.gwt.dev.cfg.BindingProperty;
import com.google.gwt.dev.cfg.CompoundCondition;
import com.google.gwt.dev.cfg.Condition;
import com.google.gwt.dev.cfg.ConditionAll;
import com.google.gwt.dev.cfg.ConditionAny;
import com.google.gwt.dev.cfg.ConditionNone;
import com.google.gwt.dev.cfg.ConditionWhenLinkerAdded;
import com.google.gwt.dev.cfg.ConditionWhenPropertyIs;
import com.google.gwt.dev.cfg.ConditionWhenTypeAssignableTo;
import com.google.gwt.dev.cfg.ConditionWhenTypeIs;
import com.google.gwt.dev.cfg.ConfigurationProperty;
import com.google.gwt.dev.cfg.Messages;
import com.google.gwt.dev.cfg.ModuleDef;
import com.google.gwt.dev.cfg.ModuleDefLoader;
import com.google.gwt.dev.cfg.Property;
import com.google.gwt.dev.cfg.PropertyProvider;
import com.google.gwt.dev.cfg.RuleFail;
import com.google.gwt.dev.cfg.RuleGenerateWith;
import com.google.gwt.dev.cfg.RuleReplaceWith;
import com.google.gwt.dev.cfg.Script;
import com.google.gwt.dev.js.JsParser;
import com.google.gwt.dev.js.JsParserException;
import com.google.gwt.dev.js.ast.JsExprStmt;
import com.google.gwt.dev.js.ast.JsFunction;
import com.google.gwt.dev.js.ast.JsProgram;
import com.google.gwt.dev.js.ast.JsStatement;
import com.google.gwt.dev.util.Empty;
import com.google.gwt.dev.util.Util;
import com.google.gwt.dev.util.xml.AttributeConverter;
import com.google.gwt.dev.util.xml.Schema;
import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

public class ModuleDefSchema
extends Schema {
    private static final HashMap<String, String> propertyDefinitions = new HashMap();
    private static final HashMap<String, String> propertySettings = new HashMap();
    protected final String __module_1_rename_to = "";
    protected final String __module_2_type = "library";
    private final PropertyAttrCvt bindingPropAttrCvt = new PropertyAttrCvt(BindingProperty.class);
    private final BodySchema bodySchema;
    private final ClassAttrCvt classAttrCvt = new ClassAttrCvt();
    private final PropertyAttrCvt configurationPropAttrCvt = new PropertyAttrCvt(ConfigurationProperty.class);
    private boolean foundAnyPublic;
    private boolean foundExplicitSourceOrSuperSource;
    private final JsProgram jsPgm = new JsProgram();
    private final LinkerNameAttrCvt linkerNameAttrCvt = new LinkerNameAttrCvt();
    private final ModuleDefLoader loader;
    private final TreeLogger logger;
    private final ModuleDef moduleDef;
    private final String moduleName;
    private final String modulePackageAsPath;
    private final URL moduleURL;
    private final NullableNameAttrCvt nullableNameAttrCvt = new NullableNameAttrCvt();
    private final PropertyNameAttrCvt propNameAttrCvt = new PropertyNameAttrCvt();
    private final PropertyValueArrayAttrCvt propValueArrayAttrCvt = new PropertyValueArrayAttrCvt();
    private final PropertyValueAttrCvt propValueAttrCvt = new PropertyValueAttrCvt();
    private final PropertyFallbackValueAttrCvt propFallbackValueAttrCvt = new PropertyFallbackValueAttrCvt();
    private final PropertyValueGlobArrayAttrCvt propValueGlobArrayAttrCvt = new PropertyValueGlobArrayAttrCvt();
    private final PropertyValueGlobAttrCvt propValueGlobAttrCvt = new PropertyValueGlobAttrCvt();

    public static boolean isValidPropertyName(String value) {
        boolean isValid = true;
        String[] tokens = (value + ". ").split("\\.");
        for (int i = 0; i < tokens.length - 1; ++i) {
            String token = tokens[i];
            if (Util.isValidJavaIdent(token)) continue;
            isValid = false;
        }
        return isValid;
    }

    private static void addPrefix(String[] strings, String prefix) {
        for (int i = 0; i < strings.length; ++i) {
            strings[i] = prefix + strings[i];
        }
    }

    private static boolean toPrimitiveBoolean(String s) {
        return "yes".equalsIgnoreCase(s) || "true".equalsIgnoreCase(s);
    }

    public ModuleDefSchema(TreeLogger logger, ModuleDefLoader loader, String moduleName, URL moduleURL, String modulePackageAsPath, ModuleDef toConfigure) {
        this.logger = logger;
        this.loader = loader;
        this.moduleName = moduleName;
        this.moduleURL = moduleURL;
        this.modulePackageAsPath = modulePackageAsPath;
        assert (modulePackageAsPath.endsWith("/") || modulePackageAsPath.equals(""));
        this.moduleDef = toConfigure;
        this.bodySchema = new BodySchema();
        this.registerAttributeConverter(PropertyName.class, this.propNameAttrCvt);
        this.registerAttributeConverter(BindingProperty.class, this.bindingPropAttrCvt);
        this.registerAttributeConverter(ConfigurationProperty.class, this.configurationPropAttrCvt);
        this.registerAttributeConverter(PropertyValue.class, this.propValueAttrCvt);
        this.registerAttributeConverter(PropertyFallbackValue.class, this.propFallbackValueAttrCvt);
        this.registerAttributeConverter(PropertyValue[].class, this.propValueArrayAttrCvt);
        this.registerAttributeConverter(PropertyValueGlob.class, this.propValueGlobAttrCvt);
        this.registerAttributeConverter(PropertyValueGlob[].class, this.propValueGlobArrayAttrCvt);
        this.registerAttributeConverter(LinkerName.class, this.linkerNameAttrCvt);
        this.registerAttributeConverter(NullableName.class, this.nullableNameAttrCvt);
        this.registerAttributeConverter(Class.class, this.classAttrCvt);
    }

    protected Schema __module_begin(NullableName renameTo, String type) throws UnableToCompleteException {
        this.moduleDef.enterModule(this.moduleName);
        this.bodySchema.__inherits_begin("com.google.gwt.core.Core");
        return this.bodySchema;
    }

    protected void __module_end(NullableName renameTo, String type) {
        if (!this.foundExplicitSourceOrSuperSource) {
            this.bodySchema.addSourcePackage(this.modulePackageAsPath, "client", Empty.STRINGS, Empty.STRINGS, Empty.STRINGS, true, true, false);
        }
        if (!this.foundAnyPublic) {
            this.bodySchema.addPublicPackage(this.modulePackageAsPath, "public", Empty.STRINGS, Empty.STRINGS, Empty.STRINGS, true, true);
        }
        this.moduleDef.setNameOverride(renameTo.token);
        this.moduleDef.exitModule();
    }

    private JsFunction parseJsBlock(int startLineNumber, String script) throws UnableToCompleteException {
        List<JsStatement> stmts;
        script = "function() { " + script + "}";
        StringReader r = new StringReader(script);
        try {
            stmts = JsParser.parse(this.jsPgm.createSourceInfo(startLineNumber, this.moduleURL.toExternalForm()), this.jsPgm.getScope(), r);
        }
        catch (IOException e) {
            this.logger.log(TreeLogger.ERROR, "Error reading script source", e);
            throw new UnableToCompleteException();
        }
        catch (JsParserException e) {
            this.logger.log(TreeLogger.ERROR, "Error parsing JavaScript source", e);
            throw new UnableToCompleteException();
        }
        JsFunction fn = (JsFunction)((JsExprStmt)stmts.get(0)).getExpression();
        return fn;
    }

    private static class ScriptSchema
    extends Schema {
        private StringBuilder script;
        private int startLineNumber = -1;

        public void __text(String text) {
            if (this.script == null) {
                this.script = new StringBuilder();
                this.startLineNumber = this.getLineNumber();
            }
            this.script.append(text);
        }

        public String getScript() {
            return this.script != null ? this.script.toString() : null;
        }

        public int getStartLineNumber() {
            return this.startLineNumber;
        }
    }

    private final class PropertyValueGlobAttrCvt
    extends AttributeConverter {
        private PropertyValueGlobAttrCvt() {
        }

        @Override
        public Object convertToArg(Schema schema, int line, String elem, String attr, String value) throws UnableToCompleteException {
            String token = value.trim();
            String tokenNoStar = token.replaceAll(Pattern.quote("*"), "");
            if ("*".equals(token) || Util.isValidJavaIdent(tokenNoStar)) {
                return new PropertyValueGlob(token);
            }
            Messages.PROPERTY_VALUE_INVALID.log(ModuleDefSchema.this.logger, line, token, null);
            throw new UnableToCompleteException();
        }
    }

    private final class PropertyValueGlobArrayAttrCvt
    extends AttributeConverter {
        private PropertyValueGlobArrayAttrCvt() {
        }

        @Override
        public Object convertToArg(Schema schema, int line, String elem, String attr, String value) throws UnableToCompleteException {
            String[] tokens = value.split(",");
            PropertyValueGlob[] values = new PropertyValueGlob[tokens.length];
            for (int i = 0; i < tokens.length; ++i) {
                values[i] = (PropertyValueGlob)ModuleDefSchema.this.propValueGlobAttrCvt.convertToArg(schema, line, elem, attr, tokens[i]);
            }
            return values;
        }
    }

    private final class PropertyFallbackValueAttrCvt
    extends AttributeConverter {
        private PropertyFallbackValueAttrCvt() {
        }

        @Override
        public Object convertToArg(Schema schema, int line, String elem, String attr, String value) throws UnableToCompleteException {
            String token = value.trim();
            if (Util.isValidJavaIdent(token)) {
                return new PropertyFallbackValue(token);
            }
            Messages.PROPERTY_VALUE_INVALID.log(ModuleDefSchema.this.logger, line, token, null);
            throw new UnableToCompleteException();
        }
    }

    private static class PropertyValueGlob {
        public final String token;

        public PropertyValueGlob(String token) {
            this.token = token;
        }

        public boolean isGlob() {
            return this.token.contains("*");
        }
    }

    private final class PropertyValueAttrCvt
    extends AttributeConverter {
        private PropertyValueAttrCvt() {
        }

        @Override
        public Object convertToArg(Schema schema, int line, String elem, String attr, String value) throws UnableToCompleteException {
            String token = value.trim();
            if (Util.isValidJavaIdent(token)) {
                return new PropertyValue(token);
            }
            Messages.PROPERTY_VALUE_INVALID.log(ModuleDefSchema.this.logger, line, token, null);
            throw new UnableToCompleteException();
        }
    }

    private final class PropertyValueArrayAttrCvt
    extends AttributeConverter {
        private PropertyValueArrayAttrCvt() {
        }

        @Override
        public Object convertToArg(Schema schema, int line, String elem, String attr, String value) throws UnableToCompleteException {
            String[] tokens = value.split(",");
            PropertyValue[] values = new PropertyValue[tokens.length];
            for (int i = 0; i < tokens.length; ++i) {
                values[i] = (PropertyValue)ModuleDefSchema.this.propValueAttrCvt.convertToArg(schema, line, elem, attr, tokens[i]);
            }
            return values;
        }
    }

    private static class PropertyFallbackValue {
        public final String token;

        public PropertyFallbackValue(String token) {
            this.token = token;
        }
    }

    private static class PropertyValue {
        public final String token;

        public PropertyValue(String token) {
            this.token = token;
        }
    }

    private final class PropertyNameAttrCvt
    extends AttributeConverter {
        private PropertyNameAttrCvt() {
        }

        @Override
        public Object convertToArg(Schema schema, int line, String elem, String attr, String value) throws UnableToCompleteException {
            if (!ModuleDefSchema.isValidPropertyName(value)) {
                Messages.PROPERTY_NAME_INVALID.log(ModuleDefSchema.this.logger, line, value, null);
                throw new UnableToCompleteException();
            }
            return new PropertyName(value);
        }
    }

    private static class PropertyName {
        public final String token;

        public PropertyName(String token) {
            this.token = token;
        }
    }

    private class PropertyConditionSchema
    extends Schema {
        protected final String __when_linker_added_1_name;
        protected final String __when_property_is_1_name;
        protected final String __when_property_is_2_value;
        protected final CompoundCondition parentCondition;

        public PropertyConditionSchema(CompoundCondition parentCondition) {
            this.__when_linker_added_1_name = null;
            this.__when_property_is_1_name = null;
            this.__when_property_is_2_value = null;
            this.parentCondition = parentCondition;
        }

        protected Schema __all_begin() {
            ConditionAll cond = new ConditionAll(new Condition[0]);
            this.parentCondition.getConditions().add(cond);
            return this.subSchema(cond);
        }

        protected Schema __any_begin() {
            ConditionAny cond = new ConditionAny(new Condition[0]);
            this.parentCondition.getConditions().add(cond);
            return this.subSchema(cond);
        }

        protected Schema __none_begin() {
            ConditionNone cond = new ConditionNone(new Condition[0]);
            this.parentCondition.getConditions().add(cond);
            return this.subSchema(cond);
        }

        protected Schema __when_linker_added_begin(LinkerName linkerName) {
            ConditionWhenLinkerAdded cond = new ConditionWhenLinkerAdded(linkerName.name);
            this.parentCondition.getConditions().add(cond);
            return null;
        }

        protected Schema __when_property_is_begin(BindingProperty prop, PropertyValue value) {
            ConditionWhenPropertyIs cond = new ConditionWhenPropertyIs(prop.getName(), value.token);
            this.parentCondition.getConditions().add(cond);
            return null;
        }

        protected Schema subSchema(CompoundCondition cond) {
            return new PropertyConditionSchema(cond);
        }
    }

    private final class PropertyAttrCvt
    extends AttributeConverter {
        private Class<? extends Property> concreteType;

        public PropertyAttrCvt(Class<? extends Property> concreteType) {
            this.concreteType = concreteType;
        }

        @Override
        public Object convertToArg(Schema schema, int line, String elem, String attr, String value) throws UnableToCompleteException {
            Property prop = ModuleDefSchema.this.moduleDef.getProperties().find(value);
            if (prop != null) {
                if (this.concreteType.isInstance(prop)) {
                    return prop;
                }
                ModuleDefSchema.this.logger.log(TreeLogger.ERROR, "The specified property '" + prop.getName() + "' is not of the correct type; found '" + prop.getClass().getSimpleName() + "' expecting '" + this.concreteType.getSimpleName() + "'");
            } else {
                Messages.PROPERTY_NOT_FOUND.log(ModuleDefSchema.this.logger, line, value, null);
            }
            throw new UnableToCompleteException();
        }
    }

    private final class NullableNameAttrCvt
    extends AttributeConverter {
        private NullableNameAttrCvt() {
        }

        @Override
        public Object convertToArg(Schema schema, int line, String elem, String attr, String value) throws UnableToCompleteException {
            if (value == null || value.length() == 0) {
                return new NullableName(null);
            }
            String[] tokens = (value + ". ").split("\\.");
            for (int i = 0; i < tokens.length - 1; ++i) {
                String token = tokens[i];
                if (Util.isValidJavaIdent(token)) continue;
                Messages.NAME_INVALID.log(ModuleDefSchema.this.logger, line, value, null);
                throw new UnableToCompleteException();
            }
            return new NullableName(value);
        }
    }

    private static class NullableName {
        public final String token;

        public NullableName(String token) {
            this.token = token;
        }
    }

    private final class LinkerNameAttrCvt
    extends AttributeConverter {
        private LinkerNameAttrCvt() {
        }

        @Override
        public Object convertToArg(Schema schema, int line, String elem, String attr, String value) throws UnableToCompleteException {
            if (!Util.isValidJavaIdent(value)) {
                Messages.LINKER_NAME_INVALID.log(ModuleDefSchema.this.logger, line, value, null);
                throw new UnableToCompleteException();
            }
            return new LinkerName(value);
        }
    }

    private static class LinkerName {
        public final String name;

        public LinkerName(String name) {
            this.name = name;
        }
    }

    private static final class IncludeExcludeSchema
    extends Schema {
        protected final String __exclude_1_name;
        protected final String __include_1_name;
        protected final String __skip_1_name;
        private final Set<String> excludes = new HashSet<String>();
        private final Set<String> includes = new HashSet<String>();
        private final Set<String> skips = new HashSet<String>();

        private IncludeExcludeSchema() {
            this.__exclude_1_name = null;
            this.__include_1_name = null;
            this.__skip_1_name = null;
        }

        public Set<String> getExcludes() {
            return this.excludes;
        }

        public Set<String> getIncludes() {
            return this.includes;
        }

        public Set<String> getSkips() {
            return this.skips;
        }

        protected Schema __exclude_begin(String name) {
            this.excludes.add(name);
            return null;
        }

        protected Schema __include_begin(String name) {
            this.includes.add(name);
            return null;
        }

        protected Schema __skip_begin(String name) {
            this.skips.add(name);
            return null;
        }
    }

    private final class FullConditionSchema
    extends PropertyConditionSchema {
        protected final String __when_type_assignable_1_class;
        protected final String __when_type_is_1_class;

        public FullConditionSchema(CompoundCondition parentCondition) {
            super(parentCondition);
            this.__when_type_assignable_1_class = null;
            this.__when_type_is_1_class = null;
        }

        protected Schema __when_type_assignable_begin(String className) {
            ConditionWhenTypeAssignableTo cond = new ConditionWhenTypeAssignableTo(className);
            this.parentCondition.getConditions().add(cond);
            return null;
        }

        protected Schema __when_type_is_begin(String className) {
            ConditionWhenTypeIs cond = new ConditionWhenTypeIs(className);
            this.parentCondition.getConditions().add(cond);
            return null;
        }

        @Override
        protected Schema subSchema(CompoundCondition cond) {
            return new FullConditionSchema(cond);
        }
    }

    private final class ClassAttrCvt
    extends AttributeConverter {
        private ClassAttrCvt() {
        }

        @Override
        public Object convertToArg(Schema schema, int line, String elem, String attr, String value) throws UnableToCompleteException {
            if (value.length() == 0) {
                return null;
            }
            try {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                return cl.loadClass(value);
            }
            catch (ClassNotFoundException e) {
                Messages.UNABLE_TO_LOAD_CLASS.log(ModuleDefSchema.this.logger, line, value, (Throwable)e);
                throw new UnableToCompleteException();
            }
        }
    }

    private final class BodySchema
    extends Schema {
        protected final String __add_linker_1_name;
        protected final String __clear_configuration_property_1_name;
        protected final String __collapse_all_properties_1_value = "true";
        protected final String __collapse_property_1_name;
        protected final String __collapse_property_2_values;
        protected final String __define_configuration_property_1_name;
        protected final String __define_configuration_property_2_is_multi_valued;
        protected final String __define_linker_1_name;
        protected final String __define_linker_2_class;
        protected final String __define_property_1_name;
        protected final String __define_property_2_values;
        protected final String __entry_point_1_class;
        protected final String __extend_configuration_property_1_name;
        protected final String __extend_configuration_property_2_value;
        protected final String __extend_property_1_name;
        protected final String __extend_property_2_values;
        protected final String __extend_property_3_fallback_value$;
        protected final String __generate_with_1_class;
        protected final String __inherits_1_name;
        protected final String __property_provider_1_name;
        protected final String __property_provider_2_generator = "";
        protected final String __public_1_path;
        protected final String __public_2_includes = "";
        protected final String __public_3_excludes = "";
        protected final String __public_4_skips = "";
        protected final String __public_5_defaultexcludes = "yes";
        protected final String __public_6_casesensitive = "true";
        protected final String __replace_with_1_class;
        protected final String __script_1_src;
        protected final String __servlet_1_path;
        protected final String __servlet_2_class;
        protected final String __set_configuration_property_1_name;
        protected final String __set_configuration_property_2_value;
        protected final String __set_property_1_name;
        protected final String __set_property_2_value;
        protected final String __set_property_fallback_1_name;
        protected final String __set_property_fallback_2_value;
        protected final String __resource_1_path = "";
        protected final String __source_1_path = "";
        protected final String __source_2_includes = "";
        protected final String __source_3_excludes = "";
        protected final String __source_4_skips = "";
        protected final String __source_5_defaultexcludes = "yes";
        protected final String __source_6_casesensitive = "true";
        protected final String __stylesheet_1_src;
        protected final String __super_source_1_path = "";
        protected final String __super_source_2_includes = "";
        protected final String __super_source_3_excludes = "";
        protected final String __super_source_4_skips = "";
        protected final String __super_source_5_defaultexcludes = "yes";
        protected final String __super_source_6_casesensitive = "true";
        private ConditionAll bindingPropertyCondition;
        private Schema fChild;

        private BodySchema() {
            this.__add_linker_1_name = null;
            this.__clear_configuration_property_1_name = null;
            this.__collapse_property_1_name = null;
            this.__collapse_property_2_values = null;
            this.__define_configuration_property_1_name = null;
            this.__define_configuration_property_2_is_multi_valued = null;
            this.__define_linker_1_name = null;
            this.__define_linker_2_class = null;
            this.__define_property_1_name = null;
            this.__define_property_2_values = null;
            this.__entry_point_1_class = null;
            this.__extend_configuration_property_1_name = null;
            this.__extend_configuration_property_2_value = null;
            this.__extend_property_1_name = null;
            this.__extend_property_2_values = null;
            this.__extend_property_3_fallback_value$ = null;
            this.__generate_with_1_class = null;
            this.__inherits_1_name = null;
            this.__property_provider_1_name = null;
            this.__public_1_path = null;
            this.__replace_with_1_class = null;
            this.__script_1_src = null;
            this.__servlet_1_path = null;
            this.__servlet_2_class = null;
            this.__set_configuration_property_1_name = null;
            this.__set_configuration_property_2_value = null;
            this.__set_property_1_name = null;
            this.__set_property_2_value = null;
            this.__set_property_fallback_1_name = null;
            this.__set_property_fallback_2_value = null;
            this.__stylesheet_1_src = null;
        }

        protected Schema __add_linker_begin(LinkerName name) throws UnableToCompleteException {
            if (ModuleDefSchema.this.moduleDef.getLinker(name.name) == null) {
                Messages.LINKER_NAME_INVALID.log(ModuleDefSchema.this.logger, this.getLineNumber(), name.name, null);
                throw new UnableToCompleteException();
            }
            ModuleDefSchema.this.moduleDef.addLinker(name.name);
            return null;
        }

        protected Schema __clear_configuration_property_begin(PropertyName name) throws UnableToCompleteException {
            Property prop = ModuleDefSchema.this.moduleDef.getProperties().find(name.token);
            if (prop == null) {
                ModuleDefSchema.this.logger.log(TreeLogger.ERROR, "No property named " + name.token + " has been defined");
                throw new UnableToCompleteException();
            }
            if (!(prop instanceof ConfigurationProperty)) {
                if (prop instanceof BindingProperty) {
                    ModuleDefSchema.this.logger.log(TreeLogger.ERROR, "The property " + name.token + " is already defined as a deferred-binding property");
                } else {
                    ModuleDefSchema.this.logger.log(TreeLogger.ERROR, "The property " + name.token + " is already defined as a property of unknown type");
                }
                throw new UnableToCompleteException();
            }
            ((ConfigurationProperty)prop).clear();
            return null;
        }

        protected Schema __collapse_all_properties_begin(boolean collapse) {
            ModuleDefSchema.this.moduleDef.setCollapseAllProperties(collapse);
            return null;
        }

        protected Schema __collapse_property_begin(PropertyName name, PropertyValueGlob[] values) throws UnableToCompleteException {
            Property prop = ModuleDefSchema.this.moduleDef.getProperties().find(name.token);
            if (prop == null) {
                ModuleDefSchema.this.logger.log(TreeLogger.ERROR, "No property named " + name.token + " has been defined");
                throw new UnableToCompleteException();
            }
            if (!(prop instanceof BindingProperty)) {
                ModuleDefSchema.this.logger.log(TreeLogger.ERROR, "The property " + name.token + " is not a deferred-binding property");
                throw new UnableToCompleteException();
            }
            BindingProperty binding = (BindingProperty)prop;
            List<String> allowed = Arrays.asList(binding.getDefinedValues());
            String[] tokens = new String[values.length];
            boolean error = false;
            int j = values.length;
            for (int i = 0; i < j; ++i) {
                tokens[i] = values[i].token;
                if (values[i].isGlob() || allowed.contains(tokens[i])) continue;
                ModuleDefSchema.this.logger.log(TreeLogger.ERROR, "The value " + tokens[i] + " was not previously defined for the property " + binding.getName());
                error = true;
            }
            if (error) {
                throw new UnableToCompleteException();
            }
            binding.addCollapsedValues(tokens);
            return null;
        }

        protected Schema __define_configuration_property_begin(PropertyName name, String is_multi_valued) throws UnableToCompleteException {
            boolean isMultiValued = ModuleDefSchema.toPrimitiveBoolean(is_multi_valued);
            Property existingProperty = ModuleDefSchema.this.moduleDef.getProperties().find(name.token);
            if (existingProperty == null) {
                ModuleDefSchema.this.moduleDef.getProperties().createConfiguration(name.token, isMultiValued);
                if (!propertyDefinitions.containsKey(name.token)) {
                    propertyDefinitions.put(name.token, ModuleDefSchema.this.moduleName);
                }
            } else if (existingProperty instanceof ConfigurationProperty) {
                String originalDefinition = (String)propertyDefinitions.get(name.token);
                if (((ConfigurationProperty)existingProperty).allowsMultipleValues() != isMultiValued) {
                    if (originalDefinition != null) {
                        ModuleDefSchema.this.logger.log(TreeLogger.ERROR, "The configuration property named " + name.token + " is already defined with a different 'is-multi-valued' setting");
                    } else {
                        ModuleDefSchema.this.logger.log(TreeLogger.ERROR, "The configuration property named " + name.token + " is already defined implicitly by 'set-configuration-property' in " + (String)propertySettings.get(name.token) + " with 'is-multi-valued' set to 'false'");
                    }
                    throw new UnableToCompleteException();
                }
                if (originalDefinition != null) {
                    ModuleDefSchema.this.logger.log(TreeLogger.WARN, "Ignoring identical definition of the configuration property named " + name.token + " (originally defined in " + originalDefinition + ", redefined in " + ModuleDefSchema.this.moduleName + ")");
                } else {
                    ModuleDefSchema.this.logger.log(TreeLogger.WARN, "Definition of already set configuration property named " + name.token + " in " + ModuleDefSchema.this.moduleName + " (set in " + (String)propertySettings.get(name.token) + ").  This may be disallowed in the future.");
                }
            } else {
                if (existingProperty instanceof BindingProperty) {
                    ModuleDefSchema.this.logger.log(TreeLogger.ERROR, "The property " + name.token + " is already defined as a deferred-binding property");
                } else {
                    ModuleDefSchema.this.logger.log(TreeLogger.ERROR, "May not replace property named " + name.token + " of unknown type " + existingProperty.getClass().getName());
                }
                throw new UnableToCompleteException();
            }
            return null;
        }

        protected Schema __define_linker_begin(LinkerName name, Class<? extends Linker> linker) throws UnableToCompleteException {
            if (!Linker.class.isAssignableFrom(linker)) {
                ModuleDefSchema.this.logger.log(TreeLogger.ERROR, "A linker must extend " + Linker.class.getName(), null);
                throw new UnableToCompleteException();
            }
            if (linker.getAnnotation(LinkerOrder.class) == null) {
                ModuleDefSchema.this.logger.log(TreeLogger.ERROR, "Linkers must be annotated with the " + LinkerOrder.class.getName() + " annotation", null);
                throw new UnableToCompleteException();
            }
            ModuleDefSchema.this.moduleDef.defineLinker(ModuleDefSchema.this.logger, name.name, linker);
            return null;
        }

        protected Schema __define_property_begin(PropertyName name, PropertyValue[] values) throws UnableToCompleteException {
            Property existingProperty = ModuleDefSchema.this.moduleDef.getProperties().find(name.token);
            if (existingProperty != null) {
                if (existingProperty instanceof BindingProperty) {
                    ModuleDefSchema.this.logger.log(TreeLogger.ERROR, "The deferred-binding property named " + name.token + " may not be redefined.");
                } else if (existingProperty instanceof ConfigurationProperty) {
                    ModuleDefSchema.this.logger.log(TreeLogger.ERROR, "The property " + name.token + " is already defined as a configuration property");
                } else {
                    ModuleDefSchema.this.logger.log(TreeLogger.ERROR, "May not replace property named " + name.token + " of unknown type " + existingProperty.getClass().getName());
                }
                throw new UnableToCompleteException();
            }
            BindingProperty prop = ModuleDefSchema.this.moduleDef.getProperties().createBinding(name.token);
            for (int i = 0; i < values.length; ++i) {
                ModuleDefSchema.this.moduleDef.addBindingPropertyDefinedValue(prop, values[i].token);
            }
            return null;
        }

        protected Schema __entry_point_begin(String className) {
            ModuleDefSchema.this.moduleDef.addEntryPointTypeName(className);
            return null;
        }

        protected Schema __extend_configuration_property_begin(PropertyName name, String value) throws UnableToCompleteException {
            Property configurationProperty = ModuleDefSchema.this.moduleDef.getProperties().find(name.token);
            if (configurationProperty == null || !(configurationProperty instanceof ConfigurationProperty)) {
                ModuleDefSchema.this.logger.log(TreeLogger.ERROR, "The property " + name.token + " must already exist as a configuration property");
                throw new UnableToCompleteException();
            }
            ConfigurationProperty configProp = (ConfigurationProperty)configurationProperty;
            if (!configProp.allowsMultipleValues()) {
                ModuleDefSchema.this.logger.log(TreeLogger.ERROR, "The property " + name.token + " does not support multiple values");
                throw new UnableToCompleteException();
            }
            ModuleDefSchema.this.moduleDef.addConfigurationPropertyValue(configProp, value);
            return null;
        }

        protected Schema __extend_property_begin(BindingProperty bindingProperty, PropertyValue[] values, PropertyFallbackValue fallbackValue) throws UnableToCompleteException {
            int i;
            for (i = 0; i < values.length; ++i) {
                ModuleDefSchema.this.moduleDef.addBindingPropertyDefinedValue(bindingProperty, values[i].token);
            }
            if (fallbackValue != null) {
                if (!bindingProperty.isDefinedValue(fallbackValue.token)) {
                    ModuleDefSchema.this.logger.log(TreeLogger.ERROR, "The property " + bindingProperty.name + " fallback-value was not defined");
                    throw new UnableToCompleteException();
                }
                for (i = 0; i < values.length; ++i) {
                    bindingProperty.addFallbackValue(values[i].token, fallbackValue.token);
                }
            }
            return null;
        }

        protected Schema __fail_begin() {
            RuleFail rule = new RuleFail();
            ModuleDefSchema.this.moduleDef.addRule(rule);
            return new FullConditionSchema(rule.getRootCondition());
        }

        protected Schema __generate_with_begin(Class<? extends Generator> generator) throws UnableToCompleteException {
            if (!Generator.class.isAssignableFrom(generator)) {
                ModuleDefSchema.this.logger.log(TreeLogger.ERROR, "A generator must extend " + Generator.class.getName(), null);
                throw new UnableToCompleteException();
            }
            RuleGenerateWith rule = new RuleGenerateWith(generator);
            ModuleDefSchema.this.moduleDef.getRules().addFirst(rule);
            return new FullConditionSchema(rule.getRootCondition());
        }

        protected Schema __inherits_begin(String name) throws UnableToCompleteException {
            ModuleDefSchema.this.loader.nestedLoad(ModuleDefSchema.this.logger, name, ModuleDefSchema.this.moduleDef);
            return null;
        }

        protected Schema __property_provider_begin(BindingProperty property, Class<? extends PropertyProviderGenerator> generator) {
            this.fChild = new ScriptSchema();
            return this.fChild;
        }

        protected void __property_provider_end(BindingProperty property, Class<? extends PropertyProviderGenerator> generator) throws UnableToCompleteException {
            if (generator != null && !PropertyProviderGenerator.class.isAssignableFrom(generator)) {
                ModuleDefSchema.this.logger.log(TreeLogger.ERROR, "A property provider generator must extend " + PropertyProviderGenerator.class.getName(), null);
                throw new UnableToCompleteException();
            }
            ScriptSchema childSchema = (ScriptSchema)this.fChild;
            String script = childSchema.getScript();
            property.setProviderGenerator(generator);
            if (script == null) {
                if (generator == null) {
                    ModuleDefSchema.this.logger.log(TreeLogger.ERROR, "Property providers must specify a JavaScript body or a provider generator", null);
                    throw new UnableToCompleteException();
                }
            } else {
                int lineNumber = childSchema.getStartLineNumber();
                JsFunction fn = ModuleDefSchema.this.parseJsBlock(lineNumber, script);
                property.setProvider(new PropertyProvider(fn.getBody().toSource()));
            }
        }

        protected Schema __public_begin(String path, String includes, String excludes, String skips, String defaultExcludes, String caseSensitive) {
            this.fChild = new IncludeExcludeSchema();
            return this.fChild;
        }

        protected void __public_end(String path, String includes, String excludes, String skips, String defaultExcludes, String caseSensitive) {
            IncludeExcludeSchema childSchema = (IncludeExcludeSchema)this.fChild;
            ModuleDefSchema.this.foundAnyPublic = true;
            Set<String> includeSet = childSchema.getIncludes();
            this.addDelimitedStringToSet(includes, "[ ,]", includeSet);
            String[] includeList = includeSet.toArray(new String[includeSet.size()]);
            Set<String> excludeSet = childSchema.getExcludes();
            this.addDelimitedStringToSet(excludes, "[ ,]", excludeSet);
            String[] excludeList = excludeSet.toArray(new String[excludeSet.size()]);
            Set<String> skipSet = childSchema.getSkips();
            this.addDelimitedStringToSet(skips, "[ ,]", skipSet);
            String[] skipList = skipSet.toArray(new String[skipSet.size()]);
            boolean doDefaultExcludes = ModuleDefSchema.toPrimitiveBoolean(defaultExcludes);
            boolean doCaseSensitive = ModuleDefSchema.toPrimitiveBoolean(caseSensitive);
            this.addPublicPackage(ModuleDefSchema.this.modulePackageAsPath, path, includeList, excludeList, skipList, doDefaultExcludes, doCaseSensitive);
        }

        protected Schema __replace_with_begin(String className) {
            RuleReplaceWith rule = new RuleReplaceWith(className);
            ModuleDefSchema.this.moduleDef.addRule(rule);
            return new FullConditionSchema(rule.getRootCondition());
        }

        protected Schema __script_begin(String src) {
            this.fChild = new ScriptSchema();
            return this.fChild;
        }

        protected void __script_end(String src) {
            ScriptSchema childSchema = (ScriptSchema)this.fChild;
            String js = childSchema.getScript();
            if (js != null) {
                ModuleDefSchema.this.logger.log(TreeLogger.WARN, "Injected scripts no longer use an associated JavaScript block; ignoring.", null);
            }
            ModuleDefSchema.this.moduleDef.getScripts().append(new Script(src));
        }

        protected Schema __servlet_begin(String path, String servletClass) throws UnableToCompleteException {
            if (!path.startsWith("/")) {
                ModuleDefSchema.this.logger.log(TreeLogger.ERROR, "Servlet path '" + path + "' must begin with forward slash (e.g. '/foo')", null);
                throw new UnableToCompleteException();
            }
            ModuleDefSchema.this.moduleDef.mapServlet(path, servletClass);
            return null;
        }

        protected Schema __set_configuration_property_begin(PropertyName name, String value) throws UnableToCompleteException {
            Property existingProperty = ModuleDefSchema.this.moduleDef.getProperties().find(name.token);
            if (existingProperty == null) {
                existingProperty = ModuleDefSchema.this.moduleDef.getProperties().createConfiguration(name.token, false);
                if (!propertySettings.containsKey(name.token)) {
                    propertySettings.put(name.token, ModuleDefSchema.this.moduleName);
                }
                Messages.UNDEFINED_CONFIGURATION_PROPERTY.log(ModuleDefSchema.this.logger, this.getLineNumber(), name.token, ModuleDefSchema.this.moduleName, null);
            } else if (!(existingProperty instanceof ConfigurationProperty)) {
                if (existingProperty instanceof BindingProperty) {
                    Messages.CONFIGURATION_PROPERTY_REDEFINES_BINDING_PROPERTY.log(ModuleDefSchema.this.logger, this.getLineNumber(), name.token, null);
                } else {
                    Messages.CANNOT_REPLACE_PROPERTY.log(ModuleDefSchema.this.logger, this.getLineNumber(), name.token, existingProperty.getName(), existingProperty.getClass().getName(), null);
                }
                throw new UnableToCompleteException();
            }
            ModuleDefSchema.this.moduleDef.setConfigurationPropertyValue((ConfigurationProperty)existingProperty, value);
            return null;
        }

        protected Schema __set_property_begin(BindingProperty prop, PropertyValue[] value) throws UnableToCompleteException {
            this.bindingPropertyCondition = new ConditionAll(new Condition[0]);
            return new PropertyConditionSchema(this.bindingPropertyCondition);
        }

        protected void __set_property_end(BindingProperty prop, PropertyValue[] value) throws UnableToCompleteException {
            boolean error = false;
            String[] stringValues = new String[value.length];
            int len = stringValues.length;
            for (int i = 0; i < len; ++i) {
                stringValues[i] = value[i].token;
                if (prop.isDefinedValue(stringValues[i])) continue;
                Messages.PROPERTY_VALUE_NOT_VALID.log(ModuleDefSchema.this.logger, this.getLineNumber(), stringValues[i], prop.getName(), null);
                error = true;
            }
            if (error) {
                throw new UnableToCompleteException();
            }
            if (!this.bindingPropertyCondition.getConditions().iterator().hasNext()) {
                this.bindingPropertyCondition = prop.getRootCondition();
            }
            prop.setValues(this.bindingPropertyCondition, stringValues);
        }

        protected Schema __set_property_fallback_begin(BindingProperty prop, PropertyValue value) throws UnableToCompleteException {
            boolean error = true;
            for (String possibleValue : prop.getAllowedValues(prop.getRootCondition())) {
                if (!possibleValue.equals(value.token)) continue;
                error = false;
                break;
            }
            if (error) {
                ModuleDefSchema.this.logger.log(TreeLogger.ERROR, "The fallback value '" + value.token + "' was not previously defined for property '" + prop.getName() + "'");
                throw new UnableToCompleteException();
            }
            prop.setFallback(value.token);
            return null;
        }

        protected Schema __source_begin(String path, String includes, String excludes, String skips, String defaultExcludes, String caseSensitive) {
            this.fChild = new IncludeExcludeSchema();
            return this.fChild;
        }

        protected void __source_end(String path, String includes, String excludes, String skips, String defaultExcludes, String caseSensitive) {
            this.addSourcePackage(path, includes, excludes, skips, defaultExcludes, caseSensitive, false);
        }

        protected Schema __resource_begin(String path) {
            this.addResourcePackage(path);
            return null;
        }

        protected Schema __stylesheet_begin(String src) {
            ModuleDefSchema.this.moduleDef.getStyles().append(src);
            return null;
        }

        protected Schema __super_source_begin(String path, String includes, String excludes, String skips, String defaultExcludes, String caseSensitive) {
            this.fChild = new IncludeExcludeSchema();
            return this.fChild;
        }

        protected void __super_source_end(String path, String includes, String excludes, String skips, String defaultExcludes, String caseSensitive) {
            this.addSourcePackage(path, includes, excludes, skips, defaultExcludes, caseSensitive, true);
        }

        private void addDelimitedStringToSet(String delimited, String delimiter, Set<String> toSet) {
            if (delimited.length() > 0) {
                String[] split = delimited.split(delimiter);
                for (int i = 0; i < split.length; ++i) {
                    if (split[i].length() <= 0) continue;
                    toSet.add(split[i]);
                }
            }
        }

        private void addPublicPackage(String parentDir, String relDir, String[] includeList, String[] excludeList, String[] skipList, boolean defaultExcludes, boolean caseSensitive) {
            String normChildDir = this.normalizePathEntry(relDir);
            if (normChildDir.startsWith("/")) {
                ModuleDefSchema.this.logger.log(TreeLogger.WARN, "Non-relative public package: " + normChildDir, null);
                return;
            }
            if (normChildDir.startsWith("./") || normChildDir.indexOf("/./") >= 0) {
                ModuleDefSchema.this.logger.log(TreeLogger.WARN, "Non-canonical public package: " + normChildDir, null);
                return;
            }
            if (normChildDir.startsWith("../") || normChildDir.indexOf("/../") >= 0) {
                ModuleDefSchema.this.logger.log(TreeLogger.WARN, "Non-canonical public package: " + normChildDir, null);
                return;
            }
            String fullDir = parentDir + normChildDir;
            ModuleDefSchema.this.moduleDef.addPublicPackage(fullDir, includeList, excludeList, skipList, defaultExcludes, caseSensitive);
        }

        private void addResourcePackage(String relDir) {
            ModuleDefSchema.this.moduleDef.addResourcePath(this.normalizePathEntry(ModuleDefSchema.this.modulePackageAsPath + relDir));
        }

        private void addSourcePackage(String relDir, String includes, String excludes, String skips, String defaultExcludes, String caseSensitive, boolean isSuperSource) {
            IncludeExcludeSchema childSchema = (IncludeExcludeSchema)this.fChild;
            ModuleDefSchema.this.foundExplicitSourceOrSuperSource = true;
            Set<String> includeSet = childSchema.getIncludes();
            this.addDelimitedStringToSet(includes, "[ ,]", includeSet);
            String[] includeList = includeSet.toArray(new String[includeSet.size()]);
            Set<String> excludeSet = childSchema.getExcludes();
            this.addDelimitedStringToSet(excludes, "[ ,]", excludeSet);
            String[] excludeList = excludeSet.toArray(new String[excludeSet.size()]);
            Set<String> skipSet = childSchema.getSkips();
            this.addDelimitedStringToSet(skips, "[ ,]", skipSet);
            String[] skipList = skipSet.toArray(new String[skipSet.size()]);
            boolean doDefaultExcludes = ModuleDefSchema.toPrimitiveBoolean(defaultExcludes);
            boolean doCaseSensitive = ModuleDefSchema.toPrimitiveBoolean(caseSensitive);
            this.addSourcePackage(ModuleDefSchema.this.modulePackageAsPath, relDir, includeList, excludeList, skipList, doDefaultExcludes, doCaseSensitive, isSuperSource);
        }

        private void addSourcePackage(String modulePackagePath, String relDir, String[] includeList, String[] excludeList, String[] skipList, boolean defaultExcludes, boolean caseSensitive, boolean isSuperSource) {
            String normChildDir = this.normalizePathEntry(relDir);
            if (normChildDir.startsWith("/")) {
                ModuleDefSchema.this.logger.log(TreeLogger.WARN, "Non-relative source package: " + normChildDir, null);
                return;
            }
            if (normChildDir.startsWith("./") || normChildDir.indexOf("/./") >= 0) {
                ModuleDefSchema.this.logger.log(TreeLogger.WARN, "Non-canonical source package: " + normChildDir, null);
                return;
            }
            if (normChildDir.startsWith("../") || normChildDir.indexOf("/../") >= 0) {
                ModuleDefSchema.this.logger.log(TreeLogger.WARN, "Non-canonical source package: " + normChildDir, null);
                return;
            }
            String fullPackagePath = modulePackagePath + normChildDir;
            if (isSuperSource) {
                ModuleDefSchema.this.moduleDef.addSuperSourcePackage(fullPackagePath, includeList, excludeList, skipList, defaultExcludes, caseSensitive);
            } else {
                ModuleDefSchema.addPrefix(includeList, fullPackagePath);
                ModuleDefSchema.addPrefix(excludeList, fullPackagePath);
                ModuleDefSchema.addPrefix(skipList, fullPackagePath);
                ModuleDefSchema.this.moduleDef.addSourcePackage(fullPackagePath, includeList, excludeList, skipList, defaultExcludes, caseSensitive);
            }
        }

        private String normalizePathEntry(String path) {
            if ((path = path.trim()).length() == 0) {
                return "";
            }
            if (!(path = path.replace('\\', '/')).endsWith("/")) {
                path = path + "/";
            }
            return path;
        }
    }
}

