/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.cfg;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.dev.cfg.ModuleDef;
import com.google.gwt.dev.cfg.ModuleDefSchema;
import com.google.gwt.dev.cfg.ResourceLoader;
import com.google.gwt.dev.cfg.ResourceLoaders;
import com.google.gwt.dev.util.Util;
import com.google.gwt.dev.util.log.speedtracer.CompilerEventType;
import com.google.gwt.dev.util.log.speedtracer.SpeedTracerLogger;
import com.google.gwt.dev.util.xml.ReflectiveParser;
import com.google.gwt.thirdparty.guava.common.annotations.VisibleForTesting;
import com.google.gwt.thirdparty.guava.common.collect.MapMaker;
import com.google.gwt.thirdparty.guava.common.collect.Maps;
import com.google.gwt.util.tools.Utility;
import java.io.File;
import java.io.Reader;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class ModuleDefLoader {
    public static final String GWT_MODULE_XML_SUFFIX = ".gwt.xml";
    private static final Map<ClassLoader, Map<String, ModuleDef>> loadedModulesCaches = new MapMaker().weakKeys().makeMap();
    private static final Map<String, String> moduleEffectiveNameToPhysicalName = new HashMap<String, String>();
    private final ResourceLoader resourceLoader;

    public static void clearModuleCache() {
        ModuleDefLoader.getModulesCache().clear();
    }

    public static ModuleDef createSyntheticModule(TreeLogger logger, String moduleName, final String[] inherits, boolean refresh) throws UnableToCompleteException {
        ModuleDef moduleDef = ModuleDefLoader.tryGetLoadedModule(moduleName, refresh);
        if (moduleDef != null) {
            return moduleDef;
        }
        ResourceLoader resources = ResourceLoaders.fromContextClassLoader();
        ModuleDefLoader loader = new ModuleDefLoader(resources){

            @Override
            protected void load(TreeLogger logger, String nameOfModuleToLoad, ModuleDef dest) throws UnableToCompleteException {
                logger.log(TreeLogger.TRACE, "Loading module '" + nameOfModuleToLoad + "'");
                for (String inherit : inherits) {
                    this.nestedLoad(logger, inherit, dest);
                }
            }
        };
        ModuleDef module = ModuleDefLoader.doLoadModule(loader, logger, moduleName, resources);
        module.setNameOverride(null);
        return module;
    }

    public static ModuleDef loadFromClassPath(TreeLogger logger, String moduleName) throws UnableToCompleteException {
        return ModuleDefLoader.loadFromClassPath(logger, moduleName, false);
    }

    public static ModuleDef loadFromClassPath(TreeLogger logger, String moduleName, boolean refresh) throws UnableToCompleteException {
        ResourceLoader resources = ResourceLoaders.fromContextClassLoader();
        return ModuleDefLoader.loadFromResources(logger, moduleName, resources, refresh);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ModuleDef loadFromResources(TreeLogger logger, String moduleName, ResourceLoader resources, boolean refresh) throws UnableToCompleteException {
        SpeedTracerLogger.Event moduleDefLoadFromClassPathEvent = SpeedTracerLogger.start(CompilerEventType.MODULE_DEF, "phase", "loadFromClassPath", "moduleName", moduleName);
        try {
            ModuleDef moduleDef;
            String physicalName = moduleEffectiveNameToPhysicalName.get(moduleName);
            if (physicalName != null) {
                moduleName = physicalName;
            }
            if ((moduleDef = ModuleDefLoader.tryGetLoadedModule(moduleName, refresh)) != null) {
                ModuleDef moduleDef2 = moduleDef;
                return moduleDef2;
            }
            ModuleDefLoader loader = new ModuleDefLoader(resources);
            ModuleDef moduleDef3 = ModuleDefLoader.doLoadModule(loader, logger, moduleName, resources, true, true);
            return moduleDef3;
        }
        finally {
            moduleDefLoadFromClassPathEvent.end(new String[0]);
        }
    }

    private static ModuleDef doLoadModule(ModuleDefLoader loader, TreeLogger logger, String moduleName, ResourceLoader resources) throws UnableToCompleteException {
        return ModuleDefLoader.doLoadModule(loader, logger, moduleName, resources, true, true);
    }

    private static ModuleDef doLoadModule(ModuleDefLoader loader, TreeLogger logger, String moduleName, ResourceLoader resources, boolean monolithic, boolean mergePathPrefixes) throws UnableToCompleteException {
        ModuleDef moduleDef = new ModuleDef(moduleName, resources, monolithic, mergePathPrefixes);
        SpeedTracerLogger.Event moduleLoadEvent = SpeedTracerLogger.start(CompilerEventType.MODULE_DEF, "phase", "strategy.load()");
        loader.load(logger, moduleName, moduleDef);
        moduleLoadEvent.end(new String[0]);
        SpeedTracerLogger.Event moduleNormalizeEvent = SpeedTracerLogger.start(CompilerEventType.MODULE_DEF, "phase", "moduleDef.normalize()");
        moduleDef.normalize(logger);
        moduleNormalizeEvent.end(new String[0]);
        ModuleDefLoader.getModulesCache().put(moduleName, moduleDef);
        moduleEffectiveNameToPhysicalName.put(moduleDef.getName(), moduleName);
        return moduleDef;
    }

    static Map<String, ModuleDef> getModulesCache() {
        ClassLoader keyClassLoader = Thread.currentThread().getContextClassLoader();
        Map<String, ModuleDef> cache = loadedModulesCaches.get(keyClassLoader);
        if (cache == null) {
            cache = Maps.newHashMap();
            loadedModulesCaches.put(keyClassLoader, cache);
        }
        return cache;
    }

    private static ModuleDef tryGetLoadedModule(String moduleName, boolean refresh) {
        ModuleDef moduleDef = ModuleDefLoader.getModulesCache().get(moduleName);
        if (moduleDef == null || moduleDef.isGwtXmlFileStale()) {
            return null;
        }
        if (refresh) {
            moduleDef.refresh();
        }
        return moduleDef;
    }

    private ModuleDefLoader(ResourceLoader loader) {
        this.resourceLoader = loader;
    }

    protected void load(TreeLogger logger, String nameOfModuleToLoad, ModuleDef dest) throws UnableToCompleteException {
        this.nestedLoad(logger, nameOfModuleToLoad, dest);
    }

    void nestedLoad(TreeLogger parentLogger, String moduleName, ModuleDef moduleDef) throws UnableToCompleteException {
        if (moduleDef.isInherited(moduleName)) {
            return;
        }
        TreeLogger logger = parentLogger.branch(TreeLogger.DEBUG, "Loading inherited module '" + moduleName + "'", null);
        if (!ModuleDef.isValidModuleName(moduleName)) {
            logger.log(TreeLogger.ERROR, "Invalid module name: '" + moduleName + "'", null);
            throw new UnableToCompleteException();
        }
        moduleDef.addInheritedModules(moduleName);
        String slashedModuleName = moduleName.replace('.', '/');
        String resName = slashedModuleName + GWT_MODULE_XML_SUFFIX;
        URL moduleURL = this.resourceLoader.getResource(resName);
        if (moduleURL != null) {
            moduleDef.recordModuleGwtXmlFile(moduleName, moduleURL.getPath());
            String externalForm = moduleURL.toExternalForm();
            if (logger.isLoggable(TreeLogger.DEBUG)) {
                logger.log(TreeLogger.DEBUG, "Module location: " + externalForm, null);
            }
            try {
                if (!(externalForm.startsWith("jar:file") || externalForm.startsWith("zip:file") || externalForm.startsWith("http://") || externalForm.startsWith("ftp://"))) {
                    moduleDef.addGwtXmlFile(new File(moduleURL.toURI()));
                }
            }
            catch (URISyntaxException e) {
                logger.log(TreeLogger.ERROR, "Error parsing URI", e);
                throw new UnableToCompleteException();
            }
        }
        if (moduleURL == null) {
            logger.log(TreeLogger.ERROR, ModuleDefLoader.formatUnableToFindModuleMessage(resName));
            throw new UnableToCompleteException();
        }
        String moduleDir = "";
        int i = slashedModuleName.lastIndexOf(47);
        if (i != -1) {
            moduleDir = slashedModuleName.substring(0, i) + "/";
        }
        Reader r = null;
        try {
            r = Util.createReader(logger, moduleURL);
            ModuleDefSchema schema = new ModuleDefSchema(logger, this, moduleName, moduleURL, moduleDir, moduleDef);
            ReflectiveParser.parse(logger, schema, r);
        }
        catch (UnableToCompleteException e) {
            throw e;
        }
        catch (Throwable e) {
            logger.log(TreeLogger.ERROR, "Unexpected error while processing XML", e);
            throw new UnableToCompleteException();
        }
        finally {
            Utility.close(r);
        }
    }

    @VisibleForTesting
    public static String formatUnableToFindModuleMessage(String moduleResourcePath) {
        return "Unable to find '" + moduleResourcePath + "' on your classpath; could be a typo, or maybe you forgot to include a classpath entry for source?";
    }
}

