/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.cfg;

import com.google.gwt.core.ext.Linker;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.linker.LinkerOrder;
import com.google.gwt.core.ext.typeinfo.TypeOracle;
import com.google.gwt.dev.CompilerContext;
import com.google.gwt.dev.cfg.BindingProperty;
import com.google.gwt.dev.cfg.ConfigurationProperty;
import com.google.gwt.dev.cfg.DepsInfoProvider;
import com.google.gwt.dev.cfg.Messages;
import com.google.gwt.dev.cfg.Properties;
import com.google.gwt.dev.cfg.PropertyProvider;
import com.google.gwt.dev.cfg.ResourceLoader;
import com.google.gwt.dev.cfg.ResourceLoaders;
import com.google.gwt.dev.cfg.Rule;
import com.google.gwt.dev.cfg.RuleGenerateWith;
import com.google.gwt.dev.cfg.Scripts;
import com.google.gwt.dev.cfg.Styles;
import com.google.gwt.dev.javac.CompilationProblemReporter;
import com.google.gwt.dev.javac.CompilationState;
import com.google.gwt.dev.javac.CompilationStateBuilder;
import com.google.gwt.dev.resource.Resource;
import com.google.gwt.dev.resource.ResourceOracle;
import com.google.gwt.dev.resource.impl.DefaultFilters;
import com.google.gwt.dev.resource.impl.PathPrefix;
import com.google.gwt.dev.resource.impl.PathPrefixSet;
import com.google.gwt.dev.resource.impl.ResourceFilter;
import com.google.gwt.dev.resource.impl.ResourceOracleImpl;
import com.google.gwt.dev.util.Empty;
import com.google.gwt.dev.util.Util;
import com.google.gwt.dev.util.log.speedtracer.CompilerEventType;
import com.google.gwt.dev.util.log.speedtracer.SpeedTracerLogger;
import com.google.gwt.thirdparty.guava.common.base.Charsets;
import com.google.gwt.thirdparty.guava.common.base.Predicates;
import com.google.gwt.thirdparty.guava.common.collect.ImmutableList;
import com.google.gwt.thirdparty.guava.common.collect.Iterators;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import com.google.gwt.thirdparty.guava.common.collect.Maps;
import com.google.gwt.thirdparty.guava.common.collect.Sets;
import java.io.File;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ModuleDef
implements DepsInfoProvider {
    public static final String EMBED_SOURCE_MAPS = "compiler.embedSourceMaps";
    private static final ResourceFilter NON_JAVA_RESOURCES = new ResourceFilter(){

        @Override
        public boolean allows(String path) {
            return !path.endsWith(".java") && !path.endsWith(".class");
        }
    };
    private static final Comparator<Map.Entry<String, ?>> REV_NAME_CMP = new Comparator<Map.Entry<String, ?>>(){

        @Override
        public int compare(Map.Entry<String, ?> entry1, Map.Entry<String, ?> entry2) {
            String key1 = entry1.getKey();
            String key2 = entry2.getKey();
            return key2.compareTo(key1);
        }
    };
    protected ResourceOracleImpl lazyPublicOracle;
    private final Set<String> activeLinkers = new LinkedHashSet<String>();
    private String activePrimaryLinker;
    private boolean collapseAllProperties;
    private final DefaultFilters defaultFilters;
    private final List<String> entryPointTypeNames = new ArrayList<String>();
    private final Deque<String> currentLibraryModuleNames = Lists.newLinkedList();
    private final Set<File> gwtXmlFiles = new HashSet<File>();
    private final Set<String> inheritedModules = new HashSet<String>();
    private ResourceOracleImpl lazyResourcesOracle;
    private ResourceOracleImpl lazySourceOracle;
    private final Map<String, Class<? extends Linker>> linkerTypesByName = new LinkedHashMap<String, Class<? extends Linker>>();
    private final long moduleDefCreationTime = System.currentTimeMillis();
    private final String name;
    private String nameOverride;
    private final Properties properties = new Properties();
    private PathPrefixSet publicPrefixSet = new PathPrefixSet();
    private Set<PathPrefix> resourcePrefixes = Sets.newHashSet();
    private final ResourceLoader resources;
    private boolean resourcesScanned;
    private final Deque<Rule> rules = Lists.newLinkedList();
    private final Scripts scripts = new Scripts();
    private final Map<String, String> servletClassNamesByPath = new HashMap<String, String>();
    private final PathPrefixSet sourcePrefixSet;
    private final Styles styles = new Styles();
    private Map<String, String> gwtXmlPathByModuleName = Maps.newHashMap();

    public static boolean isValidModuleName(String moduleName) {
        if (moduleName.contains("..")) {
            return false;
        }
        String[] parts = moduleName.split("\\.");
        for (int i = 0; i < parts.length - 1; ++i) {
            String part = parts[i];
            if (Util.isValidJavaIdent(part)) continue;
            return false;
        }
        return true;
    }

    public ModuleDef(String name) {
        this(name, ResourceLoaders.fromContextClassLoader());
    }

    public ModuleDef(String name, ResourceLoader resources) {
        this(name, resources, true, true);
    }

    public ModuleDef(String name, ResourceLoader resources, boolean monolithic, boolean mergePathPrefixes) {
        this.name = name;
        this.resources = resources;
        this.sourcePrefixSet = new PathPrefixSet(mergePathPrefixes);
        this.defaultFilters = new DefaultFilters();
    }

    public synchronized void addEntryPointTypeName(String typeName) {
        this.entryPointTypeNames.add(typeName);
    }

    public void addGwtXmlFile(File xmlFile) {
        this.gwtXmlFiles.add(xmlFile);
    }

    public void addLinker(String name) {
        Class<? extends Linker> clazz = this.getLinker(name);
        assert (clazz != null);
        LinkerOrder order = clazz.getAnnotation(LinkerOrder.class);
        if (order.value() == LinkerOrder.Order.PRIMARY) {
            if (this.activePrimaryLinker != null) {
                this.activeLinkers.remove(this.activePrimaryLinker);
            }
            this.activePrimaryLinker = name;
        }
        this.activeLinkers.add(name);
    }

    public synchronized void addPublicPackage(String publicPackage, String[] includeList, String[] excludeList, String[] skipList, boolean defaultExcludes, boolean caseSensitive) {
        if (this.lazyPublicOracle != null) {
            throw new IllegalStateException("Already normalized");
        }
        this.publicPrefixSet.add(new PathPrefix(this.getCurrentLibraryModuleName(), publicPackage, this.defaultFilters.customResourceFilter(includeList, excludeList, skipList, defaultExcludes, caseSensitive), true, excludeList));
    }

    public void addResourcePath(String resourcePath) {
        if (this.lazyResourcesOracle != null) {
            throw new IllegalStateException("Already normalized");
        }
        this.resourcePrefixes.add(new PathPrefix(this.getCurrentLibraryModuleName(), resourcePath, NON_JAVA_RESOURCES, false, null));
    }

    public void addRule(Rule rule) {
        this.getRules().addFirst(rule);
    }

    public void addSourcePackage(String sourcePackage, String[] includeList, String[] excludeList, String[] skipList, boolean defaultExcludes, boolean caseSensitive) {
        this.addSourcePackageImpl(sourcePackage, includeList, excludeList, skipList, defaultExcludes, caseSensitive, false);
    }

    public void addSourcePackageImpl(String sourcePackage, String[] includeList, String[] excludeList, String[] skipList, boolean defaultExcludes, boolean caseSensitive, boolean isSuperSource) {
        if (this.lazySourceOracle != null) {
            throw new IllegalStateException("Already normalized");
        }
        PathPrefix pathPrefix = new PathPrefix(this.getCurrentLibraryModuleName(), sourcePackage, this.defaultFilters.customJavaFilter(includeList, excludeList, skipList, defaultExcludes, caseSensitive), isSuperSource, excludeList);
        this.sourcePrefixSet.add(pathPrefix);
    }

    public void addSuperSourcePackage(String superSourcePackage, String[] includeList, String[] excludeList, String[] skipList, boolean defaultExcludes, boolean caseSensitive) {
        this.addSourcePackageImpl(superSourcePackage, includeList, excludeList, skipList, defaultExcludes, caseSensitive, true);
    }

    public void clearEntryPoints() {
        this.entryPointTypeNames.clear();
    }

    public boolean deactivateLinker(String linkerName) {
        return this.activeLinkers.remove(linkerName);
    }

    public void defineLinker(TreeLogger logger, String name, Class<? extends Linker> linker) throws UnableToCompleteException {
        Class<? extends Linker> old = this.getLinker(name);
        if (old != null) {
            if (this.activePrimaryLinker.equals(name)) {
                if (!linker.getAnnotation(LinkerOrder.class).value().equals((Object)LinkerOrder.Order.PRIMARY)) {
                    logger.log(TreeLogger.ERROR, "Redefining primary linker " + name + " with non-primary implementation " + linker.getName());
                    throw new UnableToCompleteException();
                }
            } else if (this.activeLinkers.contains(name) && linker.getAnnotation(LinkerOrder.class).value().equals((Object)LinkerOrder.Order.PRIMARY)) {
                logger.log(TreeLogger.ERROR, "Redefining non-primary linker " + name + " with primary implementation " + linker.getName());
                throw new UnableToCompleteException();
            }
        }
        this.linkerTypesByName.put(name, linker);
    }

    public void enterModule(String canonicalModuleName) {
        this.currentLibraryModuleNames.push(canonicalModuleName);
    }

    public void exitModule() {
        this.currentLibraryModuleNames.pop();
    }

    public synchronized Resource findPublicFile(String partialPath) {
        this.ensureResourcesScanned();
        return this.lazyPublicOracle.getResource(partialPath);
    }

    public synchronized String findServletForPath(String actual) {
        Set<Map.Entry<String, String>> entrySet = this.servletClassNamesByPath.entrySet();
        Map.Entry<String, String>[] entries = Util.toArray(Map.Entry.class, entrySet);
        Arrays.sort(entries, REV_NAME_CMP);
        int n = entries.length;
        for (int i = 0; i < n; ++i) {
            String mapping = entries[i].getKey();
            if (!actual.equals(mapping) && !actual.startsWith(mapping + "/")) continue;
            return entries[i].getValue();
        }
        return null;
    }

    public synchronized Resource findSourceFile(String partialPath) {
        this.ensureResourcesScanned();
        return this.lazySourceOracle.getResource(partialPath);
    }

    public Set<String> getActiveLinkerNames() {
        return new LinkedHashSet<String>(this.activeLinkers);
    }

    public Set<Class<? extends Linker>> getActiveLinkers() {
        LinkedHashSet<Class<? extends Linker>> toReturn = new LinkedHashSet<Class<? extends Linker>>();
        for (String linker : this.activeLinkers) {
            assert (this.linkerTypesByName.containsKey(linker)) : linker;
            toReturn.add(this.linkerTypesByName.get(linker));
        }
        return toReturn;
    }

    public Class<? extends Linker> getActivePrimaryLinker() {
        assert (this.linkerTypesByName.containsKey(this.activePrimaryLinker)) : this.activePrimaryLinker;
        return this.linkerTypesByName.get(this.activePrimaryLinker);
    }

    public String[] getAllSourceFiles() {
        this.ensureResourcesScanned();
        return this.lazySourceOracle.getPathNames().toArray(Empty.STRINGS);
    }

    public synchronized ResourceOracle getBuildResourceOracle() {
        if (this.lazyResourcesOracle == null) {
            this.lazyResourcesOracle = new ResourceOracleImpl(TreeLogger.NULL, this.resources);
            PathPrefixSet pathPrefixes = this.lazySourceOracle.getPathPrefixes();
            PathPrefixSet newPathPrefixes = new PathPrefixSet();
            for (PathPrefix pathPrefix : pathPrefixes.values()) {
                newPathPrefixes.add(new PathPrefix(pathPrefix.getModuleName(), pathPrefix.getPrefix(), NON_JAVA_RESOURCES, pathPrefix.shouldReroot(), null));
            }
            for (PathPrefix resourcePathPrefix : this.resourcePrefixes) {
                newPathPrefixes.add(resourcePathPrefix);
            }
            this.lazyResourcesOracle.setPathPrefixes(newPathPrefixes);
            this.lazyResourcesOracle.scanResources(TreeLogger.NULL);
        } else {
            this.ensureResourcesScanned();
        }
        return this.lazyResourcesOracle;
    }

    public String getCanonicalName() {
        return this.name;
    }

    public CompilationState getCompilationState(TreeLogger logger, CompilerContext compilerContext) throws UnableToCompleteException {
        this.ensureResourcesScanned();
        CompilationState compilationState = CompilationStateBuilder.buildFrom(logger, compilerContext, compilerContext.getSourceResourceOracle().getResources());
        this.checkForSeedTypes(logger, compilationState);
        return compilationState;
    }

    public synchronized String[] getEntryPointTypeNames() {
        int n = this.entryPointTypeNames.size();
        return this.entryPointTypeNames.toArray(new String[n]);
    }

    public synchronized String getFunctionName() {
        return this.getName().replace('.', '_');
    }

    public List<Rule> getGeneratorRules() {
        return ImmutableList.copyOf(Iterators.filter(this.rules.iterator(), Predicates.instanceOf(RuleGenerateWith.class)));
    }

    @Override
    public String getGwtXmlFilePath(String moduleName) {
        return this.gwtXmlPathByModuleName.get(moduleName);
    }

    public int getInputFilenameHash() {
        MessageDigest digest;
        ArrayList<String> filenames = new ArrayList<String>();
        filenames.addAll(this.gwtXmlPathByModuleName.values());
        for (Resource resource : this.getResourcesNewerThan(Integer.MIN_VALUE)) {
            filenames.add(resource.getLocation());
        }
        Collections.sort(filenames);
        try {
            digest = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("SHA-1 unavailable", e);
        }
        for (String filename : filenames) {
            digest.update(filename.getBytes(Charsets.UTF_8));
        }
        byte[] bytes = digest.digest();
        return bytes[0] << 24 | bytes[1] << 16 | bytes[2] << 8 | bytes[3];
    }

    public Class<? extends Linker> getLinker(String name) {
        return this.linkerTypesByName.get(name);
    }

    public Map<String, Class<? extends Linker>> getLinkers() {
        return this.linkerTypesByName;
    }

    public synchronized String getName() {
        return this.nameOverride != null ? this.nameOverride : this.name;
    }

    public synchronized Properties getProperties() {
        return this.properties;
    }

    public ResourceOracleImpl getPublicResourceOracle() {
        this.ensureResourcesScanned();
        return this.lazyPublicOracle;
    }

    public long getResourceLastModified() {
        long resourceLastModified = 1000L;
        HashSet<Resource> allResources = Sets.newHashSet();
        allResources.addAll(this.getPublicResourceOracle().getResources());
        allResources.addAll(this.getSourceResourceOracle().getResources());
        allResources.addAll(this.getBuildResourceOracle().getResources());
        for (Resource resource : allResources) {
            resourceLastModified = Math.max(resourceLastModified, resource.getLastModified());
        }
        return resourceLastModified;
    }

    public Set<Resource> getResourcesNewerThan(long modificationTime) {
        HashSet<Resource> newerResources = Sets.newHashSet();
        for (Resource resource : this.getPublicResourceOracle().getResources()) {
            if (resource.getLastModified() <= modificationTime) continue;
            newerResources.add(resource);
        }
        for (Resource resource : this.getSourceResourceOracle().getResources()) {
            if (resource.getLastModified() <= modificationTime) continue;
            newerResources.add(resource);
        }
        for (Resource resource : this.getBuildResourceOracle().getResources()) {
            if (resource.getLastModified() <= modificationTime) continue;
            newerResources.add(resource);
        }
        return newerResources;
    }

    public synchronized Deque<Rule> getRules() {
        return this.rules;
    }

    public Scripts getScripts() {
        return this.scripts;
    }

    public synchronized String[] getServletPaths() {
        return this.servletClassNamesByPath.keySet().toArray(Empty.STRINGS);
    }

    @Override
    public Set<String> getSourceModuleNames(String typeSourceName) {
        this.ensureResourcesScanned();
        return this.lazySourceOracle.getSourceModulesByTypeSourceName().get((Object)typeSourceName);
    }

    public synchronized ResourceOracle getSourceResourceOracle() {
        this.ensureResourcesScanned();
        return this.lazySourceOracle;
    }

    public Styles getStyles() {
        return this.styles;
    }

    public boolean isGwtXmlFileStale() {
        return this.lastModified() > this.moduleDefCreationTime;
    }

    public boolean isInherited(String moduleName) {
        return this.inheritedModules.contains(moduleName);
    }

    public long lastModified() {
        long lastModified = 0L;
        for (File xmlFile : this.gwtXmlFiles) {
            if (!xmlFile.exists()) continue;
            lastModified = Math.max(lastModified, xmlFile.lastModified());
        }
        return lastModified > 0L ? lastModified : this.moduleDefCreationTime;
    }

    public synchronized void mapServlet(String path, String servletClassName) {
        this.servletClassNamesByPath.put(path, servletClassName);
    }

    public void recordModuleGwtXmlFile(String moduleName, String fileSourcePath) {
        this.gwtXmlPathByModuleName.put(moduleName, fileSourcePath);
    }

    public synchronized void refresh() {
        this.resourcesScanned = false;
    }

    public void setCollapseAllProperties(boolean collapse) {
        this.collapseAllProperties = collapse;
    }

    public synchronized void setNameOverride(String nameOverride) {
        this.nameOverride = nameOverride;
    }

    public boolean shouldEmbedSourceMapContents() {
        return this.getProperties().getConfigurationProperties().stream().filter(configurationProperty -> EMBED_SOURCE_MAPS.equals(configurationProperty.getName())).findFirst().map(configurationProperty -> Boolean.valueOf(configurationProperty.getValue())).orElse(false);
    }

    void addBindingPropertyDefinedValue(BindingProperty bindingProperty, String token) {
        bindingProperty.addDefinedValue(bindingProperty.getRootCondition(), token);
    }

    void addConfigurationPropertyValue(ConfigurationProperty configurationProperty, String value) {
        configurationProperty.addValue(value);
    }

    void addInheritedModules(String moduleName) {
        this.inheritedModules.add(moduleName);
    }

    synchronized void normalize(TreeLogger logger) {
        SpeedTracerLogger.Event moduleDefNormalize = SpeedTracerLogger.start(CompilerEventType.MODULE_DEF, "phase", "normalize");
        for (BindingProperty prop : this.properties.getBindingProperties()) {
            if (this.collapseAllProperties) {
                prop.addCollapsedValues("*");
            }
            prop.normalizeCollapsedValues();
            if (prop.getProvider() != null || prop.getConstrainedValue() != null) continue;
            String src = "{";
            src = src + "return __gwt_getMetaProperty(\"";
            src = src + prop.getName();
            src = src + "\"); }";
            prop.setProvider(new PropertyProvider(src));
        }
        TreeLogger branch = Messages.PUBLIC_PATH_LOCATIONS.branch(logger, null);
        this.lazyPublicOracle = new ResourceOracleImpl(branch, this.resources);
        this.lazyPublicOracle.setPathPrefixes(this.publicPrefixSet);
        branch = Messages.SOURCE_PATH_LOCATIONS.branch(logger, null);
        this.lazySourceOracle = new ResourceOracleImpl(branch, this.resources);
        this.lazySourceOracle.setPathPrefixes(this.sourcePrefixSet);
        moduleDefNormalize.end(new String[0]);
    }

    void setConfigurationPropertyValue(ConfigurationProperty configurationProperty, String value) {
        configurationProperty.setValue(value);
    }

    private void checkForSeedTypes(TreeLogger logger, CompilationState compilationState) throws UnableToCompleteException {
        boolean seedTypesMissing = false;
        com.google.gwt.dev.javac.typemodel.TypeOracle typeOracle = compilationState.getTypeOracle();
        if (((TypeOracle)typeOracle).findType("java.lang.Object") == null) {
            CompilationProblemReporter.logErrorTrace(logger, TreeLogger.ERROR, compilationState.getCompilerContext(), "java.lang.Object", true);
            seedTypesMissing = true;
        } else {
            TreeLogger branch = logger.branch(TreeLogger.TRACE, "Finding entry point classes", null);
            String[] typeNames = this.getEntryPointTypeNames();
            for (int i = 0; i < typeNames.length; ++i) {
                String typeName = typeNames[i];
                if (((TypeOracle)typeOracle).findType(typeName) != null) continue;
                CompilationProblemReporter.logErrorTrace(branch, TreeLogger.ERROR, compilationState.getCompilerContext(), typeName, true);
                seedTypesMissing = true;
            }
        }
        if (seedTypesMissing) {
            throw new UnableToCompleteException();
        }
    }

    private synchronized void ensureResourcesScanned() {
        if (this.resourcesScanned) {
            return;
        }
        this.resourcesScanned = true;
        SpeedTracerLogger.Event moduleDefEvent = SpeedTracerLogger.start(CompilerEventType.MODULE_DEF, "phase", "refresh", "module", this.getName());
        if (this.lazyResourcesOracle != null) {
            this.lazyResourcesOracle.scanResources(TreeLogger.NULL);
        }
        this.lazyPublicOracle.scanResources(TreeLogger.NULL);
        this.lazySourceOracle.scanResources(TreeLogger.NULL);
        moduleDefEvent.end(new String[0]);
    }

    private String getCurrentLibraryModuleName() {
        return this.currentLibraryModuleNames.isEmpty() ? "" : this.currentLibraryModuleNames.peek();
    }
}

