/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.cfg;

import com.google.gwt.dev.cfg.Property;
import com.google.gwt.thirdparty.guava.common.base.Objects;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ConfigurationProperty
extends Property {
    private final boolean allowMultipleValues;
    private List<String> values = new ArrayList<String>();

    public ConfigurationProperty(String name) {
        this(name, false);
    }

    public ConfigurationProperty(String name, boolean allowMultipleValues) {
        super(name);
        this.allowMultipleValues = allowMultipleValues;
        if (!allowMultipleValues) {
            this.values.add(null);
        }
    }

    public void addValue(String value) {
        if (!this.allowMultipleValues) {
            throw new IllegalStateException("Attempt to add a value to a single-valued ConfigurationProperty");
        }
        this.values.add(value);
    }

    public boolean allowsMultipleValues() {
        return this.allowMultipleValues;
    }

    public void clear() {
        this.values.clear();
    }

    public boolean equals(Object object) {
        if (object instanceof ConfigurationProperty) {
            ConfigurationProperty that = (ConfigurationProperty)object;
            return Objects.equal(this.name, that.name) && Objects.equal(this.allowMultipleValues, that.allowMultipleValues) && Objects.equal(this.values, that.values);
        }
        return false;
    }

    public String getValue() {
        if (this.values.size() != 1) {
            throw new IllegalStateException("size != 1");
        }
        return this.values.get(0);
    }

    public List<String> getValues() {
        return Collections.unmodifiableList(this.values);
    }

    public int hashCode() {
        return Objects.hashCode(this.name, this.allowMultipleValues, this.values);
    }

    public boolean isMultiValued() {
        return this.values.size() > 1;
    }

    public void setValue(String value) {
        if (this.values.size() == 0) {
            this.values.add(value);
        } else {
            this.values.set(0, value);
        }
    }
}

