/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.cfg;

import com.google.gwt.core.ext.BadPropertyValueException;
import com.google.gwt.core.ext.DefaultConfigurationProperty;
import com.google.gwt.dev.cfg.ConfigurationProperty;
import com.google.gwt.dev.cfg.ModuleDef;
import com.google.gwt.thirdparty.guava.common.base.Splitter;
import com.google.gwt.thirdparty.guava.common.collect.ImmutableMap;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ConfigurationProperties
implements Serializable {
    public static final ConfigurationProperties EMPTY = new ConfigurationProperties(Collections.emptyList());
    private static final Splitter SPLIT_ON_COMMAS = Splitter.on(',').omitEmptyStrings().trimResults();
    private final ImmutableMap<String, List<String>> properties;

    public ConfigurationProperties(Iterable<ConfigurationProperty> properties) {
        ImmutableMap.Builder<String, List<String>> builder = ImmutableMap.builder();
        for (ConfigurationProperty property : properties) {
            builder.put(property.getName(), ConfigurationProperties.copyOf(property.getValues()));
        }
        this.properties = builder.build();
    }

    public ConfigurationProperties(ModuleDef def) {
        this(def.getProperties().getConfigurationProperties());
    }

    public ConfigurationProperties(Map<String, List<String>> map) {
        ImmutableMap.Builder<String, List<String>> builder = ImmutableMap.builder();
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            builder.put(entry.getKey(), ConfigurationProperties.copyOf(entry.getValue()));
        }
        this.properties = builder.build();
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        List<String> values = this.getStrings(key);
        if (values.size() != 1 || values.get(0) == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(values.get(0));
    }

    public int getInteger(String key, int defaultValue) {
        List<String> values = this.getStrings(key);
        if (values.size() != 1 || values.get(0) == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(values.get(0));
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public String getString(String key, String defaultValue) {
        List<String> values = this.getStrings(key);
        if (values.size() != 1 || values.get(0) == null) {
            return defaultValue;
        }
        return values.get(0);
    }

    public List<String> getStrings(String key) {
        if (!this.properties.containsKey(key)) {
            return Collections.emptyList();
        }
        return this.properties.get(key);
    }

    public List<String> getCommaSeparatedStrings(String key) {
        ArrayList<String> result = Lists.newArrayList();
        for (String value : this.getStrings(key)) {
            if (value == null) continue;
            result.addAll(SPLIT_ON_COMMAS.splitToList(value));
        }
        return result;
    }

    public boolean isMultiValued(String key) {
        return this.getStrings(key).size() > 1;
    }

    com.google.gwt.core.ext.ConfigurationProperty getConfigurationProperty(String key) throws BadPropertyValueException {
        if (!this.properties.containsKey(key)) {
            throw new BadPropertyValueException(key);
        }
        return new DefaultConfigurationProperty(key, this.properties.get(key));
    }

    private static List<String> copyOf(List<String> values) {
        return Collections.unmodifiableList(Lists.newArrayList(values));
    }
}

