/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.cfg;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.TypeOracle;
import com.google.gwt.dev.cfg.Condition;
import com.google.gwt.dev.cfg.DeferredBindingQuery;
import com.google.gwt.dev.javac.CompilationProblemReporter;
import com.google.gwt.thirdparty.guava.common.base.Objects;

public class ConditionWhenTypeAssignableTo
extends Condition {
    private static boolean warnedMissingValidationJar = false;
    private final String assignableToTypeName;

    public ConditionWhenTypeAssignableTo(String assignableToTypeName) {
        this.assignableToTypeName = assignableToTypeName;
    }

    public boolean equals(Object object) {
        if (object instanceof ConditionWhenTypeAssignableTo) {
            ConditionWhenTypeAssignableTo that = (ConditionWhenTypeAssignableTo)object;
            return Objects.equal(this.assignableToTypeName, that.assignableToTypeName);
        }
        return false;
    }

    public String getAssignableToTypeName() {
        return this.assignableToTypeName;
    }

    public int hashCode() {
        return Objects.hashCode(this.assignableToTypeName);
    }

    public String toString() {
        return "<when-assignable class='" + this.assignableToTypeName + "'/>";
    }

    @Override
    protected boolean doEval(TreeLogger logger, DeferredBindingQuery query) throws UnableToCompleteException {
        String testType;
        TypeOracle typeOracle = query.getTypeOracle();
        JClassType fromType = typeOracle.findType(testType = query.getTestType());
        if (fromType == null) {
            CompilationProblemReporter.logErrorTrace(logger, TreeLogger.ERROR, query.getCompilationState().getCompilerContext(), testType, true);
            throw new UnableToCompleteException();
        }
        JClassType toType = typeOracle.findType(this.assignableToTypeName);
        if (toType == null) {
            TreeLogger.Type level = TreeLogger.WARN;
            if (this.shouldSuppressWarning(logger, this.assignableToTypeName)) {
                level = TreeLogger.DEBUG;
            }
            logger.log(level, "Unknown type '" + this.assignableToTypeName + "' specified in deferred binding rule", null);
            return false;
        }
        return fromType.isAssignableTo(toType);
    }

    @Override
    protected String getEvalAfterMessage(String testType, boolean result) {
        if (result) {
            return "Yes, the requested type was assignable";
        }
        return "No, the requested type was not assignable";
    }

    @Override
    protected String getEvalBeforeMessage(String testType) {
        return this.toString();
    }

    private boolean shouldSuppressWarning(TreeLogger logger, String typeName) {
        if (typeName.startsWith("javax.validation.") || typeName.startsWith("com.google.gwt.validation.") || typeName.startsWith("com.google.gwt.editor.client")) {
            if (!warnedMissingValidationJar) {
                warnedMissingValidationJar = true;
                logger.log(TreeLogger.WARN, "Detected warnings related to '" + typeName + "'.   Are validation-api-<version>.jar and validation-api-<version>-sources.jar on the classpath?");
                logger.log(TreeLogger.INFO, "Specify -logLevel DEBUG to see all errors.");
                return false;
            }
            return true;
        }
        return false;
    }
}

