/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.cfg;

import com.google.gwt.core.ext.BadPropertyValueException;
import com.google.gwt.core.ext.ConfigurationProperty;
import com.google.gwt.core.ext.PropertyOracle;
import com.google.gwt.core.ext.SelectionProperty;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.dev.cfg.Condition;
import com.google.gwt.dev.cfg.DeferredBindingQuery;
import com.google.gwt.dev.util.collect.Sets;
import com.google.gwt.thirdparty.guava.common.base.Objects;
import java.util.List;
import java.util.Set;

public class ConditionWhenPropertyIs
extends Condition {
    private final String propName;
    private final String value;

    public ConditionWhenPropertyIs(String propName, String value) {
        this.propName = propName;
        this.value = value;
    }

    public boolean equals(Object object) {
        if (object instanceof ConditionWhenPropertyIs) {
            ConditionWhenPropertyIs that = (ConditionWhenPropertyIs)object;
            return Objects.equal(this.propName, that.propName) && Objects.equal(this.value, that.value);
        }
        return false;
    }

    @Override
    public Set<String> getRequiredProperties() {
        return Sets.create(this.propName);
    }

    public int hashCode() {
        return Objects.hashCode(this.propName, this.value);
    }

    public String toString() {
        return "<when-property-is name='" + this.propName + "' value='" + this.value + "'/>";
    }

    @Override
    protected boolean doEval(TreeLogger logger, DeferredBindingQuery query) throws UnableToCompleteException {
        PropertyOracle propertyOracle = query.getPropertyOracle();
        try {
            String testValue;
            try {
                SelectionProperty prop = propertyOracle.getSelectionProperty(logger, this.propName);
                testValue = prop.getCurrentValue();
            }
            catch (BadPropertyValueException e) {
                ConfigurationProperty prop2 = propertyOracle.getConfigurationProperty(this.propName);
                testValue = prop2.getValues().get(0);
            }
            if (logger.isLoggable(TreeLogger.DEBUG)) {
                logger.log(TreeLogger.DEBUG, "Property value is '" + testValue + "'", null);
            }
            if (testValue.equals(this.value)) {
                return true;
            }
            try {
                SelectionProperty prop3 = propertyOracle.getSelectionProperty(logger, this.propName);
                List<? extends Set<String>> fallbackValues = prop3.getFallbackValues(this.value);
                if (fallbackValues != null && fallbackValues.size() > 0) {
                    if (logger.isLoggable(TreeLogger.DEBUG)) {
                        logger.log(TreeLogger.DEBUG, "Property value '" + this.value + "' is the fallback of '" + fallbackValues.toString() + "'", null);
                    }
                    int cost = -1;
                    for (Set<String> set : fallbackValues) {
                        for (String fallbackValue : set) {
                            if (!testValue.equals(fallbackValue)) continue;
                            query.setFallbackEvaluationCost(cost);
                            return false;
                        }
                        --cost;
                    }
                }
            }
            catch (BadPropertyValueException prop3) {
                // empty catch block
            }
            return false;
        }
        catch (BadPropertyValueException e) {
            String msg = "Unable to get value of property '" + this.propName + "'";
            logger.log(TreeLogger.ERROR, msg, e);
            throw new UnableToCompleteException();
        }
    }

    @Override
    protected String getEvalAfterMessage(String testType, boolean result) {
        if (result) {
            return "Yes, the property value matched";
        }
        return "No, the value did not match";
    }

    @Override
    protected String getEvalBeforeMessage(String testType) {
        return this.toString();
    }
}

