/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.cfg;

import com.google.gwt.core.ext.linker.PropertyProviderGenerator;
import com.google.gwt.dev.cfg.Condition;
import com.google.gwt.dev.cfg.ConditionAll;
import com.google.gwt.dev.cfg.Property;
import com.google.gwt.dev.cfg.PropertyProvider;
import com.google.gwt.dev.util.collect.IdentityHashSet;
import com.google.gwt.dev.util.collect.Lists;
import com.google.gwt.dev.util.collect.Sets;
import com.google.gwt.thirdparty.guava.common.base.Objects;
import com.google.gwt.thirdparty.guava.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;

public class BindingProperty
extends Property {
    public static final String GLOB_STAR = "*";
    private static final String EMPTY = "";
    private List<SortedSet<String>> collapsedValues = Lists.create();
    private final SortedSet<String> definedValues = new TreeSet<String>();
    private String fallback = "";
    private HashMap<String, LinkedList<LinkedHashSet<String>>> fallbackValueMap;
    private HashMap<String, LinkedList<String>> fallbackValues = new HashMap();
    private PropertyProvider provider;
    private Class<? extends PropertyProviderGenerator> providerGenerator;
    private final ConditionAll rootCondition = new ConditionAll(new Condition[0]);
    private final ConditionalValues allowedValues = new ConditionalValues(this.rootCondition);
    private final ConditionalValues generatedValues = new ConditionalValues(this.rootCondition);

    public BindingProperty(String name) {
        super(name);
    }

    public void addCollapsedValues(String ... values) {
        for (String value : values) {
            if (value.contains(GLOB_STAR) || this.definedValues.contains(value)) continue;
            throw new IllegalArgumentException("Attempting to collapse unknown value " + value);
        }
        TreeSet<String> temp = new TreeSet<String>(Arrays.asList(values));
        this.collapsedValues = Lists.add(this.collapsedValues, temp);
    }

    public void addDefinedValue(Condition condition, String definedValue) {
        this.definedValues.add(definedValue);
        this.allowedValues.addValue(condition, definedValue);
        this.generatedValues.addValue(condition, definedValue);
    }

    public void addFallbackValue(String value, String fallbackValue) {
        LinkedList<String> values = this.fallbackValues.get(fallbackValue);
        if (values == null) {
            values = new LinkedList();
            this.fallbackValues.put(fallbackValue, values);
        }
        values.addFirst(value);
    }

    public boolean equals(Object object) {
        if (object instanceof BindingProperty) {
            BindingProperty that = (BindingProperty)object;
            return Objects.equal(this.name, that.name) && Objects.equal(this.collapsedValues, that.collapsedValues) && Objects.equal(this.allowedValues, that.allowedValues) && Objects.equal(this.generatedValues, that.generatedValues) && Objects.equal(this.definedValues, that.definedValues) && Objects.equal(this.fallback, that.fallback) && Objects.equal(this.getFallbackValuesMap(), that.getFallbackValuesMap()) && Objects.equal(this.fallbackValues, that.fallbackValues) && Objects.equal(this.provider, that.provider) && Objects.equal(this.providerGenerator, that.providerGenerator) && Objects.equal(this.rootCondition, that.rootCondition);
        }
        return false;
    }

    public String[] getAllowedValues(Condition condition) {
        return this.allowedValues.getValuesAsArray(condition);
    }

    public String[] getGeneratedValues(Condition condition) {
        return this.generatedValues.getValuesAsArray(condition);
    }

    public List<SortedSet<String>> getCollapsedValuesSets() {
        return this.collapsedValues;
    }

    public ImmutableMap<Condition, SortedSet<String>> getConditionalValues() {
        return this.generatedValues.toMap();
    }

    public String getConstrainedValue() {
        if (!this.generatedValues.allConditionsHaveOneValue()) {
            return null;
        }
        Set values = this.generatedValues.getAllValues();
        if (values.size() != 1) {
            return null;
        }
        return (String)values.iterator().next();
    }

    public String[] getDefinedValues() {
        return this.definedValues.toArray(new String[this.definedValues.size()]);
    }

    public String getFallback() {
        return this.fallback;
    }

    public Map<String, ? extends List<? extends Set<String>>> getFallbackValuesMap() {
        if (this.fallbackValueMap == null) {
            HashMap valuesMap = new HashMap();
            for (Map.Entry<String, LinkedList<String>> e : this.fallbackValues.entrySet()) {
                String from = e.getKey();
                LinkedList alternates = new LinkedList();
                valuesMap.put(from, alternates);
                LinkedList<String> childList = this.fallbackValues.get(from);
                LinkedHashSet<String> children = new LinkedHashSet<String>();
                children.addAll(childList);
                while (children != null && children.size() > 0) {
                    alternates.add(children);
                    LinkedHashSet<String> newChildren = new LinkedHashSet<String>();
                    for (String child : children) {
                        childList = this.fallbackValues.get(child);
                        if (null == childList) continue;
                        for (String val : childList) {
                            newChildren.add(val);
                        }
                    }
                    children = newChildren;
                }
            }
            this.fallbackValueMap = valuesMap;
        }
        return this.fallbackValueMap;
    }

    public String getFirstAllowedValue() {
        String value = this.allowedValues.getFirstMember(this.definedValues);
        if (value == null) {
            throw new IllegalStateException("binding property has no allowed values: " + this.name);
        }
        return value;
    }

    public String getFirstGeneratedValue() {
        if (this.definedValues.isEmpty()) {
            return this.fallback;
        }
        String value = this.generatedValues.getFirstMember(this.definedValues);
        if (value == null) {
            throw new IllegalStateException("binding property has no generated values: " + this.name);
        }
        return value;
    }

    public PropertyProvider getProvider() {
        return this.provider;
    }

    public Class<? extends PropertyProviderGenerator> getProviderGenerator() {
        return this.providerGenerator;
    }

    public Set<String> getRequiredProperties() {
        Set<String> toReturn = Sets.create();
        for (Condition cond : this.generatedValues.eachCondition()) {
            toReturn = Sets.addAll(toReturn, cond.getRequiredProperties());
        }
        return toReturn;
    }

    public ConditionAll getRootCondition() {
        return this.rootCondition;
    }

    public int hashCode() {
        return Objects.hashCode(this.name, this.collapsedValues, this.allowedValues, this.definedValues, this.fallback, this.getFallbackValuesMap(), this.fallbackValues, this.provider, this.providerGenerator, this.rootCondition);
    }

    public boolean isDefinedValue(String value) {
        return this.definedValues.contains(value);
    }

    public boolean isAllowedValue(String value) {
        return this.allowedValues.containsValue(value);
    }

    public boolean isGeneratedValue(String value) {
        return this.generatedValues.containsValue(value);
    }

    public boolean isDerived() {
        return this.generatedValues.allConditionsHaveOneValue();
    }

    public void resetGeneratedValues() {
        this.generatedValues.valueMap.clear();
        this.generatedValues.valueMap.putAll(this.allowedValues.valueMap);
    }

    public void setFallback(String token) {
        this.fallback = token;
    }

    public void setProvider(PropertyProvider provider) {
        this.provider = provider;
    }

    public void setProviderGenerator(Class<? extends PropertyProviderGenerator> generator) {
        this.providerGenerator = generator;
    }

    void normalizeCollapsedValues() {
        if (this.collapsedValues.isEmpty()) {
            return;
        }
        for (Set set : this.collapsedValues) {
            StringBuilder pattern = new StringBuilder();
            Iterator it = set.iterator();
            while (it.hasNext()) {
                String string = (String)it.next();
                if (!string.contains(GLOB_STAR)) continue;
                it.remove();
                if (pattern.length() > 0) {
                    pattern.append("|");
                }
                pattern.append("(");
                pattern.append(string.replace(GLOB_STAR, ".*"));
                pattern.append(")");
            }
            if (pattern.length() == 0) continue;
            Pattern p = Pattern.compile(pattern.toString());
            for (String definedValue : this.definedValues) {
                if (!p.matcher(definedValue).matches()) continue;
                set.add(definedValue);
            }
        }
        HashMap<String, SortedSet<String>> map = new HashMap<String, SortedSet<String>>();
        for (SortedSet<String> set : this.collapsedValues) {
            for (String string : new LinkedHashSet<String>(set)) {
                SortedSet existing = (SortedSet)map.get(string);
                if (existing == null) {
                    map.put(string, set);
                    continue;
                }
                set.addAll(existing);
                for (String mergedValue : existing) {
                    map.put(mergedValue, set);
                }
            }
        }
        this.collapsedValues = new ArrayList(new IdentityHashSet(map.values()));
        Lists.sort(this.collapsedValues, new Comparator<SortedSet<String>>(){

            @Override
            public int compare(SortedSet<String> o1, SortedSet<String> o2) {
                String s1 = o1.toString();
                String s2 = o2.toString();
                assert (!s1.equals(s2)) : "Should not have seen equal sets";
                return s1.compareTo(s2);
            }
        });
    }

    public void setValues(Condition bindingPropertyCondition, String ... values) {
        List<String> valueList = Arrays.asList(values);
        this.checkAllDefined(valueList);
        this.allowedValues.putValues(bindingPropertyCondition, valueList);
        this.generatedValues.putValues(bindingPropertyCondition, valueList);
    }

    public void setRootGeneratedValues(String ... values) {
        List<String> valueList = Arrays.asList(values);
        this.checkAllDefined(valueList);
        this.generatedValues.replaceAllValues(valueList);
    }

    private void checkAllDefined(Collection<String> valueList) {
        for (String value : valueList) {
            if (this.definedValues.contains(value)) continue;
            throw new IllegalArgumentException("Attempted to set a binding property to a value that was not previously defined: " + this.name + " = '" + value + "'");
        }
    }

    private static class ConditionalValues
    implements Serializable {
        private final Condition root;
        private final Map<Condition, SortedSet<String>> valueMap = new LinkedHashMap<Condition, SortedSet<String>>();

        private ConditionalValues(Condition root) {
            this.root = root;
            this.valueMap.put(root, new TreeSet());
        }

        private void addValue(Condition condition, String value) {
            SortedSet<String> set = this.valueMap.get(condition);
            if (set == null) {
                set = new TreeSet<String>(this.valueMap.get(this.root));
                this.valueMap.put(condition, set);
            }
            set.add(value);
        }

        private void putValues(Condition condition, Collection<String> values) {
            if (condition == this.root) {
                this.replaceAllValues(values);
            } else {
                this.valueMap.remove(condition);
                this.valueMap.put(condition, new TreeSet<String>(values));
            }
        }

        private void replaceAllValues(Collection<String> rootValues) {
            this.valueMap.clear();
            this.valueMap.put(this.root, new TreeSet<String>(rootValues));
        }

        private ImmutableMap<Condition, SortedSet<String>> toMap() {
            return ImmutableMap.copyOf(this.valueMap);
        }

        private String[] getValuesAsArray(Condition condition) {
            Set values = this.valueMap.get(condition);
            return values.toArray(new String[values.size()]);
        }

        private Iterable<Condition> eachCondition() {
            return this.valueMap.keySet();
        }

        private boolean containsValue(String value) {
            for (Set set : this.valueMap.values()) {
                if (!set.contains(value)) continue;
                return true;
            }
            return false;
        }

        private Set<String> getAllValues() {
            TreeSet<String> result = new TreeSet<String>();
            for (SortedSet<String> valueSet : this.valueMap.values()) {
                result.addAll(valueSet);
            }
            return result;
        }

        private String getFirstMember(Iterable<String> candidates) {
            Set<String> members = this.getAllValues();
            for (String candidate : candidates) {
                if (!members.contains(candidate)) continue;
                return candidate;
            }
            return null;
        }

        private boolean allConditionsHaveOneValue() {
            for (Set set : this.valueMap.values()) {
                if (set.size() == 1) continue;
                return false;
            }
            return true;
        }
    }
}

