/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.cfg;

import com.google.gwt.core.ext.BadPropertyValueException;
import com.google.gwt.core.ext.ConfigurationProperty;
import com.google.gwt.core.ext.DefaultSelectionProperty;
import com.google.gwt.core.ext.PropertyOracle;
import com.google.gwt.core.ext.SelectionProperty;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.dev.cfg.BindingProperty;
import com.google.gwt.dev.cfg.ConfigurationProperties;
import java.io.Serializable;
import java.util.Arrays;
import java.util.TreeSet;

public class BindingProperties
implements Serializable {
    private final ConfigurationProperties configurationProperties;
    private final BindingProperty[] orderedProperties;
    private final String[] orderedPropertyValues;

    public BindingProperties(BindingProperty[] orderedProperties, String[] orderedPropertyValues, ConfigurationProperties configurationProperties) {
        this.orderedProperties = orderedProperties;
        this.orderedPropertyValues = orderedPropertyValues;
        this.configurationProperties = configurationProperties;
        assert (orderedProperties.length == orderedPropertyValues.length);
        int len = orderedProperties.length;
        for (int i = 0; i < len; ++i) {
            BindingProperty prop = orderedProperties[i];
            String value = orderedPropertyValues[i];
            if (prop.isGeneratedValue(value)) continue;
            throw new IllegalArgumentException("Property " + prop.getName() + " cannot have value " + value);
        }
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        String value = this.getString(key, null);
        if (value == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(value);
    }

    public String getString(String key, String defaultValue) {
        for (int i = 0; i < this.orderedProperties.length; ++i) {
            if (!this.orderedProperties[i].getName().equals(key)) continue;
            return this.orderedPropertyValues[i];
        }
        return defaultValue;
    }

    public ConfigurationProperties getConfigurationProperties() {
        return this.configurationProperties;
    }

    public BindingProperty[] getOrderedProps() {
        return this.orderedProperties;
    }

    public String[] getOrderedPropValues() {
        return this.orderedPropertyValues;
    }

    public PropertyOracle toPropertyOracle() {
        return new SoftPropertiesOracle();
    }

    public String prettyPrint() {
        StringBuilder out = new StringBuilder();
        for (BindingProperty property : this.getOrderedProps()) {
            if (out.length() > 0) {
                out.append(",");
            }
            String name = property.getName();
            out.append(name);
            out.append("=");
            out.append(this.getString(name, "(missing)"));
        }
        return out.toString();
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        out.append("SoftProperties(");
        int j = this.orderedProperties.length;
        for (int i = 0; i < j; ++i) {
            if (out.length() > 0) {
                out.append(" ");
            }
            out.append(this.orderedProperties[i].getName());
            out.append(" = ");
            out.append(this.orderedPropertyValues[i]);
        }
        out.append(")");
        return out.toString();
    }

    boolean hasSameBindingProperties(BindingProperties other) {
        if (this.orderedProperties.length != other.orderedProperties.length) {
            return false;
        }
        for (int i = 0; i < this.orderedProperties.length; ++i) {
            if (this.orderedProperties[i] == other.orderedProperties[i]) continue;
            return false;
        }
        return true;
    }

    private class SoftPropertiesOracle
    implements PropertyOracle {
        private SoftPropertiesOracle() {
        }

        @Override
        public ConfigurationProperty getConfigurationProperty(String propertyName) throws BadPropertyValueException {
            return BindingProperties.this.configurationProperties.getConfigurationProperty(propertyName);
        }

        @Override
        public SelectionProperty getSelectionProperty(TreeLogger logger, String propertyName) throws BadPropertyValueException {
            for (int i = 0; i < BindingProperties.this.orderedProperties.length; ++i) {
                BindingProperty prop = BindingProperties.this.orderedProperties[i];
                String name = prop.getName();
                if (!name.equals(propertyName)) continue;
                String value = BindingProperties.this.orderedPropertyValues[i];
                TreeSet<String> possibleValues = new TreeSet<String>(Arrays.asList(prop.getDefinedValues()));
                return new DefaultSelectionProperty(value, prop.getFallback(), name, possibleValues, prop.getFallbackValuesMap());
            }
            throw new BadPropertyValueException(propertyName);
        }
    }
}

