/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.dev.CompilePerms;
import com.google.gwt.dev.CompilerContext;
import com.google.gwt.dev.Permutation;
import com.google.gwt.dev.PermutationWorker;
import com.google.gwt.dev.PermutationWorkerFactory;
import com.google.gwt.dev.TransientWorkerException;
import com.google.gwt.dev.jjs.PermutationResult;
import com.google.gwt.dev.jjs.UnifiedAst;
import com.google.gwt.dev.util.PersistenceBackedObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class ThreadedPermutationWorkerFactory
extends PermutationWorkerFactory {
    public static final String MAX_THREADS_PROPERTY = "gwt.jjs.maxThreads";

    @Override
    public Collection<PermutationWorker> getWorkers(TreeLogger logger, UnifiedAst unifiedAst, int numWorkers) throws UnableToCompleteException {
        logger.log(TreeLogger.SPAM, "Creating ThreadedPermutationWorkers");
        numWorkers = Math.min(numWorkers, Integer.getInteger(MAX_THREADS_PROPERTY, 1));
        if (numWorkers == 0) {
            return Collections.emptyList();
        }
        ArrayList<PermutationWorker> toReturn = new ArrayList<PermutationWorker>(numWorkers);
        for (int i = 0; i < numWorkers; ++i) {
            toReturn.add(new ThreadedPermutationWorker(unifiedAst, i));
        }
        return toReturn;
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    private static class ThreadedPermutationWorker
    implements PermutationWorker {
        private final UnifiedAst ast;
        private final int id;

        public ThreadedPermutationWorker(UnifiedAst ast, int id) {
            this.ast = ast;
            this.id = id;
        }

        @Override
        public void compile(TreeLogger logger, CompilerContext compilerContext, Permutation permutation, PersistenceBackedObject<PermutationResult> resultFile) throws TransientWorkerException, UnableToCompleteException {
            try {
                PermutationResult result = CompilePerms.compile(logger, compilerContext, permutation, this.ast);
                resultFile.set(logger, result);
            }
            catch (OutOfMemoryError e) {
                logger.log(TreeLogger.ERROR, "OutOfMemoryError: Increase heap size or lower gwt.jjs.maxThreads", e);
                throw new UnableToCompleteException();
            }
            catch (StackOverflowError e) {
                logger.log(TreeLogger.ERROR, "StackOverflowError: Increase stack size", e);
                throw new UnableToCompleteException();
            }
        }

        @Override
        public String getName() {
            return "In-process PermutationWorker " + this.id;
        }

        @Override
        public void shutdown() {
        }
    }
}

