/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.dev.DevModeBase;
import com.google.gwt.dev.DevelModeTabKey;
import com.google.gwt.dev.ModuleHandle;
import com.google.gwt.dev.ModulePanel;
import com.google.gwt.dev.ModuleTabPanel;
import com.google.gwt.dev.WebServerPanel;
import com.google.gwt.dev.shell.ShellMainWindow;
import com.google.gwt.dev.ui.DevModeUI;
import com.google.gwt.dev.ui.DoneCallback;
import com.google.gwt.dev.ui.DoneEvent;
import com.google.gwt.dev.ui.RestartServerCallback;
import com.google.gwt.dev.ui.RestartServerEvent;
import com.google.gwt.dev.util.collect.HashMap;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;

public class SwingUI
extends DevModeUI {
    protected static final String PACKAGE_PATH = SwingUI.class.getPackage().getName().replace('.', '/').concat("/shell/");
    private static final Object sessionCounterLock = new Object();
    private static int sessionCounter = 0;
    private final DevModeBase.HostedModeBaseOptions options;
    private final Map<DevelModeTabKey, ModuleTabPanel> tabPanels = new HashMap<DevelModeTabKey, ModuleTabPanel>();
    private ShellMainWindow mainWnd;
    private JFrame frame;
    private JTabbedPane tabs;
    private WebServerPanel webServerLog;
    private TreeLogger topLogger;

    static ImageIcon loadImageIcon(String name) {
        return SwingUI.loadImageIcon(name, true);
    }

    static ImageIcon loadImageIcon(String name, boolean prependPackage) {
        URL url;
        ClassLoader cl = SwingUI.class.getClassLoader();
        if (prependPackage) {
            name = PACKAGE_PATH + name;
        }
        URL uRL = url = name == null ? null : cl.getResource(name);
        if (url != null) {
            ImageIcon image = new ImageIcon(url);
            return image;
        }
        return new ImageIcon();
    }

    public SwingUI(DevModeBase.HostedModeBaseOptions options) {
        this.options = options;
    }

    @Override
    public ModuleHandle getModuleLogger(final String userAgent, final String remoteSocket, final String url, final String tabKey, final String moduleName, final String sessionKey, final String agentTag, final byte[] agentIcon, final TreeLogger.Type logLevel) {
        ModuleHandle handle = this.invokeAndGet(new Callable<ModuleHandle>(){

            @Override
            public ModuleHandle call() throws Exception {
                ModuleTabPanel tabPanel = SwingUI.this.findModuleTab(userAgent, remoteSocket, url, tabKey, moduleName, agentIcon);
                ModulePanel tab = tabPanel.addModuleSession(logLevel, moduleName, sessionKey, SwingUI.this.options.getLogFile(String.format("%s-%s-%d.log", moduleName, agentTag, SwingUI.this.getNextSessionCounter(SwingUI.this.options.getLogDir()))));
                return new SwingModuleHandle(tab);
            }
        });
        TreeLogger logger = handle.getLogger();
        TreeLogger branch = logger.branch(TreeLogger.INFO, "Loading module " + moduleName);
        if (logger.isLoggable(TreeLogger.INFO)) {
            if (url != null) {
                branch.log(TreeLogger.INFO, "Top URL: " + url);
            }
            branch.log(TreeLogger.INFO, "User agent: " + userAgent);
        }
        if (logger.isLoggable(TreeLogger.TRACE)) {
            branch.log(TreeLogger.TRACE, "Remote socket: " + remoteSocket);
        }
        if (branch.isLoggable(TreeLogger.DEBUG)) {
            if (tabKey != null) {
                branch.log(TreeLogger.DEBUG, "Tab key: " + tabKey);
            }
            if (sessionKey != null) {
                branch.log(TreeLogger.DEBUG, "Session key: " + sessionKey);
            }
        }
        return handle;
    }

    @Override
    public TreeLogger getTopLogger() {
        return this.topLogger;
    }

    @Override
    public TreeLogger getWebServerLogger(String serverName, byte[] serverIcon) {
        if (this.webServerLog == null) {
            WebServerPanel.RestartAction restartAction = null;
            final RestartServerCallback callback = (RestartServerCallback)this.getCallback(RestartServerEvent.getType());
            if (callback != null) {
                restartAction = new WebServerPanel.RestartAction(){

                    @Override
                    public void restartServer(TreeLogger logger) {
                        callback.onRestartServer(logger);
                    }
                };
            }
            this.webServerLog = new WebServerPanel(this.options.getPort(), this.getLogLevel(), this.options.getLogFile("webserver.log"), restartAction);
            ImageIcon serverIconImage = null;
            if (serverIcon != null) {
                serverIconImage = new ImageIcon(serverIcon);
            }
            this.tabs.insertTab(serverName, serverIconImage, this.webServerLog, null, 1);
        }
        return this.webServerLog.getLogger();
    }

    @Override
    public void initialize(final TreeLogger.Type logLevel) {
        super.initialize(logLevel);
        this.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                ImageIcon gwtIcon16 = SwingUI.loadImageIcon("icon16.png");
                ImageIcon gwtIcon24 = SwingUI.loadImageIcon("icon24.png");
                ImageIcon gwtIcon32 = SwingUI.loadImageIcon("icon32.png");
                ImageIcon gwtIcon48 = SwingUI.loadImageIcon("icon48.png");
                ImageIcon gwtIcon64 = SwingUI.loadImageIcon("icon64.png");
                ImageIcon gwtIcon128 = SwingUI.loadImageIcon("icon128.png");
                SwingUI.this.frame = new JFrame("GWT Development Mode");
                SwingUI.this.tabs = new JTabbedPane();
                if (SwingUI.this.options.alsoLogToFile()) {
                    SwingUI.this.options.getLogDir().mkdirs();
                }
                SwingUI.this.mainWnd = new ShellMainWindow(logLevel, SwingUI.this.options.getLogFile("main.log"));
                SwingUI.this.topLogger = SwingUI.this.mainWnd.getLogger();
                SwingUI.this.tabs.addTab("Development Mode", gwtIcon24, SwingUI.this.mainWnd, "GWT Development Mode");
                SwingUI.this.frame.getContentPane().add(SwingUI.this.tabs);
                SwingUI.this.frame.setSize(950, 700);
                SwingUI.this.frame.setDefaultCloseOperation(2);
                SwingUI.this.frame.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosed(WindowEvent e) {
                        DoneCallback callback = (DoneCallback)SwingUI.this.getCallback(DoneEvent.getType());
                        if (callback != null) {
                            callback.onDone();
                        }
                    }
                });
                SwingUI.this.setIconImages(SwingUI.this.topLogger, new ImageIcon[]{gwtIcon48, gwtIcon32, gwtIcon64, gwtIcon128, gwtIcon16});
                SwingUI.this.frame.setVisible(true);
            }
        });
        this.maybeInitializeOsXApplication();
    }

    @Override
    public void moduleLoadComplete(final boolean success) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                SwingUI.this.mainWnd.moduleLoadComplete(success);
            }
        });
    }

    @Override
    public void setStartupUrls(final Map<String, URL> urls) {
        this.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                SwingUI.this.mainWnd.setStartupUrls(urls);
            }
        });
    }

    @Override
    public void setWebServerSecure(TreeLogger serverLogger) {
        if (this.webServerLog != null && serverLogger == this.webServerLog.getLogger()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ImageIcon secureIcon = SwingUI.loadImageIcon("secure24.png");
                    SwingUI.this.tabs.setIconAt(1, secureIcon);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getNextSessionCounter(File logdir) {
        Object object = sessionCounterLock;
        synchronized (object) {
            if (sessionCounter == 0 && logdir != null) {
                for (String filename : logdir.list()) {
                    String substring;
                    int number;
                    if (!filename.matches("^[A-Za-z0-9_$]*-[a-z]*-[0-9]*.log$") || (number = Integer.parseInt(substring = filename.substring(filename.lastIndexOf(45) + 1, filename.length() - 4))) <= sessionCounter) continue;
                    sessionCounter = number;
                }
            }
            return ++sessionCounter;
        }
    }

    private ModuleTabPanel findModuleTab(String userAgent, String remoteSocket, String url, String tabKey, String moduleName, byte[] agentIcon) {
        String remoteHost;
        DevelModeTabKey key;
        ModuleTabPanel moduleTabPanel;
        int hostEnd = remoteSocket.indexOf(58);
        if (hostEnd < 0) {
            hostEnd = remoteSocket.length();
        }
        if ((moduleTabPanel = this.tabPanels.get(key = new DevelModeTabKey(userAgent, url, tabKey, remoteHost = remoteSocket.substring(0, hostEnd)))) == null) {
            moduleTabPanel = new ModuleTabPanel(userAgent, remoteSocket, url, agentIcon, new TabPanelCollection(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void addTab(ModuleTabPanel tabPanel, ImageIcon icon, String title, String tooltip) {
                    JTabbedPane jTabbedPane = SwingUI.this.tabs;
                    synchronized (jTabbedPane) {
                        SwingUI.this.tabs.addTab(title, icon, tabPanel, tooltip);
                        SwingUI.this.tabPanels.put(key, tabPanel);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void removeTab(ModuleTabPanel tabPanel) {
                    JTabbedPane jTabbedPane = SwingUI.this.tabs;
                    synchronized (jTabbedPane) {
                        SwingUI.this.tabs.remove(tabPanel);
                        SwingUI.this.tabPanels.remove(key);
                    }
                }
            }, moduleName);
        }
        return moduleTabPanel;
    }

    private <T> T invokeAndGet(Callable<T> callable) {
        FutureTask<T> task = new FutureTask<T>(callable);
        try {
            EventQueue.invokeAndWait(task);
            return task.get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private void invokeAndWait(Runnable runnable) {
        try {
            EventQueue.invokeAndWait(runnable);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Error running on Swing UI thread", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Error running on Swing UI thread", e);
        }
    }

    private void maybeInitializeOsXApplication() {
        Exception ex;
        try {
            Class<?> applicationClass = Class.forName("com.apple.eawt.Application");
            this.topLogger.log(TreeLogger.SPAM, "Got Application class, on OS X");
            Object application = applicationClass.getMethod("getApplication", new Class[0]).invoke(null, new Object[0]);
            assert (application != null) : "application";
            applicationClass.getMethod("removeAboutMenuItem", new Class[0]).invoke(application, new Object[0]);
            applicationClass.getMethod("removePreferencesMenuItem", new Class[0]).invoke(application, new Object[0]);
            applicationClass.getMethod("setDockIconImage", Image.class).invoke(application, SwingUI.loadImageIcon("icon128.png").getImage());
            return;
        }
        catch (ClassNotFoundException e) {
            return;
        }
        catch (RuntimeException e) {
            ex = e;
        }
        catch (IllegalAccessException e) {
            ex = e;
        }
        catch (InvocationTargetException e) {
            ex = e;
        }
        catch (NoSuchMethodException e) {
            ex = e;
        }
        this.topLogger.log(TreeLogger.WARN, "Unable to initialize some OS X UI support", ex);
    }

    private void setIconImages(TreeLogger logger, ImageIcon ... icons) {
        if (icons.length == 0) {
            return;
        }
        Exception caught = null;
        try {
            Method method = this.frame.getClass().getMethod("setIconImages", List.class);
            ArrayList<Image> imageList = new ArrayList<Image>();
            for (ImageIcon icon : icons) {
                Image image = icon.getImage();
                if (image == null) continue;
                imageList.add(image);
            }
            method.invoke((Object)this.frame, imageList);
            return;
        }
        catch (SecurityException e) {
            caught = e;
        }
        catch (IllegalArgumentException e) {
            caught = e;
        }
        catch (NoSuchMethodException e) {
        }
        catch (IllegalAccessException e) {
            caught = e;
        }
        catch (InvocationTargetException e) {
            caught = e;
        }
        if (caught != null) {
            logger.log(TreeLogger.WARN, "Unexpected exception setting icon images", caught);
        }
        this.frame.setIconImage(icons[icons.length - 1].getImage());
    }

    protected static interface TabPanelCollection {
        public void addTab(ModuleTabPanel var1, ImageIcon var2, String var3, String var4);

        public void removeTab(ModuleTabPanel var1);
    }

    protected class SwingModuleHandle
    implements ModuleHandle {
        private final ModulePanel tab;

        public SwingModuleHandle(ModulePanel tab) {
            this.tab = tab;
        }

        @Override
        public TreeLogger getLogger() {
            return this.tab.getLogger();
        }

        public ModulePanel getTab() {
            return this.tab;
        }

        @Override
        public void unload() {
            if (this.tab != null) {
                this.tab.disconnect();
            }
        }
    }
}

