/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev;

import cern.colt.list.IntArrayList;
import cern.colt.map.OpenIntIntHashMap;
import com.google.gwt.dev.jjs.impl.RapidTypeAnalyzer;
import com.google.gwt.dev.util.collect.IntHashMultimap;
import com.google.gwt.dev.util.collect.IntMultimap;
import com.google.gwt.thirdparty.guava.common.annotations.VisibleForTesting;
import com.google.gwt.thirdparty.guava.common.base.Objects;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import com.google.gwt.thirdparty.guava.common.collect.Maps;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class StringAnalyzableTypeEnvironment
implements RapidTypeAnalyzer.AnalyzableTypeEnvironment,
Serializable {
    private final IntMultimap calleeMethodIdsByCallerMethodId = new IntMultimap();
    private final OpenIntIntHashMap enclosingTypeIdByMethodId = new OpenIntIntHashMap();
    private final IntArrayList entryMethodIds = new IntArrayList();
    private final IntMultimap exportedMethodIdsByTypeId = new IntMultimap();
    private final IntMultimap instantiatedTypeIdsByMethodId = new IntMultimap();
    private final IntHashMultimap memberMethodIdsByTypeId = new IntHashMultimap();
    private final Map<String, Integer> methodIdsByName = Maps.newHashMap();
    private final List<String> methodNamesById = Lists.newArrayList();
    private final IntMultimap overidingMethodIdsByOverriddenMethodId = new IntMultimap();
    private final IntHashMultimap overriddenMethodIdsByOverridingMethodId = new IntHashMultimap();
    private final IntHashMultimap staticallyReferencedTypeIdsByMethodId = new IntHashMultimap();
    private final Map<String, Integer> typeIdsByName = Maps.newHashMap();
    private final OpenIntIntHashMap typeIdsWithExportedStaticReferences = new OpenIntIntHashMap();
    private final List<String> typeNamesById = Lists.newArrayList();

    private static void copyCollection(Collection fromCollection, Collection toCollection) {
        toCollection.clear();
        toCollection.addAll(fromCollection);
    }

    private static void copyCollection(IntArrayList fromCollection, IntArrayList toCollection) {
        toCollection.clear();
        toCollection.addAllOf(fromCollection);
    }

    private static void copyMap(Map fromMap, Map toMap) {
        toMap.clear();
        toMap.putAll(fromMap);
    }

    private static void copyMap(OpenIntIntHashMap fromMap, OpenIntIntHashMap toMap) {
        IntArrayList keys = fromMap.keys();
        for (int i = 0; i < keys.size(); ++i) {
            int key = keys.get(i);
            int value = fromMap.get(key);
            toMap.put(key, value);
        }
    }

    private static void copyMultimap(IntMultimap fromMap, IntMultimap toMap) {
        toMap.clear();
        toMap.putAll(fromMap);
    }

    StringAnalyzableTypeEnvironment() {
    }

    @Override
    public IntArrayList getMemberMethodIdsIn(int enclosingTypeId) {
        return this.memberMethodIdsByTypeId.get(enclosingTypeId);
    }

    @Override
    public IntArrayList getMethodIdsCalledBy(int callerMethodId) {
        return this.calleeMethodIdsByCallerMethodId.get(callerMethodId);
    }

    @Override
    public IntArrayList getOverriddenMethodIds(int overridingMethodId) {
        return this.overriddenMethodIdsByOverridingMethodId.get(overridingMethodId);
    }

    @Override
    public IntArrayList getOverridingMethodIds(int overriddenMethodId) {
        return this.overidingMethodIdsByOverriddenMethodId.get(overriddenMethodId);
    }

    @Override
    public IntArrayList getStaticallyReferencedTypeIdsIn(int reachableMethodId) {
        return this.staticallyReferencedTypeIdsByMethodId.get(reachableMethodId);
    }

    @Override
    public IntArrayList getTypeIdsInstantiatedIn(int inMethodId) {
        return this.instantiatedTypeIdsByMethodId.get(inMethodId);
    }

    public void recordExportedMethodInType(String methodName, String typeName) {
        int typeId = this.getTypeIdByName(typeName);
        int methodId = this.getMethodIdByName(methodName);
        this.exportedMethodIdsByTypeId.put(typeId, methodId);
    }

    public void recordExportedStaticReferenceInType(String typeName) {
        int typeId = this.getTypeIdByName(typeName);
        this.typeIdsWithExportedStaticReferences.put(typeId, typeId);
    }

    public void recordMethodCallsMethod(String callerMethodName, String calleeMethodName) {
        this.calleeMethodIdsByCallerMethodId.put(this.getMethodIdByName(callerMethodName), this.getMethodIdByName(calleeMethodName));
    }

    public void recordMethodInstantiatesType(String methodName, String instantiatedTypeName) {
        this.instantiatedTypeIdsByMethodId.put(this.getMethodIdByName(methodName), this.getTypeIdByName(instantiatedTypeName));
    }

    public void recordMethodOverridesMethod(String overriderMethodName, String overriddenMethodName) {
        int overriderMethodId = this.getMethodIdByName(overriderMethodName);
        int overriddenMethodId = this.getMethodIdByName(overriddenMethodName);
        this.overriddenMethodIdsByOverridingMethodId.put(overriderMethodId, overriddenMethodId);
        this.overidingMethodIdsByOverriddenMethodId.put(overriddenMethodId, overriderMethodId);
    }

    public void recordStaticReferenceInMethod(String typeName, String methodName) {
        this.staticallyReferencedTypeIdsByMethodId.put(this.getMethodIdByName(methodName), this.getTypeIdByName(typeName));
    }

    public void recordTypeEnclosesMethod(String enclosingTypeName, String nestedMethodName) {
        int enclosingTypeId = this.getTypeIdByName(enclosingTypeName);
        int nestedMethodId = this.getMethodIdByName(nestedMethodName);
        this.memberMethodIdsByTypeId.put(enclosingTypeId, nestedMethodId);
        this.enclosingTypeIdByMethodId.put(nestedMethodId, enclosingTypeId);
    }

    public void removeControlFlowIndexesFor(String typeName) {
        int typeId = this.getTypeIdByName(typeName);
        this.exportedMethodIdsByTypeId.remove(typeId);
        this.typeIdsWithExportedStaticReferences.removeKey(typeId);
        IntArrayList memberMethodIds = this.memberMethodIdsByTypeId.get(typeId);
        if (memberMethodIds == null) {
            return;
        }
        this.memberMethodIdsByTypeId.remove(typeId);
        for (int i = 0; i < memberMethodIds.size(); ++i) {
            int memberMethodId = memberMethodIds.get(i);
            this.enclosingTypeIdByMethodId.removeKey(memberMethodId);
            this.calleeMethodIdsByCallerMethodId.remove(memberMethodId);
            this.instantiatedTypeIdsByMethodId.remove(memberMethodId);
            IntArrayList overriddenMethodIds = this.overriddenMethodIdsByOverridingMethodId.remove(memberMethodId);
            if (overriddenMethodIds != null) {
                for (int j = 0; j < overriddenMethodIds.size(); ++j) {
                    int overriddenMethodId = overriddenMethodIds.get(j);
                    while (this.overidingMethodIdsByOverriddenMethodId.remove(memberMethodId, overriddenMethodId)) {
                    }
                }
            }
            this.staticallyReferencedTypeIdsByMethodId.remove(memberMethodId);
        }
    }

    public void setEntryMethodNames(List<String> entryMethodNames) {
        this.entryMethodIds.clear();
        for (String entryMethodName : entryMethodNames) {
            this.entryMethodIds.add(this.getMethodIdByName(entryMethodName));
        }
    }

    void copyFrom(StringAnalyzableTypeEnvironment that) {
        StringAnalyzableTypeEnvironment.copyMap(that.typeIdsWithExportedStaticReferences, this.typeIdsWithExportedStaticReferences);
        StringAnalyzableTypeEnvironment.copyMap(that.enclosingTypeIdByMethodId, this.enclosingTypeIdByMethodId);
        StringAnalyzableTypeEnvironment.copyMap(that.methodIdsByName, this.methodIdsByName);
        StringAnalyzableTypeEnvironment.copyMap(that.typeIdsByName, this.typeIdsByName);
        StringAnalyzableTypeEnvironment.copyMultimap(that.memberMethodIdsByTypeId, this.memberMethodIdsByTypeId);
        StringAnalyzableTypeEnvironment.copyMultimap(that.calleeMethodIdsByCallerMethodId, this.calleeMethodIdsByCallerMethodId);
        StringAnalyzableTypeEnvironment.copyMultimap(that.exportedMethodIdsByTypeId, this.exportedMethodIdsByTypeId);
        StringAnalyzableTypeEnvironment.copyMultimap(that.instantiatedTypeIdsByMethodId, this.instantiatedTypeIdsByMethodId);
        StringAnalyzableTypeEnvironment.copyMultimap(that.overidingMethodIdsByOverriddenMethodId, this.overidingMethodIdsByOverriddenMethodId);
        StringAnalyzableTypeEnvironment.copyMultimap(that.overriddenMethodIdsByOverridingMethodId, this.overriddenMethodIdsByOverridingMethodId);
        StringAnalyzableTypeEnvironment.copyMultimap(that.staticallyReferencedTypeIdsByMethodId, this.staticallyReferencedTypeIdsByMethodId);
        StringAnalyzableTypeEnvironment.copyCollection(that.entryMethodIds, this.entryMethodIds);
        StringAnalyzableTypeEnvironment.copyCollection(that.methodNamesById, this.methodNamesById);
        StringAnalyzableTypeEnvironment.copyCollection(that.typeNamesById, this.typeNamesById);
    }

    int getEnclosingTypeId(int memberMethodId) {
        return this.enclosingTypeIdByMethodId.get(memberMethodId);
    }

    IntArrayList getEnclosingTypeIdsOfExportedMethods() {
        return this.exportedMethodIdsByTypeId.keys();
    }

    IntArrayList getEntryMethodIds() {
        return this.entryMethodIds;
    }

    IntArrayList getExportedMemberMethodIdsIn(int enclosingTypeId) {
        return this.exportedMethodIdsByTypeId.get(enclosingTypeId);
    }

    int getMethodIdByName(String methodName) {
        if (this.methodIdsByName.containsKey(methodName)) {
            return this.methodIdsByName.get(methodName);
        }
        int methodId = this.methodNamesById.size();
        this.methodIdsByName.put(methodName, methodId);
        this.methodNamesById.add(methodName);
        return methodId;
    }

    int getTypeIdByName(String typeName) {
        if (this.typeIdsByName.containsKey(typeName)) {
            return this.typeIdsByName.get(typeName);
        }
        int typeId = this.typeNamesById.size();
        this.typeIdsByName.put(typeName, typeId);
        this.typeNamesById.add(typeName);
        return typeId;
    }

    IntArrayList getTypeIdsWithExportedStaticReferences() {
        return this.typeIdsWithExportedStaticReferences.keys();
    }

    String getTypeNameById(int typeId) {
        return this.typeNamesById.get(typeId);
    }

    @VisibleForTesting
    boolean hasSameContent(StringAnalyzableTypeEnvironment that) {
        return Objects.equal(this.calleeMethodIdsByCallerMethodId, that.calleeMethodIdsByCallerMethodId) && Objects.equal(this.memberMethodIdsByTypeId, that.memberMethodIdsByTypeId) && Objects.equal(this.entryMethodIds, that.entryMethodIds) && Objects.equal(this.instantiatedTypeIdsByMethodId, that.instantiatedTypeIdsByMethodId) && Objects.equal(this.overidingMethodIdsByOverriddenMethodId, that.overidingMethodIdsByOverriddenMethodId) && Objects.equal(this.overriddenMethodIdsByOverridingMethodId, that.overriddenMethodIdsByOverridingMethodId) && Objects.equal(this.staticallyReferencedTypeIdsByMethodId, that.staticallyReferencedTypeIdsByMethodId) && Objects.equal(this.enclosingTypeIdByMethodId, that.enclosingTypeIdByMethodId) && Objects.equal(this.exportedMethodIdsByTypeId, that.exportedMethodIdsByTypeId) && Objects.equal(this.typeIdsWithExportedStaticReferences, that.typeIdsWithExportedStaticReferences);
    }
}

