/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.linker.ArtifactSet;
import com.google.gwt.core.ext.linker.EmittedArtifact;
import com.google.gwt.core.linker.SymbolMapsLinker;
import com.google.gwt.dev.Link;
import com.google.gwt.dev.cfg.ResourceLoader;
import com.google.gwt.dev.json.JsonArray;
import com.google.gwt.dev.json.JsonException;
import com.google.gwt.dev.json.JsonObject;
import com.google.gwt.dev.util.OutputFileSet;
import com.google.gwt.thirdparty.guava.common.collect.Sets;
import com.google.gwt.thirdparty.guava.common.io.ByteStreams;
import com.google.gwt.thirdparty.guava.common.io.Resources;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.util.LinkedHashSet;
import java.util.Set;

class SourceSaver {
    SourceSaver() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void save(TreeLogger logger, ArtifactSet artifacts, ResourceLoader loader, Link.LinkOptions options, String modulePrefix, OutputFileSet extraFileSet) throws IOException, UnableToCompleteException {
        OutputFileSet out;
        boolean saveInExtras;
        LinkedHashSet<EmittedArtifact> genFiles = new LinkedHashSet<EmittedArtifact>();
        LinkedHashSet<EmittedArtifact> sourceMaps = new LinkedHashSet<EmittedArtifact>();
        for (EmittedArtifact candidate : artifacts.find(EmittedArtifact.class)) {
            if (candidate.getVisibility() == EmittedArtifact.Visibility.Source) {
                genFiles.add(candidate);
                continue;
            }
            boolean isSourceMap = SymbolMapsLinker.SourceMapArtifact.isSourceMapFile.matcher(candidate.getPartialPath()).find();
            if (!isSourceMap) continue;
            sourceMaps.add(candidate);
        }
        if (sourceMaps.isEmpty()) {
            logger.log(TreeLogger.Type.WARN, "Not saving source because sourcemaps weren't generated. Hint: set compiler.useSourceMaps.");
            return;
        }
        boolean bl = saveInExtras = options.getSaveSourceOutput() == null || options.getSaveSourceOutput().equals(options.getExtraDir());
        if (saveInExtras) {
            out = extraFileSet;
            logger.log(TreeLogger.Type.INFO, "Saving source with extras");
        } else {
            out = Link.chooseOutputFileSet(options.getSaveSourceOutput(), modulePrefix);
            logger.log(TreeLogger.Type.INFO, "Saving source to " + options.getSaveSourceOutput());
        }
        try {
            SourceSaver.copySources(logger, sourceMaps, genFiles, loader, out, "src/");
        }
        finally {
            if (!saveInExtras) {
                out.close();
            }
        }
    }

    private static void copySources(TreeLogger logger, Set<EmittedArtifact> sourceMaps, Set<EmittedArtifact> genFiles, ResourceLoader loader, OutputFileSet dest, String destPrefix) throws UnableToCompleteException {
        Set<String> filesInSourceMap = SourceSaver.getSourcePaths(logger, sourceMaps);
        LinkedHashSet<String> remainingFiles = Sets.newLinkedHashSet();
        for (String path : filesInSourceMap) {
            try {
                if (SourceSaver.copySourceFile(path, loader, dest, destPrefix)) continue;
                remainingFiles.add(path);
            }
            catch (IOException e) {
                logger.log(TreeLogger.Type.ERROR, "Unable to copy source file: " + path, e);
                throw new UnableToCompleteException();
            }
        }
        for (EmittedArtifact candidate : genFiles) {
            if (!remainingFiles.contains(candidate.getPartialPath())) continue;
            SourceSaver.copyGeneratedFile(logger, candidate, dest, destPrefix);
            remainingFiles.remove(candidate.getPartialPath());
        }
        if (!remainingFiles.isEmpty()) {
            logger.log(TreeLogger.Type.WARN, "Unable to find all source code needed by debuggers. " + remainingFiles.size() + " files from sourcemaps weren't found.");
            if (logger.isLoggable(TreeLogger.Type.DEBUG)) {
                TreeLogger missing = logger.branch(TreeLogger.Type.DEBUG, "Missing files:");
                int filesPrinted = 0;
                for (String path : remainingFiles) {
                    if (filesPrinted >= 100) {
                        missing.log(TreeLogger.Type.DEBUG, "(truncated)");
                        break;
                    }
                    missing.log(TreeLogger.Type.DEBUG, path);
                    ++filesPrinted;
                }
            }
        }
    }

    private static Set<String> getSourcePaths(TreeLogger logger, Set<EmittedArtifact> sourceMaps) throws UnableToCompleteException {
        LinkedHashSet<String> sourceFiles = new LinkedHashSet<String>();
        for (EmittedArtifact map : sourceMaps) {
            JsonObject json = SourceSaver.loadSourceMap(logger, map);
            JsonArray sources = json.get("sources").asArray();
            for (int i = 0; i < sources.getLength(); ++i) {
                sourceFiles.add(sources.get(i).asString().getString());
            }
        }
        return sourceFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JsonObject loadSourceMap(TreeLogger logger, EmittedArtifact sourceMap) throws UnableToCompleteException {
        JsonObject json;
        try (InputStream bytes = sourceMap.getContents(logger);){
            json = JsonObject.parse(new InputStreamReader(bytes));
        }
        catch (JsonException e) {
            logger.log(TreeLogger.Type.ERROR, "Unable to parse sourcemap: " + sourceMap.getPartialPath(), e);
            throw new UnableToCompleteException();
        }
        catch (IOException e) {
            logger.log(TreeLogger.Type.ERROR, "Unable to read sourcemap: " + sourceMap.getPartialPath(), e);
            throw new UnableToCompleteException();
        }
        return json;
    }

    private static boolean copySourceFile(String path, ResourceLoader loader, OutputFileSet dest, String destPrefix) throws IOException {
        URL resource = loader.getResource(path);
        if (resource == null) {
            return false;
        }
        try (InputStream resourceAsStream = Resources.asByteSource(resource).openStream();
             OutputStream out = dest.openForWrite(destPrefix + path);){
            ByteStreams.copy(resourceAsStream, out);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyGeneratedFile(TreeLogger log, EmittedArtifact src, OutputFileSet dest, String destPrefix) throws UnableToCompleteException {
        String newPath = destPrefix + src.getPartialPath();
        try (OutputStream out = dest.openForWrite(newPath, src.getLastModified());){
            src.writeTo(log, out);
        }
        catch (IOException e) {
            log.log(TreeLogger.WARN, "Error emitting artifact: " + newPath, e);
        }
    }
}

