/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev;

import com.google.gwt.dev.Disconnectable;
import java.util.HashMap;
import java.util.Map;

final class SessionModule {
    private static final Map<SessionModule, SessionModule> instanceCache = new HashMap<SessionModule, SessionModule>();
    private final Disconnectable modulePanel;
    private final String moduleDisplayName;
    private final String sessionKey;

    public static SessionModule create(String sessionKey, Disconnectable modulePanel, String moduleDisplayName) {
        SessionModule sessionModule = new SessionModule(sessionKey, modulePanel, moduleDisplayName);
        if (instanceCache.containsKey(sessionModule)) {
            return instanceCache.get(sessionModule);
        }
        instanceCache.put(sessionModule, sessionModule);
        return sessionModule;
    }

    private SessionModule(String sessionKey, Disconnectable modulePanel, String moduleDisplayName) {
        if (sessionKey == null) {
            throw new IllegalArgumentException("sessionKey cannot be null");
        }
        if (modulePanel == null) {
            throw new IllegalArgumentException("modulePanel cannot be null");
        }
        if (moduleDisplayName == null) {
            throw new IllegalArgumentException("moduleDisplayName cannot be null");
        }
        this.sessionKey = sessionKey;
        this.modulePanel = modulePanel;
        this.moduleDisplayName = moduleDisplayName;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SessionModule other = (SessionModule)obj;
        return this.sessionKey.equals(other.sessionKey) && this.modulePanel.equals(other.modulePanel) && this.moduleDisplayName.equals(other.moduleDisplayName);
    }

    public String getModuleDisplayName() {
        return this.moduleDisplayName;
    }

    public Disconnectable getModulePanel() {
        return this.modulePanel;
    }

    public String getStringKey() {
        return this.sessionKey + this.moduleDisplayName;
    }

    public int hashCode() {
        return this.sessionKey.hashCode() + 31 * this.moduleDisplayName.hashCode();
    }

    public String toString() {
        return this.moduleDisplayName;
    }
}

