/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev;

import com.google.gwt.util.tools.Utility;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

class ServletWriter {
    Map<String, String> mappings = new LinkedHashMap<String, String>();

    ServletWriter() {
    }

    static void generateMapping(FileWriter xmlWriter, String servletClass, String servletPath) throws IOException {
        String servletName = servletClass.replace('.', '_');
        xmlWriter.write(10);
        xmlWriter.write(ServletWriter.generateServletTag(servletName, servletClass));
        xmlWriter.write(10);
        xmlWriter.write(ServletWriter.generateServletMappingTag(servletName, servletPath));
        xmlWriter.write(10);
    }

    static String generateServletMappingTag(String servletName, String servletPath) {
        StringBuilder sb = new StringBuilder();
        sb.append("<servlet-mapping>\n");
        sb.append("  <servlet-name>" + servletName + "</servlet-name>\n");
        sb.append("  <url-pattern>" + servletPath + "</url-pattern>\n");
        sb.append("</servlet-mapping>");
        return sb.toString();
    }

    static String generateServletTag(String servletName, String servletClass) {
        StringBuilder sb = new StringBuilder();
        sb.append("<servlet>\n");
        sb.append("  <servlet-name>" + servletName + "</servlet-name>\n");
        sb.append("  <servlet-class>" + servletClass + "</servlet-class>\n");
        sb.append("</servlet>");
        return sb.toString();
    }

    public void addMapping(String servletClass, String servletPath) {
        this.mappings.put(servletClass, servletPath);
    }

    public void realize(File webXml) throws IOException {
        if (this.mappings.size() == 0) {
            return;
        }
        webXml.getParentFile().mkdirs();
        FileWriter xmlWriter = new FileWriter(webXml);
        xmlWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        xmlWriter.write("<web-app>\n");
        for (Map.Entry<String, String> entry : this.mappings.entrySet()) {
            String servletClass = entry.getKey();
            String servletPath = entry.getValue();
            String servletName = servletClass.replace('.', '_');
            xmlWriter.write(10);
            xmlWriter.write(ServletWriter.generateServletTag(servletName, servletClass));
            xmlWriter.write(10);
            xmlWriter.write(ServletWriter.generateServletMappingTag(servletName, servletPath));
            xmlWriter.write(10);
        }
        xmlWriter.write("\n</web-app>\n");
        Utility.close(xmlWriter);
    }
}

