/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.dev.ServletWriter;
import com.google.gwt.dev.util.collect.HashSet;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class ServletValidator {
    private final Map<String, Set<String>> classNameToPaths;
    private final Map<String, String> classNameToServletName;

    public static ServletValidator create(TreeLogger logger, File webXml) {
        try {
            return ServletValidator.create(logger, webXml.toURI().toURL());
        }
        catch (MalformedURLException e) {
            logger.log(TreeLogger.WARN, "Unable to process '" + webXml.getAbsolutePath() + "' for servlet validation", e);
            return null;
        }
    }

    public static ServletValidator create(TreeLogger logger, URL webXmlUrl) {
        String webXmlUrlString = webXmlUrl.toExternalForm();
        try {
            TreeLogger branch = logger.branch(TreeLogger.DEBUG, "Parsing " + webXmlUrlString);
            SAXParserFactory fac = SAXParserFactory.newInstance();
            fac.setValidating(false);
            fac.setNamespaceAware(false);
            fac.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            SAXParser parser = fac.newSAXParser();
            parser.getXMLReader().setFeature("http://xml.org/sax/features/validation", false);
            parser.getXMLReader().setFeature("http://xml.org/sax/features/namespaces", false);
            parser.getXMLReader().setFeature("http://xml.org/sax/features/namespace-prefixes", false);
            HashMap<String, String> classNameToServletName = new HashMap<String, String>();
            HashMap servletNameToPaths = new HashMap();
            parser.parse(webXmlUrlString, (DefaultHandler)new WebXmlDataCollector(branch, classNameToServletName, servletNameToPaths));
            HashMap<String, Set<String>> classNameToPaths = new HashMap<String, Set<String>>();
            for (Map.Entry entry : classNameToServletName.entrySet()) {
                classNameToPaths.put((String)entry.getKey(), (Set)servletNameToPaths.get(entry.getValue()));
            }
            return new ServletValidator(classNameToServletName, classNameToPaths);
        }
        catch (Exception e) {
            logger.log(TreeLogger.WARN, "Unable to process '" + webXmlUrlString + "' for servlet validation", e);
            return null;
        }
    }

    static String generateMissingMappingMessage(String servletClass, String servletPath, String servletName) {
        return "Module declares a servlet class '" + servletClass + "' with a mapping to '" + servletPath + "', but the web.xml has no corresponding mapping; please add the following lines to your web.xml:\n" + ServletWriter.generateServletMappingTag(servletName, servletPath);
    }

    static String generateMissingServletMessage(String servletClass, String servletPath) {
        String servletName = ServletValidator.suggestServletName(servletClass);
        return "Module declares a servlet class '" + servletClass + "', but the web.xml has no corresponding declaration; please add the following lines to your web.xml:\n" + ServletWriter.generateServletTag(servletName, servletClass) + "\n" + ServletWriter.generateServletMappingTag(servletName, servletPath);
    }

    static String suggestServletName(String servletClass) {
        int pos = servletClass.lastIndexOf(46);
        String suggest = pos < 0 ? servletClass : servletClass.substring(pos + 1);
        String firstChar = suggest.substring(0, 1).toLowerCase(Locale.ROOT);
        suggest = firstChar + suggest.substring(1);
        return suggest;
    }

    private ServletValidator(Map<String, String> classNameToServletName, Map<String, Set<String>> classNameToPaths) {
        this.classNameToServletName = classNameToServletName;
        this.classNameToPaths = classNameToPaths;
    }

    public void validate(TreeLogger logger, String servletClass, String servletPath) {
        if (this.containsServletClass(servletClass)) {
            if (!this.containsServletMapping(servletClass, servletPath)) {
                String servletName = this.getNameForClass(servletClass);
                assert (servletName != null);
                logger.log(TreeLogger.WARN, ServletValidator.generateMissingMappingMessage(servletClass, servletPath, servletName));
            }
        } else {
            logger.log(TreeLogger.WARN, ServletValidator.generateMissingServletMessage(servletClass, servletPath));
        }
    }

    boolean containsServletClass(String servletClass) {
        return this.classNameToServletName.get(servletClass) != null;
    }

    boolean containsServletMapping(String servletClass, String servletPath) {
        Set<String> paths = this.classNameToPaths.get(servletClass);
        return paths != null && paths.contains(servletPath);
    }

    String getNameForClass(String servletClass) {
        return this.classNameToServletName.get(servletClass);
    }

    private static final class WebXmlDataCollector
    extends DefaultHandler {
        private Set<String> accumulateClasses = new HashSet<String>();
        private Set<String> accumulatePaths = new HashSet<String>();
        private final TreeLogger branch;
        private final Stack<StringBuilder> cdataStack = new Stack();
        private final Map<String, String> classNameToServletName;
        private final ElementStack context = new ElementStack();
        private String currentServletName;
        private String indent = "";
        private final Map<String, Set<String>> servletNameToPaths;

        private WebXmlDataCollector(TreeLogger branch, Map<String, String> classNameToServletName, Map<String, Set<String>> servletNameToPaths) {
            this.branch = branch;
            this.classNameToServletName = classNameToServletName;
            this.servletNameToPaths = servletNameToPaths;
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.cdataStack.peek().append(ch, start, length);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            String cdata = this.cdataStack.pop().toString().trim();
            if (this.context.within("web-app", 0)) {
                if (this.context.within("servlet", 1)) {
                    if (this.context.exactly("servlet-name", 2)) {
                        this.currentServletName = cdata;
                    } else if (this.context.exactly("servlet-class", 2)) {
                        this.accumulateClasses.add(cdata);
                    } else if (this.context.exactly("servlet", 1)) {
                        if (this.currentServletName != null) {
                            for (String className : this.accumulateClasses) {
                                this.classNameToServletName.put(className, this.currentServletName);
                            }
                            this.currentServletName = null;
                        }
                        this.accumulateClasses.clear();
                    }
                } else if (this.context.within("servlet-mapping", 1)) {
                    if (this.context.exactly("servlet-name", 2)) {
                        this.currentServletName = cdata;
                    } else if (this.context.exactly("url-pattern", 2)) {
                        this.accumulatePaths.add(cdata);
                    } else if (this.context.exactly("servlet-mapping", 1)) {
                        if (this.currentServletName != null) {
                            Set<String> servletPaths = this.servletNameToPaths.get(this.currentServletName);
                            if (servletPaths == null) {
                                servletPaths = new HashSet<String>();
                                this.servletNameToPaths.put(this.currentServletName, servletPaths);
                            }
                            servletPaths.addAll(this.accumulatePaths);
                        }
                        this.currentServletName = null;
                        this.accumulatePaths.clear();
                    }
                }
            }
            assert (qName.equals(this.context.peek()));
            this.context.pop();
            if (cdata.length() > 0 && this.branch.isLoggable(TreeLogger.DEBUG)) {
                this.branch.log(TreeLogger.DEBUG, "  characters: " + this.indent + cdata);
            }
            this.indent = this.indent.substring(2);
            if (this.branch.isLoggable(TreeLogger.DEBUG)) {
                this.branch.log(TreeLogger.DEBUG, "  endElement: " + this.indent + qName);
            }
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.context.push(qName);
            this.cdataStack.push(new StringBuilder());
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < attributes.getLength(); ++i) {
                sb.append(' ');
                sb.append(attributes.getQName(i));
                sb.append("=\"");
                sb.append(attributes.getValue(i));
                sb.append('\"');
            }
            if (this.branch.isLoggable(TreeLogger.DEBUG)) {
                this.branch.log(TreeLogger.DEBUG, "startElement: " + this.indent + qName + sb.toString());
            }
            this.indent = this.indent + "  ";
        }

        private static class ElementStack {
            private final Stack<String> stack = new Stack();

            private ElementStack() {
            }

            public boolean exactly(String elementName, int depth) {
                return depth == this.stack.size() - 1 && elementName.equals(this.stack.get(depth));
            }

            public String peek() {
                return this.stack.peek();
            }

            public String pop() {
                return this.stack.pop();
            }

            public void push(String elementName) {
                this.stack.push(elementName);
            }

            public boolean within(String elementName, int depth) {
                return depth < this.stack.size() && elementName.equals(this.stack.get(depth));
            }
        }
    }
}

