/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev;

import com.google.gwt.thirdparty.guava.common.collect.ArrayListMultimap;
import com.google.gwt.thirdparty.guava.common.collect.Maps;
import com.google.gwt.thirdparty.guava.common.collect.Multimap;
import com.google.gwt.thirdparty.guava.common.collect.SortedSetMultimap;
import com.google.gwt.thirdparty.guava.common.collect.TreeMultimap;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public class PropertyAndBindingInfo
implements Serializable {
    private final SortedMap<String, String> reboundTypeByGwtCreateType;
    private final SortedMap<String, String> propertyValueByPropertyName;

    public PropertyAndBindingInfo() {
        this.reboundTypeByGwtCreateType = Maps.newTreeMap();
        this.propertyValueByPropertyName = Maps.newTreeMap();
    }

    private PropertyAndBindingInfo(SortedMap<String, String> reboundTypeByGwtCreateType, SortedMap<String, String> propertyValueByPropertyName) {
        this.reboundTypeByGwtCreateType = reboundTypeByGwtCreateType;
        this.propertyValueByPropertyName = propertyValueByPropertyName;
    }

    public String getPropertyValue(String key) {
        return (String)this.propertyValueByPropertyName.get(key);
    }

    public String getReboundType(String key) {
        return (String)this.reboundTypeByGwtCreateType.get(key);
    }

    public void putPropertyValue(String propertyName, String propertyValue) {
        this.propertyValueByPropertyName.put(propertyName, propertyValue);
    }

    void putReboundType(String key, String value) {
        this.reboundTypeByGwtCreateType.put(key, value);
    }

    public boolean containsProperty(String key) {
        return this.propertyValueByPropertyName.containsKey(key);
    }

    public boolean containsType(String key) {
        return this.reboundTypeByGwtCreateType.containsKey(key);
    }

    void assertRebindsEqual(PropertyAndBindingInfo other, Iterable<String> keysToCheck) {
        for (String key : keysToCheck) {
            assert (((String)this.reboundTypeByGwtCreateType.get(key)).equals(other.reboundTypeByGwtCreateType.get(key)));
        }
    }

    public static PropertyAndBindingInfo getCommonAnswers(Iterable<PropertyAndBindingInfo> maps) {
        Iterator<PropertyAndBindingInfo> it = maps.iterator();
        PropertyAndBindingInfo first = it.next();
        TreeMap<String, String> commonTypesByGwtCreateType = Maps.newTreeMap(first.reboundTypeByGwtCreateType);
        TreeMap<String, String> commonPropertiesValuesByPropertyNames = Maps.newTreeMap(first.propertyValueByPropertyName);
        while (it.hasNext()) {
            PropertyAndBindingInfo next = it.next();
            commonTypesByGwtCreateType.entrySet().retainAll(next.reboundTypeByGwtCreateType.entrySet());
            commonPropertiesValuesByPropertyNames.entrySet().retainAll(next.propertyValueByPropertyName.entrySet());
        }
        return new PropertyAndBindingInfo(commonTypesByGwtCreateType, commonPropertiesValuesByPropertyNames);
    }

    public static SortedSetMultimap<String, String> getPossibleReboundTypesByRequestType(Iterable<PropertyAndBindingInfo> permutationPropertyAndBindingInfoList, Set<String> requestTypes) {
        TreeMultimap<String, String> result = TreeMultimap.create();
        for (PropertyAndBindingInfo map : permutationPropertyAndBindingInfoList) {
            for (Map.Entry<String, String> entry : map.reboundTypeByGwtCreateType.entrySet()) {
                if (!requestTypes.contains(entry.getKey())) continue;
                result.put(entry.getKey(), entry.getValue());
            }
        }
        return result;
    }

    public static Multimap<String, Integer> getPermutationIdsByRequestTypes(List<PropertyAndBindingInfo> maps, String key) {
        ArrayListMultimap<String, Integer> result = ArrayListMultimap.create();
        int permutationCount = maps.size();
        for (int i = 0; i < permutationCount; ++i) {
            String answerType = maps.get(i).getReboundType(key);
            result.put(answerType, i);
        }
        return result;
    }

    public static Multimap<String, Integer> getPermutationIdsByPropertyName(List<PropertyAndBindingInfo> maps, String key) {
        ArrayListMultimap<String, Integer> result = ArrayListMultimap.create();
        int permutationCount = maps.size();
        for (int i = 0; i < permutationCount; ++i) {
            String answerType = maps.get(i).getPropertyValue(key);
            result.put(answerType, i);
        }
        return result;
    }
}

