/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev;

import com.google.gwt.core.ext.Linker;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.linker.ModuleMetricsArtifact;
import com.google.gwt.core.ext.linker.PrecompilationMetricsArtifact;
import com.google.gwt.core.ext.linker.impl.StandardLinkerContext;
import com.google.gwt.dev.CompileTaskRunner;
import com.google.gwt.dev.CompilerContext;
import com.google.gwt.dev.GraphicsInitThread;
import com.google.gwt.dev.Permutation;
import com.google.gwt.dev.Precompilation;
import com.google.gwt.dev.PrecompilationContextCreator;
import com.google.gwt.dev.PrecompileTaskArgProcessor;
import com.google.gwt.dev.PrecompileTaskOptions;
import com.google.gwt.dev.PrecompileTaskOptionsImpl;
import com.google.gwt.dev.RebindAnswersPermutationKey;
import com.google.gwt.dev.cfg.ModuleDef;
import com.google.gwt.dev.cfg.ModuleDefLoader;
import com.google.gwt.dev.cfg.PropertyCombinations;
import com.google.gwt.dev.javac.CompilationState;
import com.google.gwt.dev.javac.CompilationUnit;
import com.google.gwt.dev.javac.typemodel.JClassType;
import com.google.gwt.dev.jjs.JavaToJavaScriptCompiler;
import com.google.gwt.dev.jjs.PrecompilationContext;
import com.google.gwt.dev.jjs.UnifiedAst;
import com.google.gwt.dev.util.CollapsedPropertyKey;
import com.google.gwt.dev.util.Memory;
import com.google.gwt.dev.util.Util;
import com.google.gwt.dev.util.collect.Lists;
import com.google.gwt.dev.util.log.speedtracer.CompilerEventType;
import com.google.gwt.dev.util.log.speedtracer.SpeedTracerLogger;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;

public class Precompile {
    static final String PERM_COUNT_FILENAME = "permCount.txt";
    static final String PRECOMPILE_FILENAME = "precompilation.ser";
    static final String PRECOMPILE_FILENAME_PREFIX = "precompilation";
    static final String PRECOMPILE_FILENAME_SUFFIX = ".ser";
    private final PrecompileTaskOptionsImpl options;
    private CompilerContext compilerContext;
    private final CompilerContext.Builder compilerContextBuilder = new CompilerContext.Builder();

    public static void main(String[] args) {
        CompileTaskRunner.CompileTask task;
        Memory.initialize();
        SpeedTracerLogger.init();
        SpeedTracerLogger.Event precompileEvent = SpeedTracerLogger.start(CompilerEventType.PRECOMPILE, new String[0]);
        if (System.getProperty("gwt.jjs.dumpAst") != null) {
            System.out.println("Will dump AST to: " + System.getProperty("gwt.jjs.dumpAst"));
        }
        final PrecompileTaskOptionsImpl options = new PrecompileTaskOptionsImpl();
        boolean success = false;
        if (new PrecompileTaskArgProcessor(options).processArgs(args) && CompileTaskRunner.runWithAppropriateLogger(options, task = new CompileTaskRunner.CompileTask(){

            @Override
            public boolean run(TreeLogger logger) throws UnableToCompleteException {
                return new Precompile(options).run(logger);
            }
        })) {
            success = true;
        }
        precompileEvent.end(new String[0]);
        System.exit(success ? 0 : 1);
    }

    public static Precompilation precompile(TreeLogger logger, CompilerContext compilerContext) throws UnableToCompleteException {
        PropertyCombinations allPermutations = new PropertyCombinations(compilerContext.getModule().getProperties(), compilerContext.getModule().getActiveLinkerNames());
        if (compilerContext.getOptions().isIncrementalCompileEnabled() && allPermutations.size() > 1) {
            logger.log(TreeLogger.ERROR, "Current binding properties are expanding to more than one permutation but per-file compilation requires that each compile operate on only one permutation.");
            throw new UnableToCompleteException();
        }
        return Precompile.precompile(logger, compilerContext, 0, allPermutations);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean validate(TreeLogger logger, CompilerContext compilerContext) {
        SpeedTracerLogger.Event validateEvent = SpeedTracerLogger.start(CompilerEventType.VALIDATE, new String[0]);
        try {
            ModuleDef module = compilerContext.getModule();
            PrecompileTaskOptions jjsOptions = compilerContext.getOptions();
            CompilationState compilationState = module.getCompilationState(logger, compilerContext);
            if (jjsOptions.isStrict() && compilationState.hasErrors()) {
                Precompile.abortDueToStrictMode(logger);
            }
            String[] declEntryPts = module.getEntryPointTypeNames();
            String[] additionalRootTypes = null;
            if (declEntryPts.length == 0) {
                Collection<CompilationUnit> compilationUnits = compilationState.getCompilationUnits();
                additionalRootTypes = new String[compilationUnits.size()];
                int i = 0;
                for (CompilationUnit unit : compilationUnits) {
                    additionalRootTypes[i++] = unit.getTypeName();
                }
            }
            PrecompilationContext precompilationContext = PrecompilationContextCreator.create(compilerContext, compilationState, new PropertyCombinations(module.getProperties(), module.getActiveLinkerNames()), declEntryPts, additionalRootTypes, null);
            compilationState = null;
            JavaToJavaScriptCompiler.precompile(logger, compilerContext, precompilationContext);
            boolean bl = true;
            return bl;
        }
        catch (UnableToCompleteException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            validateEvent.end(new String[0]);
        }
    }

    static List<PropertyCombinations> getCollapsedPermutations(ModuleDef module) {
        PropertyCombinations allPermutations = new PropertyCombinations(module.getProperties(), module.getActiveLinkerNames());
        List<PropertyCombinations> collapsedPermutations = allPermutations.collapseProperties();
        return collapsedPermutations;
    }

    static Precompilation precompile(TreeLogger logger, CompilerContext compilerContext, int permutationBase, PropertyCombinations allPermutations) {
        return Precompile.precompile(logger, compilerContext, permutationBase, allPermutations, ManagementFactory.getRuntimeMXBean().getStartTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Precompilation precompile(TreeLogger logger, CompilerContext compilerContext, int permutationBase, PropertyCombinations propertyCombinations, long startTimeMilliseconds) {
        SpeedTracerLogger.Event precompileEvent = SpeedTracerLogger.start(CompilerEventType.PRECOMPILE, new String[0]);
        new GraphicsInitThread().start();
        try {
            ModuleDef module = compilerContext.getModule();
            PrecompileTaskOptions jjsOptions = compilerContext.getOptions();
            if (jjsOptions.isIncrementalCompileEnabled()) {
                compilerContext.getMinimalRebuildCache().recordDiskSourceResources(module);
                compilerContext.getMinimalRebuildCache().recordBuildResources(module);
            }
            CompilationState compilationState = module.getCompilationState(logger, compilerContext);
            if (jjsOptions.isStrict() && compilationState.hasErrors()) {
                Precompile.abortDueToStrictMode(logger);
            }
            ArrayList<String> initialTypeOracleTypes = new ArrayList<String>();
            if (jjsOptions.isCompilerMetricsEnabled()) {
                for (JClassType type : compilationState.getTypeOracle().getTypes()) {
                    initialTypeOracleTypes.add(type.getPackage().getName() + "." + type.getName());
                }
            }
            long moduleLoadFinished = System.currentTimeMillis();
            String[] declEntryPts = module.getEntryPointTypeNames();
            if (declEntryPts.length == 0) {
                logger.log(TreeLogger.ERROR, "Module has no entry points defined", null);
                throw new UnableToCompleteException();
            }
            PrecompilationMetricsArtifact precompilationMetrics = jjsOptions.isCompilerMetricsEnabled() ? new PrecompilationMetricsArtifact(permutationBase) : null;
            PrecompilationContext precompilationContext = PrecompilationContextCreator.create(compilerContext, compilationState, propertyCombinations, declEntryPts, null, precompilationMetrics);
            compilationState = null;
            UnifiedAst unifiedAst = JavaToJavaScriptCompiler.precompile(logger, compilerContext, precompilationContext);
            if (jjsOptions.isCompilerMetricsEnabled()) {
                ModuleMetricsArtifact moduleMetrics = new ModuleMetricsArtifact();
                moduleMetrics.setSourceFiles(module.getAllSourceFiles());
                moduleMetrics.setInitialTypes(initialTypeOracleTypes);
                moduleMetrics.setElapsedMilliseconds(moduleLoadFinished - startTimeMilliseconds);
                unifiedAst.setModuleMetrics(moduleMetrics);
            }
            ArrayList<Permutation> permutations = new ArrayList<Permutation>(Arrays.asList(precompilationContext.getPermutations()));
            Precompile.mergeCollapsedPermutations(permutations);
            TreeMap<RebindAnswersPermutationKey, Permutation> merged = new TreeMap<RebindAnswersPermutationKey, Permutation>();
            SortedSet<String> liveRebindRequests = unifiedAst.getRebindRequests();
            for (Permutation permutation : permutations) {
                RebindAnswersPermutationKey key = new RebindAnswersPermutationKey(permutation, liveRebindRequests);
                if (merged.containsKey(key)) {
                    Permutation existing = (Permutation)merged.get(key);
                    existing.mergeFrom(permutation, liveRebindRequests);
                    continue;
                }
                merged.put(key, permutation);
            }
            permutations.clear();
            permutations.addAll(merged.values());
            if (jjsOptions.isCompilerMetricsEnabled()) {
                int[] ids = new int[propertyCombinations.size()];
                for (int i = 0; i < propertyCombinations.size(); ++i) {
                    ids[i] = permutationBase + i;
                }
                precompilationMetrics.setPermutationIds(ids);
                precompilationMetrics.setElapsedMilliseconds(System.currentTimeMillis() - startTimeMilliseconds);
                unifiedAst.setPrecompilationMetrics(precompilationMetrics);
            }
            Precompilation precompilation = new Precompilation(unifiedAst, permutations, permutationBase, precompilationContext.getGeneratorArtifacts());
            return precompilation;
        }
        catch (UnableToCompleteException e) {
            Precompilation precompilation = null;
            return precompilation;
        }
        finally {
            precompileEvent.end(new String[0]);
        }
    }

    private static void abortDueToStrictMode(TreeLogger logger) throws UnableToCompleteException {
        logger.log(TreeLogger.ERROR, "Aborting compile due to errors in some input files");
        throw new UnableToCompleteException();
    }

    private static void mergeCollapsedPermutations(List<Permutation> permutations) {
        if (permutations.size() < 2) {
            return;
        }
        TreeMap mergedByCollapsedProperties = new TreeMap();
        Iterator<Object> it = permutations.iterator();
        while (it.hasNext()) {
            Permutation permutation = it.next();
            CollapsedPropertyKey key = new CollapsedPropertyKey(permutation);
            List<Object> equivalenceSet = (List)mergedByCollapsedProperties.get(key);
            if (equivalenceSet == null) {
                equivalenceSet = Lists.create();
            } else {
                it.remove();
                equivalenceSet = Lists.add(equivalenceSet, permutation);
            }
            mergedByCollapsedProperties.put(key, equivalenceSet);
        }
        for (Map.Entry entry : mergedByCollapsedProperties.entrySet()) {
            Permutation mergeInto = ((CollapsedPropertyKey)entry.getKey()).getPermutation();
            for (Permutation mergeFrom : (List)entry.getValue()) {
                mergeInto.mergeRebindsFromCollapsed(mergeFrom);
            }
        }
        int n = permutations.size();
        for (int i = 0; i < n; ++i) {
            permutations.set(i, new Permutation(i, permutations.get(i)));
        }
    }

    public Precompile(PrecompileTaskOptions options) {
        this.options = new PrecompileTaskOptionsImpl(options);
        this.compilerContext = this.compilerContextBuilder.options(options).build();
    }

    public boolean run(TreeLogger logger) throws UnableToCompleteException {
        for (String moduleName : this.options.getModuleNames()) {
            TreeLogger branch;
            File compilerWorkDir = this.options.getCompilerWorkDir(moduleName);
            Util.recursiveDelete(compilerWorkDir, true);
            compilerWorkDir.mkdirs();
            File precompilationFile = new File(compilerWorkDir, PRECOMPILE_FILENAME);
            ModuleDef module = ModuleDefLoader.loadFromClassPath(logger, moduleName);
            this.compilerContext = this.compilerContextBuilder.module(module).build();
            StandardLinkerContext linkerContext = new StandardLinkerContext(TreeLogger.NULL, module, this.compilerContext.getPublicResourceOracle(), this.options.getOutput());
            boolean generateOnShards = true;
            if (!this.options.isEnabledGeneratingOnShards()) {
                logger.log(TreeLogger.INFO, "Precompiling on the start node");
                generateOnShards = false;
            } else if (!linkerContext.allLinkersAreShardable()) {
                TreeLogger legacyLinkersLogger = logger.branch(TreeLogger.INFO, "Precompiling on the start node, because some linkers are not updated");
                if (legacyLinkersLogger.isLoggable(TreeLogger.INFO)) {
                    for (Linker linker : linkerContext.findUnshardableLinkers()) {
                        legacyLinkersLogger.log(TreeLogger.INFO, "Linker" + linker.getClass().getCanonicalName() + " is not updated");
                    }
                }
                generateOnShards = false;
            } else if (this.options.isValidateOnly()) {
                generateOnShards = false;
            }
            if (generateOnShards) {
                branch = logger.branch(TreeLogger.INFO, "Precompiling (minimal) module " + module.getName());
                Util.writeObjectAsFile(logger, precompilationFile, this.options);
                int numPermutations = new PropertyCombinations(module.getProperties(), module.getActiveLinkerNames()).collapseProperties().size();
                Util.writeStringAsFile(logger, new File(compilerWorkDir, PERM_COUNT_FILENAME), String.valueOf(numPermutations));
                if (!branch.isLoggable(TreeLogger.INFO)) continue;
                branch.log(TreeLogger.INFO, "Precompilation (minimal) succeeded, number of permutations: " + numPermutations);
                continue;
            }
            if (this.options.isValidateOnly()) {
                branch = logger.branch(TreeLogger.INFO, "Validating compilation " + module.getName());
                if (!Precompile.validate(branch, this.compilerContext)) {
                    branch.log(TreeLogger.ERROR, "Validation failed");
                    return false;
                }
                branch.log(TreeLogger.INFO, "Validation succeeded");
                continue;
            }
            branch = logger.branch(TreeLogger.INFO, "Precompiling module " + module.getName());
            Precompilation precompilation = Precompile.precompile(branch, this.compilerContext);
            if (precompilation == null) {
                branch.log(TreeLogger.ERROR, "Precompilation failed");
                return false;
            }
            if (!this.options.shouldSaveSource() && !module.shouldEmbedSourceMapContents()) {
                precompilation.removeSourceArtifacts(logger);
            }
            Util.writeObjectAsFile(logger, precompilationFile, precompilation);
            int permsPrecompiled = precompilation.getPermutations().length;
            Util.writeStringAsFile(logger, new File(compilerWorkDir, PERM_COUNT_FILENAME), String.valueOf(permsPrecompiled));
            if (!branch.isLoggable(TreeLogger.INFO)) continue;
            branch.log(TreeLogger.INFO, "Precompilation succeeded, number of permutations: " + permsPrecompiled);
        }
        return true;
    }
}

