/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.linker.ArtifactSet;
import com.google.gwt.core.ext.linker.EmittedArtifact;
import com.google.gwt.dev.Permutation;
import com.google.gwt.dev.PrecompilationResult;
import com.google.gwt.dev.jjs.UnifiedAst;
import com.google.gwt.dev.util.Util;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;

public class Precompilation
implements PrecompilationResult {
    private transient ArtifactSet generatedArtifacts;
    private transient byte[] generatedArtifactsSerialized;
    private final Permutation[] permutations;
    private final UnifiedAst unifiedAst;

    public Precompilation(UnifiedAst unifiedAst, Collection<Permutation> permutations, int permutationBase, ArtifactSet generatedArtifacts) {
        this.unifiedAst = unifiedAst;
        this.permutations = new Permutation[permutations.size()];
        int i = 0;
        for (Permutation permutation : permutations) {
            this.permutations[i] = new Permutation(i + permutationBase, permutation);
            ++i;
        }
        this.generatedArtifacts = generatedArtifacts;
    }

    public ArtifactSet getGeneratedArtifacts() {
        if (this.generatedArtifacts == null) {
            try {
                assert (this.generatedArtifactsSerialized != null);
                this.generatedArtifacts = Util.readStreamAsObject(new ByteArrayInputStream(this.generatedArtifactsSerialized), ArtifactSet.class);
                this.generatedArtifactsSerialized = null;
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Unexpected exception deserializing from memory stream", e);
            }
            catch (IOException e) {
                throw new RuntimeException("Unexpected exception deserializing from memory stream", e);
            }
        }
        return this.generatedArtifacts;
    }

    public Permutation[] getPermutations() {
        return this.permutations;
    }

    public UnifiedAst getUnifiedAst() {
        return this.unifiedAst;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Util.copyNoClose(stream, baos);
        this.generatedArtifactsSerialized = baos.toByteArray();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        Util.writeObjectToStream(stream, this.generatedArtifacts);
    }

    public void removeSourceArtifacts(TreeLogger logger) {
        logger.log(TreeLogger.Type.DEBUG, "removing source artifacts");
        for (EmittedArtifact artifact : this.generatedArtifacts.find(EmittedArtifact.class)) {
            if (artifact.getVisibility() != EmittedArtifact.Visibility.Source) continue;
            this.generatedArtifacts.remove(artifact);
        }
    }
}

