/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.dev.CompilerContext;
import com.google.gwt.dev.ExternalPermutationWorkerFactory;
import com.google.gwt.dev.Permutation;
import com.google.gwt.dev.PermutationWorker;
import com.google.gwt.dev.Precompilation;
import com.google.gwt.dev.ThreadedPermutationWorkerFactory;
import com.google.gwt.dev.TransientWorkerException;
import com.google.gwt.dev.jjs.PermutationResult;
import com.google.gwt.dev.jjs.UnifiedAst;
import com.google.gwt.dev.util.PersistenceBackedObject;
import com.google.gwt.dev.util.log.speedtracer.CompilerEventType;
import com.google.gwt.dev.util.log.speedtracer.SpeedTracerLogger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public abstract class PermutationWorkerFactory {
    public static final String FACTORY_IMPL_PROPERTY = "gwt.jjs.permutationWorkerFactory";
    public static final int WORKERS_AUTO = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void compilePermutations(TreeLogger logger, CompilerContext compilerContext, Precompilation precompilation, Permutation[] permutations, int localWorkers, List<PersistenceBackedObject<PermutationResult>> resultFiles) throws UnableToCompleteException {
        assert (permutations.length == resultFiles.size());
        assert (Arrays.asList(precompilation.getPermutations()).containsAll(Arrays.asList(permutations)));
        ArrayList<Work> work = new ArrayList<Work>(permutations.length);
        for (int i = 0; i < permutations.length; ++i) {
            Permutation perm = permutations[i];
            if (logger.isLoggable(TreeLogger.DEBUG)) {
                logger.log(TreeLogger.DEBUG, "Creating worker permutation " + perm.getId() + " of " + permutations.length);
            }
            work.add(new Work(logger, compilerContext, perm, resultFiles.get(i)));
        }
        ArrayList<PermutationWorker> workers = new ArrayList<PermutationWorker>();
        try {
            PermutationWorkerFactory.createWorkers(logger, precompilation.getUnifiedAst(), work.size(), localWorkers, workers);
            Manager.run(logger, work, workers);
        }
        finally {
            Throwable caught = null;
            for (PermutationWorker worker : workers) {
                try {
                    worker.shutdown();
                }
                catch (Throwable e) {
                    caught = e;
                }
            }
            if (caught != null) {
                throw new RuntimeException("One of the workers threw an exception while shutting down", caught);
            }
        }
    }

    private static synchronized List<PermutationWorkerFactory> createAll(TreeLogger logger) throws UnableToCompleteException {
        String[] classParts;
        logger = logger.branch(TreeLogger.TRACE, "Creating PermutationWorkerFactory instances");
        ArrayList<PermutationWorkerFactory> mutableFactories = new ArrayList<PermutationWorkerFactory>();
        String classes = System.getProperty(FACTORY_IMPL_PROPERTY, ThreadedPermutationWorkerFactory.class.getName() + "," + ExternalPermutationWorkerFactory.class.getName());
        if (logger.isLoggable(TreeLogger.SPAM)) {
            logger.log(TreeLogger.SPAM, "Factory impl property is " + classes);
        }
        for (String className : classParts = classes.split(",")) {
            try {
                Class<PermutationWorkerFactory> clazz = Class.forName(className).asSubclass(PermutationWorkerFactory.class);
                PermutationWorkerFactory factory = clazz.newInstance();
                mutableFactories.add(factory);
                if (!logger.isLoggable(TreeLogger.SPAM)) continue;
                logger.log(TreeLogger.SPAM, "Added PermutationWorkerFactory " + clazz.getName());
            }
            catch (ClassCastException e) {
                logger.log(TreeLogger.ERROR, className + " is not a " + PermutationWorkerFactory.class.getName());
            }
            catch (ClassNotFoundException e) {
                logger.log(TreeLogger.ERROR, "Unable to find PermutationWorkerFactory named " + className);
            }
            catch (InstantiationException e) {
                logger.log(TreeLogger.ERROR, "Unable to instantiate PermutationWorkerFactory " + className, e);
            }
            catch (IllegalAccessException e) {
                logger.log(TreeLogger.ERROR, "Unable to instantiate PermutationWorkerFactory " + className, e);
            }
        }
        if (mutableFactories.size() == 0) {
            logger.log(TreeLogger.ERROR, "No usable PermutationWorkerFactories available");
            throw new UnableToCompleteException();
        }
        return Collections.unmodifiableList(mutableFactories);
    }

    private static void createWorkers(TreeLogger logger, UnifiedAst unifiedAst, int workersNeeded, int localWorkers, List<PermutationWorker> workers) throws UnableToCompleteException {
        if (localWorkers <= 0) {
            localWorkers = 1;
        }
        for (PermutationWorkerFactory factory : PermutationWorkerFactory.createAll(logger)) {
            int wanted;
            if (workersNeeded <= 0) break;
            int n = wanted = factory.isLocal() ? Math.min(workersNeeded, localWorkers) : workersNeeded;
            if (wanted <= 0) continue;
            Collection<PermutationWorker> newWorkers = factory.getWorkers(logger, unifiedAst, wanted);
            workers.addAll(newWorkers);
            workersNeeded -= newWorkers.size();
            if (!factory.isLocal()) continue;
            localWorkers -= newWorkers.size();
        }
        if (workers.size() == 0) {
            logger.log(TreeLogger.ERROR, "No PermutationWorkers created");
            throw new UnableToCompleteException();
        }
    }

    public abstract Collection<PermutationWorker> getWorkers(TreeLogger var1, UnifiedAst var2, int var3) throws UnableToCompleteException;

    public abstract boolean isLocal();

    private static class Work {
        private final TreeLogger logger;
        private final Permutation perm;
        private final PersistenceBackedObject<PermutationResult> resultFile;
        private final CompilerContext compilerContext;

        public Work(TreeLogger logger, CompilerContext compilerContext, Permutation perm, PersistenceBackedObject<PermutationResult> resultFile) {
            this.logger = logger;
            this.compilerContext = compilerContext;
            this.perm = perm;
            this.resultFile = resultFile;
        }

        public CompilerContext getCompilerContext() {
            return this.compilerContext;
        }

        public TreeLogger getLogger() {
            return this.logger;
        }

        public Permutation getPerm() {
            return this.perm;
        }

        public PersistenceBackedObject<PermutationResult> getResultFile() {
            return this.resultFile;
        }
    }

    private static class Manager {
        private static final Work POISON_PILL = new Work(null, null, null, null);
        BlockingQueue<Work> workQueue;
        BlockingQueue<Result> resultsQueue;

        public static void run(TreeLogger logger, List<Work> work, List<PermutationWorker> workers) throws UnableToCompleteException {
            new Manager().doRun(logger, work, workers);
        }

        private Manager() {
        }

        private void doRun(TreeLogger logger, List<Work> work, List<PermutationWorker> workers) throws UnableToCompleteException {
            this.workQueue = new LinkedBlockingQueue<Work>(work);
            this.resultsQueue = new LinkedBlockingQueue<Result>();
            ArrayList<Thread> threads = new ArrayList<Thread>(workers.size());
            try {
                for (PermutationWorker worker : workers) {
                    Thread thread = new Thread((Runnable)new WorkerThread(worker), worker.getName());
                    threads.add(thread);
                    thread.start();
                }
                int workToDo = work.size();
                int aliveWorkers = workers.size();
                block11: while (workToDo > 0 && aliveWorkers > 0) {
                    SpeedTracerLogger.Event blockedEvent = SpeedTracerLogger.start(CompilerEventType.BLOCKED, new String[0]);
                    Result take = this.resultsQueue.take();
                    blockedEvent.end(new String[0]);
                    switch (take) {
                        case SUCCESS: {
                            --workToDo;
                            break;
                        }
                        case FAIL: {
                            break block11;
                        }
                        case WORKER_DEATH: {
                            --aliveWorkers;
                            break;
                        }
                        default: {
                            throw new IncompatibleClassChangeError(Result.class.toString());
                        }
                    }
                }
                this.workQueue.clear();
                for (int i = 0; i < aliveWorkers; ++i) {
                    this.workQueue.add(POISON_PILL);
                }
                if (workToDo > 0) {
                    logger.log(TreeLogger.ERROR, "Not all permutation were compiled , completed (" + (work.size() - workToDo) + "/" + work.size() + ")");
                    throw new UnableToCompleteException();
                }
            }
            catch (InterruptedException e) {
                logger.log(TreeLogger.ERROR, "Exiting without results due to interruption", e);
                throw new UnableToCompleteException();
            }
            finally {
                for (Thread thread : threads) {
                    thread.interrupt();
                }
            }
        }

        static /* synthetic */ Work access$000() {
            return POISON_PILL;
        }

        private class WorkerThread
        implements Runnable {
            private final PermutationWorker worker;

            public WorkerThread(PermutationWorker worker) {
                this.worker = worker;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                threadDeathResult = Result.FAIL;
                while (true) {
                    work = Manager.this.workQueue.take();
                    if (work == Manager.access$000()) {
                    }
                    ** GOTO lbl28
                    {
                        catch (InterruptedException e) {
                            try {
                                Manager.this.resultsQueue.put(threadDeathResult);
                                return;
                            }
                            catch (InterruptedException var3_6) {
                                // empty catch block
                            }
                            return;
                        }
                        catch (Throwable var6_11) {
                            try {
                                Manager.this.resultsQueue.put(threadDeathResult);
                                throw var6_11;
                            }
                            catch (InterruptedException var7_12) {
                                // empty catch block
                            }
                            throw var6_11;
                        }
                        try {
                            Manager.this.resultsQueue.put(threadDeathResult);
                            return;
                        }
                        catch (InterruptedException var3_5) {
                            // empty catch block
                        }
                        return;
lbl28:
                        // 1 sources

                        logger = work.getLogger();
                        try {
                            this.worker.compile(logger, work.getCompilerContext(), work.getPerm(), work.getResultFile());
                            logger.log(TreeLogger.DEBUG, "Successfully compiled permutation");
                            Manager.this.resultsQueue.put(Result.SUCCESS);
                            continue;
                        }
                        catch (TransientWorkerException e) {
                            logger.log(TreeLogger.DEBUG, "Worker died, will retry Permutation", e);
                            Manager.this.workQueue.add(work);
                            threadDeathResult = Result.WORKER_DEATH;
                            try {
                                Manager.this.resultsQueue.put(threadDeathResult);
                                return;
                            }
                            catch (InterruptedException var5_9) {
                                // empty catch block
                            }
                            return;
                        }
                        catch (UnableToCompleteException e) {}
                        {
                            logger.log(TreeLogger.ERROR, "Unrecoverable exception, shutting down", e);
                        }
                        try {
                            Manager.this.resultsQueue.put(threadDeathResult);
                            return;
                        }
                        catch (InterruptedException var5_10) {
                            // empty catch block
                        }
                        return;
                    }
                }
            }
        }

        private static enum Result {
            SUCCESS,
            FAIL,
            WORKER_DEATH;

        }
    }
}

