/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev;

import com.google.gwt.dev.PropertyAndBindingInfo;
import com.google.gwt.dev.cfg.BindingProperties;
import com.google.gwt.dev.cfg.BindingProperty;
import com.google.gwt.dev.cfg.PermutationProperties;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import java.io.Serializable;
import java.util.List;
import java.util.SortedSet;

public final class Permutation
implements Serializable {
    private final int id;
    private List<BindingProperties> orderedProps = Lists.newArrayList();
    private List<PropertyAndBindingInfo> propertyAndBindingInfos = Lists.newArrayList();

    public Permutation(int id, Permutation other) {
        this.id = id;
        this.orderedProps = Lists.newArrayList(other.orderedProps);
        this.propertyAndBindingInfos = Lists.newArrayList(other.propertyAndBindingInfos);
    }

    public Permutation(int id, BindingProperties bindingProperties) {
        this.id = id;
        this.orderedProps.add(bindingProperties);
        this.propertyAndBindingInfos.add(new PropertyAndBindingInfo());
        BindingProperty[] properties = bindingProperties.getOrderedProps();
        String[] propertyValues = bindingProperties.getOrderedPropValues();
        for (int i = 0; i < properties.length; ++i) {
            this.propertyAndBindingInfos.get(0).putPropertyValue(properties[i].getName(), propertyValues[i]);
        }
    }

    public int getId() {
        return this.id;
    }

    public List<PropertyAndBindingInfo> getPropertyAndBindingInfos() {
        return Lists.newArrayList(this.propertyAndBindingInfos);
    }

    public PermutationProperties getProperties() {
        return new PermutationProperties(this.orderedProps);
    }

    public void mergeFrom(Permutation other, SortedSet<String> liveRebindRequests) {
        if (this.getClass().desiredAssertionStatus()) {
            Permutation.assertSameAnswers(liveRebindRequests, this.propertyAndBindingInfos, other.propertyAndBindingInfos);
        }
        this.mergeRebindsFromCollapsed(other);
    }

    public void mergeRebindsFromCollapsed(Permutation other) {
        assert (other.orderedProps.size() == other.propertyAndBindingInfos.size());
        this.orderedProps.addAll(other.orderedProps);
        this.propertyAndBindingInfos.addAll(other.propertyAndBindingInfos);
        other.destroy();
    }

    public void putRebindAnswer(String requestType, String resultType) {
        assert (this.propertyAndBindingInfos.size() == 1) : "Cannot add rebind to merged Permutation";
        PropertyAndBindingInfo answerMap = this.propertyAndBindingInfos.get(0);
        assert (answerMap != null);
        answerMap.putReboundType(requestType, resultType);
    }

    private static void assertSameAnswers(SortedSet<String> liveRebindRequests, List<PropertyAndBindingInfo> theseAnswers, List<PropertyAndBindingInfo> thoseAnswers) {
        assert (theseAnswers.size() == thoseAnswers.size());
        for (int i = 0; i < theseAnswers.size(); ++i) {
            theseAnswers.get(i).assertRebindsEqual(thoseAnswers.get(i), liveRebindRequests);
        }
    }

    private void destroy() {
        this.orderedProps = Lists.newArrayList();
        this.propertyAndBindingInfos = Lists.newArrayList();
    }
}

