/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.dev.Disconnectable;
import com.google.gwt.dev.ModulePanel;
import com.google.gwt.dev.SessionModule;
import com.google.gwt.dev.SwingUI;
import com.google.gwt.dev.shell.WrapLayout;
import com.google.gwt.dev.util.BrowserInfo;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.plaf.basic.BasicComboBoxRenderer;

public class ModuleTabPanel
extends JPanel {
    public static final Color DISCONNECTED_DROPDOWN_COLOR = Color.decode("0x808080");
    private CardLayout cardLayout;
    private Session currentSession;
    private JPanel deckPanel;
    private JComboBox moduleDropdown;
    private JComboBox sessionDropdown;
    private final Map<String, Session> sessions = new HashMap<String, Session>();
    private final SwingUI.TabPanelCollection tabPanelCollection;
    private JPanel topPanel;
    private JPanel sessionDropdownPanel;
    private JPanel moduleDropdownPanel;

    public ModuleTabPanel(String userAgent, String remoteSocket, String url, byte[] agentIconBytes, SwingUI.TabPanelCollection tabPanelCollection, String moduleName) {
        super(new BorderLayout());
        this.tabPanelCollection = tabPanelCollection;
        this.topPanel = new JPanel();
        this.sessionDropdownPanel = new JPanel(new WrapLayout());
        this.sessionDropdownPanel.add(new JLabel("Session: "));
        this.sessionDropdown = new JComboBox();
        this.sessionDropdown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Session session = (Session)ModuleTabPanel.this.sessionDropdown.getSelectedItem();
                ModuleTabPanel.this.selectSession(session);
            }
        });
        this.sessionDropdown.setRenderer(new SessionRenderer());
        this.sessionDropdownPanel.add(this.sessionDropdown);
        this.sessionDropdownPanel.setEnabled(false);
        this.sessionDropdownPanel.setVisible(false);
        this.topPanel.add(this.sessionDropdownPanel);
        this.moduleDropdownPanel = new JPanel(new WrapLayout());
        this.moduleDropdownPanel.add(new JLabel("Module: "));
        this.moduleDropdown = new JComboBox();
        this.moduleDropdown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SessionModule sessionModule = (SessionModule)ModuleTabPanel.this.moduleDropdown.getSelectedItem();
                if (sessionModule != null) {
                    ModuleTabPanel.this.currentSession.selectModule(sessionModule);
                }
            }
        });
        this.moduleDropdown.setRenderer(new SessionModuleRenderer());
        this.moduleDropdownPanel.add(this.moduleDropdown);
        this.moduleDropdownPanel.setEnabled(false);
        this.moduleDropdownPanel.setVisible(false);
        this.topPanel.add(this.moduleDropdownPanel);
        this.add((Component)this.topPanel, "North");
        this.cardLayout = new CardLayout();
        this.deckPanel = new JPanel(this.cardLayout);
        this.add(this.deckPanel);
        String tabTitle = url;
        if (tabTitle == null) {
            int idx = moduleName.lastIndexOf(46);
            tabTitle = moduleName.substring(idx + 1);
            url = "";
        } else {
            try {
                URL parsedUrl = new URL(url);
                tabTitle = this.getTabTitle(parsedUrl);
                StringBuilder buf = new StringBuilder();
                buf.append(parsedUrl.getProtocol()).append(':');
                if (parsedUrl.getAuthority() != null && parsedUrl.getAuthority().length() > 0) {
                    buf.append("//").append(parsedUrl.getAuthority());
                }
                if (parsedUrl.getPath() != null) {
                    buf.append(parsedUrl.getPath());
                }
                buf.append(' ');
                url = buf.toString();
            }
            catch (MalformedURLException parsedUrl) {
                // empty catch block
            }
        }
        ImageIcon browserIcon = null;
        if (agentIconBytes != null) {
            browserIcon = new ImageIcon(agentIconBytes);
        }
        String shortName = BrowserInfo.getShortName(userAgent);
        if (browserIcon == null && shortName != null) {
            tabTitle = tabTitle + " (" + shortName + ")";
        }
        tabPanelCollection.addTab(this, browserIcon, tabTitle, url + "from " + remoteSocket + " on " + userAgent);
    }

    public synchronized ModulePanel addModuleSession(TreeLogger.Type maxLevel, String moduleName, String sessionKey, File logFile) {
        Session session = this.findOrCreateSession(sessionKey);
        ModulePanel panel = new ModulePanel(maxLevel, moduleName, session, logFile);
        return panel;
    }

    private synchronized void addSession(Session session) {
        this.sessionDropdown.addItem(session);
        this.sessionDropdown.setSelectedItem(session);
        if (this.sessionDropdown.getItemCount() > 1) {
            this.sessionDropdownPanel.setEnabled(true);
            this.sessionDropdownPanel.setVisible(true);
        }
        this.selectSession(session);
    }

    private synchronized void closeSession(Session session) {
        this.sessionDropdown.removeItem(session);
        this.sessions.remove(session.getSessionKey());
        switch (this.sessionDropdown.getItemCount()) {
            case 0: {
                this.tabPanelCollection.removeTab(this);
                return;
            }
            case 1: {
                this.sessionDropdownPanel.setEnabled(false);
                this.sessionDropdownPanel.setVisible(false);
                break;
            }
        }
        if (session == this.currentSession) {
            this.selectSession((Session)this.sessionDropdown.getItemAt(this.sessionDropdown.getItemCount() - 1));
        }
    }

    private synchronized Session findOrCreateSession(String sessionKey) {
        Session session = this.sessions.get(sessionKey);
        if (session == null) {
            session = new Session(sessionKey);
            this.sessions.put(sessionKey, session);
            this.addSession(session);
        }
        return session;
    }

    private String getTabTitle(URL parsedUrl) {
        String tabTitle = parsedUrl.getPath();
        if (tabTitle.length() > 0) {
            int startIdx = tabTitle.lastIndexOf(47);
            int lastIdx = tabTitle.length();
            if (tabTitle.endsWith(".html")) {
                lastIdx -= 5;
            } else if (tabTitle.endsWith(".htm")) {
                lastIdx -= 4;
            }
            tabTitle = tabTitle.substring(startIdx + 1, lastIdx);
        } else {
            tabTitle = "/";
        }
        return tabTitle;
    }

    private void selectSession(Session session) {
        this.currentSession = session;
        if (session != null) {
            session.buildModuleDropdownContents();
        }
    }

    private static class SessionRenderer
    extends BasicComboBoxRenderer {
        private SessionRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Session session;
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof Session && !(session = (Session)value).hasActiveModules()) {
                this.setForeground(DISCONNECTED_DROPDOWN_COLOR);
                this.setFont(this.getFont().deriveFont(2));
            }
            return this;
        }
    }

    private static class SessionModuleRenderer
    extends BasicComboBoxRenderer {
        private SessionModuleRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            SessionModule sessionModule;
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof SessionModule && (sessionModule = (SessionModule)value).getModulePanel().isDisconnected()) {
                this.setForeground(DISCONNECTED_DROPDOWN_COLOR);
                this.setFont(this.getFont().deriveFont(2));
            }
            return this;
        }
    }

    public class Session {
        private final long createTimestamp;
        private final Map<String, ModulePanel> displayNameToModule;
        private final IdentityHashMap<ModulePanel, SessionModule> moduleSessionMap;
        private SessionModule lastSelectedModule;
        private final Map<String, Integer> moduleCounts;
        private final List<SessionModule> modules;
        private final String sessionKey;

        public Session(String sessionKey) {
            this.sessionKey = sessionKey;
            this.createTimestamp = System.currentTimeMillis();
            this.displayNameToModule = new HashMap<String, ModulePanel>();
            this.moduleSessionMap = new IdentityHashMap();
            this.modules = new ArrayList<SessionModule>();
            this.moduleCounts = new HashMap<String, Integer>();
        }

        public synchronized void addModule(String moduleName, ModulePanel panel) {
            Integer moduleCount = this.moduleCounts.get(moduleName);
            if (moduleCount == null) {
                moduleCount = 0;
            }
            this.moduleCounts.put(moduleName, moduleCount + 1);
            String shortModuleName = this.getShortModuleName(moduleName);
            if (moduleCount > 0) {
                shortModuleName = shortModuleName + " (" + moduleCount + ")";
            }
            SessionModule sessionModule = SessionModule.create(this.sessionKey, panel, shortModuleName);
            this.modules.add(sessionModule);
            this.displayNameToModule.put(shortModuleName, panel);
            this.moduleSessionMap.put(panel, sessionModule);
            ModuleTabPanel.this.deckPanel.add((Component)panel, sessionModule.getStringKey());
            if (this == ModuleTabPanel.this.currentSession) {
                ModuleTabPanel.this.moduleDropdown.addItem(sessionModule);
                if (ModuleTabPanel.this.moduleDropdown.getItemCount() > 1) {
                    ModuleTabPanel.this.moduleDropdownPanel.setEnabled(true);
                    ModuleTabPanel.this.moduleDropdownPanel.setVisible(true);
                }
                this.selectModule(sessionModule);
            }
        }

        public void buildModuleDropdownContents() {
            if (this == ModuleTabPanel.this.currentSession) {
                ModuleTabPanel.this.moduleDropdown.removeAllItems();
                SessionModule firstModule = null;
                for (SessionModule sessionModule : this.modules) {
                    ModuleTabPanel.this.moduleDropdown.addItem(sessionModule);
                    if (firstModule != null) continue;
                    firstModule = sessionModule;
                }
                if (ModuleTabPanel.this.moduleDropdown.getItemCount() > 1) {
                    ModuleTabPanel.this.moduleDropdownPanel.setEnabled(true);
                    ModuleTabPanel.this.moduleDropdownPanel.setVisible(true);
                } else {
                    ModuleTabPanel.this.moduleDropdownPanel.setEnabled(false);
                    ModuleTabPanel.this.moduleDropdownPanel.setVisible(false);
                }
                if (this.lastSelectedModule != null) {
                    this.selectModule(this.lastSelectedModule);
                } else if (firstModule != null) {
                    this.selectModule(firstModule);
                }
            }
        }

        public void disconnectModule(ModulePanel modulePanel) {
            SessionModule sessionModule = this.moduleSessionMap.get(modulePanel);
            this.moduleSessionMap.remove(modulePanel);
            ModuleTabPanel.this.deckPanel.remove(modulePanel);
            this.modules.remove(sessionModule);
            switch (this.modules.size()) {
                case 0: {
                    ModuleTabPanel.this.closeSession(this);
                    break;
                }
                case 1: {
                    ModuleTabPanel.this.moduleDropdownPanel.setEnabled(false);
                    ModuleTabPanel.this.moduleDropdownPanel.setVisible(false);
                    break;
                }
                default: {
                    if (this.lastSelectedModule == sessionModule) {
                        this.lastSelectedModule = this.modules.get(this.modules.size() - 1);
                    }
                    this.buildModuleDropdownContents();
                }
            }
        }

        public Collection<String> getActiveModules() {
            ArrayList<String> activeModules = new ArrayList<String>();
            for (SessionModule sessionModule : this.modules) {
                String displayName = sessionModule.toString();
                Disconnectable module = sessionModule.getModulePanel();
                if (module.isDisconnected()) continue;
                activeModules.add(displayName);
            }
            return Collections.unmodifiableList(activeModules);
        }

        public String getDisplayName() {
            return DateFormat.getDateTimeInstance().format(new Date(this.createTimestamp));
        }

        public String getSessionKey() {
            return this.sessionKey;
        }

        public boolean hasActiveModules() {
            for (SessionModule sessionModule : this.modules) {
                Disconnectable module = sessionModule.getModulePanel();
                if (module.isDisconnected()) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return this.getDisplayName();
        }

        private String getShortModuleName(String moduleName) {
            int idx = moduleName.lastIndexOf(46);
            if (idx < 0) {
                return moduleName;
            }
            return moduleName.substring(idx + 1);
        }

        private void selectModule(SessionModule sessionModule) {
            ModuleTabPanel.this.cardLayout.show(ModuleTabPanel.this.deckPanel, sessionModule.getStringKey());
            this.lastSelectedModule = sessionModule;
            ModuleTabPanel.this.moduleDropdown.setSelectedItem(sessionModule);
        }
    }
}

