/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.dev.Disconnectable;
import com.google.gwt.dev.ModuleTabPanel;
import com.google.gwt.dev.shell.log.SwingLoggerPanel;
import java.awt.BorderLayout;
import java.io.File;
import javax.swing.JPanel;

public class ModulePanel
extends JPanel
implements Disconnectable {
    private SwingLoggerPanel loggerPanel;
    private ModuleTabPanel.Session session;
    private boolean disconnected;

    public ModulePanel(TreeLogger.Type maxLevel, String moduleName, ModuleTabPanel.Session session, File logFile) {
        super(new BorderLayout());
        this.session = session;
        this.loggerPanel = new SwingLoggerPanel(maxLevel, logFile);
        this.add(this.loggerPanel);
        session.addModule(moduleName, this);
    }

    @Override
    public void disconnect() {
        this.setDisconnected();
    }

    public TreeLogger getLogger() {
        return this.loggerPanel.getLogger();
    }

    @Override
    public boolean isDisconnected() {
        return this.disconnected;
    }

    void setDisconnected() {
        this.disconnected = true;
        this.loggerPanel.disconnected();
        this.loggerPanel.setCloseHandler(new SwingLoggerPanel.CloseHandler(){

            @Override
            public void onCloseRequest(SwingLoggerPanel loggerPanelToClose) {
                ModulePanel.this.session.disconnectModule(ModulePanel.this);
            }
        });
    }
}

