/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev;

import cern.colt.list.IntArrayList;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.linker.ArtifactSet;
import com.google.gwt.core.ext.linker.StatementRanges;
import com.google.gwt.dev.StringAnalyzableTypeEnvironment;
import com.google.gwt.dev.cfg.ModuleDef;
import com.google.gwt.dev.javac.CompilationUnit;
import com.google.gwt.dev.javac.CompiledClass;
import com.google.gwt.dev.javac.GeneratedUnit;
import com.google.gwt.dev.javac.Shared;
import com.google.gwt.dev.jjs.JsSourceMap;
import com.google.gwt.dev.jjs.ast.JProgram;
import com.google.gwt.dev.jjs.ast.JTypeOracle;
import com.google.gwt.dev.jjs.impl.RapidTypeAnalyzer;
import com.google.gwt.dev.jjs.impl.ResolveRuntimeTypeReferences;
import com.google.gwt.dev.js.JsIncrementalNamer;
import com.google.gwt.dev.resource.Resource;
import com.google.gwt.dev.util.Name;
import com.google.gwt.thirdparty.guava.common.annotations.VisibleForTesting;
import com.google.gwt.thirdparty.guava.common.base.Objects;
import com.google.gwt.thirdparty.guava.common.base.Predicates;
import com.google.gwt.thirdparty.guava.common.collect.HashMultimap;
import com.google.gwt.thirdparty.guava.common.collect.ImmutableList;
import com.google.gwt.thirdparty.guava.common.collect.ImmutableSet;
import com.google.gwt.thirdparty.guava.common.collect.Iterables;
import com.google.gwt.thirdparty.guava.common.collect.Maps;
import com.google.gwt.thirdparty.guava.common.collect.Multimap;
import com.google.gwt.thirdparty.guava.common.collect.Multimaps;
import com.google.gwt.thirdparty.guava.common.collect.Sets;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MinimalRebuildCache
implements Serializable {
    protected final JTypeOracle.ImmediateTypeRelations immediateTypeRelations = new JTypeOracle.ImmediateTypeRelations();
    private final Map<String, String> compilationUnitTypeNameByNestedTypeName = Maps.newHashMap();
    private final Map<String, String> contentHashByGeneratedTypeName = Maps.newHashMap();
    private final Set<String> deletedCompilationUnitNames = Sets.newHashSet();
    private final Set<String> deletedDiskSourcePaths = Sets.newHashSet();
    private final Set<String> deletedResourcePaths = Sets.newHashSet();
    private final Set<String> dualJsoImplInterfaceNames = Sets.newHashSet();
    private final Map<String, String> descriptionByExportedGlobalNames = Maps.newHashMap();
    private final Multimap<String, String> exportedGlobalNamesByTypeName = HashMultimap.create();
    private final ArtifactSet generatedArtifacts = new ArtifactSet();
    private final Multimap<String, String> generatedCompilationUnitNamesByReboundTypeNames = HashMultimap.create();
    private final ResolveRuntimeTypeReferences.IntTypeMapper intTypeMapper = new ResolveRuntimeTypeReferences.IntTypeMapper();
    private final Map<String, String> jsByTypeName = Maps.newHashMap();
    private final JsIncrementalNamer.JsIncrementalNamerState jsIncrementalNamerState = new JsIncrementalNamer.JsIncrementalNamerState();
    private final Set<String> jsoStatusChangedTypeNames = Sets.newHashSet();
    private final Set<String> jsoTypeNames = Sets.newHashSet();
    private Integer lastLinkedJsBytes;
    private final Map<String, Long> lastModifiedByDiskSourcePath = Maps.newHashMap();
    private final Map<String, Long> lastModifiedByResourcePath = Maps.newHashMap();
    private final Set<String> lastReachableTypeNames = Sets.newHashSet();
    private final Set<String> modifiedCompilationUnitNames = Sets.newHashSet();
    private final Set<String> modifiedDiskSourcePaths = Sets.newHashSet();
    private final Set<String> modifiedResourcePaths = Sets.newHashSet();
    private final Multimap<String, String> nestedTypeNamesByUnitTypeName = HashMultimap.create();
    private final Set<String> preambleTypeNames = Sets.newHashSet();
    private transient ImmutableSet<String> processedStaleTypeNames = ImmutableSet.of();
    private final Multimap<String, String> rebinderTypeNamesByReboundTypeName = HashMultimap.create();
    private final Multimap<String, String> reboundTypeNamesByGeneratedCompilationUnitNames = HashMultimap.create();
    private final Multimap<String, String> reboundTypeNamesByInputResource = HashMultimap.create();
    private final Multimap<String, String> referencedTypeNamesByTypeName = HashMultimap.create();
    private final Set<String> rootTypeNames = Sets.newHashSet();
    private final Set<String> singleJsoImplInterfaceNames = Sets.newHashSet();
    private final Set<String> sourceCompilationUnitNames = Sets.newHashSet();
    private final Map<String, JsSourceMap> sourceMapsByTypeName = Maps.newHashMap();
    private final Set<String> staleTypeNames = Sets.newHashSet();
    private final Map<String, StatementRanges> statementRangesByTypeName = Maps.newHashMap();
    private StringAnalyzableTypeEnvironment typeEnvironment = new StringAnalyzableTypeEnvironment();
    private final Multimap<String, String> typeNamesByReferencingTypeName = HashMultimap.create();

    private static void appendSubTypes(Set<String> accumulatedTypeNames, Set<String> parentTypeNames, JTypeOracle typeOracle) {
        for (String parentTypeName : parentTypeNames) {
            Iterables.addAll(accumulatedTypeNames, typeOracle.getSubTypeNames(parentTypeName));
        }
    }

    private static void copyCollection(Collection fromCollection, Collection toCollection) {
        toCollection.clear();
        toCollection.addAll(fromCollection);
    }

    private static void copyMap(Map fromMap, Map toMap) {
        toMap.clear();
        toMap.putAll(fromMap);
    }

    private static void copyMultimap(Multimap fromMap, Multimap toMap) {
        toMap.clear();
        toMap.putAll(fromMap);
    }

    private static void recordModifiedResources(Map<String, Long> currentModifiedByResourcePath, Map<String, Long> lastModifiedByResourcePath, Set<String> modifiedResourcePaths, Set<String> deletedResourcePaths) {
        deletedResourcePaths.clear();
        modifiedResourcePaths.clear();
        HashSet<String> currentResourcePaths = Sets.newHashSet();
        for (Map.Entry<String, Long> entry : currentModifiedByResourcePath.entrySet()) {
            String currentResourcePath = entry.getKey();
            Long currentResourceModified = entry.getValue();
            currentResourcePaths.add(currentResourcePath);
            Long lastKnownModified = lastModifiedByResourcePath.put(currentResourcePath, currentResourceModified);
            if (Objects.equal(lastKnownModified, currentResourceModified)) continue;
            modifiedResourcePaths.add(currentResourcePath);
        }
        HashSet<String> removedResourcePaths = Sets.newHashSet(Sets.difference(lastModifiedByResourcePath.keySet(), currentResourcePaths));
        deletedResourcePaths.addAll(removedResourcePaths);
        modifiedResourcePaths.addAll(removedResourcePaths);
        for (String removedResourcePath : removedResourcePaths) {
            lastModifiedByResourcePath.remove(removedResourcePath);
        }
    }

    private static Set<String> resourcePathsToCompilationUnitNames(Set<String> resourcePaths) {
        HashSet<String> compilationUnitNames = Sets.newHashSet();
        for (String resourcePath : resourcePaths) {
            compilationUnitNames.add(Shared.toTypeName(resourcePath));
        }
        return compilationUnitNames;
    }

    private static Map<String, Long> resourcesToModifiedByPath(Collection<Resource> resources) {
        HashMap<String, Long> modifiedByPath = Maps.newHashMap();
        for (Resource resource : resources) {
            modifiedByPath.put(resource.getPath(), resource.getLastModified());
        }
        return modifiedByPath;
    }

    public String addExportedGlobalName(String exportedGlobalName, String description, String inTypeName) {
        this.exportedGlobalNamesByTypeName.put(inTypeName, exportedGlobalName);
        return this.descriptionByExportedGlobalNames.put(exportedGlobalName, description);
    }

    public void addGeneratedArtifacts(ArtifactSet generatedArtifacts) {
        this.generatedArtifacts.addAll(generatedArtifacts);
    }

    public void addModifiedCompilationUnitNames(TreeLogger logger, Set<String> modifiedCompilationUnitNames) {
        logger.log(TreeLogger.DEBUG, "adding to cached list of known modified compilation units " + modifiedCompilationUnitNames);
        this.modifiedCompilationUnitNames.addAll(modifiedCompilationUnitNames);
    }

    public void addSourceCompilationUnitName(String sourceCompilationUnitName) {
        this.sourceCompilationUnitNames.add(sourceCompilationUnitName);
    }

    public void addTypeReference(String fromTypeName, String toTypeName) {
        this.referencedTypeNamesByTypeName.put(fromTypeName, toTypeName);
        this.typeNamesByReferencingTypeName.put(toTypeName, fromTypeName);
    }

    public void associateReboundTypeWithGeneratedCompilationUnitName(String reboundTypeName, String generatedCompilationUnitName) {
        this.reboundTypeNamesByGeneratedCompilationUnitNames.put(generatedCompilationUnitName, reboundTypeName);
    }

    public void associateReboundTypeWithInputResource(String reboundTypeName, String inputResourcePath) {
        this.reboundTypeNamesByInputResource.put(inputResourcePath, reboundTypeName);
    }

    public void clearPerTypeJsCache() {
        this.rootTypeNames.clear();
        this.preambleTypeNames.clear();
        this.deletedResourcePaths.clear();
        this.modifiedResourcePaths.clear();
        this.deletedDiskSourcePaths.clear();
        this.modifiedDiskSourcePaths.clear();
        this.contentHashByGeneratedTypeName.clear();
        this.jsByTypeName.clear();
        this.referencedTypeNamesByTypeName.clear();
        this.sourceMapsByTypeName.clear();
        this.statementRangesByTypeName.clear();
        this.typeNamesByReferencingTypeName.clear();
    }

    public void clearRebinderTypeAssociations(String rebinderTypeName) {
        this.rebinderTypeNamesByReboundTypeName.values().remove(rebinderTypeName);
    }

    public void clearReboundTypeAssociations(String reboundTypeName) {
        this.reboundTypeNamesByInputResource.values().remove(reboundTypeName);
        this.reboundTypeNamesByGeneratedCompilationUnitNames.values().remove(reboundTypeName);
    }

    public Set<String> computeAndClearStaleTypesCache(TreeLogger logger, JTypeOracle typeOracle) {
        if (!this.isPopulated()) {
            return Sets.newHashSet();
        }
        this.generatedCompilationUnitNamesByReboundTypeNames.clear();
        Multimaps.invertFrom(this.reboundTypeNamesByGeneratedCompilationUnitNames, this.generatedCompilationUnitNamesByReboundTypeNames);
        this.staleTypeNames.clear();
        Set<String> modifiedTypeNames = this.computeModifiedTypeNames();
        this.staleTypeNames.addAll(modifiedTypeNames);
        MinimalRebuildCache.appendSubTypes(this.staleTypeNames, modifiedTypeNames, typeOracle);
        ImmutableList<String> modifiedTypeAndSubTypeNames = ImmutableList.copyOf(this.staleTypeNames);
        this.appendReferencingTypes(this.staleTypeNames, modifiedTypeAndSubTypeNames);
        this.appendReferencingTypes(this.staleTypeNames, this.jsoStatusChangedTypeNames);
        this.staleTypeNames.addAll(this.computeTypesThatRebindTypes(this.computeReboundTypesAffectedByModifiedResources()));
        this.appendTypesToRegenerateStaleGeneratedTypes(this.staleTypeNames);
        this.staleTypeNames.removeAll(JProgram.SYNTHETIC_TYPE_NAMES);
        MinimalRebuildCache.copyCollection(this.filterUnreachableTypeNames(this.staleTypeNames), this.staleTypeNames);
        if (logger.isLoggable(TreeLogger.DEBUG)) {
            logger.log(TreeLogger.DEBUG, "known modified types = " + modifiedTypeNames);
            logger.log(TreeLogger.DEBUG, "known modified resources = " + this.modifiedResourcePaths);
            logger.log(TreeLogger.DEBUG, "clearing cached output for resulting stale types = " + this.staleTypeNames);
        }
        for (String staleTypeName : this.staleTypeNames) {
            this.clearCachedTypeOutput(staleTypeName);
        }
        return Sets.newHashSet(this.staleTypeNames);
    }

    public Set<String> computeDeletedTypeNames() {
        return this.computeNestedTypeNames(this.deletedCompilationUnitNames);
    }

    public Set<String> computeModifiedTypeNames() {
        return this.computeNestedTypeNames(this.modifiedCompilationUnitNames);
    }

    public Set<String> computeReachableTypeNames() {
        RapidTypeAnalyzer rapidTypeAnalyzer = new RapidTypeAnalyzer(this.typeEnvironment);
        for (String immortalCodegenTypeName : JProgram.IMMORTAL_CODEGEN_TYPES_SET) {
            int immortalCodegenTypeId = this.typeEnvironment.getTypeIdByName(immortalCodegenTypeName);
            rapidTypeAnalyzer.markTypeIdReachable(immortalCodegenTypeId);
            rapidTypeAnalyzer.markMemberMethodIdsReachable(immortalCodegenTypeId);
        }
        IntArrayList enclosingTypeIds = this.typeEnvironment.getEnclosingTypeIdsOfExportedMethods();
        for (int i = 0; i < enclosingTypeIds.size(); ++i) {
            int enclosingTypeId = enclosingTypeIds.get(i);
            IntArrayList exportedMethodIds = this.typeEnvironment.getExportedMemberMethodIdsIn(enclosingTypeId);
            if (exportedMethodIds == null) continue;
            for (int j = 0; j < exportedMethodIds.size(); ++j) {
                int exportedMethodId = exportedMethodIds.get(j);
                rapidTypeAnalyzer.markMethodIdReachable(exportedMethodId, false);
            }
        }
        IntArrayList typeIdsWithExportedStaticReferences = this.typeEnvironment.getTypeIdsWithExportedStaticReferences();
        for (int i = 0; i < typeIdsWithExportedStaticReferences.size(); ++i) {
            int typeId = typeIdsWithExportedStaticReferences.get(i);
            rapidTypeAnalyzer.markTypeIdReachable(typeId);
            String typeName = this.typeEnvironment.getTypeNameById(typeId);
            int typeClinitMethodId = this.typeEnvironment.getMethodIdByName(typeName + "::$clinit()V");
            rapidTypeAnalyzer.markMethodIdReachable(typeClinitMethodId, false);
        }
        IntArrayList entryMethodIds = this.typeEnvironment.getEntryMethodIds();
        for (int i = 0; i < entryMethodIds.size(); ++i) {
            int entryMethodId = entryMethodIds.get(i);
            int typeId = this.typeEnvironment.getEnclosingTypeId(entryMethodId);
            rapidTypeAnalyzer.markTypeIdReachable(typeId);
            rapidTypeAnalyzer.markMemberMethodIdsReachable(typeId);
        }
        IntArrayList reachableTypeIds = rapidTypeAnalyzer.computeReachableTypeIds();
        HashSet<String> reachableTypeNames = Sets.newHashSet();
        for (int i = 0; i < reachableTypeIds.size(); ++i) {
            int reachableTypeId = reachableTypeIds.get(i);
            reachableTypeNames.add(this.typeEnvironment.getTypeNameById(reachableTypeId));
        }
        MinimalRebuildCache.copyCollection(reachableTypeNames, this.lastReachableTypeNames);
        return reachableTypeNames;
    }

    public void copyFrom(MinimalRebuildCache that) {
        this.lastLinkedJsBytes = that.lastLinkedJsBytes;
        this.intTypeMapper.copyFrom(that.intTypeMapper);
        this.jsIncrementalNamerState.copyFrom(that.jsIncrementalNamerState);
        this.immediateTypeRelations.copyFrom(that.immediateTypeRelations);
        this.typeEnvironment.copyFrom(that.typeEnvironment);
        MinimalRebuildCache.copyMap(that.compilationUnitTypeNameByNestedTypeName, this.compilationUnitTypeNameByNestedTypeName);
        MinimalRebuildCache.copyMap(that.contentHashByGeneratedTypeName, this.contentHashByGeneratedTypeName);
        MinimalRebuildCache.copyMap(that.descriptionByExportedGlobalNames, this.descriptionByExportedGlobalNames);
        MinimalRebuildCache.copyMap(that.jsByTypeName, this.jsByTypeName);
        MinimalRebuildCache.copyMap(that.lastModifiedByDiskSourcePath, this.lastModifiedByDiskSourcePath);
        MinimalRebuildCache.copyMap(that.lastModifiedByResourcePath, this.lastModifiedByResourcePath);
        MinimalRebuildCache.copyMap(that.sourceMapsByTypeName, this.sourceMapsByTypeName);
        MinimalRebuildCache.copyMap(that.statementRangesByTypeName, this.statementRangesByTypeName);
        MinimalRebuildCache.copyMultimap(that.exportedGlobalNamesByTypeName, this.exportedGlobalNamesByTypeName);
        MinimalRebuildCache.copyMultimap(that.generatedCompilationUnitNamesByReboundTypeNames, this.generatedCompilationUnitNamesByReboundTypeNames);
        MinimalRebuildCache.copyMultimap(that.nestedTypeNamesByUnitTypeName, this.nestedTypeNamesByUnitTypeName);
        MinimalRebuildCache.copyMultimap(that.rebinderTypeNamesByReboundTypeName, this.rebinderTypeNamesByReboundTypeName);
        MinimalRebuildCache.copyMultimap(that.reboundTypeNamesByGeneratedCompilationUnitNames, this.reboundTypeNamesByGeneratedCompilationUnitNames);
        MinimalRebuildCache.copyMultimap(that.reboundTypeNamesByInputResource, this.reboundTypeNamesByInputResource);
        MinimalRebuildCache.copyMultimap(that.referencedTypeNamesByTypeName, this.referencedTypeNamesByTypeName);
        MinimalRebuildCache.copyMultimap(that.typeNamesByReferencingTypeName, this.typeNamesByReferencingTypeName);
        MinimalRebuildCache.copyCollection(that.deletedCompilationUnitNames, this.deletedCompilationUnitNames);
        MinimalRebuildCache.copyCollection(that.deletedDiskSourcePaths, this.deletedDiskSourcePaths);
        MinimalRebuildCache.copyCollection(that.deletedResourcePaths, this.deletedResourcePaths);
        MinimalRebuildCache.copyCollection(that.dualJsoImplInterfaceNames, this.dualJsoImplInterfaceNames);
        MinimalRebuildCache.copyCollection(that.generatedArtifacts, this.generatedArtifacts);
        MinimalRebuildCache.copyCollection(that.jsoStatusChangedTypeNames, this.jsoStatusChangedTypeNames);
        MinimalRebuildCache.copyCollection(that.jsoTypeNames, this.jsoTypeNames);
        MinimalRebuildCache.copyCollection(that.lastReachableTypeNames, this.lastReachableTypeNames);
        MinimalRebuildCache.copyCollection(that.modifiedCompilationUnitNames, this.modifiedCompilationUnitNames);
        MinimalRebuildCache.copyCollection(that.modifiedDiskSourcePaths, this.modifiedDiskSourcePaths);
        MinimalRebuildCache.copyCollection(that.modifiedResourcePaths, this.modifiedResourcePaths);
        MinimalRebuildCache.copyCollection(that.preambleTypeNames, this.preambleTypeNames);
        MinimalRebuildCache.copyCollection(that.rootTypeNames, this.rootTypeNames);
        MinimalRebuildCache.copyCollection(that.singleJsoImplInterfaceNames, this.singleJsoImplInterfaceNames);
        MinimalRebuildCache.copyCollection(that.sourceCompilationUnitNames, this.sourceCompilationUnitNames);
        MinimalRebuildCache.copyCollection(that.staleTypeNames, this.staleTypeNames);
    }

    public Set<String> filterUnreachableTypeNames(Set<String> typeNames) {
        return Sets.newHashSet(Sets.filter(typeNames, Predicates.in(this.lastReachableTypeNames)));
    }

    public ArtifactSet getGeneratedArtifacts() {
        return this.generatedArtifacts;
    }

    public JTypeOracle.ImmediateTypeRelations getImmediateTypeRelations() {
        return this.immediateTypeRelations;
    }

    public String getJs(String typeName) {
        return this.jsByTypeName.get(typeName);
    }

    public int getLastLinkedJsBytes() {
        return this.lastLinkedJsBytes;
    }

    @VisibleForTesting
    public Set<String> getModifiedCompilationUnitNames() {
        return this.modifiedCompilationUnitNames;
    }

    public JsIncrementalNamer.JsIncrementalNamerState getPersistentPrettyNamerState() {
        return this.jsIncrementalNamerState;
    }

    public Set<String> getPreambleTypeNames() {
        return this.preambleTypeNames;
    }

    public Set<String> getProcessedStaleTypeNames() {
        return this.processedStaleTypeNames;
    }

    public JsSourceMap getSourceMap(String typeName) {
        return this.sourceMapsByTypeName.get(typeName);
    }

    @VisibleForTesting
    public Set<String> getStaleTypeNames() {
        return this.staleTypeNames;
    }

    public StatementRanges getStatementRanges(String typeName) {
        return this.statementRangesByTypeName.get(typeName);
    }

    public StringAnalyzableTypeEnvironment getTypeEnvironment() {
        return this.typeEnvironment;
    }

    public ResolveRuntimeTypeReferences.IntTypeMapper getTypeMapper() {
        return this.intTypeMapper;
    }

    public boolean hasJs(String typeName) {
        return this.jsByTypeName.containsKey(typeName);
    }

    public boolean hasPreambleTypeNames() {
        return !this.preambleTypeNames.isEmpty();
    }

    public boolean isPopulated() {
        return !this.immediateTypeRelations.isEmpty();
    }

    public boolean isSourceCompilationUnit(String compilationUnitName) {
        return this.sourceCompilationUnitNames.contains(compilationUnitName);
    }

    public boolean knowsLastLinkedJsBytes() {
        return this.lastLinkedJsBytes != null;
    }

    @VisibleForTesting
    public void markSourceFileStale(String typeName) {
        this.lastModifiedByDiskSourcePath.remove(typeName);
    }

    public void recordBuildResources(ModuleDef module) {
        Map<String, Long> currentModifiedByResourcePath = MinimalRebuildCache.resourcesToModifiedByPath(module.getBuildResourceOracle().getResources());
        MinimalRebuildCache.recordModifiedResources(currentModifiedByResourcePath, this.lastModifiedByResourcePath, this.modifiedResourcePaths, this.deletedResourcePaths);
    }

    @VisibleForTesting
    public void recordDiskSourceResources(Map<String, Long> currentModifiedByDiskSourcePath) {
        MinimalRebuildCache.recordModifiedResources(currentModifiedByDiskSourcePath, this.lastModifiedByDiskSourcePath, this.modifiedDiskSourcePaths, this.deletedDiskSourcePaths);
        this.deletedCompilationUnitNames.clear();
        this.deletedCompilationUnitNames.addAll(MinimalRebuildCache.resourcePathsToCompilationUnitNames(this.deletedDiskSourcePaths));
        this.modifiedCompilationUnitNames.clear();
        this.modifiedCompilationUnitNames.addAll(MinimalRebuildCache.resourcePathsToCompilationUnitNames(this.modifiedDiskSourcePaths));
    }

    public void recordDiskSourceResources(ModuleDef module) {
        Map<String, Long> currentModifiedByDiskSourcePath = MinimalRebuildCache.resourcesToModifiedByPath(module.getSourceResourceOracle().getResources());
        this.recordDiskSourceResources(currentModifiedByDiskSourcePath);
    }

    public void recordGeneratedUnits(Collection<GeneratedUnit> generatedUnits) {
        for (GeneratedUnit generatedUnit : generatedUnits) {
            String currentStrongHash = generatedUnit.getStrongHash();
            String lastKnownStrongHash = this.contentHashByGeneratedTypeName.put(generatedUnit.getTypeName(), currentStrongHash);
            if (Objects.equal(lastKnownStrongHash, currentStrongHash)) continue;
            this.modifiedCompilationUnitNames.add(generatedUnit.getTypeName());
        }
    }

    @VisibleForTesting
    public void recordNestedTypeName(String compilationUnitTypeName, String nestedTypeName) {
        this.nestedTypeNamesByUnitTypeName.put(compilationUnitTypeName, nestedTypeName);
        this.compilationUnitTypeNameByNestedTypeName.put(nestedTypeName, compilationUnitTypeName);
    }

    public void recordNestedTypeNamesPerType(CompilationUnit compilationUnit) {
        String compilationUnitTypeName = compilationUnit.getTypeName();
        this.nestedTypeNamesByUnitTypeName.removeAll(compilationUnitTypeName);
        for (CompiledClass compiledClass : compilationUnit.getCompiledClasses()) {
            String nestedTypeName = Name.InternalName.toBinaryName(compiledClass.getInternalName());
            this.recordNestedTypeName(compilationUnitTypeName, nestedTypeName);
        }
    }

    public void recordRebinderTypeForReboundType(String reboundTypeName, String rebinderType) {
        this.rebinderTypeNamesByReboundTypeName.put(reboundTypeName, rebinderType);
    }

    public void removeExportedNames(String inTypeName) {
        Collection<String> exportedGlobalNamesForType = this.exportedGlobalNamesByTypeName.removeAll(inTypeName);
        this.descriptionByExportedGlobalNames.keySet().removeAll(exportedGlobalNamesForType);
    }

    public void removeReferencesFrom(String fromTypeName) {
        Collection<String> toTypeNames = this.referencedTypeNamesByTypeName.get(fromTypeName);
        for (String toTypeName : toTypeNames) {
            this.typeNamesByReferencingTypeName.remove(toTypeName, fromTypeName);
        }
        this.referencedTypeNamesByTypeName.removeAll(fromTypeName);
    }

    public void setEntryMethodNames(List<String> entryMethodNames) {
        this.typeEnvironment.setEntryMethodNames(entryMethodNames);
    }

    public void setJsForType(TreeLogger logger, String typeName, String typeJs) {
        logger.log(TreeLogger.SPAM, "caching JS for type " + typeName);
        this.jsByTypeName.put(typeName, typeJs);
    }

    public void setJsoTypeNames(Set<String> jsoTypeNames, Set<String> singleJsoImplInterfaceNames, Set<String> dualJsoImplInterfaceNames) {
        this.jsoStatusChangedTypeNames.clear();
        this.jsoStatusChangedTypeNames.addAll(Sets.symmetricDifference(this.jsoTypeNames, jsoTypeNames));
        this.jsoStatusChangedTypeNames.addAll(Sets.symmetricDifference(this.singleJsoImplInterfaceNames, singleJsoImplInterfaceNames));
        this.jsoStatusChangedTypeNames.addAll(Sets.symmetricDifference(this.dualJsoImplInterfaceNames, dualJsoImplInterfaceNames));
        this.jsoTypeNames.clear();
        this.jsoTypeNames.addAll(jsoTypeNames);
        this.singleJsoImplInterfaceNames.clear();
        this.singleJsoImplInterfaceNames.addAll(singleJsoImplInterfaceNames);
        this.dualJsoImplInterfaceNames.clear();
        this.dualJsoImplInterfaceNames.addAll(dualJsoImplInterfaceNames);
    }

    public void setLastLinkedJsBytes(int lastLinkedJsBytes) {
        this.lastLinkedJsBytes = lastLinkedJsBytes;
    }

    public void setPreambleTypeNames(TreeLogger logger, Set<String> preambleTypeNames) {
        logger.log(TreeLogger.DEBUG, "caching list of known preamble types " + preambleTypeNames);
        this.preambleTypeNames.addAll(preambleTypeNames);
    }

    public void setProcessedStaleTypeNames(Set<String> processedStaleTypeNames) {
        if (!this.isPopulated()) {
            return;
        }
        this.processedStaleTypeNames = ImmutableSet.copyOf(processedStaleTypeNames);
    }

    public void setRootTypeNames(Collection<String> rootTypeNames) {
        this.rootTypeNames.clear();
        this.rootTypeNames.addAll(rootTypeNames);
    }

    public void setSourceMapForType(String typeName, JsSourceMap sourceMap) {
        this.sourceMapsByTypeName.put(typeName, sourceMap);
    }

    public void setStatementRangesForType(String typeName, StatementRanges statementRanges) {
        this.statementRangesByTypeName.put(typeName, statementRanges);
    }

    @VisibleForTesting
    boolean hasSameContent(MinimalRebuildCache that) {
        return this.immediateTypeRelations.hasSameContent(that.immediateTypeRelations) && Objects.equal(this.compilationUnitTypeNameByNestedTypeName, that.compilationUnitTypeNameByNestedTypeName) && Objects.equal(this.contentHashByGeneratedTypeName, that.contentHashByGeneratedTypeName) && Objects.equal(this.deletedCompilationUnitNames, that.deletedCompilationUnitNames) && Objects.equal(this.deletedDiskSourcePaths, that.deletedDiskSourcePaths) && Objects.equal(this.deletedResourcePaths, that.deletedResourcePaths) && Objects.equal(this.dualJsoImplInterfaceNames, that.dualJsoImplInterfaceNames) && Objects.equal(this.generatedArtifacts, that.generatedArtifacts) && Objects.equal(this.descriptionByExportedGlobalNames, that.descriptionByExportedGlobalNames) && Objects.equal(this.exportedGlobalNamesByTypeName, that.exportedGlobalNamesByTypeName) && Objects.equal(this.generatedCompilationUnitNamesByReboundTypeNames, that.generatedCompilationUnitNamesByReboundTypeNames) && this.intTypeMapper.hasSameContent(that.intTypeMapper) && Objects.equal(this.jsByTypeName, that.jsByTypeName) && Objects.equal(this.jsoStatusChangedTypeNames, that.jsoStatusChangedTypeNames) && Objects.equal(this.jsoTypeNames, that.jsoTypeNames) && Objects.equal(this.lastLinkedJsBytes, that.lastLinkedJsBytes) && Objects.equal(this.lastModifiedByDiskSourcePath, that.lastModifiedByDiskSourcePath) && Objects.equal(this.lastModifiedByResourcePath, that.lastModifiedByResourcePath) && Objects.equal(this.lastReachableTypeNames, that.lastReachableTypeNames) && Objects.equal(this.modifiedCompilationUnitNames, that.modifiedCompilationUnitNames) && Objects.equal(this.modifiedDiskSourcePaths, that.modifiedDiskSourcePaths) && Objects.equal(this.modifiedResourcePaths, that.modifiedResourcePaths) && Objects.equal(this.nestedTypeNamesByUnitTypeName, that.nestedTypeNamesByUnitTypeName) && this.jsIncrementalNamerState.hasSameContent(that.jsIncrementalNamerState) && Objects.equal(this.preambleTypeNames, that.preambleTypeNames) && Objects.equal(this.rebinderTypeNamesByReboundTypeName, that.rebinderTypeNamesByReboundTypeName) && Objects.equal(this.reboundTypeNamesByGeneratedCompilationUnitNames, that.reboundTypeNamesByGeneratedCompilationUnitNames) && Objects.equal(this.reboundTypeNamesByInputResource, that.reboundTypeNamesByInputResource) && Objects.equal(this.referencedTypeNamesByTypeName, that.referencedTypeNamesByTypeName) && Objects.equal(this.rootTypeNames, that.rootTypeNames) && Objects.equal(this.singleJsoImplInterfaceNames, that.singleJsoImplInterfaceNames) && Objects.equal(this.sourceCompilationUnitNames, that.sourceCompilationUnitNames) && Objects.equal(this.sourceMapsByTypeName, that.sourceMapsByTypeName) && Objects.equal(this.staleTypeNames, that.staleTypeNames) && Objects.equal(this.statementRangesByTypeName, that.statementRangesByTypeName) && this.typeEnvironment.hasSameContent(that.typeEnvironment) && Objects.equal(this.typeNamesByReferencingTypeName, that.typeNamesByReferencingTypeName);
    }

    private void appendReferencingTypes(Set<String> accumulatedTypeNames, Collection<String> referencedTypeNames) {
        for (String referencedTypeName : referencedTypeNames) {
            Collection<String> referencingTypeNames = this.typeNamesByReferencingTypeName.get(referencedTypeName);
            accumulatedTypeNames.addAll(referencingTypeNames);
        }
    }

    private void appendTypesToRegenerateStaleGeneratedTypes(Set<String> staleTypeNames) {
        boolean discoveredMoreStaleTypes;
        Set<String> generatedCompilationUnitNames = this.reboundTypeNamesByGeneratedCompilationUnitNames.keySet();
        Sets.SetView<String> staleGeneratedCompilationUnitNames = Sets.intersection(this.computeCompilationUnitNames(staleTypeNames), generatedCompilationUnitNames);
        do {
            Set<String> reboundTypesThatGenerateTheStaleCompilationUnits = this.computeReboundTypesThatGenerateTypes(staleGeneratedCompilationUnitNames);
            Set<String> generatorTriggeringTypes = this.computeTypesThatRebindTypes(reboundTypesThatGenerateTheStaleCompilationUnits);
            discoveredMoreStaleTypes = staleTypeNames.addAll(generatorTriggeringTypes);
            staleGeneratedCompilationUnitNames = Sets.intersection(this.computeCompilationUnitNames(generatorTriggeringTypes), generatedCompilationUnitNames);
        } while (discoveredMoreStaleTypes);
    }

    private void clearCachedTypeOutput(String staleTypeName) {
        this.jsByTypeName.remove(staleTypeName);
        this.statementRangesByTypeName.remove(staleTypeName);
        this.sourceMapsByTypeName.remove(staleTypeName);
    }

    private Set<String> computeCompilationUnitNames(Set<String> typeNames) {
        HashSet<String> compilationUnitNames = Sets.newHashSet();
        for (String typeName : typeNames) {
            compilationUnitNames.add(this.compilationUnitTypeNameByNestedTypeName.get(typeName));
        }
        return compilationUnitNames;
    }

    private Set<String> computeNestedTypeNames(Set<String> compilationUnitNames) {
        HashSet<String> nestedTypeNames = Sets.newHashSet();
        nestedTypeNames.addAll(compilationUnitNames);
        for (String compilationUnitName : compilationUnitNames) {
            nestedTypeNames.addAll(this.nestedTypeNamesByUnitTypeName.get(compilationUnitName));
        }
        return nestedTypeNames;
    }

    private Set<String> computeReboundTypesAffectedByModifiedResources() {
        HashSet<String> affectedRebindTypeNames = Sets.newHashSet();
        for (String modifiedResourcePath : this.modifiedResourcePaths) {
            affectedRebindTypeNames.addAll(this.reboundTypeNamesByInputResource.get(modifiedResourcePath));
        }
        return affectedRebindTypeNames;
    }

    private Set<String> computeReboundTypesThatGenerateTypes(Set<String> staleGeneratedCompilationUnitNames) {
        HashSet<String> reboundTypesThatGenerateTypes = Sets.newHashSet();
        for (String staleGeneratedCompilationUnitName : staleGeneratedCompilationUnitNames) {
            reboundTypesThatGenerateTypes.addAll(this.reboundTypeNamesByGeneratedCompilationUnitNames.get(staleGeneratedCompilationUnitName));
        }
        return reboundTypesThatGenerateTypes;
    }

    private Set<String> computeTypesThatRebindTypes(Set<String> reboundTypeNames) {
        HashSet<String> typesThatRebindTypes = Sets.newHashSet();
        for (String reboundTypeName : reboundTypeNames) {
            typesThatRebindTypes.addAll(this.rebinderTypeNamesByReboundTypeName.get(reboundTypeName));
        }
        return typesThatRebindTypes;
    }
}

